/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;

public class OneToManyLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private final QueryableCollection collectionPersister;
    private final Type idType;

    protected boolean isJoinedFetchEnabled(Type type, boolean mappingDefault, String path, String table, String[] foreignKeyColumns) {
        return super.isJoinedFetchEnabled(type, mappingDefault, path, table, foreignKeyColumns) && (!table.equals(this.collectionPersister.getTableName()) || !Arrays.equals(foreignKeyColumns, this.collectionPersister.getKeyColumnNames()));
    }

    public OneToManyLoader(QueryableCollection collPersister, SessionFactoryImplementor session) throws MappingException {
        this(collPersister, 1, session);
    }

    public OneToManyLoader(QueryableCollection collPersister, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        super(factory.getDialect());
        this.collectionPersister = collPersister;
        this.idType = collPersister.getKeyType();
        OuterJoinLoadable persister = (OuterJoinLoadable)collPersister.getElementPersister();
        String alias = this.generateRootAlias(collPersister.getRole());
        List associations = this.walkTree(persister, alias, factory);
        this.initStatementString(collPersister, persister, alias, associations, batchSize, factory);
        this.initClassPersisters(persister, associations);
        this.postInstantiate();
    }

    private void initClassPersisters(OuterJoinLoadable persister, List associations) {
        int joins = associations.size();
        this.lockModeArray = this.createLockModeArray(joins + 1, LockMode.NONE);
        this.classPersisters = new Loadable[joins + 1];
        this.owners = new int[joins + 1];
        int i = 0;
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinLoader.OuterJoinableAssociation oj = (OuterJoinLoader.OuterJoinableAssociation)iter.next();
            this.classPersisters[i] = (Loadable)((Object)oj.joinable);
            this.owners[i] = this.toOwner(oj, joins, oj.isOneToOne);
            ++i;
        }
        this.classPersisters[joins] = persister;
        this.owners[joins] = -1;
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        this.loadCollection(session, id, this.idType);
    }

    private void initStatementString(QueryableCollection collPersister, OuterJoinLoadable persister, String alias, List associations, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        int joins = associations.size();
        this.suffixes = OneToManyLoader.generateSuffixes(joins + 1);
        StringBuffer whereString = OneToManyLoader.whereString(alias, collPersister.getKeyColumnNames(), batchSize);
        if (collPersister.hasWhere()) {
            whereString.append(" and ").append(collPersister.getSQLWhereString(alias));
        }
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select().setSelectClause(collPersister.selectFragment(alias, this.suffixes[joins], true) + this.selectString(associations, factory)).setFromClause(persister.fromTableFragment(alias) + persister.fromJoinFragment(alias, true, true)).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + persister.whereJoinFragment(alias, true, true));
        if (collPersister.hasOrdering()) {
            select.setOrderByClause(collPersister.getSQLOrderByString(alias));
        }
        this.sql = select.toStatementString();
    }
}

