/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

import com.atlassian.core.util.InvalidDurationException;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Category;

public class DateUtils {
    private static Category log = Category.getInstance((Class)DateUtils.class);
    private static final int SECOND = 1;
    private static final int MINUTE = 60;
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private static final int WEEK = 604800;
    private static final int MONTH = 2678400;
    private static final int YEAR = 31536000;
    public static final long SECOND_MILLIS = 1000L;
    public static final long MINUTE_MILLIS = 60000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final long DAY_MILLIS = 86400000L;
    public static final long MONTH_MILLIS = 2678400000L;
    public static final long YEAR_MILLIS = 31536000000L;
    private static final int[] CALENDAR_PERIODS = new int[]{1, 2, 5, 11, 12, 13, 14};
    private final ResourceBundle resourceBundle;
    public static final DateFormat ISO8601DateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    public DateUtils(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public static boolean equalTimestamps(Timestamp t1, Timestamp t2) {
        return Math.abs(t1.getTime() - t2.getTime()) < 10L;
    }

    public String dateDifferenceBean(long dateA, long dateB, long resolution, ResourceBundle resourceBundle) {
        return DateUtils.dateDifference(dateA, dateB, resolution, resourceBundle);
    }

    public static String dateDifference(long dateA, long dateB, long resolution, ResourceBundle resourceBundle) {
        StringBuffer sb = new StringBuffer();
        long difference = Math.abs(dateB - dateA);
        --resolution;
        long months = difference / 2678400000L;
        if (months > 0L) {
            difference %= 2678400000L;
            if (months > 1L) {
                sb.append(months).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.months")).append(", ");
            } else {
                sb.append(months).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.month")).append(", ");
            }
        }
        if (resolution < 0L) {
            if (sb.length() == 0) {
                return "0 " + DateUtils.getText(resourceBundle, "core.dateutils.months");
            }
            return sb.substring(0, sb.length() - 2);
        }
        --resolution;
        long days = difference / 86400000L;
        if (days > 0L) {
            difference %= 86400000L;
            if (days > 1L) {
                sb.append(days).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.days")).append(", ");
            } else {
                sb.append(days).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.day")).append(", ");
            }
        }
        if (resolution < 0L) {
            if (sb.length() == 0) {
                return "0 " + DateUtils.getText(resourceBundle, "core.dateutils.days");
            }
            return sb.substring(0, sb.length() - 2);
        }
        --resolution;
        long hours = difference / 3600000L;
        if (hours > 0L) {
            difference %= 3600000L;
            if (hours > 1L) {
                sb.append(hours).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.hours")).append(", ");
            } else {
                sb.append(hours).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.hour")).append(", ");
            }
        }
        if (resolution < 0L) {
            if (sb.length() == 0) {
                return "0 " + DateUtils.getText(resourceBundle, "core.dateutils.hours");
            }
            return sb.substring(0, sb.length() - 2);
        }
        --resolution;
        long minutes = difference / 60000L;
        if (minutes > 0L) {
            difference %= 60000L;
            if (minutes > 1L) {
                sb.append(minutes).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.minutes")).append(", ");
            } else {
                sb.append(minutes).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.minute")).append(", ");
            }
        }
        if (resolution < 0L) {
            if (sb.length() == 0) {
                return "0 " + DateUtils.getText(resourceBundle, "core.dateutils.minutes");
            }
            return sb.substring(0, sb.length() - 2);
        }
        --resolution;
        long seconds = difference / 1000L;
        if (seconds > 0L) {
            if (seconds > 1L) {
                sb.append(seconds).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.seconds")).append(", ");
            } else {
                sb.append(seconds).append(" ").append(DateUtils.getText(resourceBundle, "core.dateutils.second")).append(", ");
            }
        }
        if (resolution <= 0L && sb.length() == 0) {
            return "0 " + DateUtils.getText(resourceBundle, "core.dateutils.seconds");
        }
        if (sb.length() > 2) {
            return sb.substring(0, sb.length() - 2);
        }
        return "";
    }

    public static String formatDateISO8601(Date ts) {
        return ISO8601DateFormat.format(ts);
    }

    public static boolean validDuration(String s) {
        try {
            DateUtils.getDuration(s);
            return true;
        }
        catch (InvalidDurationException e) {
            return false;
        }
    }

    public static long getDuration(String durationStr) throws InvalidDurationException {
        return DateUtils.getDurationSeconds(durationStr, 86400, 604800);
    }

    public static long getDurationWithNegative(String durationStr) throws InvalidDurationException {
        String cleanedDurationStr = TextUtils.noNull((String)durationStr).trim();
        if (!TextUtils.stringSet((String)cleanedDurationStr)) {
            return 0L;
        }
        boolean negative = false;
        if (cleanedDurationStr.charAt(0) == '-') {
            negative = true;
        }
        if (negative) {
            return 0L - DateUtils.getDuration(cleanedDurationStr.substring(1));
        }
        return DateUtils.getDuration(cleanedDurationStr);
    }

    public static long getDuration(String durationStr, int hoursPerDay, int daysPerWeek) throws InvalidDurationException {
        int secondsInDay = hoursPerDay * 3600;
        int secondsPerWeek = daysPerWeek * secondsInDay;
        return DateUtils.getDurationSeconds(durationStr, secondsInDay, secondsPerWeek);
    }

    private static long getDurationSeconds(String durationStr, int secondsPerDay, int secondsPerWeek) throws InvalidDurationException {
        long time = 0L;
        String remainingDurationStr = null;
        if (!TextUtils.stringSet((String)durationStr)) {
            return 0L;
        }
        if ((durationStr = durationStr.trim().toLowerCase()).indexOf(" ") > 0) {
            StringTokenizer st = new StringTokenizer(durationStr, ", ");
            while (st.hasMoreTokens()) {
                time += DateUtils.getDurationSeconds(st.nextToken(), secondsPerDay, secondsPerWeek);
            }
        } else {
            try {
                time = Long.parseLong(durationStr.trim()) * 60L;
            }
            catch (Exception ex) {
                for (int i = 0; i < durationStr.length(); ++i) {
                    if (Character.isDigit(durationStr.charAt(i))) continue;
                    if (i == 0) {
                        throw new InvalidDurationException("Must have integer preceding duration type");
                    }
                    time = Long.parseLong(durationStr.substring(0, i));
                    remainingDurationStr = durationStr.substring(i + 1);
                    switch (durationStr.charAt(i)) {
                        case 'm': {
                            time *= 60L;
                        }
                        case 'h': {
                            time *= 3600L;
                        }
                        case 'd': {
                            time *= (long)secondsPerDay;
                        }
                        case 'w': {
                            time *= (long)secondsPerWeek;
                        }
                        default: {
                            throw new InvalidDurationException("Not a valid duration string");
                        }
                    }
                }
            }
        }
        if (remainingDurationStr != null && remainingDurationStr.length() != 0 && Character.isDigit(remainingDurationStr.charAt(0))) {
            time += DateUtils.getDurationSeconds(remainingDurationStr, secondsPerDay, secondsPerWeek);
        }
        return time;
    }

    public static String getDurationString(long seconds) {
        return DateUtils.getDurationStringSeconds(seconds, 86400, 604800);
    }

    public static String getDurationStringWithNegative(long seconds) {
        if (seconds < 0L) {
            return "-" + DateUtils.getDurationString(-seconds);
        }
        return DateUtils.getDurationString(seconds);
    }

    public static String getDurationString(long l, int hoursPerDay, int daysPerWeek) {
        int secondsInDay = hoursPerDay * 3600;
        int secondsPerWeek = daysPerWeek * secondsInDay;
        return DateUtils.getDurationStringSeconds(l, secondsInDay, secondsPerWeek);
    }

    private static String getDurationStringSeconds(long l, int secondsPerDay, int secondsPerWeek) {
        if (l == 0L) {
            return "0m";
        }
        StringBuffer result = new StringBuffer();
        if (l >= (long)secondsPerWeek) {
            result.append(l / (long)secondsPerWeek);
            result.append("w ");
            l %= (long)secondsPerWeek;
        }
        if (l >= (long)secondsPerDay) {
            result.append(l / (long)secondsPerDay);
            result.append("d ");
            l %= (long)secondsPerDay;
        }
        if (l >= 3600L) {
            result.append(l / 3600L);
            result.append("h ");
            l %= 3600L;
        }
        if (l >= 60L) {
            result.append(l / 60L);
            result.append("m ");
        }
        return result.toString().trim();
    }

    public static String getDurationPretty(long numSecs, ResourceBundle resourceBundle) {
        return DateUtils.getDurationPrettySeconds(numSecs, 86400, 604800, resourceBundle, false);
    }

    public static String getDurationPretty(long numSecs, int hoursPerDay, int daysPerWeek, ResourceBundle resourceBundle) {
        int secondsInDay = hoursPerDay * 3600;
        int secondsPerWeek = daysPerWeek * secondsInDay;
        return DateUtils.getDurationPrettySeconds(numSecs, secondsInDay, secondsPerWeek, resourceBundle, false);
    }

    public static String getDurationPrettySecondsResolution(long numSecs, ResourceBundle resourceBundle) {
        return DateUtils.getDurationPrettySeconds(numSecs, 86400, 604800, resourceBundle, true);
    }

    public static String getDurationPrettySecondsResolution(long numSecs, int hoursPerDay, int daysPerWeek, ResourceBundle resourceBundle) {
        int secondsInDay = hoursPerDay * 3600;
        int secondsPerWeek = daysPerWeek * secondsInDay;
        return DateUtils.getDurationPrettySeconds(numSecs, secondsInDay, secondsPerWeek, resourceBundle, true);
    }

    private static String getDurationPrettySeconds(long numSecs, int secondsPerDay, int secondsPerWeek, ResourceBundle resourceBundle, boolean secondsDuration) {
        return DateUtils.getDurationPrettySeconds(numSecs, 31536000, secondsPerDay, secondsPerWeek, resourceBundle, secondsDuration);
    }

    private static String getDurationPrettySeconds(long numSecs, int secondsPerYear, int secondsPerDay, int secondsPerWeek, ResourceBundle resourceBundle, boolean secondResolution) {
        if (numSecs == 0L) {
            if (secondResolution) {
                return "0 " + DateUtils.getText(resourceBundle, "core.dateutils.seconds");
            }
            return "0 " + DateUtils.getText(resourceBundle, "core.dateutils.minutes");
        }
        StringBuffer result = new StringBuffer();
        if (numSecs >= (long)secondsPerYear) {
            long years = numSecs / (long)secondsPerYear;
            result.append(years).append(' ');
            if (years > 1L) {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.years"));
            } else {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.year"));
            }
            result.append(", ");
            numSecs %= (long)secondsPerYear;
        }
        if (numSecs >= (long)secondsPerWeek) {
            long weeks = numSecs / (long)secondsPerWeek;
            result.append(weeks).append(' ');
            if (weeks > 1L) {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.weeks"));
            } else {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.week"));
            }
            result.append(", ");
            numSecs %= (long)secondsPerWeek;
        }
        if (numSecs >= (long)secondsPerDay) {
            long days = numSecs / (long)secondsPerDay;
            result.append(days).append(' ');
            if (days > 1L) {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.days"));
            } else {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.day"));
            }
            result.append(", ");
            numSecs %= (long)secondsPerDay;
        }
        if (numSecs >= 3600L) {
            long hours = numSecs / 3600L;
            result.append(hours).append(' ');
            if (hours > 1L) {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.hours"));
            } else {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.hour"));
            }
            result.append(", ");
            numSecs %= 3600L;
        }
        if (numSecs >= 60L) {
            long minute = numSecs / 60L;
            result.append(minute).append(' ');
            if (minute > 1L) {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.minutes"));
            } else {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.minute"));
            }
            result.append(", ");
            if (secondResolution) {
                numSecs %= 60L;
            }
        }
        if (numSecs >= 1L && numSecs < 60L) {
            long sec = numSecs;
            result.append(sec).append(' ');
            if (sec > 1L) {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.seconds"));
            } else {
                result.append(DateUtils.getText(resourceBundle, "core.dateutils.second"));
            }
            result.append(", ");
        }
        if (result.length() > 2) {
            return result.substring(0, result.length() - 2);
        }
        return result.toString();
    }

    public String formatDurationPretty(long l) {
        return DateUtils.getDurationPretty(l, this.resourceBundle);
    }

    public String formatDurationPretty(String seconds) {
        return DateUtils.getDurationPretty(Long.parseLong(seconds), this.resourceBundle);
    }

    public String formatDurationString(long l) {
        return DateUtils.getDurationPretty(l, this.resourceBundle);
    }

    private static String getText(ResourceBundle resourceBundle, String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            log.error((Object)e);
            return "";
        }
    }

    public static Calendar toEndOfPeriod(Calendar calendar, int period) {
        boolean zero = false;
        for (int i = 0; i < CALENDAR_PERIODS.length; ++i) {
            if (zero) {
                calendar.set(CALENDAR_PERIODS[i], calendar.getMaximum(CALENDAR_PERIODS[i]));
            }
            if (CALENDAR_PERIODS[i] != period) continue;
            zero = true;
        }
        if (!zero) {
            throw new IllegalArgumentException("unknown Calendar period: " + period);
        }
        return calendar;
    }

    public static Calendar toStartOfPeriod(Calendar calendar, int period) {
        boolean zero = false;
        for (int i = 0; i < CALENDAR_PERIODS.length; ++i) {
            if (zero) {
                if (CALENDAR_PERIODS[i] == 5) {
                    calendar.set(5, 1);
                } else {
                    calendar.set(CALENDAR_PERIODS[i], 0);
                }
            }
            if (CALENDAR_PERIODS[i] != period) continue;
            zero = true;
        }
        if (!zero) {
            throw new IllegalArgumentException("unknown Calendar period: " + period);
        }
        return calendar;
    }

    public static DateRange toDateRange(Calendar date, int period) {
        Calendar cal = (Calendar)date.clone();
        DateUtils.toStartOfPeriod(cal, period);
        Date startDate = new Date(cal.getTimeInMillis());
        cal.add(period, 1);
        Date endDate = new Date(cal.getTimeInMillis());
        return new DateRange(startDate, endDate);
    }

    public static Calendar getCalendarDay(int year, int month, int day) {
        return DateUtils.initCalendar(year, month, day, 0, 0, 0, 0);
    }

    public static Date getDateDay(int year, int month, int day) {
        return DateUtils.getCalendarDay(year, month, day).getTime();
    }

    public static Date getSqlDateDay(int year, int month, int day) {
        return new java.sql.Date(DateUtils.getCalendarDay(year, month, day).getTimeInMillis());
    }

    public static Date tomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date yesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }

    private static Calendar initCalendar(int year, int month, int day, int hour, int minute, int second, int millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, hour, minute, second);
        calendar.set(14, millis);
        return calendar;
    }

    public static class DateRange {
        public final Date startDate;
        public final Date endDate;

        public DateRange(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }
}

