/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MemoryCache
implements Cache {
    private final String cacheName;
    private final Map cache = Collections.synchronizedMap(new HashMap());

    public MemoryCache(String cacheName) {
        if (cacheName == null) {
            throw new IllegalArgumentException("Cache name must not be null when constructing a MemoryCache!");
        }
        this.cacheName = cacheName;
    }

    public String getName() {
        return this.cacheName;
    }

    public Collection getKeys() {
        return new ArrayList(this.cache.keySet());
    }

    public Object get(Object key) {
        return this.cache.get(key);
    }

    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    public void remove(Object key) {
        this.cache.remove(key);
    }

    public void removeAll() {
        this.cache.clear();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryCache other = (MemoryCache)obj;
        return other.cacheName.equals(this.cacheName);
    }

    public int hashCode() {
        return 3 + this.cacheName.hashCode();
    }
}

