/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.memory.MemoryCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MemoryCacheManager
implements CacheManager {
    private final Map caches = new HashMap();
    private final List nonFlushableCacheNames;

    public MemoryCacheManager() {
        this(Collections.EMPTY_LIST);
    }

    public MemoryCacheManager(List nonFlushableCacheNames) {
        this.nonFlushableCacheNames = new ArrayList(nonFlushableCacheNames);
    }

    public synchronized Cache getCache(String cacheName) {
        if (!this.caches.containsKey(cacheName)) {
            this.caches.put(cacheName, new MemoryCache(cacheName));
        }
        return (Cache)this.caches.get(cacheName);
    }

    public Collection getCaches() {
        return new HashSet(this.caches.values());
    }

    public synchronized void flushCaches() {
        Iterator iterator = this.caches.values().iterator();
        while (iterator.hasNext()) {
            Cache cache = (Cache)iterator.next();
            if (this.nonFlushableCacheNames.contains(cache.getName())) continue;
            cache.removeAll();
        }
    }
}

