/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.classloader;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.classloader.AbstractClassLoader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginsClassLoader
extends AbstractClassLoader {
    private static final Log log = LogFactory.getLog((Class)PluginsClassLoader.class);
    private final PluginAccessor pluginAccessor;
    private final Map pluginResourceIndex = new HashMap();
    private final Map pluginClassIndex = new HashMap();
    private final Set missedPluginResource = new HashSet();
    private final Set missedPluginClass = new HashSet();

    public PluginsClassLoader(PluginAccessor pluginAccessor) {
        this(null, pluginAccessor);
    }

    public PluginsClassLoader(ClassLoader parent, PluginAccessor pluginAccessor) {
        super(parent);
        if (pluginAccessor == null) {
            throw new IllegalArgumentException("The plugin accessor should not be null.");
        }
        this.pluginAccessor = pluginAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL findResource(String name) {
        Plugin indexedPlugin;
        PluginsClassLoader pluginsClassLoader = this;
        synchronized (pluginsClassLoader) {
            indexedPlugin = (Plugin)this.pluginResourceIndex.get(name);
        }
        URL result = this.isPluginEnabled(indexedPlugin) ? indexedPlugin.getClassLoader().getResource(name) : this.getResourceFromPlugins(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Find resource [ " + name + " ], found [ " + result + " ]"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String className) throws ClassNotFoundException {
        Plugin indexedPlugin;
        PluginsClassLoader pluginsClassLoader = this;
        synchronized (pluginsClassLoader) {
            indexedPlugin = (Plugin)this.pluginClassIndex.get(className);
        }
        Class<?> result = this.isPluginEnabled(indexedPlugin) ? indexedPlugin.getClassLoader().loadClass(className) : this.loadClassFromPlugins(className);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Find class [ " + className + " ], found [ " + result + " ]"));
        }
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassFromPlugins(String className) {
        boolean isMissedClassName;
        PluginsClassLoader pluginsClassLoader = this;
        synchronized (pluginsClassLoader) {
            isMissedClassName = this.missedPluginClass.contains(className);
        }
        if (isMissedClassName) {
            return null;
        }
        Collection plugins = this.pluginAccessor.getEnabledPlugins();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            try {
                Class<?> result = plugin.getClassLoader().loadClass(className);
                PluginsClassLoader pluginsClassLoader2 = this;
                synchronized (pluginsClassLoader2) {
                    this.pluginClassIndex.put(className, plugin);
                }
                return result;
            }
            catch (ClassNotFoundException e) {
            }
        }
        PluginsClassLoader pluginsClassLoader3 = this;
        synchronized (pluginsClassLoader3) {
            this.missedPluginClass.add(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResourceFromPlugins(String name) {
        boolean isMissedResource;
        PluginsClassLoader pluginsClassLoader = this;
        synchronized (pluginsClassLoader) {
            isMissedResource = this.missedPluginResource.contains(name);
        }
        if (isMissedResource) {
            return null;
        }
        Collection plugins = this.pluginAccessor.getEnabledPlugins();
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            URL resource = plugin.getClassLoader().getResource(name);
            if (resource == null) continue;
            PluginsClassLoader pluginsClassLoader2 = this;
            synchronized (pluginsClassLoader2) {
                this.pluginResourceIndex.put(name, plugin);
            }
            return resource;
        }
        PluginsClassLoader pluginsClassLoader3 = this;
        synchronized (pluginsClassLoader3) {
            this.missedPluginResource.add(name);
        }
        return null;
    }

    private boolean isPluginEnabled(Plugin plugin) {
        return plugin != null && this.pluginAccessor.isPluginEnabled(plugin.getKey());
    }

    public synchronized void notifyUninstallPlugin(Plugin plugin) {
        this.flushMissesCaches();
        Iterator it = this.pluginResourceIndex.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry resourceEntry = it.next();
            Plugin pluginForResource = (Plugin)resourceEntry.getValue();
            if (!plugin.getKey().equals(pluginForResource.getKey())) continue;
            it.remove();
        }
        it = this.pluginClassIndex.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pluginClassEntry = it.next();
            Plugin pluginForClass = (Plugin)pluginClassEntry.getValue();
            if (!plugin.getKey().equals(pluginForClass.getKey())) continue;
            it.remove();
        }
    }

    public synchronized void notifyPluginOrModuleEnabled() {
        this.flushMissesCaches();
    }

    private void flushMissesCaches() {
        this.missedPluginClass.clear();
        this.missedPluginResource.clear();
    }
}

