/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors.servlet;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.descriptors.servlet.PluginHttpRequestWrapper;
import com.atlassian.plugin.descriptors.servlet.ServletModuleDescriptor;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DelegatingPluginServlet
extends HttpServlet {
    private final ServletModuleDescriptor descriptor;
    private final HttpServlet servlet;

    public DelegatingPluginServlet(ServletModuleDescriptor descriptor) {
        this.descriptor = descriptor;
        this.servlet = descriptor.getServlet();
    }

    private ClassLoader replaceThreadClassLoaderWithPluginClassLoader(Plugin plugin) {
        ClassLoader startingClassLoader = Thread.currentThread().getContextClassLoader();
        if (plugin.isDynamicallyLoaded()) {
            Thread.currentThread().setContextClassLoader(plugin.getClassLoader());
        }
        return startingClassLoader;
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ClassLoader startingClassLoader = this.replaceThreadClassLoaderWithPluginClassLoader(this.descriptor.getPlugin());
        this.servlet.service((ServletRequest)new PluginHttpRequestWrapper(req, this.descriptor), (ServletResponse)res);
        Thread.currentThread().setContextClassLoader(startingClassLoader);
    }

    public void init(ServletConfig config) throws ServletException {
        ClassLoader startingClassLoader = this.replaceThreadClassLoaderWithPluginClassLoader(this.descriptor.getPlugin());
        this.servlet.init(config);
        Thread.currentThread().setContextClassLoader(startingClassLoader);
    }

    public void destroy() {
        this.servlet.destroy();
    }

    public boolean equals(Object obj) {
        return this.servlet.equals(obj);
    }

    public String getInitParameter(String name) {
        return this.servlet.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.servlet.getInitParameterNames();
    }

    public ServletConfig getServletConfig() {
        return this.servlet.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.servlet.getServletContext();
    }

    public String getServletInfo() {
        return this.servlet.getServletInfo();
    }

    public String getServletName() {
        return this.servlet.getServletName();
    }

    public int hashCode() {
        return this.servlet.hashCode();
    }

    public void init() throws ServletException {
        this.servlet.init();
    }

    public void log(String message, Throwable t) {
        this.servlet.log(message, t);
    }

    public void log(String msg) {
        this.servlet.log(msg);
    }

    public String toString() {
        return this.servlet.toString();
    }

    public ServletModuleDescriptor getDescriptor() {
        return this.descriptor;
    }
}

