/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginJar;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.classloader.PluginClassLoader;
import com.atlassian.plugin.loaders.DynamicPluginLoader;
import com.atlassian.plugin.loaders.PluginFactory;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.Scanner;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassLoadingPluginLoader
implements DynamicPluginLoader {
    private static Log log = LogFactory.getLog((Class)ClassLoadingPluginLoader.class);
    private final String pluginDescriptorFileName;
    private final PluginFactory pluginFactory;
    private final Scanner scanner;
    private final Map plugins;
    private DescriptorParserFactory descriptorParserFactory;
    private File pluginTemp;

    public ClassLoadingPluginLoader(File path, PluginFactory pluginFactory) {
        this(path, pluginFactory, new File(System.getProperty("java.io.tmpdir")));
    }

    public ClassLoadingPluginLoader(File path, PluginFactory pluginFactory, File pluginTemp) {
        this(path, "atlassian-plugin.xml", pluginFactory, pluginTemp);
    }

    public ClassLoadingPluginLoader(File path, String pluginDescriptorFileName, PluginFactory pluginFactory) {
        this(path, pluginDescriptorFileName, pluginFactory, new File(System.getProperty("java.io.tmpdir")));
    }

    public ClassLoadingPluginLoader(File path, String pluginDescriptorFileName, PluginFactory pluginFactory, File pluginTemp) {
        log.debug((Object)("Creating classloader for url " + path));
        this.scanner = new Scanner(path);
        this.pluginDescriptorFileName = pluginDescriptorFileName;
        this.pluginFactory = pluginFactory;
        this.descriptorParserFactory = new XmlDescriptorParserFactory();
        this.plugins = new HashMap();
        this.pluginTemp = pluginTemp;
    }

    public Collection loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        this.scanner.scan();
        Iterator iterator = this.scanner.getDeploymentUnits().iterator();
        while (iterator.hasNext()) {
            DeploymentUnit deploymentUnit = (DeploymentUnit)iterator.next();
            try {
                Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
                this.plugins.put(deploymentUnit, plugin);
            }
            catch (PluginParseException e) {
                log.error((Object)("Error loading descriptor for : " + deploymentUnit), (Throwable)((Object)e));
            }
        }
        return this.plugins.values();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Plugin deployPluginFromUnit(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        URL pluginResourceUrl;
        PluginClassLoader loader;
        InputStream pluginDescriptor;
        Plugin plugin;
        block8: {
            plugin = null;
            pluginDescriptor = null;
            loader = null;
            loader = new PluginClassLoader(deploymentUnit.getPath(), Thread.currentThread().getContextClassLoader(), this.pluginTemp);
            pluginResourceUrl = loader.getLocalResource(this.pluginDescriptorFileName);
            if (pluginResourceUrl != null) break block8;
            Plugin plugin2 = this.handleNoDescriptor(deploymentUnit);
            IOUtils.closeQuietly((InputStream)pluginDescriptor);
            return plugin2;
        }
        try {
            pluginDescriptor = pluginResourceUrl.openStream();
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor);
            plugin = parser.configurePlugin(moduleDescriptorFactory, this.createPlugin(parser, deploymentUnit, loader));
        }
        catch (PluginParseException e) {
            try {
                this.closeQuietly(loader);
                throw e;
                catch (RuntimeException e2) {
                    this.closeQuietly(loader);
                    throw new PluginParseException(e2);
                }
                catch (Error e3) {
                    this.closeQuietly(loader);
                    throw e3;
                }
                catch (IOException e4) {
                    this.closeQuietly(loader);
                    throw new PluginParseException(e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pluginDescriptor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    protected void setDescriptorParserFactory(DescriptorParserFactory factory) {
        this.descriptorParserFactory = factory;
    }

    protected Plugin handleNoDescriptor(DeploymentUnit deploymentUnit) throws PluginParseException {
        throw new PluginParseException("No descriptor found in classloader for : " + deploymentUnit);
    }

    protected Plugin createPlugin(DescriptorParser parser, DeploymentUnit unit, PluginClassLoader loader) {
        return this.pluginFactory.createPlugin(unit, loader);
    }

    public boolean supportsRemoval() {
        return true;
    }

    public boolean supportsAddition() {
        return true;
    }

    public Collection addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Collection updatedDeploymentUnits = this.scanner.scan();
        ArrayList<Plugin> foundPlugins = new ArrayList<Plugin>();
        Iterator it = updatedDeploymentUnits.iterator();
        while (it.hasNext()) {
            DeploymentUnit deploymentUnit = (DeploymentUnit)it.next();
            if (this.plugins.containsKey(deploymentUnit)) continue;
            Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
            this.plugins.put(deploymentUnit, plugin);
            foundPlugins.add(plugin);
        }
        return foundPlugins;
    }

    public void removePlugin(Plugin plugin) throws PluginException {
        if (plugin.isEnabled()) {
            throw new PluginException("Cannot remove an enabled plugin");
        }
        if (!plugin.isUninstallable()) {
            throw new PluginException("Cannot remove an uninstallable plugin: [" + plugin.getName() + "]");
        }
        DeploymentUnit deploymentUnit = this.findMatchingDeploymentUnit(plugin);
        File pluginOnDisk = deploymentUnit.getPath();
        plugin.close();
        try {
            boolean found = false;
            Iterator i = this.plugins.keySet().iterator();
            while (i.hasNext()) {
                DeploymentUnit unit = (DeploymentUnit)i.next();
                if (!unit.getPath().equals(deploymentUnit.getPath()) || unit.equals(deploymentUnit)) continue;
                found = true;
            }
            if (!found && !pluginOnDisk.delete()) {
                throw new PluginException("Could not delete plugin [" + plugin.getName() + "].");
            }
        }
        catch (SecurityException e) {
            throw new PluginException(e);
        }
        this.scanner.clear(pluginOnDisk);
        this.plugins.remove(deploymentUnit);
    }

    private DeploymentUnit findMatchingDeploymentUnit(Plugin plugin) throws PluginException {
        DeploymentUnit deploymentUnit = null;
        Iterator iterator = this.plugins.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != plugin) continue;
            deploymentUnit = (DeploymentUnit)entry.getKey();
        }
        if (deploymentUnit == null) {
            throw new PluginException("This pluginLoader has no memory of deploying the plugin you are trying remove: [" + plugin.getName() + "]");
        }
        return deploymentUnit;
    }

    public void shutDown() {
        this.scanner.clearAll();
        Iterator it = this.plugins.values().iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            plugin.close();
        }
    }

    public String canLoad(PluginJar pluginJar) throws PluginParseException {
        String pluginKey = null;
        InputStream descriptorStream = pluginJar.getFile(this.pluginDescriptorFileName);
        if (descriptorStream != null) {
            DescriptorParser descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream);
            pluginKey = descriptorParser.getKey();
        }
        return pluginKey;
    }

    private void closeQuietly(PluginClassLoader loader) {
        if (loader != null) {
            loader.close();
        }
    }
}

