/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.parsers;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptorFactory;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.parsers.DescriptorParser;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlDescriptorParser
implements DescriptorParser {
    private static Log log = LogFactory.getLog((Class)XmlDescriptorParser.class);
    boolean recogniseSystemPlugins = false;
    private Document document;

    public XmlDescriptorParser(InputStream source) throws PluginParseException {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be null");
        }
        this.document = this.createDocument(source);
    }

    protected Document createDocument(InputStream source) throws PluginParseException {
        SAXReader reader = new SAXReader();
        try {
            return reader.read(source);
        }
        catch (DocumentException e) {
            throw new PluginParseException("Cannot parse XML plugin descriptor", e);
        }
    }

    protected Document getDocument() {
        return this.document;
    }

    public Plugin configurePlugin(ModuleDescriptorFactory moduleDescriptorFactory, Plugin plugin) throws PluginParseException {
        Element pluginElement = this.getPluginElement();
        plugin.setName(pluginElement.attributeValue("name"));
        plugin.setKey(this.getKey());
        if (pluginElement.attributeValue("i18n-name-key") != null) {
            plugin.setI18nNameKey(pluginElement.attributeValue("i18n-name-key"));
        }
        if (plugin.getKey().indexOf(":") > 0) {
            throw new PluginParseException("Plugin keys cannot contain ':'. Key is '" + plugin.getKey() + "'");
        }
        if ("disabled".equalsIgnoreCase(pluginElement.attributeValue("state"))) {
            plugin.setEnabledByDefault(false);
        }
        Iterator i = pluginElement.elementIterator();
        while (i.hasNext()) {
            ModuleDescriptor moduleDescriptor;
            Element element = (Element)i.next();
            if ("plugin-info".equalsIgnoreCase(element.getName())) {
                plugin.setPluginInformation(this.createPluginInformation(element));
                continue;
            }
            if ("resource".equalsIgnoreCase(element.getName()) || (moduleDescriptor = this.createModuleDescriptor(plugin, element, moduleDescriptorFactory)) == null) continue;
            if (plugin.getModuleDescriptor(moduleDescriptor.getKey()) != null) {
                throw new PluginParseException("Found duplicate key '" + moduleDescriptor.getKey() + "' within plugin '" + plugin.getKey() + "'");
            }
            plugin.addModuleDescriptor(moduleDescriptor);
            if (!(moduleDescriptor instanceof UnloadableModuleDescriptor)) continue;
            log.error((Object)("There were errors loading the plugin '" + plugin.getName() + "'. The plugin has been disabled."));
            return UnloadablePluginFactory.createUnloadablePlugin(plugin);
        }
        plugin.setResources(Resources.fromXml(pluginElement));
        return plugin;
    }

    private Element getPluginElement() {
        return this.document.getRootElement();
    }

    protected ModuleDescriptor createModuleDescriptor(Plugin plugin, Element element, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        ModuleDescriptor moduleDescriptorDescriptor;
        String name = element.getName();
        try {
            moduleDescriptorDescriptor = moduleDescriptorFactory.getModuleDescriptor(name);
        }
        catch (Throwable e) {
            UnrecognisedModuleDescriptor descriptor = UnrecognisedModuleDescriptorFactory.createUnrecognisedModuleDescriptor(plugin, element, e, moduleDescriptorFactory);
            log.error((Object)("There were problems loading the module '" + name + "' in plugin '" + plugin.getName() + "'. The module has been disabled."));
            log.error((Object)descriptor.getErrorText(), e);
            return descriptor;
        }
        if (moduleDescriptorDescriptor == null) {
            log.info((Object)("The module '" + name + "' in plugin '" + plugin.getName() + "' is in the list of excluded module descriptors, so not enabling."));
            return null;
        }
        try {
            moduleDescriptorDescriptor.init(plugin, element);
        }
        catch (PluginParseException e) {
            UnloadableModuleDescriptor descriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, element, (Throwable)((Object)e), moduleDescriptorFactory);
            log.error((Object)("There were problems loading the module '" + name + "'. The module and its plugin have been disabled."));
            log.error((Object)descriptor.getErrorText(), (Throwable)((Object)e));
            return descriptor;
        }
        return moduleDescriptorDescriptor;
    }

    protected PluginInformation createPluginInformation(Element element) {
        PluginInformation pluginInfo = new PluginInformation();
        if (element.element("description") != null) {
            pluginInfo.setDescription(element.element("description").getTextTrim());
            if (element.element("description").attributeValue("key") != null) {
                pluginInfo.setDescriptionKey(element.element("description").attributeValue("key"));
            }
        }
        if (element.element("version") != null) {
            pluginInfo.setVersion(element.element("version").getTextTrim());
        }
        if (element.element("vendor") != null) {
            Element vendor = element.element("vendor");
            pluginInfo.setVendorName(vendor.attributeValue("name"));
            pluginInfo.setVendorUrl(vendor.attributeValue("url"));
        }
        Iterator iterator = element.elements("param").iterator();
        while (iterator.hasNext()) {
            Element param = (Element)iterator.next();
            if (param.attribute("name") == null) continue;
            pluginInfo.addParameter(param.attribute("name").getData().toString(), param.getText());
        }
        if (element.element("application-version") != null) {
            pluginInfo.setMaxVersion(Float.parseFloat(element.element("application-version").attributeValue("max")));
            pluginInfo.setMinVersion(Float.parseFloat(element.element("application-version").attributeValue("min")));
        }
        if (element.element("java-version") != null) {
            pluginInfo.setMinJavaVersion(Float.valueOf(element.element("java-version").attributeValue("min")));
        }
        return pluginInfo;
    }

    public String getKey() {
        return this.getPluginElement().attributeValue("key");
    }

    public int getPluginsVersion() {
        String val = this.getPluginElement().attributeValue("pluginsVersion");
        if (val != null) {
            return Integer.parseInt(val);
        }
        return 1;
    }

    public boolean isSystemPlugin() {
        return "true".equalsIgnoreCase(this.getPluginElement().attributeValue("system"));
    }
}

