/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractWebResourceFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

class CssWebResourceFormatter
extends AbstractWebResourceFormatter {
    private static final String CSS_EXTENSION = ".css";
    private static final List HANDLED_PARAMETERS = Arrays.asList("title", "media", "charset");

    CssWebResourceFormatter() {
    }

    public boolean matches(String name) {
        return name != null && name.endsWith(CSS_EXTENSION);
    }

    public String formatResource(String name, String url, Map params) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(url).append("\"");
        List attributes = this.getParametersAsAttributes(params);
        if (attributes != null && attributes.size() > 0) {
            buffer.append(" ").append(StringUtils.join(attributes.iterator(), (String)" "));
        }
        if (!params.containsKey("media")) {
            buffer.append(" media=\"all\"");
        }
        buffer.append("/>\n");
        if (BooleanUtils.toBoolean((String)((String)params.get("ieonly")))) {
            buffer.insert(0, "<!--[if IE]>\n");
            buffer.append("<![endif]-->\n");
        }
        return buffer.toString();
    }

    protected List getAttributeParameters() {
        return HANDLED_PARAMETERS;
    }
}

