/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration;

import com.atlassian.user.configuration.CacheConfiguration;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.atlassian.user.configuration.RepositoryProcessor;
import com.atlassian.user.repository.RepositoryIdentifier;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultRepositoryConfiguration
implements RepositoryConfiguration {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final RepositoryIdentifier identifier;
    private final RepositoryProcessor processor;
    private final Map components;
    private final Map componentClassNames;
    private CacheConfiguration cacheConfiguration;

    public DefaultRepositoryConfiguration(RepositoryIdentifier identifier, RepositoryProcessor processor, Map components, Map componentClassNames) {
        this.identifier = identifier;
        this.processor = processor;
        this.components = components;
        this.componentClassNames = componentClassNames;
    }

    public void addComponent(String componentName, Object component) {
        if (this.hasComponent(componentName)) {
            this.logger.info((Object)("Overwriting existing component with name [" + componentName + "]"));
        }
        this.components.put(componentName, component);
    }

    public Object getComponent(String componentName) {
        return this.components.get(componentName);
    }

    public boolean hasComponent(String componentName) {
        return this.components.containsKey(componentName) && this.components.get(componentName) != null;
    }

    public String getComponentClassName(String componentName) {
        return (String)this.componentClassNames.get(componentName);
    }

    public RepositoryAccessor configure() throws ConfigurationException {
        return this.processor.process(this);
    }

    public RepositoryIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean hasClassForComponent(String componentName) {
        return this.componentClassNames.containsKey(componentName);
    }

    public Set getComponentNames() {
        return Collections.unmodifiableSet(this.components.keySet());
    }

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    public boolean isCachingEnabled() {
        return this.cacheConfiguration != null;
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.cacheConfiguration;
    }
}

