/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search.page;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.search.page.AbstractPrefetchingPager;
import com.atlassian.user.util.EnumerationAdaptor;
import com.atlassian.user.util.LDAPUtils;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Logger;

public abstract class AbstractLDAPPager
extends AbstractPrefetchingPager
implements Iterator {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected NamingEnumeration enume;
    protected Filter originalQuery;
    protected LdapContextFactory repository;
    protected String originalBaseSearchContext;
    protected boolean searchAllDepths;
    protected String[] returningAttributes;
    private int timeLimitMillis;
    public boolean closed;

    protected AbstractLDAPPager(LdapContextFactory repository, LDAPPagerInfo info) {
        this.repository = repository;
        this.enume = info.getNamingEnumeration();
        this.originalQuery = info.getLDAPQuery();
        this.originalBaseSearchContext = info.getBaseSearchContext();
        this.searchAllDepths = info.isSearchAllDepths();
        this.returningAttributes = info.getReturningAttributes();
        this.timeLimitMillis = info.getTimeToLive();
    }

    public AbstractLDAPPager() {
    }

    protected abstract List preloadSearchResult(SearchResult var1, List var2) throws EntityException;

    public void remove() {
        throw new UnsupportedOperationException("This iterator does not support removal.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void preload() {
        block23: {
            NamingException e222;
            DirContext ctx;
            block21: {
                this.indexOfFirstItemInCurrentPage = this.idx;
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.push((String)(this.getClass().getName() + "_preload__(originalQuery= " + this.originalQuery + ")"));
                }
                ctx = null;
                if (this.closed) {
                    ctx = this.repository.getLDAPContext();
                    SearchControls ctls = LDAPUtils.createSearchControls(this.returningAttributes, this.searchAllDepths, this.timeLimitMillis);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("AbstractLDAPPager.preload:" + this.originalQuery.encode()));
                    }
                    this.enume = ctx.search(this.originalBaseSearchContext, this.originalQuery.encode(), ctls);
                }
                super.preload(new EnumerationAdaptor(this.enume));
                Object var4_4 = null;
                if (this.enume == null) break block21;
                try {
                    this.enume.close();
                }
                catch (NamingException e222) {
                    this.log.error((Object)"Error closing enumeration.", (Throwable)e222);
                }
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e222) {
                    this.log.error((Object)"Error closing context.", (Throwable)e222);
                }
            }
            this.closed = true;
            {
                break block23;
                catch (Exception e3) {
                    NamingException e222;
                    this.log.error((Object)"Could not close connection", (Throwable)e3);
                    Object var4_5 = null;
                    if (this.enume != null) {
                        try {
                            this.enume.close();
                        }
                        catch (NamingException e222) {
                            this.log.error((Object)"Error closing enumeration.", (Throwable)e222);
                        }
                    }
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (NamingException e222) {
                            this.log.error((Object)"Error closing context.", (Throwable)e222);
                        }
                    }
                    this.closed = true;
                }
            }
            catch (Throwable throwable) {
                NamingException e222;
                Object var4_6 = null;
                if (this.enume != null) {
                    try {
                        this.enume.close();
                    }
                    catch (NamingException e222) {
                        this.log.error((Object)"Error closing enumeration.", (Throwable)e222);
                    }
                }
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e222) {
                        this.log.error((Object)"Error closing context.", (Throwable)e222);
                    }
                }
                this.closed = true;
                throw throwable;
            }
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_preload__(originalQuery= " + this.originalQuery + ")"));
        }
    }

    protected List fetch(Object element, List prefetched) throws EntityException {
        return this.preloadSearchResult((SearchResult)element, prefetched);
    }
}

