/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.rpc.AlreadyExistsException;
import com.atlassian.confluence.rpc.AuthenticationFailedException;
import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.VersionMismatchException;
import com.atlassian.confluence.rpc.soap.ConfluenceSoapService;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntrySummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteClusterInformation;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermissionSet;
import com.atlassian.confluence.rpc.soap.beans.RemoteLabel;
import com.atlassian.confluence.rpc.soap.beans.RemoteNodeStatus;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemotePageHistory;
import com.atlassian.confluence.rpc.soap.beans.RemotePageSummary;
import com.atlassian.confluence.rpc.soap.beans.RemotePermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteSearchResult;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceGroup;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceSummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import java.util.Map;

public class ConfluenceSoapServiceDelegator
implements ConfluenceSoapService {
    private ConfluenceSoapService soapService;

    public String login(String username, String password) throws AuthenticationFailedException, RemoteException {
        return this.soapService.login(username, password);
    }

    public boolean logout(String token) throws RemoteException {
        return this.soapService.logout(token);
    }

    public RemoteSpaceSummary[] getSpaces(String token) throws InvalidSessionException, RemoteException {
        return this.soapService.getSpaces(token);
    }

    public RemoteSpaceSummary[] getSpacesInGroup(String token, String spaceGroupKey) throws RemoteException {
        return new RemoteSpaceSummary[0];
    }

    public RemoteSpace addSpace(String token, RemoteSpace space) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException {
        return this.soapService.addSpace(token, space);
    }

    public RemoteSpace storeSpace(String token, RemoteSpace remoteSpace) throws RemoteException {
        return this.soapService.addSpace(token, remoteSpace);
    }

    public RemoteSpaceGroup addSpaceGroup(String token, RemoteSpaceGroup spaceGroup) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException {
        return this.soapService.addSpaceGroup(token, spaceGroup);
    }

    public RemoteSpaceGroup getSpaceGroup(String token, String spaceGroup) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException {
        return this.soapService.getSpaceGroup(token, spaceGroup);
    }

    public RemoteSpaceGroup[] getSpaceGroups(String token) throws InvalidSessionException, RemoteException {
        return this.soapService.getSpaceGroups(token);
    }

    public boolean removeSpaceGroup(String token, String spaceGroupKey) throws RemoteException {
        return this.soapService.removeSpaceGroup(token, spaceGroupKey);
    }

    public RemoteSpace addPersonalSpace(String token, RemoteSpace space, String username) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException {
        return this.soapService.addPersonalSpace(token, space, username);
    }

    public boolean convertToPersonalSpace(String token, String userName, String spaceKey, String newName, boolean updateLinks) throws RemoteException {
        return this.soapService.convertToPersonalSpace(token, userName, spaceKey, newName, updateLinks);
    }

    public Boolean removeSpace(String token, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removeSpace(token, spaceKey);
    }

    public RemoteSpace getSpace(String token, String spaceKey) throws InvalidSessionException, RemoteException {
        return this.soapService.getSpace(token, spaceKey);
    }

    public String[] getPermissions(String token, String spaceKey) throws InvalidSessionException, RemoteException {
        return this.soapService.getPermissions(token, spaceKey);
    }

    public String[] getPermissionsForUser(String token, String spaceKey, String userName) throws InvalidSessionException, RemoteException {
        return this.soapService.getPermissionsForUser(token, spaceKey, userName);
    }

    public boolean addPermissionToSpace(String token, String permission, String remoteEntityName, String spaceKey) throws RemoteException {
        return this.soapService.addPermissionToSpace(token, permission, remoteEntityName, spaceKey);
    }

    public boolean addPermissionsToSpace(String token, String[] permissions, String remoteEntityName, String spaceKey) throws RemoteException {
        return this.soapService.addPermissionsToSpace(token, permissions, remoteEntityName, spaceKey);
    }

    public boolean removePermissionFromSpace(String token, String permission, String remoteEntityName, String spaceKey) throws NotPermittedException, RemoteException {
        return this.soapService.removePermissionFromSpace(token, permission, remoteEntityName, spaceKey);
    }

    public boolean addAnonymousPermissionToSpace(String token, String permission, String spaceKey) throws RemoteException {
        return this.soapService.addAnonymousPermissionToSpace(token, permission, spaceKey);
    }

    public boolean addAnonymousPermissionsToSpace(String token, String[] permissions, String spaceKey) throws RemoteException {
        return this.soapService.addAnonymousPermissionsToSpace(token, permissions, spaceKey);
    }

    public boolean removeAnonymousPermissionFromSpace(String token, String permission, String spaceKey) throws NotPermittedException, RemoteException {
        return this.soapService.removeAnonymousPermissionFromSpace(token, permission, spaceKey);
    }

    public String[] getSpaceLevelPermissions(String token) throws RemoteException {
        return this.soapService.getSpaceLevelPermissions(token);
    }

    public RemotePageSummary[] getPages(String token, String spaceKey) throws InvalidSessionException, RemoteException {
        return this.soapService.getPages(token, spaceKey);
    }

    public RemotePage getPage(String token, String spaceKey, String pageTitle) throws InvalidSessionException, RemoteException {
        return this.soapService.getPage(token, spaceKey, pageTitle);
    }

    public RemotePage getPage(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.soapService.getPage(token, pageId);
    }

    public RemoteComment[] getComments(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.soapService.getComments(token, pageId);
    }

    public RemoteComment getComment(String token, long commentId) throws InvalidSessionException, RemoteException {
        return this.soapService.getComment(token, commentId);
    }

    public RemoteComment addComment(String token, RemoteComment comment) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.soapService.addComment(token, comment);
    }

    public RemoteComment editComment(String token, RemoteComment comment) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.soapService.editComment(token, comment);
    }

    public boolean removeComment(String token, long commentId) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.soapService.removeComment(token, commentId);
    }

    public RemotePageSummary[] getTopLevelPages(String token, String spaceKey) throws RemoteException {
        return this.soapService.getTopLevelPages(token, spaceKey);
    }

    public RemotePageSummary[] getAncestors(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.soapService.getAncestors(token, pageId);
    }

    public RemotePageSummary[] getChildren(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.soapService.getChildren(token, pageId);
    }

    public RemotePageSummary[] getDescendents(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.soapService.getDescendents(token, pageId);
    }

    public RemoteAttachment[] getAttachments(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.soapService.getAttachments(token, pageId);
    }

    public RemotePageHistory[] getPageHistory(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.soapService.getPageHistory(token, pageId);
    }

    public String renderContent(String token, String spaceKey, long pageId, String newContent) throws InvalidSessionException, RemoteException {
        return this.soapService.renderContent(token, spaceKey, pageId, newContent);
    }

    public String renderContent(String token, String spaceKey, long pageId, String newContent, Map renderParameters) throws RemoteException {
        return this.soapService.renderContent(token, spaceKey, pageId, newContent, renderParameters);
    }

    public RemoteAttachment addAttachment(String token, long contentId, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException {
        return this.soapService.addAttachment(token, contentId, attachment, attachmentData);
    }

    public RemoteAttachment addAttachment(String token, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException {
        return this.soapService.addAttachment(token, attachment, attachmentData);
    }

    public RemoteAttachment getAttachment(String token, long entityId, String fileName, int version) throws RemoteException {
        return this.soapService.getAttachment(token, entityId, fileName, version);
    }

    public byte[] getAttachmentData(String token, long entityId, String fileName, int version) throws RemoteException {
        return this.soapService.getAttachmentData(token, entityId, fileName, version);
    }

    public boolean removeAttachment(String token, long contentId, String fileName) throws RemoteException {
        return this.soapService.removeAttachment(token, contentId, fileName);
    }

    public boolean moveAttachment(String token, long originalContentId, String originalFileName, long newContentId, String newFileName) throws RemoteException {
        return this.soapService.moveAttachment(token, originalContentId, originalFileName, newContentId, newFileName);
    }

    public RemotePage storePage(String token, RemotePage page) throws VersionMismatchException, NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.storePage(token, page);
    }

    public Boolean movePageToTopLevel(String token, long pageId, String targetSpaceKey) throws RemoteException {
        return this.soapService.movePageToTopLevel(token, pageId, targetSpaceKey);
    }

    public Boolean movePage(String token, long sourcePageId, long targetPageId, String position) throws RemoteException {
        return this.soapService.movePage(token, sourcePageId, targetPageId, position);
    }

    public Boolean removePage(String token, long pageId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removePage(token, pageId);
    }

    public RemoteSearchResult[] search(String token, String query, int maxResults) throws InvalidSessionException, RemoteException {
        return this.soapService.search(token, query, maxResults);
    }

    public RemoteSearchResult[] search(String token, String query, Map params, int maxResults) throws RemoteException {
        return this.soapService.search(token, query, params, maxResults);
    }

    public RemoteBlogEntry getBlogEntryByDayAndTitle(String token, String spaceKey, int dayOfMonth, String postTitle) throws RemoteException {
        return this.soapService.getBlogEntryByDayAndTitle(token, spaceKey, dayOfMonth, postTitle);
    }

    public RemoteBlogEntry getBlogEntry(String token, long entryId) throws RemoteException {
        return this.soapService.getBlogEntry(token, entryId);
    }

    public RemoteBlogEntrySummary[] getBlogEntries(String token, String spaceKey) throws InvalidSessionException, RemoteException {
        return this.soapService.getBlogEntries(token, spaceKey);
    }

    public RemoteBlogEntry storeBlogEntry(String token, RemoteBlogEntry blogEntry) throws VersionMismatchException, NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.storeBlogEntry(token, blogEntry);
    }

    public RemoteServerInfo getServerInfo(String token) throws InvalidSessionException, RemoteException {
        return this.soapService.getServerInfo(token);
    }

    public RemotePermission[] getPagePermissions(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.soapService.getPagePermissions(token, pageId);
    }

    public String exportSpace(String token, String spaceKey, String exportType) throws RemoteException {
        return this.soapService.exportSpace(token, spaceKey, exportType);
    }

    public String exportSite(String token, boolean exportAttachments) throws RemoteException {
        return this.soapService.exportSite(token, exportAttachments);
    }

    public boolean importSpace(String token, byte[] importData) throws RemoteException {
        return this.soapService.importSpace(token, importData);
    }

    public boolean flushIndexQueue(String token) throws RemoteException {
        return this.soapService.flushIndexQueue(token);
    }

    public boolean clearIndexQueue(String token) throws RemoteException {
        return this.soapService.clearIndexQueue(token);
    }

    public RemoteClusterInformation getClusterInformation(String token) throws RemoteException {
        return this.soapService.getClusterInformation(token);
    }

    public RemoteNodeStatus[] getClusterNodeStatuses(String token) throws RemoteException {
        return this.soapService.getClusterNodeStatuses(token);
    }

    public String[] getGroups(String token) throws RemoteException {
        return this.soapService.getGroups(token);
    }

    public boolean hasGroup(String token, String groupname) throws InvalidSessionException, RemoteException {
        return this.soapService.hasGroup(token, groupname);
    }

    public boolean addGroup(String token, String groupname) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.addGroup(token, groupname);
    }

    public boolean removeGroup(String token, String groupname, String defaultGroupName) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removeGroup(token, groupname, defaultGroupName);
    }

    public boolean removeAllPermissionsForGroup(String token, String groupname) throws RemoteException {
        return this.soapService.removeAllPermissionsForGroup(token, groupname);
    }

    public String[] getUserGroups(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.getUserGroups(token, username);
    }

    public boolean addUserToGroup(String token, String username, String groupname) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.addUserToGroup(token, username, groupname);
    }

    public boolean removeUserFromGroup(String token, String username, String groupname) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removeUserFromGroup(token, username, groupname);
    }

    public RemoteUser getUser(String token, String username) throws InvalidSessionException, RemoteException {
        return this.soapService.getUser(token, username);
    }

    public boolean hasUser(String token, String username) throws InvalidSessionException, RemoteException {
        return this.soapService.hasUser(token, username);
    }

    public void addUser(String token, RemoteUser remoteUser, String password) throws NotPermittedException, InvalidSessionException, RemoteException {
        this.soapService.addUser(token, remoteUser, password);
    }

    public boolean removeUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removeUser(token, username);
    }

    public boolean editUser(String token, RemoteUser remoteUser) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.editUser(token, remoteUser);
    }

    public boolean deactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.deactivateUser(token, username);
    }

    public boolean reactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.reactivateUser(token, username);
    }

    public String[] getActiveUsers(String token, boolean viewAll) throws InvalidSessionException, RemoteException {
        return this.soapService.getActiveUsers(token, viewAll);
    }

    public boolean setUserInformation(String token, RemoteUserInformation userInfo) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.setUserInformation(token, userInfo);
    }

    public RemoteUserInformation getUserInformation(String token, String username) throws InvalidSessionException, RemoteException {
        return this.soapService.getUserInformation(token, username);
    }

    public boolean changeMyPassword(String token, String oldPass, String newPass) throws InvalidSessionException, RemoteException {
        return this.soapService.changeMyPassword(token, oldPass, newPass);
    }

    public boolean changeUserPassword(String token, String username, String newPass) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.changeUserPassword(token, username, newPass);
    }

    public boolean addProfilePicture(String token, String userName, String fileName, String mimeType, byte[] pictureData) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.addProfilePicture(token, userName, fileName, mimeType, pictureData);
    }

    public RemoteLabel[] getLabelsById(String token, long objectId) throws InvalidSessionException, RemoteException {
        return this.soapService.getLabelsById(token, objectId);
    }

    public RemoteLabel[] getMostPopularLabels(String token, int maxCount) throws InvalidSessionException, RemoteException {
        return this.soapService.getMostPopularLabels(token, maxCount);
    }

    public RemoteLabel[] getMostPopularLabelsInSpace(String token, String spaceKey, int maxCount) throws InvalidSessionException, RemoteException {
        return this.soapService.getMostPopularLabelsInSpace(token, spaceKey, maxCount);
    }

    public RemoteLabel[] getRecentlyUsedLabels(String token, int maxResults) throws InvalidSessionException, RemoteException {
        return this.soapService.getRecentlyUsedLabels(token, maxResults);
    }

    public RemoteLabel[] getRecentlyUsedLabelsInSpace(String token, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException {
        return this.soapService.getRecentlyUsedLabelsInSpace(token, spaceKey, maxResults);
    }

    public RemoteSpace[] getSpacesWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException {
        return this.soapService.getSpacesWithLabel(token, labelName);
    }

    public RemoteLabel[] getRelatedLabels(String token, String labelName, int maxResults) throws InvalidSessionException, RemoteException {
        return this.soapService.getRelatedLabels(token, labelName, maxResults);
    }

    public RemoteLabel[] getRelatedLabelsInSpace(String token, String labelName, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException {
        return this.soapService.getRelatedLabelsInSpace(token, labelName, spaceKey, maxResults);
    }

    public RemoteLabel[] getLabelsByDetail(String token, String labelName, String namespace, String spaceKey, String owner) throws InvalidSessionException, RemoteException, NotPermittedException {
        return this.soapService.getLabelsByDetail(token, labelName, namespace, spaceKey, owner);
    }

    public RemoteSearchResult[] getLabelContentById(String token, long labelId) throws InvalidSessionException, RemoteException {
        return this.soapService.getLabelContentById(token, labelId);
    }

    public RemoteSearchResult[] getLabelContentByName(String token, String labelName) throws InvalidSessionException, RemoteException {
        return this.soapService.getLabelContentByName(token, labelName);
    }

    public RemoteSearchResult[] getLabelContentByObject(String token, RemoteLabel labelObject) throws InvalidSessionException, RemoteException {
        return this.soapService.getLabelContentByObject(token, labelObject);
    }

    public RemoteSpace[] getSpacesContainingContentWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException {
        return this.soapService.getSpacesContainingContentWithLabel(token, labelName);
    }

    public boolean addLabelByName(String token, String labelName, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.addLabelByName(token, labelName, objectId);
    }

    public boolean addLabelById(String token, long labelId, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.addLabelById(token, labelId, objectId);
    }

    public boolean addLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.addLabelByObject(token, labelObject, objectId);
    }

    public boolean addLabelByNameToSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.addLabelByNameToSpace(token, labelName, spaceKey);
    }

    public boolean removeLabelByName(String token, String labelName, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removeLabelByName(token, labelName, objectId);
    }

    public boolean removeLabelById(String token, long labelId, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removeLabelById(token, labelId, objectId);
    }

    public boolean removeLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removeLabelByObject(token, labelObject, objectId);
    }

    public boolean removeLabelByNameFromSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.removeLabelByNameFromSpace(token, labelName, spaceKey);
    }

    public RemoteContentPermissionSet[] getContentPermissionSets(String token, long contentId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.getContentPermissionSets(token, contentId);
    }

    public RemoteContentPermissionSet getContentPermissionSet(String token, long contentId, String permissionType) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.getContentPermissionSet(token, contentId, permissionType);
    }

    public boolean setContentPermissions(String token, long contentId, String permissionType, RemoteContentPermission[] remoteContentPermissions) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapService.setContentPermissions(token, contentId, permissionType, remoteContentPermissions);
    }

    public boolean addGlobalPermission(String token, String permission, String remoteEntityName) throws NotPermittedException, RemoteException {
        return this.soapService.addGlobalPermission(token, permission, remoteEntityName);
    }

    public boolean addGlobalPermissions(String token, String[] permissions, String remoteEntityName) throws NotPermittedException, RemoteException {
        return this.soapService.addGlobalPermissions(token, permissions, remoteEntityName);
    }

    public boolean removeGlobalPermission(String token, String permission, String remoteEntityName) throws RemoteException {
        return this.soapService.removeGlobalPermission(token, permission, remoteEntityName);
    }

    public boolean addAnonymousUsePermission(String token) throws RemoteException {
        return this.soapService.addAnonymousUsePermission(token);
    }

    public boolean removeAnonymousUsePermission(String token) throws RemoteException {
        return this.soapService.removeAnonymousUsePermission(token);
    }

    public void setSoapServiceDelegator(ConfluenceSoapService soapServiceDelegator) {
        this.soapService = soapServiceDelegator;
    }

    public boolean setEnableWysiwyg(String token, boolean value) throws RemoteException {
        return this.soapService.setEnableWysiwyg(token, value);
    }

    public boolean setEnableAnonymousAccess(String token, boolean value) throws RemoteException {
        return this.soapService.setEnableAnonymousAccess(token, value);
    }

    public boolean isRpcPluginEnabled(String token) {
        return this.soapService.isRpcPluginEnabled(token);
    }
}

