/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.rpc.AlreadyExistsException;
import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.ConfluenceSoapService;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntrySummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteClusterInformation;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermissionSet;
import com.atlassian.confluence.rpc.soap.beans.RemoteLabel;
import com.atlassian.confluence.rpc.soap.beans.RemoteNodeStatus;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemotePageHistory;
import com.atlassian.confluence.rpc.soap.beans.RemotePageSummary;
import com.atlassian.confluence.rpc.soap.beans.RemotePermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteSearchResult;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceGroup;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceSummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import com.atlassian.confluence.rpc.soap.services.AdminSoapService;
import com.atlassian.confluence.rpc.soap.services.AttachmentsSoapService;
import com.atlassian.confluence.rpc.soap.services.BlogsSoapService;
import com.atlassian.confluence.rpc.soap.services.LabelsSoapService;
import com.atlassian.confluence.rpc.soap.services.PagesSoapService;
import com.atlassian.confluence.rpc.soap.services.SpacesSoapService;
import com.atlassian.confluence.rpc.soap.services.UsersSoapService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConfluenceSoapServiceImpl
implements ConfluenceSoapService {
    public static final List VIEW_SPACE_PERMISSION_TYPES = Arrays.asList("VIEWSPACE");
    public static final List MODIFY_SPACE_PERMISSION_TYPES = Arrays.asList("EDITSPACE");
    public static final List ADMINISTER_PERMISSION_TYPES = Arrays.asList("SYSTEMADMINISTRATOR");
    public static final List SPACE_ADMIN_PERMISSION_TYPES = Arrays.asList("SETSPACEPERMISSIONS");
    public static final List REMOVE_PAGE_PERMISSION_TYPES = Arrays.asList("REMOVEPAGE");
    public static final List EXPORT_SPACE_PERMISSION_TYPES = Arrays.asList("EXPORTSPACE");
    SpacesSoapService spacesService;
    PagesSoapService pagesService;
    UsersSoapService usersService;
    BlogsSoapService blogsService;
    AdminSoapService adminSoapService;
    LabelsSoapService labelsSoapService;
    AttachmentsSoapService attachmentsService;

    public void setSpacesSoapService(SpacesSoapService spacesService) {
        this.spacesService = spacesService;
    }

    public void setPagesSoapService(PagesSoapService pagesService) {
        this.pagesService = pagesService;
    }

    public void setUsersSoapService(UsersSoapService usersService) {
        this.usersService = usersService;
    }

    public void setBlogsSoapService(BlogsSoapService blogsService) {
        this.blogsService = blogsService;
    }

    public void setGlobalSoapService(AdminSoapService adminSoapService) {
        this.adminSoapService = adminSoapService;
    }

    public void setAdminSoapService(AdminSoapService adminSoapService) {
        this.adminSoapService = adminSoapService;
    }

    public void setLabelsSoapService(LabelsSoapService labelsSoapService) {
        this.labelsSoapService = labelsSoapService;
    }

    public void setAttachmentsSoapService(AttachmentsSoapService attachmentsService) {
        this.attachmentsService = attachmentsService;
    }

    public String login(String username, String password) throws RemoteException {
        throw new UnsupportedOperationException("Should be handled in an interceptor.");
    }

    public boolean logout(String token) {
        throw new UnsupportedOperationException("Should be handled in an interceptor.");
    }

    public RemoteSpaceSummary[] getSpaces(String token) throws RemoteException {
        return this.spacesService.getSpaces();
    }

    public RemoteSpaceSummary[] getSpacesInGroup(String token, String spaceGroupKey) throws RemoteException {
        return this.spacesService.getSpacesInGroup(spaceGroupKey);
    }

    public RemoteSpace addSpace(String token, RemoteSpace space) throws RemoteException {
        return this.spacesService.addSpace(space);
    }

    public RemoteSpace storeSpace(String token, RemoteSpace remoteSpace) throws RemoteException {
        return this.spacesService.storeSpace(remoteSpace);
    }

    public RemoteSpaceGroup addSpaceGroup(String token, RemoteSpaceGroup spaceGroup) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException {
        return this.spacesService.addSpaceGroup(spaceGroup);
    }

    public RemoteSpaceGroup getSpaceGroup(String token, String spaceGroupKey) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException {
        return this.spacesService.getSpaceGroup(spaceGroupKey);
    }

    public RemoteSpaceGroup[] getSpaceGroups(String token) throws InvalidSessionException, RemoteException {
        return this.spacesService.getSpaceGroups();
    }

    public boolean removeSpaceGroup(String token, String spaceGroupKey) throws RemoteException {
        return this.spacesService.removeSpaceGroup(spaceGroupKey);
    }

    public RemoteSpace addPersonalSpace(String token, RemoteSpace space, String username) throws RemoteException {
        return this.spacesService.addPersonalSpace(space, username);
    }

    public boolean convertToPersonalSpace(String token, String userName, String spaceKey, String newName, boolean updateLinks) throws RemoteException {
        return this.spacesService.convertToPersonalSpace(userName, spaceKey, newName, updateLinks);
    }

    public Boolean removeSpace(String token, String spaceKey) throws RemoteException {
        return this.spacesService.removeSpace(spaceKey);
    }

    public RemoteSpace getSpace(String token, String spaceKey) throws RemoteException {
        return this.spacesService.getSpace(spaceKey);
    }

    public String[] getPermissions(String token, String spaceKey) throws RemoteException {
        return this.spacesService.getPermissions(spaceKey);
    }

    public String[] getPermissionsForUser(String token, String spaceKey, String userName) throws InvalidSessionException, RemoteException {
        return this.spacesService.getPermissions(spaceKey, userName);
    }

    public boolean addPermissionToSpace(String token, String permission, String remoteEntityName, String spaceKey) throws RemoteException {
        return this.spacesService.addPermissionToSpace(permission, remoteEntityName, spaceKey);
    }

    public boolean addPermissionsToSpace(String token, String[] permissions, String remoteEntityName, String spaceKey) throws RemoteException {
        return this.spacesService.addPermissionsToSpace(permissions, remoteEntityName, spaceKey);
    }

    public boolean removePermissionFromSpace(String token, String permission, String remoteEntityName, String spaceKey) throws NotPermittedException, RemoteException {
        return this.spacesService.removePermissionFromSpace(permission, remoteEntityName, spaceKey);
    }

    public boolean addGlobalPermission(String token, String permission, String remoteEntityName) throws NotPermittedException, RemoteException {
        return this.spacesService.addGlobalPermission(permission, remoteEntityName);
    }

    public boolean addGlobalPermissions(String token, String[] permissions, String remoteEntityName) throws NotPermittedException, RemoteException {
        return this.spacesService.addGlobalPermissions(permissions, remoteEntityName);
    }

    public boolean removeGlobalPermission(String token, String permission, String remoteEntityName) throws RemoteException {
        return this.spacesService.removeGlobalPermission(permission, remoteEntityName);
    }

    public boolean addAnonymousUsePermission(String token) throws RemoteException {
        return this.spacesService.addAnonymousUsePermission();
    }

    public boolean removeAnonymousUsePermission(String token) throws RemoteException {
        return this.spacesService.removeAnonymousUserPermission();
    }

    public boolean addAnonymousPermissionToSpace(String token, String permission, String spaceKey) throws RemoteException {
        return this.spacesService.addPermissionToSpace(permission, null, spaceKey);
    }

    public boolean addAnonymousPermissionsToSpace(String token, String[] permissions, String spaceKey) throws RemoteException {
        return this.spacesService.addPermissionsToSpace(permissions, null, spaceKey);
    }

    public boolean removeAnonymousPermissionFromSpace(String token, String permission, String spaceKey) throws NotPermittedException, RemoteException {
        return this.spacesService.removePermissionFromSpace(permission, null, spaceKey);
    }

    public String[] getSpaceLevelPermissions(String token) throws RemoteException {
        return this.spacesService.getSpaceLevelPermissions();
    }

    public RemotePageSummary[] getPages(String token, String spaceKey) throws RemoteException {
        return this.pagesService.getPages(spaceKey);
    }

    public RemotePage getPage(String token, String spaceKey, String pageTitle) throws InvalidSessionException, RemoteException {
        return this.pagesService.getPage(spaceKey, pageTitle);
    }

    public RemotePage getPage(String token, long pageId) throws RemoteException {
        return this.pagesService.getPage(pageId);
    }

    public RemoteComment[] getComments(String token, long pageId) throws RemoteException {
        return this.pagesService.getComments(pageId);
    }

    public RemoteComment getComment(String token, long commentId) throws InvalidSessionException, RemoteException {
        return this.pagesService.getComment(commentId);
    }

    public RemoteComment addComment(String token, RemoteComment comment) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.pagesService.addComment(comment);
    }

    public RemoteComment editComment(String token, RemoteComment comment) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.pagesService.editComment(comment);
    }

    public boolean removeComment(String token, long commentId) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.pagesService.removeComment(commentId);
    }

    public RemotePageSummary[] getTopLevelPages(String token, String spaceKey) throws RemoteException {
        return this.pagesService.getTopLevelPages(spaceKey);
    }

    public RemotePageSummary[] getAncestors(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.pagesService.getAncestors(pageId);
    }

    public RemotePageSummary[] getChildren(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.pagesService.getChildren(pageId);
    }

    public RemotePageSummary[] getDescendents(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.pagesService.getDescendents(pageId);
    }

    public RemoteAttachment[] getAttachments(String token, long pageId) throws RemoteException {
        return this.pagesService.getAttachments(pageId);
    }

    public RemotePageHistory[] getPageHistory(String token, long pageId) throws RemoteException {
        return this.pagesService.getPageHistory(pageId);
    }

    public RemoteSearchResult[] search(String token, String query, int maxResults) throws RemoteException {
        return this.pagesService.search(query, maxResults);
    }

    public RemoteSearchResult[] search(String token, String query, Map params, int maxResults) throws RemoteException {
        return this.pagesService.search(query, params, maxResults);
    }

    public RemoteBlogEntry getBlogEntryByDayAndTitle(String token, String spaceKey, int dayOfMonth, String postTitle) throws RemoteException {
        return this.blogsService.getBlogEntryByDayAndTitle(spaceKey, dayOfMonth, postTitle);
    }

    public String renderContent(String token, String spaceKey, long pageId, String newContent) throws RemoteException {
        return this.pagesService.renderContent(spaceKey, pageId, newContent);
    }

    public String renderContent(String token, String spaceKey, long pageId, String newContent, Map renderParameters) throws RemoteException {
        return this.pagesService.renderContent(spaceKey, pageId, newContent, renderParameters);
    }

    public RemoteAttachment addAttachment(String token, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException {
        return this.attachmentsService.addAttachment(attachment.getPageId(), attachment, attachmentData);
    }

    public RemoteAttachment addAttachment(String token, long contentId, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException {
        return this.attachmentsService.addAttachment(contentId, attachment, attachmentData);
    }

    public RemoteAttachment getAttachment(String token, long contentId, String fileName, int version) throws RemoteException {
        return this.attachmentsService.getAttachment(contentId, fileName, version);
    }

    public byte[] getAttachmentData(String token, long contentId, String fileName, int version) throws RemoteException {
        return this.attachmentsService.getAttachmentData(contentId, fileName, version);
    }

    public boolean removeAttachment(String token, long contentId, String fileName) throws RemoteException {
        return this.attachmentsService.removeAttachment(contentId, fileName);
    }

    public boolean moveAttachment(String token, long originalContentId, String originalFileName, long newContentId, String newFileName) throws RemoteException {
        return this.attachmentsService.moveAttachment(originalContentId, originalFileName, newContentId, newFileName);
    }

    public Boolean movePageToTopLevel(String token, long pageId, String targetSpaceKey) throws RemoteException {
        return this.pagesService.movePageToTopLevel(pageId, targetSpaceKey);
    }

    public Boolean movePage(String token, long sourcePageId, long targetPageId, String position) throws RemoteException {
        return this.pagesService.movePage(sourcePageId, targetPageId, position);
    }

    public Boolean removePage(String token, long pageId) throws RemoteException {
        return this.pagesService.removePage(pageId);
    }

    public RemotePage storePage(String token, RemotePage rpage) throws RemoteException {
        return this.pagesService.storePage(rpage);
    }

    public RemotePermission[] getPagePermissions(String token, long pageId) throws RemoteException {
        return this.pagesService.getPermissions(pageId);
    }

    public RemoteBlogEntry getBlogEntry(String token, long entryId) throws RemoteException {
        return this.blogsService.getBlogEntry(entryId);
    }

    public RemoteBlogEntrySummary[] getBlogEntries(String token, String spaceKey) throws RemoteException {
        return this.blogsService.getBlogEntries(spaceKey);
    }

    public RemoteBlogEntry storeBlogEntry(String token, RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        return this.blogsService.storeBlogEntry(remoteBlogEntry);
    }

    public String[] getGroups(String token) throws RemoteException {
        return this.usersService.getGroups();
    }

    public boolean hasGroup(String token, String groupname) throws InvalidSessionException, RemoteException {
        return this.usersService.hasGroup(groupname);
    }

    public boolean addGroup(String token, String groupname) throws RemoteException {
        return this.usersService.addGroup(groupname);
    }

    public boolean removeGroup(String token, String groupname, String defaultGroupName) throws RemoteException {
        return this.usersService.removeGroup(groupname, defaultGroupName);
    }

    public boolean removeAllPermissionsForGroup(String token, String groupname) throws RemoteException {
        return this.usersService.removeAllPermissionsForGroup(groupname);
    }

    public String[] getUserGroups(String token, String username) throws RemoteException {
        return this.usersService.getUserGroups(username);
    }

    public boolean addUserToGroup(String token, String username, String groupname) throws RemoteException {
        return this.usersService.addUserToGroup(username, groupname);
    }

    public boolean removeUserFromGroup(String token, String username, String groupname) throws RemoteException {
        return this.usersService.removeUserFromGroup(username, groupname);
    }

    public RemoteUser getUser(String token, String username) throws RemoteException {
        return this.usersService.getUser(username);
    }

    public boolean hasUser(String token, String username) throws InvalidSessionException, RemoteException {
        return this.usersService.hasUser(username);
    }

    public void addUser(String token, RemoteUser remoteUser, String password) throws RemoteException {
        this.usersService.addUser(remoteUser, password);
    }

    public boolean removeUser(String token, String username) throws RemoteException {
        return this.usersService.removeUser(username);
    }

    public boolean editUser(String token, RemoteUser remoteUser) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.editUser(remoteUser);
    }

    public boolean deactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.deactivateUser(username);
    }

    public boolean reactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.reactivateUser(username);
    }

    public String[] getActiveUsers(String token, boolean viewAll) throws InvalidSessionException, RemoteException {
        return this.usersService.getActiveUsers(viewAll);
    }

    public boolean setUserInformation(String token, RemoteUserInformation userInfo) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.setUserInformation(userInfo);
    }

    public RemoteUserInformation getUserInformation(String token, String username) throws InvalidSessionException, RemoteException {
        return this.usersService.getUserInformation(username);
    }

    public boolean changeMyPassword(String token, String oldPass, String newPass) throws InvalidSessionException, RemoteException {
        return this.usersService.changeMyPassword(oldPass, newPass);
    }

    public boolean changeUserPassword(String token, String username, String newPass) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.changeUserPassword(username, newPass);
    }

    public boolean addProfilePicture(String token, String userName, String fileName, String mimeType, byte[] pictureData) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.addProfilePicture(userName, fileName, mimeType, pictureData);
    }

    public RemoteServerInfo getServerInfo(String token) throws RemoteException {
        return this.adminSoapService.getServerInfo();
    }

    public String exportSpace(String token, String spaceKey, String exportType) throws RemoteException {
        return this.spacesService.exportSpace(spaceKey, exportType);
    }

    public String exportSite(String token, boolean exportAttachments) throws RemoteException {
        return this.adminSoapService.exportSite(exportAttachments);
    }

    public boolean importSpace(String token, byte[] importData) throws RemoteException {
        return this.adminSoapService.importSpace(importData);
    }

    public boolean flushIndexQueue(String token) throws RemoteException {
        return this.adminSoapService.flushIndexQueue();
    }

    public boolean clearIndexQueue(String token) throws RemoteException {
        return this.adminSoapService.clearIndexQueue();
    }

    public RemoteClusterInformation getClusterInformation(String token) throws RemoteException {
        return this.adminSoapService.getClusterInformation();
    }

    public RemoteNodeStatus[] getClusterNodeStatuses(String token) throws RemoteException {
        return this.adminSoapService.getClusterNodeStatuses();
    }

    public RemoteLabel[] getLabelsById(String token, long objectId) throws RemoteException {
        return this.labelsSoapService.getLabelsById(objectId);
    }

    public RemoteLabel[] getMostPopularLabels(String token, int maxCount) throws RemoteException {
        return this.labelsSoapService.getMostPopularLabels(maxCount);
    }

    public RemoteLabel[] getMostPopularLabelsInSpace(String token, String spaceKey, int maxCount) throws RemoteException {
        return this.labelsSoapService.getMostPopularLabelsInSpace(spaceKey, maxCount);
    }

    public RemoteLabel[] getRecentlyUsedLabels(String token, int maxResults) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRecentlyUsedLabels(maxResults);
    }

    public RemoteLabel[] getRecentlyUsedLabelsInSpace(String token, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRecentlyUsedLabelsInSpace(spaceKey, maxResults);
    }

    public RemoteSpace[] getSpacesWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getSpacesWithLabel(labelName);
    }

    public RemoteLabel[] getRelatedLabels(String token, String labelName, int maxResults) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRelatedLabels(labelName, maxResults);
    }

    public RemoteLabel[] getRelatedLabelsInSpace(String token, String labelName, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRelatedLabelsInSpace(labelName, spaceKey, maxResults);
    }

    public RemoteLabel[] getLabelsByDetail(String token, String labelName, String namespace, String spaceKey, String owner) throws InvalidSessionException, RemoteException, NotPermittedException {
        return this.labelsSoapService.getLabelsByDetail(labelName, namespace, spaceKey, owner);
    }

    public RemoteSearchResult[] getLabelContentById(String token, long labelId) throws RemoteException {
        return this.labelsSoapService.getLabelContentById(labelId);
    }

    public RemoteSearchResult[] getLabelContentByName(String token, String labelName) throws RemoteException {
        return this.labelsSoapService.getLabelContentByName(labelName);
    }

    public RemoteSearchResult[] getLabelContentByObject(String token, RemoteLabel labelObject) throws RemoteException {
        return this.labelsSoapService.getLabelContentByObject(labelObject);
    }

    public RemoteSpace[] getSpacesContainingContentWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getSpacesContainingContentWithLabel(labelName);
    }

    public boolean addLabelByName(String token, String labelName, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelByName(labelName, objectId);
    }

    public boolean addLabelById(String token, long labelId, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelById(labelId, objectId);
    }

    public boolean addLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelByObject(labelObject, objectId);
    }

    public boolean addLabelByNameToSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.labelsSoapService.addLabelByNameToSpace(labelName, spaceKey);
    }

    public boolean removeLabelByName(String token, String labelName, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelByName(labelName, objectId);
    }

    public boolean removeLabelById(String token, long labelId, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelById(labelId, objectId);
    }

    public boolean removeLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelByObject(labelObject, objectId);
    }

    public boolean removeLabelByNameFromSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.labelsSoapService.removeLabelByNameFromSpace(labelName, spaceKey);
    }

    public RemoteContentPermissionSet[] getContentPermissionSets(String token, long contentId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.pagesService.getContentPermissionSets(contentId);
    }

    public RemoteContentPermissionSet getContentPermissionSet(String token, long contentId, String permissionType) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.pagesService.getContentPermissionSet(contentId, permissionType);
    }

    public boolean setContentPermissions(String token, long contentId, String permissionType, RemoteContentPermission[] remoteContentPermissions) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.pagesService.setContentPermissions(contentId, permissionType, remoteContentPermissions);
    }

    public boolean setEnableWysiwyg(String token, boolean value) throws RemoteException {
        return this.adminSoapService.setEnableWysiwyg(value);
    }

    public boolean setEnableAnonymousAccess(String token, boolean value) throws RemoteException {
        return this.adminSoapService.setEnableAnonymousAccess(value);
    }

    public boolean isRpcPluginEnabled(String token) {
        return this.adminSoapService.isRpcPluginEnabled();
    }
}

