/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AttachmentsSoapService {
    private AttachmentManager attachmentManager;
    private ContentEntityManager contentEntityManager;
    private PermissionManager permissionManager;

    public RemoteAttachment addAttachment(RemoteAttachment remoteAttachment, byte[] attachmentData) throws NotPermittedException, RemoteException {
        return this.addAttachment(remoteAttachment.getPageId(), remoteAttachment, attachmentData);
    }

    public RemoteAttachment addAttachment(long contentId, RemoteAttachment remoteAttachment, byte[] attachmentData) throws NotPermittedException, RemoteException {
        Attachment attachment;
        ContentEntityObject ceo = this.getCEO(contentId);
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.getUser(), (Object)ceo, Attachment.class)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        Attachment previousVersion = this.attachmentManager.getAttachment(ceo, remoteAttachment.getFileName());
        if (previousVersion != null) {
            try {
                attachment = previousVersion;
                previousVersion = (Attachment)previousVersion.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new RemoteException((Throwable)cnse);
            }
        } else {
            attachment = new Attachment();
            ceo.addAttachment(attachment);
        }
        attachment.setComment(remoteAttachment.getComment());
        attachment.setContentType(remoteAttachment.getContentType());
        attachment.setContent(ceo);
        attachment.setFileName(remoteAttachment.getFileName());
        attachment.setFileSize((long)attachmentData.length);
        try {
            this.attachmentManager.saveAttachment(attachment, previousVersion, (InputStream)new ByteArrayInputStream(attachmentData));
        }
        catch (IOException ioe) {
            throw new RemoteException("Error saving attachment", (Throwable)ioe);
        }
        Attachment newAttachment = this.attachmentManager.getAttachment(ceo, attachment.getFileName());
        return new RemoteAttachment(newAttachment);
    }

    public RemoteAttachment getAttachment(long contentId, String fileName, int version) throws NotPermittedException, RemoteException {
        ContentEntityObject ceo = this.getCEO(contentId);
        Attachment attachment = this.getExistingAttachment(ceo, fileName, version);
        if (attachment == null) {
            throw new RemoteException("No attachment on content with id " + ceo.getId() + ", name '" + fileName + "' exists.");
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)attachment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        return new RemoteAttachment(attachment);
    }

    public byte[] getAttachmentData(long contentId, String fileName, int version) throws NotPermittedException, RemoteException {
        ContentEntityObject ceo = this.getCEO(contentId);
        Attachment attachment = this.getExistingAttachment(ceo, fileName, version);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)attachment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)attachment.getFileSize());
        InputStream attachmentStream = null;
        try {
            attachmentStream = this.attachmentManager.getAttachmentData(attachment);
            FileUtils.copy((InputStream)attachmentStream, (OutputStream)baos);
        }
        catch (IOException ioe) {
            try {
                throw new RemoteException("Error reading attachment contents", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtils.shutdownStream(attachmentStream);
                throw throwable;
            }
        }
        FileUtils.shutdownStream((InputStream)attachmentStream);
        return baos.toByteArray();
    }

    public boolean removeAttachment(long contentId, String fileName) throws NotPermittedException, RemoteException {
        ContentEntityObject ceo = this.getCEO(contentId);
        Attachment attachment = this.getExistingCurrentAttachment(ceo, fileName);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.REMOVE, (Object)attachment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        this.attachmentManager.removeAttachmentFromServer(attachment);
        return true;
    }

    public boolean moveAttachment(long contentId, String name, long newContentId, String newName) throws RemoteException, NotPermittedException {
        ContentEntityObject existingCeo = this.getCEO(contentId);
        Attachment attachment = this.getExistingCurrentAttachment(existingCeo, name);
        ContentEntityObject newCeo = this.getCEO(newContentId);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.REMOVE, (Object)attachment) || !this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.getUser(), (Object)newCeo, Attachment.class)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        this.attachmentManager.moveAttachment(attachment, newName, newCeo);
        return true;
    }

    private ContentEntityObject getCEO(long id) throws RemoteException {
        ContentEntityObject ceo = this.contentEntityManager.getById(id);
        if (ceo == null) {
            throw new RemoteException("No content with id " + id + " exists.");
        }
        return ceo;
    }

    private Attachment getExistingAttachment(ContentEntityObject ceo, String fileName, int version) throws RemoteException {
        Attachment attachment = this.attachmentManager.getAttachment(ceo, fileName, version);
        if (attachment == null) {
            throw new RemoteException("No attachment on content with id " + ceo.getId() + ", name '" + fileName + "' and version " + version + " exists.");
        }
        return attachment;
    }

    private Attachment getExistingCurrentAttachment(ContentEntityObject ceo, String fileName) throws RemoteException {
        Attachment attachment = this.attachmentManager.getAttachment(ceo, fileName);
        if (attachment == null) {
            throw new RemoteException("No attachment on content with id " + ceo.getId() + ", name '" + fileName + "' exists.");
        }
        return attachment;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

