/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.xmlrpc;

import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.ConfluenceSoapService;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteClusterInformation;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteLabel;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceGroup;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import com.atlassian.confluence.rpc.xmlrpc.ConfluenceXmlRpcHandler;
import com.atlassian.confluence.rpc.xmlrpc.Translator;
import com.atlassian.core.exception.InfrastructureException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Category;

public class ConfluenceXmlRpcHandlerImpl
implements ConfluenceXmlRpcHandler {
    public static final Category log = Category.getInstance(ConfluenceXmlRpcHandlerImpl.class);
    ConfluenceSoapService soapServiceDelegator;

    public void setSoapServiceDelegator(ConfluenceSoapService soapServiceDelegator) {
        this.soapServiceDelegator = soapServiceDelegator;
    }

    public String login(String username, String password) throws RemoteException {
        return this.soapServiceDelegator.login(username, password);
    }

    public boolean logout(String token) throws RemoteException {
        return this.soapServiceDelegator.logout(token);
    }

    public Vector getSpaces(String token) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getSpaces(token));
    }

    public Vector getSpacesInGroup(String token, String spaceGroupKey) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getSpacesInGroup(token, spaceGroupKey));
    }

    public Vector getBlogEntries(String token, String spaceKey) throws RemoteException {
        try {
            return Translator.makeVector((Object[])this.soapServiceDelegator.getBlogEntries(token, spaceKey));
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException((Throwable)e);
        }
    }

    public Hashtable getBlogEntryByDayAndTitle(String token, String spaceKey, int dayOfMonth, String postTitle) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getBlogEntryByDayAndTitle(token, spaceKey, dayOfMonth, postTitle));
    }

    public Vector getComments(String token, String pageId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getComments(token, this.makePageId(pageId)));
    }

    public Hashtable getComment(String token, String commentId) throws InvalidSessionException, RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getComment(token, Long.parseLong(commentId)));
    }

    public Hashtable addComment(String token, Hashtable comment) throws InvalidSessionException, NotPermittedException, RemoteException {
        RemoteComment rComment = new RemoteComment();
        comment.remove("created");
        this.convertLong(comment, "id");
        this.convertLong(comment, "pageId");
        try {
            BeanUtils.populate((Object)rComment, (Map)comment);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Unable to add comment via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to add comment: " + e.toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.addComment(token, rComment));
    }

    public Hashtable editComment(String token, Hashtable comment) throws InvalidSessionException, NotPermittedException, RemoteException {
        RemoteComment rComment = new RemoteComment();
        comment.remove("created");
        comment.remove("modified");
        this.convertLong(comment, "id");
        this.convertLong(comment, "pageId");
        try {
            BeanUtils.populate((Object)rComment, (Map)comment);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Unable to add comment via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to edit comment: " + e.toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e);
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.editComment(token, rComment));
    }

    public boolean removeComment(String token, String commentId) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removeComment(token, Long.parseLong(commentId));
    }

    public Vector getTopLevelPages(String token, String spaceKey) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getTopLevelPages(token, spaceKey));
    }

    public Vector getAncestors(String token, String pageId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getAncestors(token, this.makePageId(pageId)));
    }

    public Vector getChildren(String token, String pageId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getChildren(token, this.makePageId(pageId)));
    }

    public Vector getDescendents(String token, String pageId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getDescendents(token, this.makePageId(pageId)));
    }

    public Vector getAttachments(String token, String pageId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getAttachments(token, this.makePageId(pageId)));
    }

    public Hashtable getBlogEntry(String token, String blogEntryId) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getBlogEntry(token, this.makePageId(blogEntryId)));
    }

    public Vector getPages(String token, String spaceKey) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPages(token, spaceKey));
    }

    public Hashtable getPage(String token, String pageId) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getPage(token, this.makePageId(pageId)));
    }

    public Hashtable getPage(String token, String spaceKey, String pageTitle) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getPage(token, spaceKey, pageTitle));
    }

    public Vector getContentPermissionSets(String token, String contentId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getContentPermissionSets(token, this.makePageId(contentId)));
    }

    public Hashtable getContentPermissionSet(String token, String contentId, String permissionType) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getContentPermissionSet(token, this.makePageId(contentId), permissionType));
    }

    public Vector getContentPermissions(String token, String contentId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPagePermissions(token, this.makePageId(contentId)));
    }

    public Boolean setContentPermissions(String token, String contentId, String permissionType, Vector permissions) throws RemoteException {
        this.soapServiceDelegator.setContentPermissions(token, this.makePageId(contentId), permissionType, this.makePermissionArray(permissions));
        return Boolean.TRUE;
    }

    private RemoteContentPermission[] makePermissionArray(Vector permissions) {
        ArrayList<RemoteContentPermission> permissionsList = new ArrayList<RemoteContentPermission>(permissions.size());
        for (Hashtable permissionHash : permissions) {
            try {
                RemoteContentPermission permission = new RemoteContentPermission();
                BeanUtils.populate((Object)permission, (Map)permissionHash);
                permissionsList.add(permission);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to create content permission via XML-RPC: " + e.getMessage()), (Throwable)e);
                throw new InfrastructureException("Unable to create content permission: " + e.toString(), (Throwable)e);
            }
        }
        return permissionsList.toArray(new RemoteContentPermission[permissionsList.size()]);
    }

    public Vector getPageHistory(String token, String pageId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPageHistory(token, this.makePageId(pageId)));
    }

    public Hashtable getSpace(String token, String spaceKey) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getSpace(token, spaceKey));
    }

    public Vector getPermissions(String token, String spaceKey) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPermissions(token, spaceKey));
    }

    public Vector getPermissionsForUser(String token, String spaceKey, String userName) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPermissionsForUser(token, spaceKey, userName));
    }

    public Vector getPagePermissions(String token, String pageId) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPagePermissions(token, this.makePageId(pageId)));
    }

    private long makePageId(String pageId) throws RemoteException {
        try {
            return Long.parseLong(pageId);
        }
        catch (NumberFormatException e) {
            throw new RemoteException("You must supply a valid number as the page ID.");
        }
    }

    public String renderContent(String token, String spaceKey, String pageId, String newContent) throws RemoteException {
        return this.soapServiceDelegator.renderContent(token, spaceKey, this.makePageId(pageId), newContent);
    }

    public String renderContent(String token, String spaceKey, String pageId, String newContent, Hashtable renderParameters) throws RemoteException {
        return this.soapServiceDelegator.renderContent(token, spaceKey, this.makePageId(pageId), newContent, renderParameters);
    }

    public Boolean movePageToTopLevel(String token, String pageId, String targetSpaceKey) throws RemoteException {
        return this.soapServiceDelegator.movePageToTopLevel(token, this.makePageId(pageId), targetSpaceKey);
    }

    public Boolean movePage(String token, String sourcePageId, String targetPageId, String position) throws RemoteException {
        return this.soapServiceDelegator.movePage(token, this.makePageId(sourcePageId), this.makePageId(targetPageId), position);
    }

    public Boolean removePage(String token, String pageId) throws RemoteException {
        return this.soapServiceDelegator.removePage(token, this.makePageId(pageId));
    }

    public Vector search(String token, String query, int maxResults) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.search(token, query, maxResults));
    }

    public Vector search(String token, String query, Hashtable params, int maxResults) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.search(token, query, params, maxResults));
    }

    public Hashtable storeBlogEntry(String token, Hashtable blogEntryStruct) throws RemoteException {
        RemoteBlogEntry rblog = new RemoteBlogEntry();
        this.convertLong(blogEntryStruct, "id");
        this.convertInteger(blogEntryStruct, "version");
        try {
            BeanUtils.populate((Object)rblog, (Map)blogEntryStruct);
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("Bad error :)", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.storeBlogEntry(token, rblog));
    }

    private void convertLong(Hashtable table, String key) {
        if (table.containsKey(key)) {
            table.put(key, new Long((String)table.get(key)));
        }
    }

    private void convertDate(Hashtable table, String key) {
        if (table.containsKey(key)) {
            String dateString = (String)table.get(key);
            try {
                Date d = SimpleDateFormat.getDateInstance().parse(dateString);
                table.put(key, d);
            }
            catch (ParseException pe) {
                throw new RuntimeException("Error parsing date '" + dateString + "'", pe);
            }
        }
    }

    private void convertInteger(Hashtable table, String key) {
        if (table.containsKey(key)) {
            table.put(key, new Integer((String)table.get(key)));
        }
    }

    public Hashtable storePage(String token, Hashtable pageStruct) throws RemoteException {
        RemotePage rpage = new RemotePage();
        this.convertLong(pageStruct, "id");
        if (pageStruct.containsKey("parentId")) {
            pageStruct.put("parentId", new Long((String)pageStruct.get("parentId")));
        }
        if (pageStruct.containsKey("version")) {
            pageStruct.put("version", new Integer((String)pageStruct.get("version")));
        }
        pageStruct.remove("modified");
        pageStruct.remove("created");
        try {
            BeanUtils.populate((Object)rpage, (Map)pageStruct);
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("Bad error :)", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.storePage(token, rpage));
    }

    private String getRequiredStringParameter(Hashtable map, String key) {
        if (!map.containsKey(key)) {
            throw new RuntimeException("No '" + key + "' specified.");
        }
        return (String)map.get(key);
    }

    public Hashtable addAttachment(String token, String contentId, Hashtable attachment, byte[] attachmentData) throws RemoteException {
        RemoteAttachment attachmentStruct = new RemoteAttachment(Long.parseLong(contentId), this.getRequiredStringParameter(attachment, "fileName"), this.getRequiredStringParameter(attachment, "contentType"), (String)attachment.get("comment"));
        return Translator.makeStruct((Object)this.soapServiceDelegator.addAttachment(token, Long.parseLong(contentId), attachmentStruct, attachmentData));
    }

    public Hashtable getAttachment(String token, String contentId, String fileName, String version) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getAttachment(token, Long.parseLong(contentId), fileName, Integer.parseInt(version)));
    }

    public byte[] getAttachmentData(String token, String contentId, String fileName, String version) throws RemoteException {
        return this.soapServiceDelegator.getAttachmentData(token, Long.parseLong(contentId), fileName, Integer.parseInt(version));
    }

    public boolean removeAttachment(String token, String contentId, String fileName) throws RemoteException, NotPermittedException {
        return this.soapServiceDelegator.removeAttachment(token, Long.parseLong(contentId), fileName);
    }

    public boolean moveAttachment(String token, String originalContentId, String originalFileName, String newContentId, String newFileName) throws RemoteException, NotPermittedException {
        return this.soapServiceDelegator.moveAttachment(token, Long.parseLong(originalContentId), originalFileName, Long.parseLong(newContentId), newFileName);
    }

    public Hashtable addSpaceGroup(String token, Hashtable spaceGroup) throws RemoteException {
        RemoteSpaceGroup rSpaceGroup = new RemoteSpaceGroup();
        try {
            BeanUtils.populate((Object)rSpaceGroup, (Map)spaceGroup);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to create space group via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to create space group: " + e.toString(), (Throwable)e);
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.addSpaceGroup(token, rSpaceGroup));
    }

    public Hashtable getSpaceGroup(String token, String spaceGroupKey) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getSpaceGroup(token, spaceGroupKey));
    }

    public Vector getSpaceGroups(String token) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getSpaceGroups(token));
    }

    public boolean removeSpaceGroup(String token, String spaceGroupKey) throws RemoteException {
        return this.soapServiceDelegator.removeSpaceGroup(token, spaceGroupKey);
    }

    public Hashtable addSpace(String token, Hashtable space) throws RemoteException {
        RemoteSpace rSpace = new RemoteSpace();
        try {
            BeanUtils.populate((Object)rSpace, (Map)space);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to create space via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to create space: " + e.toString(), (Throwable)e);
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.addSpace(token, rSpace));
    }

    public Hashtable storeSpace(String token, Hashtable remoteSpace) throws RemoteException {
        RemoteSpace rSpace = new RemoteSpace();
        try {
            BeanUtils.populate((Object)rSpace, (Map)remoteSpace);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to create space via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to create space: " + e.toString(), (Throwable)e);
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.storeSpace(token, rSpace));
    }

    public Hashtable addPersonalSpace(String token, Hashtable space, String username) throws RemoteException {
        RemoteSpace rSpace = new RemoteSpace();
        try {
            BeanUtils.populate((Object)rSpace, (Map)space);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to create space via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to create space: " + e.toString(), (Throwable)e);
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.addPersonalSpace(token, rSpace, username));
    }

    public boolean convertToPersonalSpace(String token, String userName, String spaceKey, String newName, boolean updateLinks) throws RemoteException {
        return this.soapServiceDelegator.convertToPersonalSpace(token, userName, spaceKey, newName, updateLinks);
    }

    public Boolean removeSpace(String token, String spaceKey) throws RemoteException {
        return this.soapServiceDelegator.removeSpace(token, spaceKey);
    }

    public String exportSpace(String token, String spaceKey, String exportType) throws RemoteException {
        return this.soapServiceDelegator.exportSpace(token, spaceKey, exportType);
    }

    public boolean importSpace(String token, byte[] importData) throws RemoteException {
        return this.soapServiceDelegator.importSpace(token, importData);
    }

    public boolean addPermissionToSpace(String token, String permission, String remoteEntityName, String spaceKey) throws RemoteException {
        return this.soapServiceDelegator.addPermissionToSpace(token, permission, remoteEntityName, spaceKey);
    }

    public boolean addPermissionsToSpace(String token, Vector permissions, String remoteEntityName, String spaceKey) throws RemoteException {
        return this.soapServiceDelegator.addPermissionsToSpace(token, this.convertPermissionsVectorToArray(permissions), remoteEntityName, spaceKey);
    }

    public boolean addGlobalPermissions(String token, Vector permissions, String remoteEntityName) throws RemoteException {
        return this.soapServiceDelegator.addGlobalPermissions(token, this.convertPermissionsVectorToArray(permissions), remoteEntityName);
    }

    public boolean addGlobalPermission(String token, String permission, String remoteEntityName) throws RemoteException {
        return this.soapServiceDelegator.addGlobalPermission(token, permission, remoteEntityName);
    }

    public boolean removeGlobalPermission(String token, String permission, String remoteEntityName) throws RemoteException {
        return this.soapServiceDelegator.removeGlobalPermission(token, permission, remoteEntityName);
    }

    public boolean addAnonymousUsePermission(String token) throws RemoteException {
        return this.soapServiceDelegator.addAnonymousUsePermission(token);
    }

    public boolean removeAnonymousUsePermission(String token) throws RemoteException {
        return this.soapServiceDelegator.removeAnonymousUsePermission(token);
    }

    private String[] convertPermissionsVectorToArray(Vector permissions) throws RemoteException {
        String[] permissionsArray = new String[permissions.size()];
        for (int i = 0; i < permissions.size(); ++i) {
            Object object = permissions.elementAt(i);
            if (!(object instanceof String)) {
                throw new RemoteException("Unable to add permissions to Space: Permissions must be Strings");
            }
            permissionsArray[i] = (String)object;
        }
        return permissionsArray;
    }

    public boolean removePermissionFromSpace(String token, String permission, String remoteEntityName, String spaceKey) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removePermissionFromSpace(token, permission, remoteEntityName, spaceKey);
    }

    public boolean addAnonymousPermissionToSpace(String token, String permission, String spaceKey) throws RemoteException {
        return this.soapServiceDelegator.addAnonymousPermissionToSpace(token, permission, spaceKey);
    }

    public boolean addAnonymousPermissionsToSpace(String token, Vector permissions, String spaceKey) throws RemoteException {
        return this.soapServiceDelegator.addAnonymousPermissionsToSpace(token, this.convertPermissionsVectorToArray(permissions), spaceKey);
    }

    public boolean removeAnonymousPermissionFromSpace(String token, String permission, String spaceKey) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removeAnonymousPermissionFromSpace(token, permission, spaceKey);
    }

    public String[] getSpaceLevelPermissions(String token) throws RemoteException {
        return this.soapServiceDelegator.getSpaceLevelPermissions(token);
    }

    public Hashtable getServerInfo(String token) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getServerInfo(token));
    }

    public String exportSite(String token, boolean exportAttachments) throws RemoteException {
        return this.soapServiceDelegator.exportSite(token, exportAttachments);
    }

    public boolean flushIndexQueue(String token) throws RemoteException {
        return this.soapServiceDelegator.flushIndexQueue(token);
    }

    public boolean clearIndexQueue(String token) throws RemoteException {
        return this.soapServiceDelegator.clearIndexQueue(token);
    }

    public Hashtable getClusterInformation(String token) throws RemoteException {
        RemoteClusterInformation rci = this.soapServiceDelegator.getClusterInformation(token);
        Hashtable h = Translator.makeStruct((Object)rci);
        return h;
    }

    public Vector getClusterNodeStatuses(String token) throws RemoteException {
        Object[] rcni = this.soapServiceDelegator.getClusterNodeStatuses(token);
        Vector v = Translator.makeVector((Object[])rcni);
        return v;
    }

    public Vector getGroups(String token) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getGroups(token));
    }

    public boolean hasGroup(String token, String groupname) throws InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.hasGroup(token, groupname);
    }

    public boolean addGroup(String token, String groupname) throws RemoteException {
        return this.soapServiceDelegator.addGroup(token, groupname);
    }

    public boolean removeGroup(String token, String groupname, String defaultGroupName) throws RemoteException {
        return this.soapServiceDelegator.removeGroup(token, groupname, defaultGroupName);
    }

    public Vector getUserGroups(String token, String username) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getUserGroups(token, username));
    }

    public boolean addUserToGroup(String token, String username, String groupname) throws RemoteException {
        this.soapServiceDelegator.addUserToGroup(token, username, groupname);
        return true;
    }

    public boolean removeAllPermissionsForGroup(String token, String groupname) throws RemoteException {
        return this.soapServiceDelegator.removeAllPermissionsForGroup(token, groupname);
    }

    public boolean removeUserFromGroup(String token, String username, String groupname) throws RemoteException {
        return this.soapServiceDelegator.removeUserFromGroup(token, username, groupname);
    }

    public Hashtable getUser(String token, String username) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getUser(token, username));
    }

    public boolean hasUser(String token, String username) throws InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.hasUser(token, username);
    }

    public boolean addUser(String token, Hashtable remoteUser, String password) throws RemoteException {
        RemoteUser rUser = new RemoteUser();
        try {
            BeanUtils.populate((Object)rUser, (Map)remoteUser);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to create user via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to create user: " + e.toString(), (Throwable)e);
        }
        this.soapServiceDelegator.addUser(token, rUser, password);
        return true;
    }

    public boolean removeUser(String token, String username) throws RemoteException {
        return this.soapServiceDelegator.removeUser(token, username);
    }

    public boolean editUser(String token, Hashtable remoteUser) throws NotPermittedException, InvalidSessionException, RemoteException {
        RemoteUser rUser = new RemoteUser();
        try {
            BeanUtils.populate((Object)rUser, (Map)remoteUser);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to edit user via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to edit user: " + e.toString(), (Throwable)e);
        }
        return this.soapServiceDelegator.editUser(token, rUser);
    }

    public boolean deactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.deactivateUser(token, username);
    }

    public boolean reactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.reactivateUser(token, username);
    }

    public Vector getActiveUsers(String token, boolean viewAll) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getActiveUsers(token, viewAll));
    }

    public boolean setUserInformation(String token, Hashtable userInfo) throws NotPermittedException, InvalidSessionException, RemoteException {
        RemoteUserInformation rUser = new RemoteUserInformation();
        if (userInfo.containsKey("id")) {
            userInfo.put("id", new Long((String)userInfo.get("id")));
        }
        if (userInfo.containsKey("version")) {
            userInfo.put("version", new Integer((String)userInfo.get("version")));
        }
        userInfo.remove("creationDate");
        userInfo.remove("lastModificationDate");
        try {
            BeanUtils.populate((Object)rUser, (Map)userInfo);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to edit user information via XML-RPC: " + e.getMessage()), (Throwable)e);
            throw new InfrastructureException("Unable to edit user information: " + e.toString(), (Throwable)e);
        }
        return this.soapServiceDelegator.setUserInformation(token, rUser);
    }

    public Hashtable getUserInformation(String token, String username) throws InvalidSessionException, RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getUserInformation(token, username));
    }

    public boolean changeMyPassword(String token, String oldPass, String newPass) throws InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.changeMyPassword(token, oldPass, newPass);
    }

    public boolean changeUserPassword(String token, String username, String newPass) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.changeUserPassword(token, username, newPass);
    }

    public boolean addProfilePicture(String token, String userName, String fileName, String mimeType, byte[] pictureData) throws RemoteException {
        return this.soapServiceDelegator.addProfilePicture(token, userName, fileName, mimeType, pictureData);
    }

    public Vector getLabelsById(String token, String objectId) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelsById(token, this.makePageId(objectId)));
    }

    public Vector getMostPopularLabels(String token, int maxCount) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getMostPopularLabels(token, maxCount));
    }

    public Vector getMostPopularLabelsInSpace(String token, String spaceKey, int maxCount) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getMostPopularLabelsInSpace(token, spaceKey, maxCount));
    }

    public Vector getLabelContentById(String token, String labelId) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelContentById(token, Long.parseLong(labelId)));
    }

    public Vector getLabelContentByName(String token, String labelName) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelContentByName(token, labelName));
    }

    public Vector getLabelContentByObject(String token, Hashtable labelObject) throws NotPermittedException, RemoteException {
        RemoteLabel remoteLabel = new RemoteLabel();
        this.convertLong(labelObject, "id");
        try {
            BeanUtils.populate((Object)remoteLabel, (Map)labelObject);
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("Error in populating RemoteLabel bean", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelContentByObject(token, remoteLabel));
    }

    public Vector getRecentlyUsedLabels(String token, int maxResults) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getRecentlyUsedLabels(token, maxResults));
    }

    public Vector getRecentlyUsedLabelsInSpace(String token, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getRecentlyUsedLabelsInSpace(token, spaceKey, maxResults));
    }

    public Vector getSpacesWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getSpacesWithLabel(token, labelName));
    }

    public Vector getRelatedLabels(String token, String labelName, int maxResults) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getRelatedLabels(token, labelName, maxResults));
    }

    public Vector getRelatedLabelsInSpace(String token, String labelName, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getRelatedLabelsInSpace(token, labelName, spaceKey, maxResults));
    }

    public Vector getLabelsByDetail(String token, String labelName, String namespace, String spaceKey, String owner) throws InvalidSessionException, RemoteException, NotPermittedException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelsByDetail(token, labelName, namespace, spaceKey, owner));
    }

    public Vector getSpacesContainingContentWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getSpacesContainingContentWithLabel(token, labelName));
    }

    public boolean addLabelByName(String token, String labelName, String objectId) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.addLabelByName(token, labelName, Long.parseLong(objectId));
    }

    public boolean addLabelById(String token, String labelId, String objectId) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.addLabelById(token, Long.parseLong(labelId), Long.parseLong(objectId));
    }

    public boolean addLabelByObject(String token, Hashtable labelObject, String objectId) throws NotPermittedException, RemoteException {
        RemoteLabel remoteLabel = new RemoteLabel();
        this.convertLong(labelObject, "id");
        try {
            BeanUtils.populate((Object)remoteLabel, (Map)labelObject);
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("Error in populating RemoteLabel bean", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.soapServiceDelegator.addLabelByObject(token, remoteLabel, Long.parseLong(objectId));
    }

    public boolean addLabelByNameToSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.addLabelByNameToSpace(token, labelName, spaceKey);
    }

    public boolean removeLabelByName(String token, String labelName, String objectId) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removeLabelByName(token, labelName, Long.parseLong(objectId));
    }

    public boolean removeLabelById(String token, String labelId, String objectId) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removeLabelById(token, Long.parseLong(labelId), Long.parseLong(objectId));
    }

    public boolean removeLabelByObject(String token, Hashtable labelObject, String objectId) throws NotPermittedException, RemoteException {
        RemoteLabel remoteLabel = new RemoteLabel();
        this.convertLong(labelObject, "id");
        try {
            BeanUtils.populate((Object)remoteLabel, (Map)labelObject);
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("Error in populating RemoteLabel bean", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.soapServiceDelegator.removeLabelByObject(token, remoteLabel, Long.parseLong(objectId));
    }

    public boolean removeLabelByNameFromSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.removeLabelByNameFromSpace(token, labelName, spaceKey);
    }

    public boolean setEnableWysiwyg(String token, String value) throws RemoteException {
        return this.soapServiceDelegator.setEnableWysiwyg(token, Boolean.parseBoolean(value));
    }

    public boolean setEnableAnonymousAccess(String token, String value) throws RemoteException {
        return this.soapServiceDelegator.setEnableAnonymousAccess(token, Boolean.parseBoolean(value));
    }

    public boolean isRpcPluginEnabled(String token) throws RemoteException {
        return this.soapServiceDelegator.isRpcPluginEnabled(token);
    }
}

