/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.application.console;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Application;
import com.tangosol.coherence.component.application.Console;
import com.tangosol.coherence.component.application.console.Coherence$CacheItem;
import com.tangosol.coherence.component.application.console.Coherence$DtdParser;
import com.tangosol.coherence.component.application.console.Coherence$Logger;
import com.tangosol.coherence.component.application.console.Coherence$Worker;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.jmxHelper.HttpAdapter;
import com.tangosol.coherence.component.net.jmxHelper.ServerConnector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.SafeNamedCache;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$SeniorMemberHeartbeat;
import com.tangosol.coherence.component.util.transactionCache.Local;
import com.tangosol.dev.component.ComponentClassLoader;
import com.tangosol.dev.component.Loader;
import com.tangosol.dev.component.NullStorage;
import com.tangosol.io.ReadBuffer;
import com.tangosol.license.LicensedObject;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationObserver;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.net.cache.WrapperNamedCache;
import com.tangosol.net.management.Registry;
import com.tangosol.run.jca.SimpleValidator;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.UID;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.Versionable;
import com.tangosol.util.WrapperException;
import com.tangosol.util.comparator.ChainedComparator;
import com.tangosol.util.comparator.InverseComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.processor.ConditionalProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.AccessControlException;
import java.security.PrivilegedAction;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class Coherence
extends Console {
    public static final String COPYRIGHT = "Copyright (c) 2000-2007 Oracle. All rights reserved.";
    public static final String DEFAULT_EDITION = "GE";
    public static final String DEFAULT_MODE = "development";
    public static final String[] EDITION_NAMES;
    public static final String FILE_CFG_CERTIFICATE = "tangosol.cer";
    public static final String FILE_CFG_COHERENCE = "/tangosol-coherence.xml";
    public static final String FILE_CFG_COHERENCE_OVERRIDE = "/tangosol-coherence-override.xml";
    public static final String[] MODE_NAMES;
    public static final String TITLE = "Oracle Coherence";
    public static final String VERSION = "3.3.1/389";
    private int __m_Edition;
    private transient Map __m_Filters;
    private transient Object[] __m_LogParameters;
    private transient NamedCache __m_Map;
    private int __m_Mode;
    private transient String __m_Product;
    private transient CacheService __m_Service;
    private transient boolean __m_Stop;
    private static ListMap __mapChildren;
    private static transient Cluster __s_Cluster;
    private static String __s_CoherenceDtd;
    private static String __s_CoherenceUrl;
    private static transient boolean __s_LicenseLoaded;
    private static Map __s_ServiceConfigMap;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        try {
            EDITION_NAMES = new String[]{"DC", "RTC", "", "SE", "EE", DEFAULT_EDITION};
            MODE_NAMES = new String[]{"eval", "dev", "prod"};
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        Coherence.__initStatic();
    }

    public Coherence() {
        this(null, null, true);
    }

    public Coherence(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        if (Application.__singleton != null) {
            throw new IllegalStateException("A singleton for \\\"Coherence\\\" has already been set");
        }
        Application.__singleton = this;
        this.__initPrivate();
        this._addChild(new Coherence$Logger("Logger", this, true), "Logger");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        try {
            Coherence.setServiceConfigMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"CacheItem", (Object)Coherence$CacheItem.get_CLASS());
        Object object2 = __mapChildren.put((Object)"DtdParser", (Object)Coherence$DtdParser.get_CLASS());
        Object object3 = __mapChildren.put((Object)"Worker", (Object)Coherence$Worker.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("com.tangosol.license.LicensedObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Set applyFilter(String sFilter, boolean fKeysOnly, Comparator comparator, int nPage) {
        try {
            LimitFilter filterLimit;
            Filter filter = (Filter)this.getFilters().get(sFilter);
            Set setEntry = null;
            if (filter instanceof LimitFilter) {
                filterLimit = (LimitFilter)filter;
                if (nPage >= 0) {
                    filterLimit.setPage(nPage);
                }
                filterLimit.setComparator(comparator);
            }
            setEntry = fKeysOnly ? this.getMap().keySet(filter) : (comparator != null ? this.getMap().entrySet(filter, comparator) : this.getMap().entrySet(filter));
            if (!(filter instanceof LimitFilter) ? false : nPage < 0) {
                filterLimit = (LimitFilter)filter;
                if (setEntry.size() < filterLimit.getPageSize()) {
                    filterLimit.setPage(0);
                } else {
                    filterLimit.nextPage();
                }
            }
            return setEntry;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    protected static String calculateAttribute(String sAttr) {
        String MODE = "{mode}";
        if (sAttr.indexOf(MODE) >= 0) {
            XmlElement xmlLicense = Coherence.getServiceConfig("$License");
            sAttr = Base.replace((String)sAttr, (String)MODE, (String)xmlLicense.getSafeElement("license-mode").getString(DEFAULT_MODE));
        }
        while (!sAttr.startsWith("{") ? false : sAttr.endsWith("}")) {
            String sDefault;
            String sPropName;
            int ofDefault = sAttr.indexOf(32);
            int cchLength = sAttr.length();
            if (ofDefault < 0) {
                sDefault = sPropName = sAttr.substring(1, cchLength - 1);
            } else {
                sPropName = sAttr.substring(1, ofDefault);
                sDefault = sAttr.substring(ofDefault + 1, cchLength - 1);
            }
            sAttr = System.getProperty(sPropName, sDefault);
        }
        return sAttr;
    }

    protected Object[] collectLogParameters() {
        Object[] aoParam = this.getLogParameters();
        try {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)Coherence.getCluster().getLocalMember();
            int nMemberNew = member == null ? 0 : member.getId();
            int nMemberOld = aoParam == null ? -1 : (Integer)aoParam[0];
            if (nMemberNew != nMemberOld) {
                aoParam = member == null ? new Object[]{Base.makeInteger((int)0), null, null, this.getProduct()} : new Object[]{Base.makeInteger((int)nMemberNew), member.getRoleName(), member.getLocationInfo(), this.getProduct()};
                this.setLogParameters(aoParam);
            }
        }
        catch (Exception exception) {}
        return aoParam;
    }

    protected Object convertArgument(String sParam) {
        block42: {
            String sValue;
            int ofStart = sParam.indexOf(123);
            if (ofStart == 0) {
                if (sParam.equals("{cluster}")) {
                    return Coherence.getCluster();
                }
                if (sParam.equals("{Date}")) {
                    return new Date(Base.getSafeTimeMillis());
                }
                if (sParam.equals("{date}")) {
                    return new Date(Coherence.getCluster().getTimeMillis());
                }
                if (sParam.equals("{map}")) {
                    return this.getMap();
                }
                if (sParam.equals("{Member}")) {
                    return Coherence.getCluster().getLocalMember();
                }
                if (sParam.equals("{random}")) {
                    return new Integer(Base.getRandom().nextInt());
                }
                if (sParam.equals("{result}")) {
                    return ((ThreadLocal)this.get_Sink()).get();
                }
                if (sParam.equals("{service}")) {
                    return this.getService();
                }
                if (sParam.equals("{time}")) {
                    return new Long(Coherence.getCluster().getTimeMillis());
                }
                if (sParam.endsWith("}")) {
                    sValue = sParam.substring(1, sParam.length() - 1);
                    if (sValue.charAt(0) == '#') {
                        int ofIter = sValue.indexOf(32);
                        String sIter = sValue.substring(1, ofIter);
                        int cIters = Integer.parseInt(sIter);
                        if (ofIter > 0) {
                            Object[] aoValue = new Object[cIters];
                            sValue = sValue.substring(ofIter + 1);
                            int i = 0;
                            while (i < cIters) {
                                String s = sValue.indexOf(35) >= 0 ? Base.replace((String)sValue, (String)"#", (String)String.valueOf(i)) : sValue;
                                aoValue[i] = this.convertArgument(s);
                                ++i;
                            }
                            return new ImmutableArrayList(aoValue);
                        }
                    } else {
                        if (sValue.indexOf(44) >= 0) {
                            Object[] aoValue = sValue.length() == 0 ? ClassHelper.VOID : this.convertArguments(Base.parseDelimitedString((String)sValue, (char)','));
                            return new ImmutableArrayList(aoValue);
                        }
                        if (sValue.startsWith("filter:")) {
                            String sFilter = sValue.substring(sValue.indexOf(58) + 1);
                            return (Filter)this.getFilters().get(sFilter);
                        }
                    }
                } else {
                    throw new RuntimeException(String.valueOf("Unbalanced {} in parameter: ") + sParam + "; quotes may need to be used");
                }
            }
            if (ofStart >= 0) {
                int ofEnd;
                String[][] aasReplace = null;
                try {
                    long dtTime = Coherence.getCluster().getTimeMillis();
                    Member member = Coherence.getCluster().getLocalMember();
                    aasReplace = new String[][]{{"{Date}", String.valueOf(new Date(Base.getSafeTimeMillis()))}, {"{date}", String.valueOf(new Date(dtTime))}, {"{random}", String.valueOf(Base.getRandom().nextInt())}, {"{result}", String.valueOf(((ThreadLocal)this.get_Sink()).get())}, {"{time}", String.valueOf(dtTime)}, {"{Member}", String.valueOf(member)}, {"{member}", member == null ? "0" : String.valueOf(member.getId())}};
                }
                catch (Exception e) {
                    // empty catch block
                }
                int iR = 0;
                int cR = aasReplace == null ? 0 : aasReplace.length;
                while (iR < cR) {
                    void asReplace = aasReplace[iR];
                    sParam = Base.replace((String)sParam, (String)asReplace[0], (String)asReplace[1]);
                    ++iR;
                }
                int ofBegin = sParam.indexOf("{random:");
                if (ofBegin >= 0 && (ofEnd = sParam.indexOf(125, ofBegin)) > ofBegin) {
                    String sMax = sParam.substring(ofBegin + "{random:".length(), ofEnd);
                    int iMax = sMax.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(sMax);
                    int iRand = iMax > 0 ? Base.getRandom().nextInt(iMax) : (iMax < 0 ? (int)((double)(-iMax) * Base.getRandom().nextDouble() * Base.getRandom().nextDouble()) : (int)Math.abs((double)Integer.MAX_VALUE * Base.getRandom().nextGaussian()));
                    sParam = Base.replace((String)sParam, (String)sParam.substring(ofBegin, ofEnd + 1), (String)String.valueOf(iRand));
                }
            }
            if (sParam.startsWith("[")) {
                if (sParam.equals("[null]")) {
                    return null;
                }
                if (sParam.equals("[true]")) {
                    return Boolean.TRUE;
                }
                if (sParam.equals("[false]")) {
                    return Boolean.FALSE;
                }
                if (sParam.endsWith("]")) {
                    sValue = sParam.substring(1, sParam.length() - 1);
                    return sValue.length() == 0 ? ClassHelper.VOID : this.convertArguments(Base.parseDelimitedString((String)sValue, (char)','));
                }
            } else {
                if (sParam.endsWith("l")) {
                    try {
                        return Long.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block42;
                    }
                }
                if (sParam.endsWith("f")) {
                    try {
                        return Float.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block42;
                    }
                }
                if (sParam.endsWith("d")) {
                    try {
                        return Double.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block42;
                    }
                }
                if (!(sParam.length() == 2) ? false : sParam.charAt(0) == '\\') {
                    return new Character(sParam.charAt(1));
                }
                if (sParam.startsWith(" ")) {
                    return sParam.trim();
                }
                try {
                    return Integer.valueOf(sParam);
                }
                catch (NumberFormatException numberFormatException) {}
                {
                }
            }
        }
        return sParam;
    }

    public Object[] convertArguments(String[] asParam) {
        int cParams = asParam == null ? 0 : asParam.length;
        Object[] aoParam = new Object[cParams];
        int i = 0;
        while (i < cParams) {
            Object oParam;
            String sParam = asParam[i];
            aoParam[i] = oParam = this.convertArgument(sParam);
            if (oParam != sParam) {
                asParam[i] = String.valueOf(oParam);
            }
            ++i;
        }
        return aoParam;
    }

    public void debugOutput(String message, int severity) {
        Coherence$Logger logger = this.getLogger();
        if (logger == null ? true : logger.isDead()) {
            super.debugOutput(message, severity);
        } else if (logger.isEnabled(severity)) {
            logger.log(severity, message, this.collectLogParameters());
        }
    }

    public void debugOutput(Throwable e) {
        Coherence$Logger logger = this.getLogger();
        if (logger == null ? true : logger.isDead()) {
            super.debugOutput(e);
        } else if (logger.isEnabled(Logger.LEVEL_ERROR)) {
            logger.log(Logger.LEVEL_ERROR, e, this.collectLogParameters());
        }
    }

    public static Message displayMessage(ReadBuffer buf, InetSocketAddress addr, ClusterService$SeniorMemberHeartbeat msgPrevHeartbeat) throws IOException {
        Broadcast packet = (Broadcast)Packet.instantiate(new DataInputStream((InputStream)buf.getBufferInput()), 0);
        packet.setFromAddress(addr.getAddress());
        packet.setFromPort(addr.getPort());
        Message msg = new ClusterService().instantiateMessage(packet.getMessageType());
        msg.setIncoming(true);
        msg.setMessageType(packet.getMessageType());
        msg.setMessagePartCount(1);
        msg.setPacket(0, packet);
        DataInputStream inBody = new DataInputStream(new ByteArrayInputStream(packet.getBody()));
        msg.readInternal(inBody);
        msg.read(inBody);
        ClusterService$SeniorMemberHeartbeat msgCurHeartbeat = msg instanceof ClusterService$SeniorMemberHeartbeat ? (ClusterService$SeniorMemberHeartbeat)msg : null;
        if (!(!(!(msgCurHeartbeat != null) ? false : msgPrevHeartbeat != null) ? false : packet.getFromId() == msgPrevHeartbeat.getPacket(0).getFromId()) ? false : msgCurHeartbeat.getMemberSet().toString().equals(msgPrevHeartbeat.getMemberSet().toString())) {
            long lLastRecvTimestamp = msgCurHeartbeat.getLastReceivedMillis();
            String sLastRecvTimestamp = lLastRecvTimestamp == 0L ? "none" : new Date(lLastRecvTimestamp).toString();
            Base.out((String)(String.valueOf("Message \"SeniorMemberHeartbeat\" (no change) LastRecvTimestamp=") + sLastRecvTimestamp));
        } else {
            Base.out((Object)msg);
        }
        return msgCurHeartbeat;
    }

    protected void doAggregate(Object[] aoParam, boolean fSilent) {
        InvocableMap.EntryAggregator aggregator;
        NamedCache map = this.getMap();
        int cParams = aoParam.length;
        if (cParams < 2) {
            Component._trace("Aggregator name must be specified");
            return;
        }
        Object oTarget = aoParam[0];
        String sAggregator = (String)aoParam[1];
        Object extractor = null;
        if (cParams > 2) {
            String sMethod = (String)aoParam[2];
            extractor = (sMethod == null ? true : sMethod.equals("none")) ? NullImplementation.getValueExtractor() : (Object)sMethod;
        }
        try {
            Object[] objectArray;
            Class<?> clzAggregator = Class.forName(String.valueOf("com.tangosol.util.aggregator.") + sAggregator);
            if (extractor == null) {
                objectArray = ClassHelper.VOID;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = extractor;
            }
            aggregator = (InvocableMap.EntryAggregator)ClassHelper.newInstance(clzAggregator, (Object[])objectArray);
        }
        catch (Throwable e) {
            Coherence.printException(String.valueOf("Invalid aggregator format: ") + sAggregator + " " + Coherence.toString(extractor) + "\n", e);
            return;
        }
        Object oResult = (oTarget instanceof Filter ? true : oTarget == null) ? map.aggregate((Filter)oTarget, aggregator) : (oTarget instanceof Collection ? map.aggregate((Collection)oTarget, aggregator) : (oTarget.equals("*") ? map.aggregate(map.keySet(), aggregator) : map.aggregate(Collections.singleton(oTarget), aggregator)));
        ((ThreadLocal)this.get_Sink()).set(oResult);
        if (fSilent ^ true) {
            Component._trace(String.valueOf(oResult));
        }
    }

    protected void doBackup(String[] asParam, boolean fSilent) {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        NamedCache map = this.getMap();
        try {
            File file = new File(asParam[0]);
            FileOutputStream streamFile = new FileOutputStream(file);
            DataOutputStream streamData = new DataOutputStream(new BufferedOutputStream(streamFile, 32 * 1024));
            ExternalizableHelper.writeMap((DataOutput)streamData, (Map)map);
            streamData.close();
            streamFile.close();
            if (fSilent ^ true) {
                Component._trace(String.valueOf(map.size()) + " entries written to " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
            }
        }
        catch (IOException e) {
            Component._trace(String.valueOf("Failed to backup: ") + e);
        }
    }

    protected void doBatch(String[] asParam, boolean fSilent) throws InterruptedException {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        String sFile = asParam[0];
        InputStreamReader readerRaw = null;
        try {
            try {
                String sCmd;
                readerRaw = new FileReader(sFile);
                BufferedReader reader = new BufferedReader(readerRaw);
                while (!((sCmd = reader.readLine()) == null)) {
                    if (!(sCmd.length() > 0)) continue;
                    if (fSilent ^ true) {
                        Component._trace(String.valueOf(">>> ") + sCmd);
                    }
                    if (!(sCmd.startsWith("//") ^ true)) continue;
                    this.processCommand(sCmd);
                }
            }
            catch (IOException e) {
                Component._trace(String.valueOf("Failed to read the batch file: ") + e);
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                readerRaw.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            readerRaw.close();
        }
        catch (Exception e) {}
    }

    protected void doBulkPut(String[] asParam, boolean fSilent) {
        if (this.isMapValid() ^ true) {
            return;
        }
        int cIters = 1000;
        int cbData = 1000;
        int iFirst = 0;
        try {
            cIters = Integer.parseInt(asParam[0]);
            cbData = Integer.parseInt(asParam[1]);
            iFirst = Integer.parseInt(asParam[2]);
        }
        catch (Exception e) {
            Component._trace(String.valueOf("Assuming iterations=") + cIters + ", size=" + cbData + ", first=" + iFirst);
        }
        int cBatch = 0;
        if (asParam.length > 3) {
            String sBatch = asParam[3];
            if ("all".equals(sBatch)) {
                cBatch = cIters;
            } else {
                try {
                    cBatch = Integer.parseInt(sBatch);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (cIters < 0) {
            cIters = -cIters;
            iFirst -= cIters - 1;
        }
        if (fSilent ^ true) {
            Component._trace(String.valueOf(new Date()) + ": adding " + cIters + " items (starting with #" + iFirst + ") each " + cbData + " bytes ...");
        }
        int nOrigin = 0;
        try {
            nOrigin = this.getService().getCluster().getLocalMember().getId();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        NamedCache mapAll = this.getMap();
        HashMap<Object, byte[]> mapBatch = cBatch > 0 ? new HashMap<Object, byte[]>() : null;
        Random random = new Random();
        long lBegin = Base.getSafeTimeMillis();
        int i = iFirst;
        int iLast = iFirst + cIters;
        int cB = 0;
        while (i < iLast) {
            Object oVal;
            Object oKey;
            if (cbData > 0) {
                byte[] ab = new byte[cbData];
                ab[0] = (byte)random.nextInt();
                oKey = new Integer(i);
                oVal = ab;
            } else {
                Coherence$CacheItem item = new Coherence$CacheItem();
                item.setIndex(i);
                item.setOrigin(nOrigin);
                oKey = cbData < 0 ? (Object)item : new Integer(i);
                oVal = item;
            }
            if (cBatch > 0) {
                mapBatch.put(oKey, (byte[])oVal);
                if (++cB == cBatch) {
                    mapAll.putAll(mapBatch);
                    mapBatch.clear();
                    cB = 0;
                }
            } else {
                mapAll.put(oKey, oVal);
            }
            ++i;
        }
        if (!(cBatch > 0) ? false : mapBatch.isEmpty() ^ true) {
            mapAll.putAll(mapBatch);
        }
        long lElapsed = Base.getSafeTimeMillis() - lBegin;
        if (fSilent ^ true) {
            if (cbData == 0) {
                cbData = 480;
            }
            double dThrouK = (double)cIters * (double)(cbData += 4) / (double)lElapsed;
            double dThrouI = (double)cIters * (double)1000 / (double)lElapsed;
            Component._trace(String.valueOf(new Date()) + ": done putting (" + lElapsed + "ms, " + (int)dThrouK + "KB/sec, " + (int)dThrouI + " items/sec)");
        }
    }

    protected void doBulkRemove(String[] asParam, boolean fSilent) {
        if (this.isMapValid() ^ true) {
            return;
        }
        int cIters = 1000;
        int iFirst = 1;
        try {
            cIters = Integer.parseInt(asParam[0]);
            iFirst = Integer.parseInt(asParam[1]);
        }
        catch (Exception e) {
            Component._trace(String.valueOf("Assuming iterations=") + cIters + ", first=" + iFirst);
        }
        int cBatch = 0;
        if (asParam.length > 3) {
            String sBatch = asParam[3];
            if ("all".equals(sBatch)) {
                cBatch = cIters;
            } else {
                try {
                    cBatch = Integer.parseInt(sBatch);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (cIters < 0) {
            cIters = -cIters;
            iFirst -= cIters - 1;
        }
        if (fSilent ^ true) {
            Component._trace(String.valueOf(new Date()) + ": removing " + cIters + " items (starting with #" + iFirst + ")");
        }
        boolean fResult = false;
        Set setAll = this.getMap().keySet();
        HashSet<Integer> setBatch = cBatch > 0 ? new HashSet<Integer>() : null;
        long lBegin = Base.getSafeTimeMillis();
        int i = iFirst;
        int iLast = iFirst + cIters;
        int cB = 0;
        while (i < iLast) {
            Integer oKey = new Integer(i);
            if (cBatch > 0) {
                setBatch.add(oKey);
                if (cB++ == cBatch) {
                    fResult |= setAll.removeAll(setBatch);
                    setBatch.clear();
                    cB = 0;
                }
            } else {
                fResult |= setAll.remove(oKey);
            }
            ++i;
        }
        if (!(cBatch > 1) ? false : setBatch.isEmpty() ^ true) {
            fResult |= setAll.removeAll(setBatch);
        }
        long lElapsed = Base.getSafeTimeMillis() - lBegin;
        if (fSilent ^ true) {
            Component._trace(String.valueOf(new Date()) + ": done removing; " + "result=" + fResult + " (" + lElapsed + "ms)");
        }
    }

    protected void doCache(String[] asParam, boolean fSilent) {
        boolean fCQC;
        DefaultConfigurableCacheFactory factory = (DefaultConfigurableCacheFactory)CacheFactory.getConfigurableCacheFactory();
        String sName = asParam[0];
        boolean fUnique = !(asParam.length > 1) ? false : asParam[1].equals("unique");
        boolean fBinary = !(asParam.length > 1) ? false : asParam[1].equals("binary");
        boolean bl = fCQC = !(asParam.length > 1) ? false : this.getFilters().containsKey(asParam[1]);
        ClassLoader loader = fUnique ? this.getUniqueClassLoader() : (fBinary ? NullImplementation.getClassLoader() : this.getClass().getClassLoader());
        NamedCache cache = CacheFactory.getCache((String)sName, (ClassLoader)loader);
        String sPrompt = cache.getCacheName();
        if (fCQC) {
            cache = new ContinuousQueryCache(cache, (Filter)this.getFilters().get(asParam[1]));
            sPrompt = String.valueOf("CQC-") + sPrompt;
        }
        this.getLogger().setPrompt(sPrompt);
        this.setService(cache.getCacheService());
        this.setMap(cache);
        if (fSilent ^ true) {
            DefaultConfigurableCacheFactory.CacheInfo info = factory.findSchemeMapping(sName);
            Component._trace(String.valueOf(factory.resolveScheme(info)));
        }
    }

    protected void doCacheFactory(String[] asParam, boolean fSilent) {
        int cParams = asParam.length;
        if (cParams > 0) {
            DefaultConfigurableCacheFactory factory = new DefaultConfigurableCacheFactory(asParam[0]);
            CacheFactory.setConfigurableCacheFactory((ConfigurableCacheFactory)factory);
            if (!(cParams > 1) ? false : asParam[1].equals("start")) {
                DefaultCacheServer.start((ConfigurableCacheFactory)factory);
            }
        }
        if (fSilent ^ true) {
            Component._trace(CacheFactory.getConfigurableCacheFactory().getConfig().getSafeElement("caching-scheme-mapping").toString());
        }
    }

    protected void doConnector(String[] asParam, boolean fSilent) throws InterruptedException {
        int cParams = asParam.length;
        if (cParams == 0) {
            Component._trace("Command: connector (listener | publisher) [(unicast | multicast | *) [on | off | drop <drop ratio> | pause <pause ratio>]]");
            return;
        }
        float flRate = -1.0f;
        boolean fPause = false;
        if (cParams >= 3) {
            String sRate = asParam[2];
            float f = sRate.equals("off") ? 1.0f : (sRate.equals("on") ? 0.0f : (sRate.equals("drop") ? (cParams >= 4 ? Float.parseFloat(asParam[3]) : -1.0f) : (sRate.equals("pause") ? (cParams >= 4 ? Float.parseFloat(asParam[3]) : -1.0f) : (flRate = -1.0f))));
            fPause = !(!sRate.equals("pause") ? false : flRate > 0.0f) ? false : flRate < 1.0f;
            if (flRate < 0.0f ? true : flRate > 1.0f) {
                Component._trace("Ratio should be within [0.0, 1.0] interval");
                return;
            }
        }
        int CHANNEL_UNI = 1;
        int CHANNEL_MULTI = 2;
        int nChannels = CHANNEL_MULTI | CHANNEL_UNI;
        if (cParams >= 2) {
            nChannels = asParam[1].startsWith("u") ? CHANNEL_UNI : (asParam[1].startsWith("m") ? CHANNEL_MULTI : nChannels);
        }
        long lPause = (long)((float)10000 * flRate);
        int iDropRate = fPause ? 100000 : (int)(flRate * (float)100000);
        while (true) {
            int nChannel = CHANNEL_UNI;
            while (nChannel <= CHANNEL_MULTI) {
                if ((nChannels & nChannel) != 0) {
                    String sDirection;
                    String sTarget = String.valueOf(this.getMap() == null ? "&" : "&getCacheService.getService.") + "getCluster";
                    if (asParam[0].startsWith("l")) {
                        sDirection = "Rx";
                        sTarget = String.valueOf(sTarget) + (nChannel == CHANNEL_UNI ? ".getPointListener" : ".getMultiListener");
                        sTarget = String.valueOf(sTarget) + ".getUdpSocket";
                    } else {
                        sDirection = "Tx";
                        sTarget = String.valueOf(sTarget) + (String.valueOf(".getPublisher") + (nChannel == CHANNEL_UNI ? ".getUdpSocketUnicast" : ".getUdpSocketMulticast"));
                    }
                    if (flRate == -1.0f) {
                        this.processCommand(sTarget);
                    } else {
                        this.processCommand(String.valueOf('@') + sTarget + ".set" + sDirection + "DebugDropRate " + iDropRate);
                    }
                }
                nChannel <<= 1;
            }
            if (!fPause) break;
            ((ThreadLocal)this.get_Sink()).set(null);
            Thread.sleep(lPause);
            lPause = (long)10000 - lPause;
            iDropRate = Math.abs(iDropRate - 100000);
        }
    }

    protected void doFilter(Object[] aoParam, boolean fSilent) {
        Map mapFilter = this.getFilters();
        int cParams = aoParam.length;
        String sFilterName = (String)aoParam[0];
        String sFilterType = (String)aoParam[1];
        Object[] aoFilterParam = new Object[cParams - 2];
        try {
            int i = 2;
            while (i < cParams) {
                Object oParam = aoParam[i];
                Filter filter = (Filter)mapFilter.get(oParam);
                if (filter != null) {
                    oParam = filter;
                } else if (String.valueOf(oParam).startsWith("!")) {
                    oParam = (oParam = this.convertArgument(((String)oParam).substring(1))) == null ? new KeyExtractor(null) : new KeyExtractor((String)oParam);
                }
                aoFilterParam[i - 2] = oParam;
                ++i;
            }
            if (sFilterType.equals("All") ? true : sFilterType.equals("Any")) {
                int cFilters = aoFilterParam.length;
                Filter[] aFilter = new Filter[cFilters];
                System.arraycopy(aoFilterParam, 0, aFilter, 0, cFilters);
                aoFilterParam = new Object[]{aFilter};
            }
            Class<?> clzFilter = Class.forName(String.valueOf("com.tangosol.util.filter.") + sFilterType + "Filter");
            Filter filter = (Filter)ClassHelper.newInstance(clzFilter, (Object[])aoFilterParam);
            mapFilter.put(sFilterName, filter);
            if (fSilent ^ true) {
                Component._trace(String.valueOf(filter));
            }
        }
        catch (Throwable e) {
            Coherence.printException("Invalid filter format: ", e);
        }
    }

    protected Object doFunction(String sFunction, Object[] aoParam, boolean fSilent) {
        NamedCache oTarget = null;
        boolean fSetTarget = true;
        if (sFunction.startsWith("&&") ? true : sFunction.startsWith("&!")) {
            fSetTarget = sFunction.startsWith("&&");
            sFunction = sFunction.substring(2);
            oTarget = (NamedCache)((ThreadLocal)this.get_Sink()).get();
        } else if (sFunction.startsWith("&/")) {
            try {
                String sClass = sFunction.substring(2);
                int ofClz = sClass.indexOf(46);
                sFunction = sClass.substring(ofClz + 1);
                sClass = sClass.substring(0, ofClz).replace('/', '.');
                try {
                    oTarget = Class.forName(sClass);
                }
                catch (ClassNotFoundException e) {
                    oTarget = Class.forName(String.valueOf("java.lang.") + sClass);
                }
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Invalid format: ") + e);
                return e;
            }
        } else if (sFunction.startsWith("&{")) {
            int ofTarget = sFunction.indexOf(125);
            if (ofTarget > 0) {
                oTarget = this.convertArgument(sFunction.substring(1, ++ofTarget));
                if (!(sFunction.length() > ofTarget) ? false : sFunction.charAt(ofTarget) == '.') {
                    ++ofTarget;
                }
                sFunction = sFunction.substring(ofTarget);
            }
        } else if (sFunction.startsWith("&~")) {
            sFunction = sFunction.substring(2);
            oTarget = this;
        } else {
            sFunction = sFunction.substring(1);
            oTarget = this.getMap();
            if (oTarget == null) {
                oTarget = Coherence.getCluster();
            }
        }
        if (sFunction.length() > 0) {
            oTarget = Coherence.processFunction(oTarget, sFunction, fSilent, aoParam);
        } else {
            Coherence.processFunction(oTarget, "toString", fSilent, aoParam);
        }
        if (fSetTarget) {
            ((ThreadLocal)this.get_Sink()).set(oTarget);
        }
        return oTarget;
    }

    protected void doIndex(String[] asParam, boolean fSilent) {
        KeyExtractor extractor;
        boolean fRemove;
        String sMethod = asParam[0];
        boolean bl = fRemove = !(asParam.length > 1) ? false : asParam[1].equals("remove");
        if (sMethod.startsWith("!")) {
            extractor = new KeyExtractor(sMethod.substring(1));
        } else {
            Object object = extractor = sMethod.indexOf(46) < 0 ? (ValueExtractor)new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod);
        }
        if (fRemove) {
            this.getMap().removeIndex((ValueExtractor)extractor);
        } else {
            this.getMap().addIndex((ValueExtractor)extractor, true, (Comparator)new SafeComparator(null));
        }
    }

    protected void doInvoke(String sService, String[] asParam, boolean fSilent) {
        InvocationService srvc = this.getInvocationService(sService);
        int cParams = asParam.length;
        if (cParams == 0) {
            return;
        }
        String sCommand = asParam[0];
        String sTarget = cParams >= 2 ? asParam[1] : "all";
        boolean fAsync = !(cParams >= 3) ? false : asParam[2].startsWith("a");
        int iPriority = cParams >= 4 ? Integer.parseInt(asParam[3]) : 0;
        long cTimeout = cParams >= 5 ? Long.parseLong(asParam[4]) : 0L;
        Coherence$CacheItem task = new Coherence$CacheItem();
        task.setInvokeCommand(sCommand);
        task.setSchedulingPriority(iPriority);
        task.setExecutionTimeoutMillis(cTimeout);
        Set setMember = null;
        if (sTarget.equals("all") ^ true) {
            setMember = srvc.getInfo().getServiceMembers();
            if (sTarget.equals("other")) {
                setMember.remove(Coherence.getCluster().getLocalMember());
            } else if (sTarget.equals("senior")) {
                setMember.clear();
                setMember.add(srvc.getInfo().getOldestMember());
            } else {
                setMember.clear();
                Set setAll = srvc.getInfo().getServiceMembers();
                try {
                    int nMember = Integer.parseInt(sTarget);
                    Iterator iter = setAll.iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        if (!(member.getId() == nMember)) continue;
                        setMember.add(member);
                        break;
                    }
                }
                catch (NumberFormatException e) {
                    Component._trace(String.valueOf("Unknown target: ") + sTarget);
                    return;
                }
            }
        }
        if (fAsync) {
            srvc.execute((Invocable)task, setMember, (InvocationObserver)((Coherence$Worker)this._newChild("Worker")));
        } else {
            TreeMap mapResult = srvc.query((Invocable)task, setMember);
            if (fSilent ^ true) {
                if (mapResult.isEmpty()) {
                    Component._trace("No results");
                } else {
                    if (mapResult.size() > 1) {
                        mapResult = new TreeMap(mapResult);
                    }
                    Iterator iter = mapResult.keySet().iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        Object oResult = mapResult.get(member);
                        Component._trace(String.valueOf("Member ") + (member == null ? "Proxy" : String.valueOf(member.getId())) + ", Result=" + (oResult instanceof Throwable ? String.valueOf(oResult) + "\n" + Component.getStackTrace((Throwable)oResult) : String.valueOf(oResult)));
                    }
                }
            }
        }
    }

    protected void doJmx(String[] asParam) {
        String sName;
        int cParams = asParam.length;
        int nPort = 8082;
        String sUrl = "";
        try {
            if (cParams > 0) {
                nPort = Integer.parseInt(asParam[0]);
            }
        }
        catch (NumberFormatException e) {
            sUrl = asParam[0];
        }
        boolean fStart = cParams <= 1 ? true : asParam[1].equals("stop") ^ true;
        String string = sName = sUrl.length() == 0 ? "Adapter" : "Connector";
        if (fStart) {
            Component wrapper = this._findChild(sName);
            if (wrapper != null) {
                Component._trace(String.valueOf("Already started: ") + wrapper);
                return;
            }
            try {
                wrapper = sUrl.length() == 0 ? new HttpAdapter() : new ServerConnector();
            }
            catch (NoClassDefFoundError e) {
                Component._trace("JMX library is not on a classpath; only remote management is allowed");
                return;
            }
            try {
                if (wrapper instanceof HttpAdapter) {
                    ((HttpAdapter)wrapper).start(nPort, Coherence.getCluster());
                } else {
                    ((ServerConnector)wrapper).start(sUrl, Coherence.getCluster());
                }
            }
            catch (RuntimeException e) {
                if (cParams > 1) {
                    Component._trace(e);
                } else {
                    Component._trace(e.getMessage());
                }
                return;
            }
            this._addChild(wrapper, sName);
            ((ThreadLocal)this.get_Sink()).set(wrapper);
            Component._trace(String.valueOf("Installed: ") + wrapper);
        } else {
            Component wrapper = this._findChild(sName);
            if (wrapper != null) {
                if (wrapper instanceof HttpAdapter) {
                    ((HttpAdapter)wrapper).stop();
                } else {
                    ((ServerConnector)wrapper).stop();
                }
                this._removeChild(wrapper);
            }
        }
    }

    protected void doList(String[] asParam, boolean fSilent) {
        Set setEntry;
        NamedCache map = this.getMap();
        int cParams = asParam.length;
        if (cParams > 0) {
            String sName = asParam[0];
            if (this.getFilters().containsKey(sName)) {
                Object comparator = null;
                int nPage = -1;
                if (cParams > 1) {
                    String[] asMethod = Base.parseDelimitedString((String)asParam[1], (char)',');
                    int cMethods = asMethod.length;
                    if (cMethods > 1) {
                        Comparator[] acomp = new Comparator[cMethods];
                        int i = 0;
                        while (i < cMethods) {
                            String sMethod = asMethod[i];
                            acomp[i] = sMethod.startsWith("!") ? (Comparator)new KeyExtractor(sMethod.substring(1)) : new ReflectionExtractor(sMethod);
                            ++i;
                        }
                        comparator = new ChainedComparator(acomp);
                    } else {
                        String sMethod;
                        comparator = asMethod[0].equals("null") ? new SafeComparator(null) : ((sMethod = asMethod[0]).startsWith("!") ? (Comparator)new KeyExtractor(sMethod.substring(1)) : new ReflectionExtractor(sMethod));
                    }
                    if (!(cParams > 2) ? false : asParam[2].startsWith("desc")) {
                        comparator = new InverseComparator((Comparator)comparator);
                    }
                    if (cParams > 3) {
                        nPage = Integer.parseInt(asParam[3]);
                    }
                }
                setEntry = this.applyFilter(sName, false, (Comparator)comparator, nPage);
            } else {
                map = this.getService().ensureCache(sName, null);
                setEntry = map.entrySet();
            }
        } else {
            setEntry = map.entrySet();
        }
        int cSize = setEntry.size();
        int cLimit = Math.min(cSize, 50);
        int c = 0;
        Iterator iter = setEntry.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!(!(c++ < cLimit) ? false : fSilent ^ true)) continue;
            Component._trace(String.valueOf(entry.getKey()) + " = " + entry.getValue());
        }
        if (!(cLimit < cSize) ? false : fSilent ^ true) {
            Component._trace(String.valueOf("Only ") + cLimit + " out of total " + cSize + " items were printed");
        }
        if (c != cSize) {
            Component._trace(String.valueOf("Iterator returned ") + c + " items");
        }
        ((ThreadLocal)this.get_Sink()).set(setEntry);
    }

    protected void doListen(String sSource, boolean fStop, Filter filter, Object oKey, boolean fLite) {
        NamedCache map = this.getMap();
        CacheService service = map.getCacheService();
        NamedCache mapListen = map;
        if (sSource.equals("local")) {
            BackingMapManager mgr = service.getBackingMapManager();
            if (mgr == null) {
                Component._trace(String.valueOf("Service ") + service.getInfo().getServiceName() + " does not have BackingMapManager;" + " use coherence-cache-config.xml and 'cache' command to create a cache");
                return;
            }
            String sCacheName = map.getCacheName();
            try {
                mapListen = (ObservableMap)ClassHelper.invoke((Object)mgr, (String)"getBackingMap", (Object[])new Object[]{sCacheName});
            }
            catch (ClassCastException e) {
                Component._trace(String.valueOf("Local storage for cache: ") + sCacheName + " is not observable;" + " use coherence-cache-config.xml to configure");
                return;
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Service ") + service.getInfo().getServiceName() + " uses unsupported BackingMapManager: " + mgr.getClass().getName());
                return;
            }
            if (mapListen == null) {
                Component._trace(String.valueOf("Local storage for cache: ") + sCacheName + " is missing");
            }
        }
        String sWorker = String.valueOf("Worker!") + sSource;
        Coherence$Worker worker = (Coherence$Worker)this._findChild(sWorker);
        if (fStop) {
            if (worker == null) {
                Component._trace("No listener to stop");
            } else {
                if (sSource.equals("members")) {
                    service.removeMemberListener((MemberListener)worker);
                } else if (sSource.equals("master")) {
                    service.getCluster().ensureService("Cluster", "Cluster").removeMemberListener((MemberListener)worker);
                } else {
                    Coherence$Worker listener = worker;
                    if (sSource.endsWith("-sync")) {
                        listener = new MapListenerSupport.WrapperSynchronousListener((MapListener)listener);
                    }
                    if (oKey == null) {
                        mapListen.removeMapListener((MapListener)listener, filter);
                    } else {
                        mapListen.removeMapListener((MapListener)listener, oKey);
                    }
                }
                int cRefCount = worker.getRefCount() - 1;
                if (cRefCount == 0) {
                    this._removeChild(worker);
                } else {
                    worker.setRefCount(cRefCount);
                }
            }
        } else {
            if (worker == null) {
                worker = new Coherence$Worker();
                this._addChild(worker, sWorker);
            }
            if (sSource.equals("members")) {
                service.addMemberListener((MemberListener)worker);
            } else if (sSource.equals("master")) {
                service.getCluster().ensureService("Cluster", "Cluster").addMemberListener((MemberListener)worker);
            } else {
                Coherence$Worker listener = worker;
                if (sSource.endsWith("-sync")) {
                    listener = new MapListenerSupport.WrapperSynchronousListener((MapListener)listener);
                }
                if (oKey == null) {
                    mapListen.addMapListener((MapListener)listener, filter, fLite);
                } else {
                    mapListen.addMapListener((MapListener)listener, oKey, fLite);
                }
            }
            worker.setRefCount(worker.getRefCount() + 1);
        }
    }

    protected void doLog(Object[] aoParam, boolean fSilent) {
        int cParams = aoParam.length;
        String sMsg = null;
        int cchMsg = 50;
        if (cParams >= 1) {
            if (aoParam[0] instanceof Number) {
                cchMsg = ((Number)aoParam[0]).intValue();
                cchMsg = Math.max(1, cchMsg);
            } else {
                sMsg = String.valueOf(aoParam[0]);
                cchMsg = sMsg.length();
            }
        }
        if (sMsg == null) {
            sMsg = Base.dup((char)'*', (int)cchMsg);
        }
        int cIters = 1;
        if (!(cParams >= 2) ? false : aoParam[1] instanceof Number) {
            cIters = ((Number)aoParam[1]).intValue();
        }
        cIters = Math.max(1, cIters);
        int nLevel = 3;
        if (!(cParams >= 3) ? false : aoParam[2] instanceof Number) {
            nLevel = ((Number)aoParam[2]).intValue();
        }
        if (fSilent ^ true) {
            Component._trace(String.valueOf("Logging ") + cIters + " messages of " + cchMsg + " characters at level " + nLevel + ":");
        }
        if (cIters == 1) {
            Component._trace(sMsg, nLevel);
        } else {
            int i = 1;
            while (i <= cIters) {
                Component._trace(String.valueOf(i) + ":" + sMsg, nLevel);
                ++i;
            }
        }
    }

    protected void doMap(String[] asParam, boolean fSilent) {
        CacheService service = this.getService();
        int cParams = asParam.length;
        String sCacheName = cParams == 0 ? "Default" : asParam[0];
        String sPrefix = "";
        String sServiceType = service == null ? "ReplicatedCache" : service.getInfo().getServiceType();
        String sServiceName = service == null ? sServiceType : service.getInfo().getServiceName();
        int ofServiceType = sCacheName.indexOf(58);
        if (ofServiceType >= 0) {
            int ofServiceName;
            sServiceType = sCacheName.substring(0, ofServiceType);
            if ((sCacheName = sCacheName.substring(ofServiceType + 1)).length() == 0) {
                sCacheName = null;
            }
            if ((ofServiceName = sServiceType.indexOf(33)) > 0) {
                sServiceName = sServiceType.substring(ofServiceName + 1);
                sServiceType = sServiceType.substring(0, ofServiceName);
            }
            if (sServiceType.endsWith("Cache") ^ true) {
                sServiceType = String.valueOf(sServiceType) + "Cache";
                if (ofServiceName < 0) {
                    sServiceName = sServiceType;
                }
            }
        }
        String sInternal = null;
        if (!(sCacheName != null) ? false : sCacheName.startsWith("@")) {
            sInternal = sCacheName;
            sCacheName = "Default";
        }
        if (sServiceType.equals("ReplicatedCache")) {
            service = this.getReplicatedCache(sServiceName);
            sPrefix = "Replicated!";
        } else if (sServiceType.equals("OptimisticCache")) {
            service = this.getOptimisticCache(sServiceName);
            sPrefix = "Optimistic!";
        } else if (sServiceType.equals("DistributedCache")) {
            service = this.getDistributedCache(sServiceName);
            sPrefix = "Distributed!";
        } else if (sServiceType.equals("SimpleCache")) {
            service = this.getSimpleCache(sCacheName);
            sPrefix = "Simple!";
        } else if (sServiceType.equals("LocalCache")) {
            service = this.getLocalCache(sServiceName);
            sPrefix = "Local!";
        } else {
            service = (CacheService)this.ensureCluster().ensureService(sServiceName, sServiceType);
            if (service.isRunning() ^ true) {
                service.configure(Coherence.getServiceConfig(sServiceType));
                service.start();
            }
            sPrefix = String.valueOf(sServiceName) + '!';
        }
        boolean fUnique = !(cParams > 1) ? false : asParam[1].equals("unique");
        ClassLoader loader = fUnique ? this.getUniqueClassLoader() : this.getClass().getClassLoader();
        NamedCache cache = service.ensureCache(sCacheName, loader);
        if (sInternal != null) {
            while (cache instanceof SafeNamedCache) {
                cache = ((SafeNamedCache)cache).getNamedCache();
            }
            service = cache.getCacheService();
            Object map = null;
            if (sInternal.equals("@service")) {
                map = ((com.tangosol.coherence.component.util.daemon.queueProcessor.Service)service).getServiceConfigMap();
            } else if (sInternal.startsWith("@member")) {
                int nMember = ((com.tangosol.coherence.component.util.daemon.queueProcessor.Service)service).getThisMember().getId();
                try {
                    nMember = Integer.parseInt(sInternal.substring("@member".length()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                map = ((com.tangosol.coherence.component.util.daemon.queueProcessor.Service)service).getServiceMemberSet().getMemberConfigMap(nMember);
            } else {
                try {
                    map = (Map)ClassHelper.newInstance(Class.forName(sInternal.substring(1)), (Object[])ClassHelper.VOID);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (map == null) {
                Component._trace(String.valueOf("No such map: ") + sInternal);
                return;
            }
            cache = new WrapperNamedCache((Map)map, sInternal, service);
            sPrefix = "";
        }
        if (fSilent ^ true) {
            Component._trace(String.valueOf("\n") + service.getCluster().getLocalMember());
            Component._trace(String.valueOf(service));
            this.getLogger().setPrompt(String.valueOf(sPrefix) + cache.getCacheName());
        }
        this.setService(service);
        this.setMap(cache);
    }

    protected void doProcess(Object[] aoParam, boolean fSilent) {
        InvocableMap.EntryProcessor processor;
        NamedCache map = this.getMap();
        int cParams = aoParam.length;
        if (cParams < 2) {
            Component._trace("Processor name must be specified");
            return;
        }
        int iParam = 0;
        Object oTarget = aoParam[iParam++];
        Filter filter = aoParam[iParam] instanceof Filter ? (Filter)aoParam[iParam++] : null;
        String sProcessor = (String)aoParam[iParam++];
        Object[] aoProcessorParam = new Object[cParams -= iParam];
        if (cParams > 0) {
            System.arraycopy(aoParam, iParam, aoProcessorParam, 0, cParams);
        }
        try {
            Class<?> clzProcessor = Class.forName(String.valueOf("com.tangosol.util.processor.") + sProcessor);
            processor = (InvocableMap.EntryProcessor)ClassHelper.newInstance(clzProcessor, (Object[])aoProcessorParam);
        }
        catch (Throwable e) {
            Coherence.printException(String.valueOf("Invalid processor format: ") + sProcessor + " " + Coherence.toString(aoProcessorParam) + "\n", e);
            return;
        }
        if (filter != null) {
            processor = new ConditionalProcessor(filter, processor);
        }
        Map oResult = (oTarget instanceof Filter ? true : oTarget == null) ? map.invokeAll((Filter)oTarget, processor) : (oTarget instanceof Collection ? map.invokeAll((Collection)oTarget, processor) : (oTarget.equals("*") ? map.invokeAll(map.keySet(), processor) : map.invoke(oTarget, processor)));
        ((ThreadLocal)this.get_Sink()).set(oResult);
        if (fSilent ^ true) {
            Component._trace(String.valueOf(oResult));
        }
    }

    protected void doRepeat(String sCmd, int cIter, boolean fForce) throws InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        int cch = sCmd.length();
        int ofPrev = 0;
        while (ofPrev < cch) {
            int ofNext;
            if (sCmd.charAt(ofPrev) == '{') {
                ++ofPrev;
                ofNext = sCmd.lastIndexOf(125);
            } else {
                ofNext = sCmd.indexOf(59, ofPrev);
            }
            if (ofNext < 0) {
                list.add(sCmd.substring(ofPrev));
                break;
            }
            list.add(sCmd.substring(ofPrev, ofNext));
            ofPrev = ofNext + 1;
        }
        int cCmds = list.size();
        String[] asCmd = list.toArray(new String[cCmds]);
        int i = 0;
        block1: while (i < cIter) {
            ((ThreadLocal)this.get_Sink()).set(new Integer(i));
            int j = 0;
            while (j < cCmds) {
                Object oResult;
                sCmd = asCmd[j].trim();
                if (sCmd.length() > 0 && (oResult = this.processCommand(sCmd)) instanceof Throwable) {
                    if (!fForce) break block1;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void doRestore(String[] asParam, boolean fSilent) {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        NamedCache map = this.getMap();
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            File file = new File(asParam[0]);
            FileInputStream streamFile = new FileInputStream(file);
            DataInputStream streamData = new DataInputStream(new BufferedInputStream(streamFile, 32 * 1024));
            int cBlock = Integer.MAX_VALUE;
            if (asParam.length > 1) {
                try {
                    cBlock = Integer.parseInt(asParam[1]);
                    Component._assert(cBlock > 0);
                }
                catch (Exception e) {
                    Component._trace("Invalid block size");
                    return;
                }
            }
            int cEntries = ExternalizableHelper.readMap((DataInput)streamData, (Map)map, (int)cBlock, (ClassLoader)loader);
            if (fSilent ^ true) {
                Component._trace(String.valueOf(cEntries) + " entries restored from " + file.getAbsolutePath());
            }
            streamData.close();
            streamFile.close();
        }
        catch (IOException e) {
            Component._trace(String.valueOf("Failed to restore: ") + e);
        }
    }

    protected void doScan(String[] asParam) {
        int iFirst = 1;
        int cIters = 1000;
        try {
            iFirst = Integer.parseInt(asParam[0]);
            cIters = Integer.parseInt(asParam[1]);
        }
        catch (NumberFormatException e) {
            Component._trace(String.valueOf("Assuming first=") + iFirst + ", iterations=" + cIters);
        }
        NamedCache map = this.getMap();
        int iGapStart = 0;
        int iGapEnd = 0;
        int i = iFirst;
        int iLast = iFirst + cIters;
        while (i < iLast) {
            if (map.containsKey(new Integer(i)) ^ true) {
                iGapStart = i;
                iGapEnd = i;
                while (!(++i < iLast) ? false : map.containsKey(new Integer(i)) ^ true) {
                    iGapEnd = i;
                }
                if (iGapStart == iGapEnd) {
                    Component._trace(String.valueOf("\nMissing item: ") + iGapStart);
                } else {
                    Component._trace(String.valueOf("\nMissing items: ") + iGapStart + " .. " + iGapEnd);
                }
            }
            if (!(i > iGapStart + 1000) ? false : i % 1000 == 0) {
                System.out.print(String.valueOf("\b\b\b\b\b\b\b") + i);
                System.out.flush();
            }
            ++i;
        }
    }

    protected Object doSecure(String[] asParam, boolean fSilent) throws InterruptedException {
        Object subject;
        PrivilegedAction action;
        int cParams = asParam.length;
        if (cParams < 3) {
            return null;
        }
        String sName = asParam[0];
        char[] acPwd = asParam[1].toCharArray();
        String sCmd = asParam[2];
        int i = 3;
        while (i < cParams) {
            sCmd = String.valueOf(sCmd) + (String.valueOf(' ') + asParam[i]);
            ++i;
        }
        boolean fImpersonate = false;
        if (sName.startsWith("hack_")) {
            fImpersonate = true;
            sName = sName.substring("hack_".length());
        }
        try {
            Class<?> clz = Class.forName("com.tangosol.net.security.SimpleHandler");
            Object handler = ClassHelper.newInstance(clz, (Object[])new Object[]{sName, acPwd});
            action = Security.createPrivilegedAction(this.getClass().getMethod("processCommand", Coherence.__sm0()), this, new Object[]{sCmd});
            subject = this.getClass().getName().startsWith("_package") ? Security.login(handler) : ClassHelper.invokeStatic(Class.forName("com.tangosol.net.security.Security"), (String)"login", (Object[])new Object[]{handler});
        }
        catch (Throwable e) {
            Coherence.printException(null, e);
            return null;
        }
        if (fImpersonate) {
            subject = Security.getInstance().impersonate(subject, sName, asParam[0]);
        }
        try {
            if (this.getClass().getName().startsWith("_package")) {
                return Security.runAs(subject, action);
            }
            return ClassHelper.invokeStatic(Class.forName("com.tangosol.net.security.Security"), (String)"runAs", (Object[])new Object[]{subject, action});
        }
        catch (Throwable e) {
            Throwable eOrig = e;
            while (true) {
                if (e instanceof WrapperException) {
                    e = ((WrapperException)e).getOriginalException();
                    continue;
                }
                if (!(e instanceof InvocationTargetException)) break;
                e = eOrig = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof AccessControlException) {
                Component._trace(String.valueOf("Permission rejected: ") + ((AccessControlException)e).getPermission(), 1);
            }
            Component._trace(eOrig);
            return null;
        }
    }

    protected void doTransaction(String sFunction, String[] asParam) {
        if (sFunction.equals("begin")) {
            int nIsolation;
            int nConcur;
            String sConcur = asParam[0];
            String sIsolation = asParam[1];
            int nTimeout = 20;
            try {
                nTimeout = Integer.parseInt(asParam[2]);
            }
            catch (Exception e) {
                // empty catch block
            }
            switch (sConcur.charAt(0)) {
                case 'E': 
                case 'e': {
                    nConcur = TransactionMap.CONCUR_EXTERNAL;
                    break;
                }
                case 'O': 
                case 'o': {
                    nConcur = TransactionMap.CONCUR_OPTIMISTIC;
                    break;
                }
                default: {
                    nConcur = TransactionMap.CONCUR_PESSIMISTIC;
                    break;
                }
            }
            switch (sIsolation.charAt(0)) {
                case 'C': 
                case 'c': {
                    nIsolation = TransactionMap.TRANSACTION_GET_COMMITTED;
                    break;
                }
                case 'R': 
                case 'r': {
                    nIsolation = TransactionMap.TRANSACTION_REPEATABLE_GET;
                    break;
                }
                default: {
                    nIsolation = TransactionMap.TRANSACTION_SERIALIZABLE;
                    break;
                }
            }
            this.txStart(nConcur, nIsolation, nTimeout);
        } else if (sFunction.equals("commit")) {
            try {
                ((TransactionMap)this.getMap()).prepare();
                ((TransactionMap)this.getMap()).commit();
            }
            finally {
                Object var4_6 = null;
                this.txEnd();
            }
        } else if (sFunction.equals("rollback")) {
            ((TransactionMap)this.getMap()).rollback();
            this.txEnd();
        }
    }

    protected synchronized Cluster ensureCluster() {
        Cluster cluster = Coherence.getCluster();
        if (cluster.isRunning() ^ true) {
            cluster.configure(Coherence.getServiceConfig("Cluster"));
            cluster.start();
        }
        return cluster;
    }

    protected Coherence$Logger ensureLogger() {
        Coherence$Logger logger = this.getLogger();
        if (logger.isStarted() ^ true) {
            Coherence$Logger coherence$Logger = logger;
            synchronized (coherence$Logger) {
                if (logger.isStarted() ^ true) {
                    logger.setDead(false);
                    try {
                        logger.configure(Coherence.getServiceConfig("$Logger"));
                        logger.start();
                    }
                    catch (RuntimeException e) {
                        logger.setDead(true);
                        throw e;
                    }
                    catch (Error e) {
                        logger.setDead(true);
                        throw e;
                    }
                }
            }
        }
        return logger;
    }

    public static synchronized Cluster getCluster() {
        Cluster cluster = __s_Cluster;
        if (cluster == null) {
            cluster = new SafeCluster();
            Coherence.setCluster(cluster);
            ((Coherence)Coherence.get_Instance()).ensureLogger();
            Gateway mgmt = Gateway.createGateway(Coherence.getServiceConfig("$Management"), cluster);
            cluster.setManagement((Registry)mgmt);
        }
        return cluster;
    }

    public static String getCoherenceDtd() {
        return __s_CoherenceDtd;
    }

    public static String getCoherenceUrl() {
        return __s_CoherenceUrl;
    }

    protected synchronized CacheService getDistributedCache(String sServiceName) {
        if (this.getClass().getName().startsWith("_package")) {
            Cluster cluster;
            Cluster cluster2 = cluster = this.ensureCluster();
            synchronized (cluster2) {
                CacheService service = (CacheService)cluster.ensureService(sServiceName, CacheService.TYPE_DISTRIBUTED);
                if (service.isRunning() ^ true) {
                    service.configure(Coherence.getServiceConfig(CacheService.TYPE_DISTRIBUTED));
                    service.start();
                }
                CacheService cacheService = service;
                Object var6_6 = null;
                return cacheService;
            }
        }
        return CacheFactory.getDistributedCacheService((String)sServiceName);
    }

    public int getEdition() {
        return this.__m_Edition;
    }

    public Map getFilters() {
        HashMap mapFilter = this.__m_Filters;
        if (mapFilter == null) {
            mapFilter = new HashMap();
            this.setFilters(mapFilter);
        }
        return mapFilter;
    }

    protected synchronized InvocationService getInvocationService(String sServiceName) {
        if (this.getClass().getName().startsWith("_package")) {
            Cluster cluster;
            Cluster cluster2 = cluster = this.ensureCluster();
            synchronized (cluster2) {
                InvocationService service = (InvocationService)cluster.ensureService(sServiceName, InvocationService.TYPE_DEFAULT);
                if (service.isRunning() ^ true) {
                    service.configure(Coherence.getServiceConfig(InvocationService.TYPE_DEFAULT));
                    service.start();
                }
                InvocationService invocationService = service;
                Object var6_7 = null;
                return invocationService;
            }
        }
        try {
            return (InvocationService)CacheFactory.getConfigurableCacheFactory().ensureService(sServiceName);
        }
        catch (IllegalArgumentException e) {
            return CacheFactory.getInvocationService((String)sServiceName);
        }
    }

    protected synchronized CacheService getLocalCache(String sServiceName) {
        if (this.getClass().getName().startsWith("_package")) {
            Cluster cluster;
            Cluster cluster2 = cluster = Coherence.getCluster();
            synchronized (cluster2) {
                CacheService service = (CacheService)cluster.ensureService(sServiceName, CacheService.TYPE_LOCAL);
                if (service.isRunning() ^ true) {
                    service.configure(Coherence.getServiceConfig(CacheService.TYPE_LOCAL));
                    service.start();
                }
                CacheService cacheService = service;
                Object var6_6 = null;
                return cacheService;
            }
        }
        return CacheFactory.getLocalCacheService((String)sServiceName);
    }

    public static TransactionMap getLocalTransaction(NamedCache cache) {
        Local mapTx = new Local();
        mapTx.initialize(cache);
        return mapTx;
    }

    public Object[] getLogParameters() {
        return this.__m_LogParameters;
    }

    public Coherence$Logger getLogger() {
        return (Coherence$Logger)this._findChild("Logger");
    }

    public NamedCache getMap() {
        return this.__m_Map;
    }

    public int getMode() {
        return this.__m_Mode;
    }

    protected synchronized CacheService getOptimisticCache(String sServiceName) {
        if (this.getClass().getName().startsWith("_package")) {
            Cluster cluster;
            Cluster cluster2 = cluster = this.ensureCluster();
            synchronized (cluster2) {
                CacheService service = (CacheService)cluster.ensureService(sServiceName, CacheService.TYPE_OPTIMISTIC);
                if (service.isRunning() ^ true) {
                    service.configure(Coherence.getServiceConfig(CacheService.TYPE_OPTIMISTIC));
                    service.start();
                }
                CacheService cacheService = service;
                Object var6_6 = null;
                return cacheService;
            }
        }
        return CacheFactory.getOptimisticCacheService((String)sServiceName);
    }

    public String getProduct() {
        return this.__m_Product;
    }

    protected synchronized CacheService getReplicatedCache(String sServiceName) {
        if (this.getClass().getName().startsWith("_package")) {
            Cluster cluster;
            Cluster cluster2 = cluster = this.ensureCluster();
            synchronized (cluster2) {
                CacheService service = (CacheService)cluster.ensureService(sServiceName, CacheService.TYPE_REPLICATED);
                if (service.isRunning() ^ true) {
                    service.configure(Coherence.getServiceConfig(CacheService.TYPE_REPLICATED));
                    service.start();
                }
                CacheService cacheService = service;
                Object var6_6 = null;
                return cacheService;
            }
        }
        return CacheFactory.getReplicatedCacheService((String)sServiceName);
    }

    public CacheService getService() {
        return this.__m_Service;
    }

    public static XmlElement getServiceConfig(String sServiceType) {
        XmlElement xml;
        Map mapConfig = Coherence.getServiceConfigMap();
        if (mapConfig.isEmpty()) {
            Coherence.getCluster();
            Map map = mapConfig;
            synchronized (map) {
                if (mapConfig.isEmpty()) {
                    Coherence.loadConfiguration();
                }
            }
        }
        return (xml = (XmlElement)mapConfig.get(sServiceType)) == null ? null : (XmlElement)xml.clone();
    }

    protected static Map getServiceConfigMap() {
        return __s_ServiceConfigMap;
    }

    protected synchronized CacheService getSimpleCache(String sServiceName) {
        sServiceName = (sServiceName == null ? true : sServiceName.length() == 0) ? "Default" : sServiceName;
        Cluster cluster = this.getClass().getName().startsWith("_package") ? this.ensureCluster() : CacheFactory.ensureCluster();
        CacheService service = (CacheService)cluster.ensureService(sServiceName, "SimpleCache");
        if (service.isRunning() ^ true) {
            service.configure(Coherence.getServiceConfig("SimpleCache"));
            service.start();
        }
        return service;
    }

    protected ClassLoader getUniqueClassLoader() {
        return new ComponentClassLoader(this.getClass().getClassLoader(), (Loader)new NullStorage());
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/application/console/Coherence".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        Component singleton = Application.__singleton;
        if (singleton == null) {
            singleton = new Coherence();
        } else if (!(singleton instanceof Coherence)) {
            throw new IllegalStateException("A singleton for \\\"Coherence\\\" has already been set to a different type");
        }
        return singleton;
    }

    private final Component get_Module() {
        return this;
    }

    public Object get_Sink() {
        ThreadLocal oSink = super.get_Sink();
        if (oSink == null) {
            Coherence coherence = this;
            synchronized (coherence) {
                oSink = super.get_Sink();
                if (oSink == null) {
                    oSink = new ThreadLocal();
                    this.set_Sink(oSink);
                }
            }
        }
        return oSink;
    }

    public boolean isDebugOutputEnabled(int iSeverity) {
        Coherence$Logger logger = this.getLogger();
        return logger == null ? super.isDebugOutputEnabled(iSeverity) : iSeverity <= logger.getLevel();
    }

    private static boolean isLicenseLoaded() {
        return __s_LicenseLoaded;
    }

    protected boolean isMapValid() {
        if (this.getMap() == null) {
            Component._trace("Please specify the current map using \"cache\" or \"map\" command");
            return false;
        }
        return true;
    }

    public boolean isStop() {
        return this.__m_Stop;
    }

    protected static void loadConfiguration() {
        XmlDocument xmlCoherence;
        Coherence.get_Instance();
        Map mapConfig = Coherence.getServiceConfigMap();
        try {
            URL url = Coherence.get_CLASS().getResource(FILE_CFG_COHERENCE);
            if (url == null) {
                String sErrorMsg = String.valueOf("Configuration file is missing: \"") + FILE_CFG_COHERENCE + "\"";
                Component._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
            xmlCoherence = new SimpleParser().parseXml(url.openStream(), "ISO-8859-1");
            Component._trace(String.valueOf("Loaded operational configuration from resource \"") + url + "\"", 3);
        }
        catch (IOException e) {
            throw new WrapperException((Throwable)e);
        }
        String sDtdUri = xmlCoherence.getDtdUri();
        if (sDtdUri == null) {
            Component._trace(String.valueOf("DOCTYPE element is missing from \"") + FILE_CFG_COHERENCE + "\"; some functionality may be unavailable.", 2);
        }
        Coherence.setCoherenceUrl(sDtdUri);
        Coherence.replaceSystemProperties((XmlElement)xmlCoherence);
        XmlElement xmlLicense = xmlCoherence.ensureElement("license-config");
        String sModeDescription = Coherence.resolveMode(xmlLicense);
        mapConfig.put("$License", xmlLicense.clone());
        Coherence.loadOverrides((XmlElement)xmlCoherence, new HashSet());
        String sEditionDesc = Coherence.resolveEdition(xmlLicense);
        Component._trace(String.valueOf("\n") + TITLE + " Version " + VERSION + "\n " + sEditionDesc + ": " + sModeDescription + " mode" + "\n" + COPYRIGHT + "\n");
        XmlElement xmlCluster = xmlCoherence.ensureElement("cluster-config");
        XmlElement xmlLogging = xmlCoherence.getSafeElement("logging-config");
        XmlElement xmlFactory = xmlCoherence.getSafeElement("configurable-cache-factory-config");
        XmlElement xmlSecurity = xmlCoherence.getSafeElement("security-config");
        XmlElement xmlManagement = xmlCoherence.getSafeElement("management-config");
        xmlCluster.getElementList().addAll(xmlLicense.getElementList());
        mapConfig.put("Cluster", xmlCluster.clone());
        mapConfig.put("$License", xmlLicense.clone());
        mapConfig.put("$Logger", xmlLogging.clone());
        mapConfig.put("$CacheFactory", xmlFactory.clone());
        mapConfig.put("$Security", xmlSecurity.clone());
        mapConfig.put("$Management", xmlManagement.clone());
        Iterator iter = xmlCoherence.getSafeElement("cluster-config/services").getElements("service");
        while (iter.hasNext()) {
            XmlElement xmlSvc = (XmlElement)iter.next();
            String sSvcType = xmlSvc.getSafeElement("service-type").getString("service");
            SimpleElement xmlParams = new SimpleElement(sSvcType);
            XmlHelper.transformInitParams((XmlElement)xmlParams, (XmlElement)xmlSvc.getSafeElement("init-params"));
            mapConfig.put(sSvcType, xmlParams);
        }
    }

    protected static void loadLicenses(XmlElement xml, String sLicenseFile) {
        Signature signature;
        XmlDocument xmlLicenses;
        String sXml;
        InputStream stream = null;
        String sUrl = null;
        URL url = Coherence.get_CLASS().getClassLoader().getResource(sLicenseFile);
        if (url != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (stream == null && (url = Coherence.__sm1().getClassLoader().getResource(sLicenseFile)) != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (stream == null) {
            String sErrorMsg = String.valueOf("Edition file (") + sLicenseFile + ") is missing from the " + TITLE + " libraries";
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        sUrl = url.toString();
        try {
            sXml = new String(Base.read((InputStream)stream), "ISO-8859-1");
        }
        catch (IOException e) {
            throw new WrapperException((Throwable)e, "An exception occurred while reading the license data");
        }
        if (sXml == null ? true : sXml.length() == 0) {
            String sErrorMsg = String.valueOf("Edition data (") + sUrl + ") is missing or empty.";
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        Component._trace(String.valueOf("Loaded edition data from \"") + sUrl + "\"", 6);
        try {
            xmlLicenses = new SimpleParser().parseXml(sXml);
        }
        catch (IOException e) {
            throw new WrapperException((Throwable)e, "An exception occurred while parsing the license data");
        }
        xml.ensureElement("license-list").getElementList().addAll(xmlLicenses.getElementList());
        if (Coherence.isLicenseLoaded()) {
            return;
        }
        Coherence.setLicenseLoaded(true);
        try {
            InputStream streamCert = Coherence.get_CLASS().getClassLoader().getResourceAsStream(FILE_CFG_CERTIFICATE);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate cert = factory.generateCertificate(streamCert);
            signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(cert.getPublicKey());
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e, (String)"Error during license validation");
        }
        ArrayList<LicensedObject.LicenseData> list = new ArrayList<LicensedObject.LicenseData>();
        Iterator iter = xmlLicenses.getElements("license");
        while (iter.hasNext()) {
            int ofColon;
            XmlElement xmlLicense = (XmlElement)iter.next();
            String sLicensee = xmlLicense.getSafeElement("licensee").getString(null);
            String sAgreement = xmlLicense.getSafeElement("agreement").getString(null);
            String sMode = xmlLicense.getSafeElement("type").getString(null);
            String sFromDate = xmlLicense.getSafeElement("from-date").getString(null);
            String sToDate = xmlLicense.getSafeElement("to-date").getString(null);
            String sRenewDate = xmlLicense.getSafeElement("maintenance-renewal-date").getString(null);
            int cSeats = xmlLicense.getSafeElement("max-seats").getInt();
            int cUsers = xmlLicense.getSafeElement("max-users").getInt();
            String sSite = xmlLicense.getSafeElement("site").getString(null);
            int cServers = xmlLicense.getSafeElement("max-servers").getInt();
            int cSockets = xmlLicense.getSafeElement("max-sockets").getInt();
            int cCores = xmlLicense.getSafeElement("max-cpus").getInt();
            String sUid = xmlLicense.getSafeElement("id").getString(null);
            String sKey = xmlLicense.getSafeElement("key").getString(null);
            String sSig = xmlLicense.getSafeElement("signature").getString(null);
            String sClass = null;
            String sSoftware = null;
            String sEdition = null;
            if (sUid == null) {
                String sMsg = String.valueOf("You are using an out-of-date license format; ") + "please contact Oracle to obtain a replacement license.";
                Component._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            UID uid = new UID(sUid);
            long lDateFrom = sFromDate == null ? 0L : Coherence.parseDate(sFromDate);
            long lDateTo = sToDate == null ? 0L : Coherence.parseDate(sToDate);
            long lDateRenew = sRenewDate == null ? 0L : Coherence.parseDate(sRenewDate);
            int nMode = -1;
            if (!(sMode != null) ? false : sMode.length() > 0) {
                switch (sMode.charAt(0)) {
                    case 'e': {
                        nMode = 0;
                        break;
                    }
                    case 'd': {
                        nMode = 1;
                        break;
                    }
                    case 'p': {
                        nMode = 2;
                        break;
                    }
                }
            }
            if (nMode < 0) {
                String sErrorMsg = String.valueOf("Invalid license mode: \"") + sMode + "\"";
                Component._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
            if (sSig == null) {
                if (sKey == null) {
                    continue;
                }
            } else {
                sSoftware = xmlLicense.getSafeElement("software").getString();
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(sSoftware).append(sLicensee).append(sAgreement == null ? "" : sAgreement).append(nMode).append(lDateFrom).append(lDateTo).append(lDateRenew).append(cSeats).append(cUsers).append(sSite).append(cServers).append(cSockets).append(cCores).append(uid);
                    ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                    DataOutputStream streamSig = new DataOutputStream(streamRaw);
                    streamSig.writeUTF(sb.toString());
                    signature.update(streamRaw.toByteArray());
                    if (signature.verify(Base.parseHex((String)sSig)) ^ true) {
                        String sMsg = String.valueOf("The ") + sSoftware + " license signature " + "is not valid, please contact Oracle.";
                        System.err.println(sMsg);
                        Component._trace(sMsg, 1);
                        continue;
                    }
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException((Throwable)e, (String)(String.valueOf("Error validating license signature for ") + sSoftware));
                }
                if (sSoftware.endsWith(": Grid Edition")) {
                    sEdition = DEFAULT_EDITION;
                    sClass = "com.tangosol.license.CoherenceDataGridEdition";
                } else if (sSoftware.endsWith(": Enterprise Edition") ? true : sSoftware.endsWith(": Application Edition")) {
                    sEdition = "EE";
                    sClass = "com.tangosol.license.CoherenceApplicationEdition";
                } else if (sSoftware.endsWith(": Standard Edition") ? true : sSoftware.endsWith(": Caching Edition")) {
                    sEdition = "SE";
                    sClass = "com.tangosol.license.CoherenceCachingEdition";
                } else if (sSoftware.endsWith(": Compute Client")) {
                    sEdition = "CC";
                    sClass = "com.tangosol.license.CoherenceComputeClient";
                } else if (sSoftware.endsWith(": Real-Time Client")) {
                    sEdition = "RTC";
                    sClass = "com.tangosol.license.CoherenceRealTimeClient";
                } else if (sSoftware.endsWith(": Data Client")) {
                    sEdition = "DC";
                    sClass = "com.tangosol.license.CoherenceDataClient";
                }
            }
            if (!(sClass == null) ? false : sKey != null) {
                try {
                    sClass = new Binary(Base.parseHex((String)sKey.substring(9, sKey.length() - 1))).getBufferInput().readUTF();
                }
                catch (IOException e) {
                    continue;
                }
                if (sClass.endsWith(".CoherenceEnterprise")) {
                    sSoftware = String.valueOf(TITLE) + ": Enterprise Edition";
                    sEdition = "EE";
                    sClass = "com.tangosol.license.CoherenceApplicationEdition";
                } else if (sClass.endsWith(".Coherence")) {
                    sSoftware = String.valueOf(TITLE) + ": Standard Edition";
                    sEdition = "SE";
                    sClass = "com.tangosol.license.CoherenceCachingEdition";
                } else {
                    if (!(sClass.endsWith(".CoherenceLocal") ? true : sClass.endsWith(".ClientAccess"))) continue;
                    sSoftware = String.valueOf(TITLE) + ": Data Client";
                    sEdition = "DC";
                    sClass = "com.tangosol.license.CoherenceDataClient";
                }
            }
            boolean fOem = sLicensee.startsWith("OEM:");
            String sApp = null;
            if (fOem && (ofColon = (sLicensee = sLicensee.substring(4)).lastIndexOf(58)) > 0) {
                sApp = sLicensee.substring(ofColon + 1);
                sLicensee = sLicensee.substring(0, ofColon);
            }
            list.add(new LicensedObject.LicenseData(sSoftware, sEdition, sLicensee, fOem, sAgreement, nMode, sClass, sSite, sApp, lDateFrom, lDateTo, lDateRenew, cSeats, cUsers, cServers, cSockets, cCores, uid));
        }
        LicensedObject.setLicenseData((LicensedObject.LicenseData[])list.toArray(new LicensedObject.LicenseData[0]));
    }

    protected static void loadOverrides(XmlElement xml, Set setOverrides) {
        String ATTR_NAME = "xml-override";
        XmlValue attr = xml.getAttribute(ATTR_NAME);
        if (attr != null) {
            xml.setAttribute(ATTR_NAME, null);
            String sOverride = Coherence.calculateAttribute(attr.getString());
            try {
                InputStream stream;
                XmlDocument xmlOverride = null;
                File file = new File(sOverride);
                if (file.exists()) {
                    String sPath;
                    if (file.isDirectory()) {
                        file = new File(file, FILE_CFG_COHERENCE_OVERRIDE);
                    }
                    stream = new FileInputStream(file);
                    try {
                        sPath = file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        sPath = file.getAbsolutePath();
                    }
                    xmlOverride = new SimpleParser().parseXml(stream);
                    Component._trace(String.valueOf("Loaded operational overrides from file \"") + sPath + '\"', 3);
                } else {
                    stream = null;
                    Class clazz = Coherence.get_CLASS();
                    URL url = clazz.getResource(sOverride);
                    if (url == null) {
                        url = sOverride.startsWith("/") ? clazz.getResource(sOverride.substring(1)) : clazz.getResource(String.valueOf('/') + sOverride);
                    }
                    if (url == null) {
                        try {
                            url = new URL(sOverride);
                            stream = url.openConnection().getInputStream();
                        }
                        catch (Exception e) {}
                    } else {
                        stream = url.openStream();
                    }
                    if (stream != null) {
                        xmlOverride = new SimpleParser().parseXml(stream, "ISO-8859-1");
                        Component._trace(String.valueOf("Loaded operational overrides from resource \"") + url + '\"', 3);
                    }
                }
                if (xmlOverride == null) {
                    Component._trace(String.valueOf("Optional configuration override \"") + sOverride + "\" is not specified", 5);
                } else if (xmlOverride.getName().equals(xml.getName())) {
                    Coherence.replaceSystemProperties((XmlElement)xmlOverride);
                    XmlValue attrOverride = xmlOverride.getAttribute(ATTR_NAME);
                    if (attrOverride == null ? true : setOverrides.add(attrOverride.getString())) {
                        Coherence.loadOverrides((XmlElement)xmlOverride, setOverrides);
                        XmlHelper.overrideElement((XmlElement)xml, (XmlElement)xmlOverride);
                    } else {
                        Component._trace(String.valueOf("Document \"") + sOverride + "\" is cyclically referenced by the '" + ATTR_NAME + "' attribute of element '" + xml.getName() + "'", 1);
                    }
                } else {
                    Component._trace(String.valueOf("Root name mismatch in the document: ") + sOverride + "; " + "expected name: \"" + xml.getName() + '\"', 1);
                }
            }
            catch (IOException e) {
                Component._trace(String.valueOf("Failed to parse the element override: ") + sOverride + "; " + e, 1);
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Failed to apply the element override: ") + sOverride + "; " + e, 1);
            }
        }
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            Coherence.loadOverrides((XmlElement)iter.next(), new HashSet(setOverrides));
        }
    }

    public static void main(String[] asArgs) {
        Application.setArgument(asArgs);
        ((Coherence)Coherence.get_Instance()).run();
    }

    public static String[] parseArguments(String sArguments) {
        if (sArguments.length() == 0) {
            return new String[0];
        }
        char[] ach = sArguments.toCharArray();
        int cch = ach.length;
        boolean fEsc = false;
        boolean fQuote = false;
        char chQuote = (char)0;
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int ofCur = 0;
        while (ofCur < cch) {
            char ch = ach[ofCur];
            if (fEsc) {
                switch (ch) {
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case ' ': {
                        sb.append(' ');
                        break;
                    }
                    default: {
                        sb.append('\\').append(ch);
                        break;
                    }
                }
                fEsc = false;
            } else {
                switch (ch) {
                    case '\"': 
                    case '\'': {
                        if (fQuote) {
                            if (ch == chQuote) {
                                fQuote = false;
                                break;
                            }
                            sb.append(ch);
                            break;
                        }
                        fQuote = true;
                        chQuote = ch;
                        break;
                    }
                    case ' ': {
                        if (fQuote) {
                            sb.append(' ');
                            break;
                        }
                        if (!(sb.length() > 0)) break;
                        list.add(sb.toString());
                        sb.setLength(0);
                        break;
                    }
                    case '\\': {
                        fEsc = true;
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
            }
            ++ofCur;
        }
        if (fQuote) {
            throw new IllegalArgumentException(String.valueOf("Unmatched quote (") + chQuote + ") in command: " + sArguments);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public static long parseDate(String s) {
        if (s == null ? true : s.length() == 0) {
            return 0L;
        }
        String[] asParts = Base.parseDelimitedString((String)s, (char)'-');
        return Date.UTC(Integer.parseInt(asParts[0]) - 1900, Integer.parseInt(asParts[1]) - 1, Integer.parseInt(asParts[2]), 0, 0, 0);
    }

    public static int parseEditionName(String sEdition) {
        if (sEdition != null) {
            String[] asEdition = EDITION_NAMES;
            int i = 0;
            int c = asEdition.length;
            while (i < c) {
                if (sEdition.equals(asEdition[i])) {
                    return i;
                }
                ++i;
            }
        }
        Component._trace(String.valueOf("Unknown edition: ") + sEdition, 2);
        return 0;
    }

    public static int parseModeName(String sMode) {
        if (sMode != null) {
            String[] asMode = MODE_NAMES;
            int i = 0;
            int c = asMode.length;
            while (i < c) {
                if (sMode.equals(asMode[i])) {
                    return i;
                }
                ++i;
            }
        }
        Component._trace(String.valueOf("Unknown mode: ") + sMode, 2);
        return 1;
    }

    public static synchronized void prepareDtd(Service service) {
        if (Coherence.getCoherenceDtd() == null) {
            Coherence.setCoherenceDtd("");
            Coherence$DtdParser parser = new Coherence$DtdParser();
            parser.setService(service);
            parser.start();
        }
    }

    public static void printException(String sPrefix, Throwable e) {
        Object oPartial;
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (sPrefix == null) {
            Component._trace(e);
        } else {
            Component._trace(String.valueOf(sPrefix) + Component.getStackTrace(e), 1);
        }
        if (e instanceof RequestTimeoutException && (oPartial = ((RequestTimeoutException)e).getPartialResult()) != null) {
            Component._trace(String.valueOf("Partial result: ") + oPartial);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object processCommand(String sCmd) throws InterruptedException {
        String sFunction;
        int ofFunction;
        CacheService service = this.getService();
        NamedCache map = this.getMap();
        Object oResult = null;
        boolean fSilent = false;
        if (sCmd.charAt(0) == '@') {
            fSilent = true;
            sCmd = sCmd.substring(1);
        }
        if ((ofFunction = sCmd.indexOf(32)) < 0) {
            sFunction = sCmd;
            sCmd = "";
        } else {
            sFunction = sCmd.substring(0, ofFunction);
            sCmd = sCmd.substring(ofFunction + 1).trim();
        }
        if (sFunction.startsWith("#")) {
            String sIter = sFunction.substring(1);
            boolean fForce = false;
            if (sIter.startsWith("#")) {
                sIter = sIter.substring(1);
                fForce = true;
            }
            try {
                int cIter = Integer.parseInt(sIter);
                this.doRepeat(sCmd, cIter, fForce);
                return null;
            }
            catch (NumberFormatException e) {
                Component._trace(String.valueOf("invalid counter: ") + sIter);
            }
            return null;
        }
        String[] asParam = Coherence.parseArguments(sCmd);
        Object[] aoParam = this.convertArguments(asParam);
        int cParams = asParam.length;
        if (sFunction.startsWith("&")) {
            return this.doFunction(sFunction, aoParam, fSilent);
        }
        if (sFunction.equals("lock") ? true : sFunction.equals("unlock")) {
            if (!this.isMapValid()) return oResult;
            return this.doFunction(String.valueOf('&') + sFunction, aoParam, fSilent);
        }
        if (sFunction.equals("bye")) {
            Coherence.getCluster().shutdown();
            this.setStop(true);
            return oResult;
        }
        if (sFunction.equals("help")) {
            Component._trace("The commands are:");
            Component._trace("  aggregate ('{' <key> [, <key>]* '}' | '{filter:'<filter-name>'}' | '*') <aggregator-name> [<extractor>]");
            Component._trace("  assert <value>");
            Component._trace("  backup <path>");
            Component._trace("  batch <path>");
            Component._trace("  bulkput <# of iterations> <block size> <start key> [<batch size> | all]");
            Component._trace("  bulkremove <# of iterations> <start key> [all]");
            Component._trace("  bye");
            Component._trace("  cachefactory [<path>]");
            Component._trace("  cache <name>");
            Component._trace("  clear");
            Component._trace("  destroy");
            Component._trace("  get <key>");
            Component._trace("  hash");
            Component._trace("  help");
            Component._trace("  filter <name> <type> [(<accessor> <value>) | [<paramValue>]+]");
            Component._trace("  inc <key> [<increment>]");
            Component._trace("  invoke <command> [('all' | 'other' | 'senior' | <id>) [('async' | 'sync')]]");
            Component._trace("  index <accessor> [add | remove]");
            Component._trace("  jmx [(<port> | <url>) [('start' | 'stop')]]");
            Component._trace("  kill");
            Component._trace("  list [<map name> | <filter name> [<accessor> [asc | desc]]]");
            Component._trace("  listen [('start' | 'stop') [('cluster' | 'local' | 'members')]] [<filter> | <key>] [<lite>]");
            Component._trace("  lock <key>");
            Component._trace("  log (<size> | <message>) [<iterations> [<level>]]");
            Component._trace("  map [[('Optimistic' | 'Replicated' | 'Distributed') [! <service-name>] ':'] <name>");
            Component._trace("  maps");
            Component._trace("  memory");
            Component._trace("  process (<key> | '{' <key> [, <key>]* '}' | '{filter:'<filter-name>'}' | '*') <processor-name> [<paramValue>]+");
            Component._trace("  profile <command>");
            Component._trace("  put <key> <value>");
            Component._trace("  release");
            Component._trace("  remove <key>");
            Component._trace("  restore <path>");
            Component._trace("  runAs <name> <password> <command>");
            Component._trace("  service");
            Component._trace("  services");
            Component._trace("  size [<filter name>]");
            Component._trace("  sleep [interval]");
            Component._trace("  stats [cluster | service | p2p] [reset]");
            Component._trace("  unlock <key>");
            Component._trace("  waitkey <start key> <stop key>");
            Component._trace("  who | cluster");
            Component._trace("  whoami | service");
            Component._trace("  worker <command>");
            Component._trace("  #<repeat count> <command>");
            Component._trace("  &<functionName> [paramValue]*");
            return oResult;
        }
        if (sFunction.equals("aggregate")) {
            if (!this.isMapValid()) return oResult;
            this.doAggregate(aoParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("assert")) {
            String sResult;
            if (!(cParams >= 1)) return oResult;
            String sValue = String.valueOf(aoParam[0]);
            if (!(sValue.equals(sResult = String.valueOf(((ThreadLocal)this.get_Sink()).get())) ^ true)) return oResult;
            String sMsg = String.valueOf("Assertion failed: expected=\"") + sValue + "\"; actual=\"" + sResult + '\"';
            Component._trace(sMsg, 1);
            return new RuntimeException(sMsg);
        }
        if (sFunction.equals("backup")) {
            this.doBackup(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("batch")) {
            this.doBatch(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("bulkput")) {
            this.doBulkPut(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("bulkremove")) {
            this.doBulkRemove(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("cachefactory")) {
            this.doCacheFactory(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("cache")) {
            if (cParams > 0) {
                this.doCache(asParam, fSilent);
                return oResult;
            } else {
                Component._trace(String.valueOf(map));
            }
            return oResult;
        }
        if (sFunction.equals("clear")) {
            if (!this.isMapValid()) return oResult;
            map.clear();
            return oResult;
        }
        if (sFunction.equals("cluster") ? true : sFunction.equals("who")) {
            Component._trace(String.valueOf(Coherence.getCluster()));
            return oResult;
        }
        if (sFunction.equals("connector")) {
            this.doConnector(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("destroy")) {
            if (!this.isMapValid()) return oResult;
            map.destroy();
            return oResult;
        }
        if (sFunction.equals("filter")) {
            if (!this.isMapValid()) return oResult;
            this.doFilter(aoParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("get")) {
            if (!(!this.isMapValid() ? false : cParams >= 1)) return oResult;
            oResult = map.get(aoParam[0]);
            ((ThreadLocal)this.get_Sink()).set(oResult);
            if (!(fSilent ^ true)) return oResult;
            Component._trace(Coherence.toString(oResult));
            return oResult;
        }
        if (sFunction.equals("hash")) {
            if (this.isMapValid() ^ true) {
                return null;
            }
            int iHash = 0;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                Object v = map.get(oKey);
                if (v instanceof byte[]) {
                    byte[] ab = (byte[])v;
                    int i = 0;
                    int c = ab.length;
                    while (i < c) {
                        iHash += ab[i];
                        ++i;
                    }
                    continue;
                }
                if (!(v != null)) continue;
                iHash += v.hashCode();
            }
            Component._trace(String.valueOf("hash=") + iHash);
            return oResult;
        }
        if (sFunction.equals("inc")) {
            String sVal;
            boolean fLock;
            if (this.isMapValid() ^ true) {
                return null;
            }
            Object oKey = aoParam[0];
            int cInc = 1;
            try {
                cInc = Integer.parseInt(asParam[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = fLock = cParams <= 2 ? true : asParam[2].startsWith("o") ^ true;
            if (fLock) {
                map.lock(oKey, (long)-1);
            }
            try {
                void var14_69;
                Object v = map.get(oKey);
                String string = sVal = fSilent ? null : String.valueOf(v);
                if (v instanceof Versionable) {
                    Versionable ver = (Versionable)v;
                    int i = 0;
                    while (i < cInc) {
                        ver.incrementVersion();
                        ++i;
                    }
                } else {
                    int nVal = 0;
                    try {
                        nVal = Integer.parseInt(String.valueOf(v));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Integer n = new Integer(nVal + cInc);
                }
                map.put(oKey, var14_69);
                if (fSilent ^ true) {
                    Component._trace(String.valueOf("incremented ") + oKey + " from " + sVal + " to " + var14_69);
                }
                ((ThreadLocal)this.get_Sink()).set(var14_69);
                return oResult;
            }
            finally {
                sVal = null;
                if (fLock) {
                    map.unlock(oKey);
                }
            }
        }
        if (sFunction.equals("index")) {
            if (this.isMapValid() ^ true) {
                return null;
            }
            this.doIndex(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("iterate")) {
            int cItems = 0;
            Iterator iter = (Iterator)((ThreadLocal)this.get_Sink()).get();
            while (iter.hasNext()) {
                Object oNext = iter.next();
                ++cItems;
            }
            if (!(fSilent ^ true)) return oResult;
            Component._trace(String.valueOf(cItems) + " items");
            return oResult;
        }
        if (sFunction.startsWith("invoke")) {
            int ofName = sFunction.indexOf(58);
            String sName = ofName < 0 ? "InvocationService" : sFunction.substring(ofName + 1);
            this.doInvoke(sName, asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("jmx")) {
            this.doJmx(asParam);
            return oResult;
        }
        if (sFunction.equals("kill")) {
            if (!(cParams > 0) ? false : asParam[0].equals("all")) {
                Coherence.getCluster().shutdown();
                Coherence.setCluster(null);
            } else if (service == null) {
                Coherence.getCluster().shutdown();
            } else {
                service.shutdown();
            }
            this.setService(null);
            this.setMap(null);
            this.getLogger().setPrompt("?");
            return oResult;
        }
        if (sFunction.equals("list")) {
            if (!this.isMapValid()) return oResult;
            this.doList(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("listen")) {
            void var14_73;
            Filter filter;
            boolean fStop = !(cParams >= 1) ? false : asParam[0].equals("stop");
            String sSource = cParams >= 2 ? asParam[1] : "cluster";
            Object oKey = null;
            Object var14_71 = null;
            boolean fLite = false;
            if (cParams >= 3 && (filter = (Filter)this.getFilters().get(asParam[2])) == null) {
                oKey = aoParam[2];
            }
            if (cParams >= 4) {
                fLite = asParam[3].equals("lite");
            }
            this.doListen(sSource, fStop, (Filter)var14_73, oKey, fLite);
            return oResult;
        }
        if (sFunction.equals("log")) {
            this.doLog(aoParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("map")) {
            if (cParams > 0) {
                this.doMap(asParam, fSilent);
                return oResult;
            } else {
                Component._trace(String.valueOf(map));
            }
            return oResult;
        }
        if (sFunction.equals("maps")) {
            Enumeration enumS = this.ensureCluster().getServiceNames();
            while (enumS.hasMoreElements()) {
                String sName = (String)enumS.nextElement();
                Service srv = Coherence.getCluster().getService(sName);
                if (!(!(srv instanceof CacheService) ? false : srv.isRunning())) continue;
                CacheService cacheService = (CacheService)srv;
                Enumeration enumC = cacheService.getCacheNames();
                while (enumC.hasMoreElements()) {
                    Component._trace(String.valueOf(srv.getInfo().getServiceName()) + ":" + enumC.nextElement());
                }
            }
            return oResult;
        }
        if (sFunction.equals("memory")) {
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            long lTotal = rt.totalMemory();
            long l = rt.freeMemory();
            Component._trace(String.valueOf("total=") + lTotal / (long)1000 + "K (" + lTotal + ")");
            Component._trace(String.valueOf("free =") + l / (long)1000 + "K (" + l + ")");
            try {
                Long LMax = (Long)ClassHelper.invoke((Object)rt, (String)"maxMemory", (Object[])ClassHelper.VOID);
                Component._trace(String.valueOf("max  =") + LMax / (long)1000 + "K (" + LMax + ")");
                return new Long(l);
            }
            catch (Throwable e) {
                // empty catch block
            }
            return new Long(l);
        }
        if (sFunction.equals("new")) {
            if (cParams > 0) {
                try {
                    String sClass = asParam[0];
                    if (sClass.startsWith("Component")) {
                        oResult = Component._newInstance(sClass);
                    } else {
                        Class<?> clz = Class.forName(sClass);
                        if (cParams > 1) {
                            Object[] ao = new Object[cParams - 1];
                            System.arraycopy(aoParam, 1, ao, 0, cParams - 1);
                            oResult = ClassHelper.newInstance(clz, (Object[])ao);
                        } else {
                            oResult = clz.newInstance();
                        }
                    }
                }
                catch (Exception e) {
                    Coherence.printException(null, e);
                }
            }
            if (fSilent ^ true) {
                Component._trace(Coherence.toString(oResult));
            }
            ((ThreadLocal)this.get_Sink()).set(oResult);
            return oResult;
        }
        if (sFunction.equals("process")) {
            if (!this.isMapValid()) return oResult;
            this.doProcess(aoParam, fSilent);
            return oResult;
        }
        if (sFunction.equals("profile")) {
            long lBegin = Base.getSafeTimeMillis();
            this.processCommand(sCmd);
            long lElapsed = Base.getSafeTimeMillis() - lBegin;
            Component._trace(String.valueOf("Elapsed ") + lElapsed + "ms");
            return oResult;
        }
        if (sFunction.equals("put")) {
            if (!(!this.isMapValid() ? false : cParams >= 2)) return oResult;
            oResult = map.put(aoParam[0], aoParam[1]);
            if (!(fSilent ^ true)) return oResult;
            Component._trace(Coherence.toString(oResult));
            return oResult;
        }
        if (sFunction.equals("release")) {
            if (!this.isMapValid()) return oResult;
            map.release();
            return oResult;
        }
        if (sFunction.equals("remove")) {
            if (!(!this.isMapValid() ? false : cParams >= 1)) return oResult;
            oResult = map.remove(aoParam[0]);
            ((ThreadLocal)this.get_Sink()).set(oResult);
            if (!(fSilent ^ true)) return oResult;
            Component._trace(Coherence.toString(oResult));
            return oResult;
        }
        if (sFunction.equals("restore")) {
            this.doRestore(asParam, fSilent);
            return oResult;
        }
        if (sFunction.equalsIgnoreCase("runAs")) {
            return this.doSecure(asParam, fSilent);
        }
        if (sFunction.equals("scan")) {
            if (!this.isMapValid()) return oResult;
            this.doScan(asParam);
            return oResult;
        }
        if (sFunction.equals("service") ? true : sFunction.equals("whoami")) {
            if (service == null) {
                this.processCommand("who");
                return oResult;
            } else {
                Component._trace(String.valueOf(service));
                Component._trace(String.valueOf(service.getInfo().getServiceMembers()));
            }
            return oResult;
        }
        if (sFunction.equals("services")) {
            Enumeration enumeration = this.ensureCluster().getServiceNames();
            while (enumeration.hasMoreElements()) {
                String sName = (String)enumeration.nextElement();
                ServiceInfo info = Coherence.getCluster().getServiceInfo(sName);
                if (!(info != null)) continue;
                Component._trace(info.toString());
            }
            return oResult;
        }
        if (sFunction.equals("sleep")) {
            long lMillis = 1L;
            try {
                lMillis = Long.parseLong(asParam[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Object oKey = null;
            if (cParams > 1) {
                if (this.isMapValid() ^ true) {
                    return null;
                }
                oKey = aoParam[1];
            }
            try {
                try {
                    long lStop;
                    long l = Base.getSafeTimeMillis();
                    if (oKey != null) {
                        map.lock(oKey, -1L);
                    }
                    if (lMillis > (long)0) {
                        Thread.sleep(lMillis);
                        lStop = Base.getSafeTimeMillis();
                    } else {
                        do {
                            int i = 0;
                            while (i < 100) {
                                ++i;
                            }
                            Thread.yield();
                        } while ((lStop = Base.getSafeTimeMillis()) < l - lMillis);
                    }
                    if (fSilent ^ true) {
                        Component._trace(String.valueOf("Elapsed ") + (lStop - l) + "ms");
                    }
                }
                catch (InterruptedException interruptedException) {
                    Component._trace("Sleep was interrupted; re-setting the interrupt flag...", 3);
                    Thread.currentThread().interrupt();
                }
                Object enumC = null;
                if (!(oKey != null)) return oResult;
            }
            catch (Throwable throwable) {
                Object enumC = null;
                if (!(oKey != null)) throw throwable;
                map.unlock(oKey);
                throw throwable;
            }
            map.unlock(oKey);
            return oResult;
        }
        if (sFunction.equals("size")) {
            Set setEntry;
            if (this.isMapValid() ^ true) {
                return null;
            }
            if (cParams > 0) {
                String sName = asParam[0];
                if (this.getFilters().containsKey(sName)) {
                    int nPage = -1;
                    if (cParams > 1) {
                        nPage = Integer.parseInt(asParam[1]);
                    }
                    setEntry = this.applyFilter(sName, true, null, nPage);
                } else {
                    map = this.getService().ensureCache(sName, null);
                    setEntry = map.entrySet();
                }
            } else {
                setEntry = map.entrySet();
            }
            int cSize = setEntry.size();
            if (fSilent ^ true) {
                Component._trace(String.valueOf(cSize));
            }
            ((ThreadLocal)this.get_Sink()).set(setEntry);
            return oResult;
        }
        if (sFunction.equals("stats")) {
            String sSilent;
            void var14_82;
            boolean fCluster = true;
            boolean fP2p = false;
            boolean fReset = false;
            int n = 0;
            if (!(cParams > n) ? false : asParam[n].equals("service")) {
                void var14_80;
                fCluster = false;
                ++var14_80;
            } else if (!(cParams > n) ? false : asParam[n].equals("p2p")) {
                void var14_81;
                fCluster = false;
                fP2p = true;
                ++var14_81;
            }
            if (!(cParams > var14_82) ? false : asParam[var14_82].equals("reset")) {
                fReset = true;
            }
            String string = sSilent = fSilent ? "@" : "";
            if (fCluster) {
                String sTarget = this.getMap() == null ? "&" : "&getCacheService.getService.";
                if (!fReset) return this.processCommand(String.valueOf(sSilent) + sTarget + "getCluster.formatStats");
                this.processCommand(String.valueOf('@') + sTarget + "getCluster.resetStats");
                return this.processCommand(String.valueOf(sSilent) + sTarget + "getCluster.formatStats");
            }
            if (fP2p) {
                String sTarget = this.getMap() == null ? "&" : "&getCacheService.getService.";
                if (!fReset) return this.processCommand(String.valueOf(sSilent) + sTarget + "getCluster.formatPointToPointStats");
                this.processCommand(String.valueOf('@') + sTarget + "getCluster.resetPointToPointStats");
                return this.processCommand(String.valueOf(sSilent) + sTarget + "getCluster.formatPointToPointStats");
            }
            if (!this.isMapValid()) return oResult;
            if (!fReset) return this.processCommand(String.valueOf(sSilent) + "&getCacheService.getService.formatStats");
            this.processCommand("@&getCacheService.getService.resetStats");
            return this.processCommand(String.valueOf(sSilent) + "&getCacheService.getService.formatStats");
        }
        if (sFunction.equals("sum")) {
            void var14_84;
            if (this.isMapValid() ^ true) {
                return null;
            }
            long cSum = 0;
            int cNums = 0;
            boolean bl = false;
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                Object oVal = iter.next();
                if (oVal instanceof Number) {
                    ++cNums;
                    cSum += ((Number)oVal).longValue();
                    continue;
                }
                if (oVal instanceof Versionable) {
                    Comparable oVer = ((Versionable)oVal).getVersionIndicator();
                    if (oVer instanceof Number) {
                        ++cNums;
                        cSum += ((Number)((Object)oVer)).longValue();
                        continue;
                    }
                    ++var14_84;
                    continue;
                }
                ++var14_84;
            }
            if (fSilent ^ true) {
                Component._trace(String.valueOf("sum=") + cSum + " (" + cNums + " values were numbers, " + (int)var14_84 + " were not)");
            }
            oResult = new Long(cSum);
            ((ThreadLocal)this.get_Sink()).set(oResult);
            return oResult;
        }
        if (sFunction.equals("waitkey")) {
            if (this.isMapValid() ^ true) {
                return null;
            }
            Object oKeyStart = aoParam[0];
            Object oKeyStop = aoParam[1];
            Component._trace(String.valueOf("waiting for key: ") + oKeyStart);
            while (map.containsKey(oKeyStart) ^ true) {
                Thread.currentThread();
                Thread.sleep(10);
            }
            Component._trace(String.valueOf("waiting for key: ") + oKeyStop);
            long lBegin = Base.getSafeTimeMillis();
            while (map.containsKey(oKeyStop) ^ true) {
                Thread.currentThread();
                Thread.sleep(10);
            }
            long lElapsed = Base.getSafeTimeMillis() - lBegin;
            Component._trace(String.valueOf(new Date()) + ": done (" + lElapsed + "ms)");
            return oResult;
        }
        if (sFunction.equals("worker")) {
            String sName = null;
            Object worker = null;
            try {
                sName = String.valueOf("Worker!") + Integer.parseInt(asParam[0]);
                worker = (Coherence$Worker)this._findChild(sName);
                if (worker == null) {
                    Component._trace(String.valueOf(sName) + " has been terminated.");
                    return null;
                }
                if (fSilent ^ true) {
                    Component._trace(((Coherence$Worker)worker).toString());
                }
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (worker == null) {
                void var14_86;
                boolean fWait = !(cParams == 1) ? false : asParam[0].equals("wait");
                boolean bl = false;
                while (var14_86 < 1000) {
                    sName = String.valueOf("Worker!") + (int)var14_86;
                    worker = (Coherence$Worker)this._findChild(sName);
                    if (worker == null) {
                        if (!(cParams > 0) ? false : fWait ^ true) {
                            break;
                        }
                    } else if (fWait) {
                        ((Daemon)worker).getThread().join();
                    } else if (cParams == 0) {
                        Component._trace(((Coherence$Worker)worker).toString());
                    }
                    ++var14_86;
                }
                if (!(fWait ^ true) ? false : cParams > 0) {
                    worker = new Coherence$Worker();
                    this._addChild((Component)worker, sName);
                    ((Daemon)worker).setThreadName(sName);
                    ((QueueProcessor)worker).getQueue().add(sCmd);
                    ((Coherence$Worker)worker).start();
                }
            }
            ((ThreadLocal)this.get_Sink()).set(worker == null ? (Object)Coherence$Worker.getWorkerGroup() : worker);
            return oResult;
        }
        if ((sFunction.equals("begin") ? true : sFunction.equals("commit")) ? true : sFunction.equals("rollback")) {
            if (!this.isMapValid()) return oResult;
            this.doTransaction(sFunction, asParam);
            return oResult;
        } else {
            Component._trace(String.valueOf("Unknown command: \"") + sFunction + '\"' + "\nPrint \"help\" for command list");
        }
        return oResult;
    }

    public static Object processFunction(Object target, String sFunction, boolean fSilent, Object[] aoParam) {
        boolean fLast = false;
        try {
            do {
                String sMethod = sFunction;
                int ofNext = sFunction.indexOf(46);
                if (ofNext == -1) {
                    ofNext = sFunction.length();
                    fLast = true;
                } else {
                    sMethod = sFunction.substring(0, ofNext);
                    sFunction = sFunction.substring(ofNext + 1);
                }
                int nIx = -1;
                int ofIx = sMethod.indexOf(91);
                if (ofIx != -1) {
                    nIx = Integer.parseInt(sMethod.substring(ofIx + 1, sMethod.indexOf(93)));
                    sMethod = sMethod.substring(0, ofIx);
                }
                if (sMethod.endsWith("lock") && (!(aoParam.length > 0) ? false : "*".equals(aoParam[0]))) {
                    aoParam[0] = ConcurrentMap.LOCK_ALL;
                }
                boolean fTryStatic = target instanceof Class;
                boolean fTryInstance = fTryStatic ^ true;
                if (fTryStatic) {
                    try {
                        target = ClassHelper.invokeStatic((Class)((Class)target), (String)sMethod, (Object[])(fLast ? aoParam : ClassHelper.VOID));
                    }
                    catch (NoSuchMethodException e) {
                        fTryInstance = true;
                    }
                }
                if (fTryInstance) {
                    target = ClassHelper.invoke((Object)target, (String)sMethod, (Object[])(fLast ? aoParam : ClassHelper.VOID));
                }
                if (nIx >= 0) {
                    target = Array.get(target, nIx);
                }
                if (fLast) {
                    if (!(fSilent ^ true)) continue;
                    Component._trace(Coherence.toString(target));
                    continue;
                }
                if (!(target == null)) continue;
                if (!(fSilent ^ true)) break;
                Component._trace(String.valueOf("Exception: ") + sMethod + " returned null");
                break;
            } while (fLast ^ true);
        }
        catch (Throwable e) {
            target = e;
            Coherence.printException(null, e);
        }
        return target;
    }

    protected static void replaceSystemProperties(XmlElement xml) {
        XmlHelper.replaceSystemProperties((XmlElement)xml, (String)"system-property");
    }

    protected static String resolveEdition(XmlElement xmlLicense) {
        String sDescription;
        String sLicenseFile;
        String sEdition = xmlLicense.getSafeElement("edition-name").getString(DEFAULT_EDITION);
        int nEdition = 0;
        if ((sEdition.equalsIgnoreCase("ge") ? true : sEdition.equalsIgnoreCase("grid")) ? true : sEdition.equalsIgnoreCase("dge")) {
            sLicenseFile = "coherence-grid.xml";
            sEdition = DEFAULT_EDITION;
            sDescription = "Grid Edition";
            nEdition = 5;
        } else if ((sEdition.equalsIgnoreCase("ee") ? true : sEdition.equalsIgnoreCase("enterprise")) ? true : sEdition.equalsIgnoreCase("ae")) {
            sLicenseFile = "coherence-enterprise.xml";
            sEdition = "EE";
            sDescription = "Enterprise Edition";
            nEdition = 4;
        } else if ((sEdition.equalsIgnoreCase("se") ? true : sEdition.equalsIgnoreCase("standard")) ? true : sEdition.equalsIgnoreCase("ce")) {
            sLicenseFile = "coherence-standard.xml";
            sEdition = "SE";
            sDescription = "Standard Edition";
            nEdition = 3;
        } else if (((sEdition.equalsIgnoreCase("rtc") ? true : sEdition.equalsIgnoreCase("realtime")) ? true : sEdition.equalsIgnoreCase("cc")) ? true : sEdition.equalsIgnoreCase("compute")) {
            sLicenseFile = "coherence-rtc.xml";
            sEdition = "RTC";
            sDescription = "Real-Time Client";
            nEdition = 1;
        } else if (sEdition.equalsIgnoreCase("dc") ? true : sEdition.equalsIgnoreCase("client")) {
            sLicenseFile = "coherence-client.xml";
            sEdition = "DC";
            sDescription = "Data Client";
            nEdition = 0;
        } else {
            String sErrorMsg = String.valueOf("Invalid \"edition-name\" specified: \"") + sEdition + "\" (valid editions are GE/EE/SE/RTC/DC)";
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        Coherence.loadLicenses(xmlLicense, sLicenseFile);
        LicensedObject.LicenseData[] aLicense = LicensedObject.getLicenseData();
        Component._assert(aLicense != null);
        Coherence app = (Coherence)Coherence.get_Instance();
        app.setEdition(nEdition);
        app.setProduct(String.valueOf(TITLE) + ' ' + sEdition);
        xmlLicense.ensureElement("edition-name").setString(sEdition);
        return sDescription;
    }

    protected static String resolveMode(XmlElement xmlLicense) {
        String sDescription;
        int nMode = 0;
        String sMode = xmlLicense.getSafeElement("license-mode").getString(DEFAULT_MODE);
        switch (sMode.length() > 0 ? (int)sMode.charAt(0) : 63) {
            case 69: 
            case 101: {
                nMode = 0;
                sDescription = "Evaluation";
                break;
            }
            case 68: 
            case 100: {
                nMode = 1;
                sDescription = "Development";
                break;
            }
            case 80: 
            case 112: {
                nMode = 2;
                sDescription = "Production";
                break;
            }
            default: {
                String sErrorMsg = String.valueOf("Invalid \"mode\" specified: \"") + sMode + "\" (valid modes are eval/dev/prod)";
                Component._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
        }
        sMode = MODE_NAMES[nMode];
        ((Coherence)Coherence.get_Instance()).setMode(nMode);
        xmlLicense.ensureElement("license-mode").setString(sMode);
        return sDescription;
    }

    public void run() {
        super.run();
        String sCmd = "";
        String[] asArg = Application.getArgument();
        if (asArg.length > 0) {
            sCmd = asArg[0].startsWith("@") ? asArg[0].substring(1) : String.valueOf("cache ") + asArg[0];
            int i = 1;
            int c = asArg.length;
            while (i < c) {
                sCmd = String.valueOf(sCmd) + (String.valueOf(' ') + asArg[i]);
                ++i;
            }
            Coherence.getCluster();
        } else {
            Component._trace(this.ensureCluster().toString());
        }
        InputStreamReader reader = new InputStreamReader(System.in);
        Coherence$Logger logger = this.ensureLogger();
        logger.setPrompt("?");
        while (true) {
            if (sCmd.length() > 0) {
                try {
                    this.processCommand(sCmd);
                }
                catch (Throwable e) {
                    Coherence.printException(null, e);
                }
            }
            if (this.isStop()) {
                return;
            }
            try {
                Thread.currentThread();
                Thread.sleep(50);
                logger.setCommandPrompt(true);
                char[] ach = new char[256];
                int cch = reader.read(ach);
                logger.setCommandPrompt(false);
                logger.setPendingLineFeed(false);
                sCmd = cch <= 2 ? "" : new String(ach).trim();
                continue;
            }
            catch (Exception e) {
                reader = new InputStreamReader(System.in);
                sCmd = "";
                continue;
            }
            break;
        }
    }

    public static void setCluster(Cluster cluster) {
        if (cluster == null) {
            Map mapConfig;
            Map map = mapConfig = Coherence.getServiceConfigMap();
            synchronized (map) {
                mapConfig.clear();
            }
            ((Coherence)Coherence.get_Instance()).getLogger().shutdown();
        }
        __s_Cluster = cluster;
    }

    public static void setCoherenceDtd(String xml) {
        __s_CoherenceDtd = xml;
    }

    protected static void setCoherenceUrl(String sUrl) {
        __s_CoherenceUrl = sUrl;
    }

    private void setEdition(int nEdition) {
        this.__m_Edition = nEdition;
    }

    protected void setFilters(Map map) {
        this.__m_Filters = map;
    }

    private static void setLicenseLoaded(boolean fLoaded) {
        if (fLoaded) {
            __s_LicenseLoaded = fLoaded;
        }
    }

    protected void setLogParameters(Object[] ao) {
        this.__m_LogParameters = ao;
    }

    protected void setMap(NamedCache map) {
        this.__m_Map = map;
    }

    private void setMode(int nMode) {
        this.__m_Mode = nMode;
    }

    protected void setProduct(String sProduct) {
        Component._assert(this.getProduct() == null ? true : this.getProduct().equals(sProduct));
        this.__m_Product = sProduct;
        this.setLogParameters(null);
    }

    protected void setService(CacheService service) {
        this.__m_Service = service;
    }

    protected static void setServiceConfigMap(Map map) {
        __s_ServiceConfigMap = map;
    }

    protected void setStop(boolean fStop) {
        this.__m_Stop = fStop;
    }

    public static String toString(Object oResult) {
        int MAX_TRACE = 50;
        String BEGIN = " {\n ";
        String NEXT = "\n ";
        String END = "\n }";
        Class<?> clzArrayType = oResult == null ? null : oResult.getClass().getComponentType();
        if (clzArrayType == null) {
            if (oResult instanceof Iterator) {
                StringBuffer sb = new StringBuffer();
                sb.append(oResult.getClass().getName());
                Iterator iter = (Iterator)oResult;
                if (iter.hasNext()) {
                    sb.append(BEGIN);
                    int i = 0;
                    while (!iter.hasNext() ? false : i < MAX_TRACE) {
                        sb.append(Coherence.toString(iter.next()));
                        if (iter.hasNext()) {
                            sb.append(NEXT);
                        }
                        ++i;
                    }
                    if (iter.hasNext()) {
                        sb.append("...");
                    }
                    sb.append(END);
                }
                return sb.toString();
            }
            if (oResult instanceof Enumeration) {
                StringBuffer sb = new StringBuffer();
                sb.append(oResult.getClass().getName()).append(BEGIN);
                Enumeration enumeration = (Enumeration)oResult;
                int i = 0;
                while (!enumeration.hasMoreElements() ? false : i < MAX_TRACE) {
                    sb.append(Coherence.toString(enumeration.nextElement()));
                    if (enumeration.hasMoreElements()) {
                        sb.append(NEXT);
                    }
                    ++i;
                }
                if (enumeration.hasMoreElements()) {
                    sb.append("...");
                }
                sb.append(END);
                return sb.toString();
            }
            if (oResult instanceof Class) {
                return Base.toString((Class)((Class)oResult));
            }
            return String.valueOf(oResult);
        }
        int c = Array.getLength(oResult);
        StringBuffer sb = new StringBuffer();
        sb.append(clzArrayType.getName()).append('[').append(c).append(']');
        if (c > 0) {
            sb.append(BEGIN);
            int cTrace = Math.min(c, MAX_TRACE);
            int i = 0;
            while (i < cTrace) {
                if (i > 0) {
                    sb.append(NEXT);
                }
                sb.append(Coherence.toString(Array.get(oResult, i)));
                ++i;
            }
            if (c > cTrace) {
                sb.append(", ...");
            }
            sb.append(END);
        }
        return sb.toString();
    }

    protected void txEnd() {
        NamedCache map = this.getMap();
        if (map instanceof TransactionMap) {
            NamedCache cache = (NamedCache)((TransactionMap)map).getBaseMap();
            this.setMap(cache);
            Coherence$Logger logger = this.getLogger();
            logger.setPrompt(logger.getPrompt().substring(3));
        }
    }

    protected void txStart(int nConcur, int nIsolation, int nTimeout) {
        TransactionMap mapTx;
        NamedCache map = this.getMap();
        if (map instanceof TransactionMap) {
            mapTx = (TransactionMap)map;
        } else {
            mapTx = this.getClass().getName().startsWith("_package") ? Coherence.getLocalTransaction(map) : CacheFactory.getLocalTransaction((NamedCache)map);
            mapTx.setConcurrency(nConcur);
            mapTx.setTransactionIsolation(nIsolation);
            mapTx.setTransactionTimeout(nTimeout);
            mapTx.setValidator((TransactionMap.Validator)new SimpleValidator());
            this.setMap((NamedCache)mapTx);
            Coherence$Logger logger = this.getLogger();
            logger.setPrompt(String.valueOf("Tx-") + logger.getPrompt());
        }
        mapTx.begin();
    }
}

