/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Channel$MessageAction;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.RequestStatus;
import com.tangosol.coherence.component.comm.messageFactory.MessagingFactory$ChannelCloseMessage;
import com.tangosol.coherence.component.comm.messageFactory.MessagingFactory$DisconnectMessage;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.messaging.Response;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;

public class Channel
extends Comm
implements PofContext,
PofSerializer,
com.tangosol.net.messaging.Channel {
    private Map __m_AttributeMap;
    private volatile com.tangosol.net.messaging.Connection __m_Connection;
    private int __m_Id;
    private Protocol.MessageFactory __m_MessageFactory;
    private volatile boolean __m_Open;
    private Channel.Receiver __m_Receiver;
    private LongArray __m_RequestArray;
    private long __m_RequestTimeout;
    private Serializer __m_Serializer;
    private Subject __m_Subject;
    private ThreadGate __m_ThreadGate;
    private static ListMap __mapChildren;
    private static boolean __s_Debug;

    static {
        Channel._initStatic();
    }

    public Channel() {
        this(null, null, true);
    }

    public Channel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"MessageAction", (Object)Channel$MessageAction.get_CLASS());
    }

    private static void _initStatic$Default() {
        Channel.__initStatic();
    }

    protected static void _initStatic() {
        Channel._initStatic$Default();
        Channel.setDebug(Boolean.getBoolean("tangosol.coherence.messaging.debug"));
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean fNotify) {
        Connection connection;
        ThreadGate gate;
        block6: {
            gate = this.getThreadGate();
            Component._assert(gate.isActiveThread() ^ true);
            gate.close(-1L);
            try {
                if (this.isOpen()) {
                    try {
                        this.doClose(fNotify);
                    }
                    catch (Throwable t) {
                        Component._trace(t, String.valueOf("An error occured while closing a channel") + "; the channel will be marked as closed");
                    }
                    this.setOpen(false);
                    connection = (Connection)this.getConnection();
                    this.setConnection(null);
                    break block6;
                }
                connection = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                gate.open();
                throw throwable;
            }
        }
        Object var5_6 = null;
        gate.open();
        if (connection != null) {
            connection.onChannelClosed(this, fNotify);
        }
    }

    public Message createMessage(int nType) {
        return this.getMessageFactory().createMessage(nType);
    }

    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        PofBufferReader reader = new PofBufferReader(in, (PofContext)this);
        return reader.readObject(-1);
    }

    public Object deserialize(PofReader in) throws IOException {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofSerializer) {
            return ((PofSerializer)serializer).deserialize(in);
        }
        Binary bin = in.readBinary(0);
        in.readRemainder();
        return serializer.deserialize(bin.getBufferInput());
    }

    protected void doClose(boolean fNotify) {
        LongArray laStatus;
        LongArray longArray = laStatus = this.getRequestArray();
        synchronized (longArray) {
            LongArray.Iterator iter = laStatus.iterator();
            while (iter.hasNext()) {
                Request.Status status = (Request.Status)iter.next();
                iter.remove();
                status.cancel();
            }
        }
        Channel.Receiver receiver = this.getReceiver();
        if (receiver != null) {
            receiver.unregisterChannel((com.tangosol.net.messaging.Channel)this);
        }
        this.setSerializer(null);
    }

    protected void doOpen() {
        Component._assert(this.getConnection() != null);
        Component._assert(this.getMessageFactory() != null);
        Component._assert(this.getSerializer() != null);
        Channel.Receiver receiver = this.getReceiver();
        if (receiver != null) {
            receiver.registerChannel((com.tangosol.net.messaging.Channel)this);
        }
    }

    protected void doSend(Message message) {
        Component._assert(message != null);
        message.setChannel((com.tangosol.net.messaging.Channel)this);
        ((Connection)this.getConnection()).send(message);
        if (!Channel.isDebug() ? false : Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Sent: ") + message, 6);
        }
    }

    public Object getAttribute(String sName) {
        return this.getAttributeMap().get(sName);
    }

    protected Map getAttributeMap() {
        return this.__m_AttributeMap;
    }

    public Map getAttributes() {
        Map map;
        Map map2 = map = this.getAttributeMap();
        synchronized (map2) {
            HashMap hashMap = new HashMap(map);
            Object var4_4 = null;
            return hashMap;
        }
    }

    public Class getClass(int nTypeId) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getClass(nTypeId);
        }
        throw new IllegalStateException(String.valueOf("cannot determine class for user type ID: ") + nTypeId);
    }

    public String getClassName(int nTypeId) {
        return this.getClass(nTypeId).getName();
    }

    public com.tangosol.net.messaging.Connection getConnection() {
        return this.__m_Connection;
    }

    public ClassLoader getContextClassLoader() {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof ClassLoaderAware) {
            return ((ClassLoaderAware)serializer).getContextClassLoader();
        }
        return null;
    }

    protected String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Id=").append(this.getId());
        boolean fOpen = this.isOpen();
        if (fOpen) {
            com.tangosol.net.messaging.Connection connection = this.getConnection();
            sb.append(", Connection=").append(connection == null ? "null" : String.valueOf(connection.getId()));
        }
        sb.append(", Open=").append(fOpen);
        return sb.toString();
    }

    public int getId() {
        return this.__m_Id;
    }

    public Protocol.MessageFactory getMessageFactory() {
        return this.__m_MessageFactory;
    }

    public PofSerializer getPofSerializer(int nTypeId) {
        String sTarget;
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getPofSerializer(nTypeId);
        }
        if (nTypeId == 0) {
            return this;
        }
        try {
            sTarget = this.getConnection().getConnectionManager().toString();
        }
        catch (RuntimeException e) {
            sTarget = this.toString();
        }
        throw new IllegalStateException(String.valueOf(sTarget) + " has not been configured with a PofContext; " + " this channel cannot decode POF-encoded user types");
    }

    public Channel.Receiver getReceiver() {
        return this.__m_Receiver;
    }

    protected LongArray getRequestArray() {
        return this.__m_RequestArray;
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    public Subject getSubject() {
        return this.__m_Subject;
    }

    public ThreadGate getThreadGate() {
        return this.__m_ThreadGate;
    }

    public int getUserTypeIdentifier(Class clz) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(clz);
        }
        Component._assert(clz != null);
        return 0;
    }

    public int getUserTypeIdentifier(Object o) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(o);
        }
        Component._assert(o != null);
        return 0;
    }

    public int getUserTypeIdentifier(String sClass) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(sClass);
        }
        Component._assert(sClass != null);
        return 0;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/Channel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Channel();
    }

    private final Component get_Module() {
        return this;
    }

    public static boolean isDebug() {
        return __s_Debug;
    }

    public boolean isOpen() {
        return this.__m_Open;
    }

    public boolean isUserType(Class clz) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(clz);
        }
        Component._assert(clz != null);
        return false;
    }

    public boolean isUserType(Object o) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(o);
        }
        Component._assert(o != null);
        return false;
    }

    public boolean isUserType(String sClass) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(sClass);
        }
        Component._assert(sClass != null);
        return false;
    }

    public void onInit() {
        this.setAttributeMap((Map)new SafeHashMap());
        this.setRequestArray((LongArray)new SparseArray());
        this.setThreadGate(new ThreadGate());
        super.onInit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onReceive(Message message) {
        Object var8_9;
        ThreadGate gateOuter;
        Throwable tReceive;
        Connection connection;
        block29: {
            Object var8_8;
            block28: {
                boolean bl;
                block25: {
                    ThreadGate gateInner;
                    Component._assert(message != null);
                    Component._assert(message.getChannel() == this);
                    connection = (Connection)this.getConnection();
                    if (connection == null) return;
                    boolean bl2 = false;
                    if (bl2) {
                        return;
                    }
                    tReceive = null;
                    int nTypeId = message.getTypeId();
                    if (!(this.getId() == 0) ? false : (nTypeId == MessagingFactory$ChannelCloseMessage.TYPE_ID ? true : nTypeId == MessagingFactory$DisconnectMessage.TYPE_ID)) {
                        gateInner = null;
                        gateOuter = null;
                    } else {
                        gateInner = this.getThreadGate();
                        gateOuter = connection.getThreadGate();
                    }
                    if (gateOuter != null && gateOuter.enter(0L) ^ true) {
                        return;
                    }
                    try {
                        try {
                            block27: {
                                boolean bl3;
                                block26: {
                                    if (gateInner != null && gateInner.enter(0L) ^ true) {
                                        Object var8_7 = null;
                                        bl = gateOuter != null;
                                        break block25;
                                    }
                                    try {
                                        if (this.isOpen() ^ true) {
                                            var8_8 = null;
                                            bl3 = gateInner != null;
                                            break block26;
                                        }
                                        if (!Channel.isDebug() ? false : Component._isTraceEnabled(6)) {
                                            Component._trace(String.valueOf("Received: ") + message, 6);
                                        }
                                        if (message instanceof Response) {
                                            RequestStatus status;
                                            Response response = (Response)message;
                                            LongArray laStatus = this.getRequestArray();
                                            long lId = response.getRequestId();
                                            LongArray longArray = laStatus;
                                            synchronized (longArray) {
                                                status = (RequestStatus)laStatus.get(lId);
                                            }
                                            if (!(status != null)) break block27;
                                            status.setResponse(response);
                                            break block27;
                                        }
                                        Channel.Receiver receiver = this.getReceiver();
                                        Subject subject = this.getSubject();
                                        if (subject == null) {
                                            if (receiver == null) {
                                                message.run();
                                                break block27;
                                            } else {
                                                receiver.process(message);
                                            }
                                            break block27;
                                        }
                                        if (!Channel.isDebug() ? false : Component._isTraceEnabled(6)) {
                                            Component._trace("Calling Security.runAs()", 6);
                                        }
                                        Channel$MessageAction action = new Channel$MessageAction();
                                        action.setMessage(message);
                                        action.setReceiver(receiver);
                                        Subject.doAs(subject, action);
                                        break block27;
                                    }
                                    catch (Throwable receiver) {
                                        Object var8_10 = null;
                                        if (!(gateInner != null)) throw receiver;
                                        gateInner.exit();
                                        throw receiver;
                                    }
                                }
                                if (bl3) {
                                    gateInner.exit();
                                }
                                break block28;
                            }
                            var8_9 = null;
                            if (gateInner != null) {
                                gateInner.exit();
                            }
                            break block29;
                        }
                        catch (Throwable t) {
                            tReceive = t;
                        }
                        break block29;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        if (!(gateOuter != null)) throw throwable;
                        gateOuter.exit();
                        throw throwable;
                    }
                }
                if (!bl) return;
                gateOuter.exit();
                return;
            }
            var8_8 = null;
            if (!(gateOuter != null)) return;
            gateOuter.exit();
            return;
        }
        var8_9 = null;
        if (gateOuter != null) {
            gateOuter.exit();
        }
        if (!(tReceive != null)) return;
        if (tReceive instanceof ConnectionException) {
            connection.close(tReceive);
            return;
        }
        Component._trace(tReceive, String.valueOf("Caught an unhandled exception while processing a ") + ClassHelper.getSimpleName(message.getClass()));
    }

    public void onRequestCanceled(Request.Status status) {
        this.unregisterRequest(status);
    }

    public void onRequestCompleted(Request.Status status) {
        this.unregisterRequest(status);
    }

    public void open() {
        Connection connection;
        ThreadGate gate;
        block4: {
            gate = this.getThreadGate();
            Component._assert(gate.isActiveThread() ^ true);
            gate.close(-1L);
            try {
                if (this.isOpen()) {
                    connection = null;
                    break block4;
                }
                this.doOpen();
                this.setOpen(true);
                connection = (Connection)this.getConnection();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                gate.open();
                throw throwable;
            }
        }
        Object var4_3 = null;
        gate.open();
        if (connection != null) {
            connection.onChannelOpened(this);
        }
    }

    protected Request.Status registerRequest(Request request) {
        Component._assert(request != null);
        RequestStatus status = new RequestStatus();
        LongArray laStatus = this.getRequestArray();
        long lId = request.getId();
        status.setChannel(this);
        status.setRequest(request);
        LongArray longArray = laStatus;
        synchronized (longArray) {
            Object oStatus = laStatus.set(lId, (Object)status);
            if (oStatus != null) {
                laStatus.set(lId, oStatus);
                throw new IllegalArgumentException(String.valueOf("duplicate request: ") + request);
            }
        }
        return status;
    }

    public Object removeAttribute(String sName) {
        return this.getAttributeMap().remove(sName);
    }

    public Object request(Request request) {
        return this.request(request, this.getRequestTimeout());
    }

    public Object request(Request request, long cMillis) {
        boolean bl;
        Response response;
        Object var10_14;
        Request.Status status;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Connection connection = (Connection)this.getConnection();
        if (connection == null) {
            throw new ConnectionException("channel is closed");
        }
        ConnectionException eSend = null;
        ThreadGate gateOuter = connection.getThreadGate();
        if (gateOuter.enter(0L) ^ true) {
            throw new ConnectionException("connection is closed");
        }
        try {
            ThreadGate gateInner = this.getThreadGate();
            if (gateInner.enter(0L) ^ true) {
                throw new ConnectionException("channel is closed");
            }
            try {
                if (!this.isOpen() ? false : connection == this.getConnection()) {
                    status = this.registerRequest(request);
                    try {
                        this.doSend((Message)request);
                    }
                    catch (Throwable t) {
                        status.cancel();
                        if (t instanceof ConnectionException) {
                            eSend = (ConnectionException)t;
                        }
                        throw Comm.ensureRuntimeException(t);
                    }
                } else {
                    throw new ConnectionException("channel is closed");
                }
                var10_14 = null;
            }
            catch (Throwable t) {
                Object var10_15 = null;
                gateInner.exit();
                throw t;
            }
            gateInner.exit();
            Object t = null;
        }
        catch (Throwable gateInner) {
            Object t = null;
            gateOuter.exit();
            throw gateInner;
        }
        gateOuter.exit();
        if (eSend != null) {
            connection.close(eSend);
            throw eSend;
        }
        if (gateOuter.isActiveThread()) {
            gateOuter.exit();
        } else {
            gateOuter = null;
        }
        try {
            response = status.waitForResponse(cMillis);
            if (response.isFailure()) {
                Object oResult = response.getResult();
                if (oResult instanceof Throwable) {
                    throw Comm.ensureRuntimeException((Throwable)oResult);
                }
                throw new RuntimeException(String.valueOf("received error: ") + oResult);
            }
            var10_14 = null;
            bl = gateOuter != null;
        }
        catch (Throwable throwable) {
            var10_14 = null;
            if (gateOuter != null && gateOuter.enter(0L) ^ true) {
                throw new ConnectionException("connection is closed");
            }
            throw throwable;
        }
        if (bl && gateOuter.enter(0L) ^ true) {
            throw new ConnectionException("connection is closed");
        }
        if (!this.isOpen() ? false : connection == this.getConnection()) {
            return response.getResult();
        }
        throw new ConnectionException("channel is closed");
    }

    public void respond(Response response) {
        Component._assert(this.getThreadGate().isActiveThread());
        if (response == null) {
            throw new IllegalArgumentException("response cannot be null");
        }
        this.doSend((Message)response);
    }

    public void send(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        Connection connection = (Connection)this.getConnection();
        if (connection == null) {
            throw new ConnectionException("channel is closed");
        }
        ConnectionException eSend = null;
        ThreadGate gateOuter = connection.getThreadGate();
        if (gateOuter.enter(0L) ^ true) {
            throw new ConnectionException("connection is closed");
        }
        try {
            ThreadGate gateInner = this.getThreadGate();
            if (gateInner.enter(0L) ^ true) {
                throw new ConnectionException("channel is closed");
            }
            try {
                if (!this.isOpen() ? false : connection == this.getConnection()) {
                    try {
                        this.doSend(message);
                    }
                    catch (ConnectionException e) {
                        eSend = e;
                    }
                } else {
                    throw new ConnectionException("channel is closed");
                }
                Object var7_11 = null;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                gateInner.exit();
                throw throwable;
            }
            gateInner.exit();
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            gateOuter.exit();
            throw throwable;
        }
        gateOuter.exit();
        if (eSend != null) {
            connection.close(eSend);
            throw eSend;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Request.Status send(Request request) {
        Object var8_11;
        ConnectionException eSend;
        ThreadGate gateOuter;
        Connection connection;
        block15: {
            Request.Status status;
            block14: {
                if (request == null) {
                    throw new IllegalArgumentException("request cannot be null");
                }
                connection = (Connection)this.getConnection();
                if (connection == null) {
                    throw new ConnectionException("channel is closed");
                }
                gateOuter = connection.getThreadGate();
                if (gateOuter.enter(0L) ^ true) {
                    throw new ConnectionException("connection is closed");
                }
                try {
                    ThreadGate gateInner;
                    block13: {
                        Object var8_10;
                        gateInner = this.getThreadGate();
                        if (gateInner.enter(0L) ^ true) {
                            throw new ConnectionException("channel is closed");
                        }
                        try {
                            if (!(!this.isOpen() ? false : connection == this.getConnection())) {
                                throw new ConnectionException("channel is closed");
                            }
                            Request.Status status2 = this.registerRequest(request);
                            try {
                                this.doSend((Message)request);
                                status = status2;
                                var8_10 = null;
                            }
                            catch (Throwable t) {
                                status2.cancel();
                                if (!(t instanceof ConnectionException)) {
                                    throw Comm.ensureRuntimeException(t);
                                }
                                eSend = (ConnectionException)t;
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_12 = null;
                            gateInner.exit();
                            throw throwable;
                        }
                        gateInner.exit();
                        var8_10 = null;
                        break block14;
                    }
                    var8_11 = null;
                    gateInner.exit();
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    gateOuter.exit();
                    throw throwable;
                }
            }
            gateOuter.exit();
            return status;
        }
        var8_11 = null;
        gateOuter.exit();
        connection.close(eSend);
        throw eSend;
    }

    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        PofBufferWriter writer = new PofBufferWriter(out, (PofContext)this);
        writer.writeObject(-1, o);
    }

    public void serialize(PofWriter out, Object o) throws IOException {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofSerializer) {
            ((PofSerializer)serializer).serialize(out, o);
        } else {
            BinaryWriteBuffer buf = new BinaryWriteBuffer(32);
            serializer.serialize(buf.getBufferOutput(), o);
            out.writeBinary(0, buf.toBinary());
            out.writeRemainder(null);
        }
    }

    public Object setAttribute(String sName, Object oValue) {
        return this.getAttributeMap().put(sName, oValue);
    }

    protected void setAttributeMap(Map map) {
        this.__m_AttributeMap = map;
    }

    public void setConnection(com.tangosol.net.messaging.Connection connection) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Connection = connection;
    }

    public void setContextClassLoader(ClassLoader loader) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof ClassLoaderAware) {
            ((ClassLoaderAware)serializer).setContextClassLoader(loader);
        }
    }

    protected static void setDebug(boolean fDebug) {
        __s_Debug = fDebug;
    }

    public void setId(int nId) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Id = nId;
    }

    public void setMessageFactory(Protocol.MessageFactory factory) {
        Component._assert(this.isOpen() ^ true);
        this.__m_MessageFactory = factory;
    }

    protected void setOpen(boolean fOpen) {
        this.__m_Open = fOpen;
    }

    public void setReceiver(Channel.Receiver receiver) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Receiver = receiver;
    }

    protected void setRequestArray(LongArray la) {
        this.__m_RequestArray = la;
    }

    public void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = cMillis;
    }

    public void setSerializer(Serializer serializer) {
        Component._assert(this.isOpen() ^ true ? true : serializer == null);
        this.__m_Serializer = serializer;
    }

    public void setSubject(Subject subject) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Subject = subject;
    }

    protected void setThreadGate(ThreadGate gate) {
        this.__m_ThreadGate = gate;
    }

    protected void unregisterRequest(Request.Status status) {
        Component._assert(status != null);
        Request request = status.getRequest();
        Component._assert(request != null);
        LongArray laStatus = this.getRequestArray();
        long lId = request.getId();
        LongArray longArray = laStatus;
        synchronized (longArray) {
            laStatus.remove(lId);
        }
    }
}

