/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.ConnectionManager$Daemon$Queue;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Request;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ConnectionManager$Daemon
extends QueueProcessor {
    private static ListMap __mapChildren;

    static {
        ConnectionManager$Daemon.__initStatic();
    }

    public ConnectionManager$Daemon() {
        this(null, null, true);
    }

    public ConnectionManager$Daemon(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Queue", (Object)ConnectionManager$Daemon$Queue.get_CLASS());
    }

    public String getThreadName() {
        return this.get_Module().get_Name();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/ConnectionManager$Daemon".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ConnectionManager$Daemon();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected void onException(Throwable e) {
        if (this.isExiting() ^ true) {
            Component._trace("The following exception was caught by the service daemon:", 1);
            Component._trace(e);
            Component._trace("(The service daemon has logged the exception and is continuing.)", 1);
        }
    }

    protected void onNotify() {
        long cMillis;
        ConnectionManager manager = (ConnectionManager)this.get_Module();
        Component._assert(manager != null);
        while (this.isExiting() ^ true) {
            Runnable task = (Runnable)this.getQueue().removeNoWait();
            if (task == null) break;
            task.run();
        }
        DaemonPool pool = manager.getDaemonPool();
        if (!(!(pool != null) ? false : pool.isStarted()) ? false : Base.getSafeTimeMillis() >= pool.getNextCheckMillis()) {
            pool.checkTimeouts();
        }
        if ((cMillis = manager.getPingInterval()) > 0L) {
            long ldtNext;
            long ldtNow = Base.getSafeTimeMillis();
            Collection col = manager.getPingStatus();
            if ((col == null ? true : col.isEmpty()) ^ true) {
                boolean fTimeout = ldtNow >= manager.getPingTimeoutMillis();
                Iterator iter = col.iterator();
                while (iter.hasNext()) {
                    Request.Status status = (Request.Status)iter.next();
                    if (status.isClosed()) {
                        iter.remove();
                        continue;
                    }
                    if (!fTimeout) continue;
                    Connection connection = (Connection)status.getRequest().getChannel().getConnection();
                    ConnectionException e = new ConnectionException(String.valueOf("did not receive a response to a ping within ") + manager.getPingTimeout() + " milliseconds");
                    manager.closeConnection(connection, false, e);
                    iter.remove();
                }
            }
            if (!(ldtNow >= (ldtNext = manager.getPingNextMillis())) ? false : (col == null ? true : col.isEmpty())) {
                manager.ping();
            }
            if ((ldtNext = manager.getPingNextMillis()) > ldtNow) {
                long ldtTimeout = manager.getPingTimeoutMillis();
                cMillis = ldtTimeout > ldtNow ? Math.min(ldtNext, ldtTimeout) - ldtNow : ldtNext - ldtNow;
            }
            this.setWaitMillis(cMillis);
        }
    }
}

