/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Channel;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.messaging.Response;

public class RequestStatus
extends Comm
implements Request.Status {
    private Channel __m_Channel;
    private boolean __m_Closed;
    private long __m_InitTimeMillis;
    private Request __m_Request;
    private Response __m_Response;

    public RequestStatus() {
        this(null, null, true);
    }

    public RequestStatus(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void cancel() {
        Channel channel;
        RequestStatus requestStatus = this;
        synchronized (requestStatus) {
            if (this.isClosed()) {
                channel = null;
            } else {
                channel = this.getChannel();
                this.setChannel(null);
                this.setClosed(true);
                this.onCompletion();
            }
        }
        if (channel != null) {
            channel.onRequestCanceled(this);
        }
    }

    public Channel getChannel() {
        return this.__m_Channel;
    }

    protected String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Request=").append(this.getRequest());
        boolean fClosed = this.isClosed();
        if (fClosed) {
            sb.append(", Response=").append(this.getResponse());
        }
        sb.append(", Closed=").append(fClosed);
        return sb.toString();
    }

    public long getInitTimeMillis() {
        return this.__m_InitTimeMillis;
    }

    public Request getRequest() {
        return this.__m_Request;
    }

    public Response getResponse() {
        return this.__m_Response;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/RequestStatus".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new RequestStatus();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isClosed() {
        return this.__m_Closed;
    }

    protected void onCompletion() {
        this.notifyAll();
    }

    public void onInit() {
        this.setInitTimeMillis(System.currentTimeMillis());
        super.onInit();
    }

    public void setChannel(Channel channel) {
        Component._assert(this.isClosed() ^ true ? true : channel == null);
        this.__m_Channel = channel;
    }

    protected void setClosed(boolean fClosed) {
        this.__m_Closed = fClosed;
    }

    protected void setInitTimeMillis(long ldt) {
        this.__m_InitTimeMillis = ldt;
    }

    public void setRequest(Request request) {
        Component._assert(this.isClosed() ^ true ? true : request == null);
        this.__m_Request = request;
    }

    public void setResponse(Response response) {
        Channel channel;
        Component._assert(response != null);
        RequestStatus requestStatus = this;
        synchronized (requestStatus) {
            if (this.isClosed()) {
                channel = null;
            } else {
                channel = this.getChannel();
                this.__m_Response = response;
                this.setChannel(null);
                this.setClosed(true);
                this.onCompletion();
            }
        }
        if (channel != null) {
            channel.onRequestCompleted(this);
        }
    }

    public Response waitForResponse(long cMillis) {
        Response response;
        boolean fClosed;
        if (cMillis <= 0L) {
            RequestStatus requestStatus = this;
            synchronized (requestStatus) {
                while (this.isClosed() ^ true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Comm.ensureRuntimeException(e);
                    }
                }
                fClosed = this.isClosed();
                response = this.getResponse();
            }
        }
        long cMillisRemain = cMillis;
        RequestStatus requestStatus = this;
        synchronized (requestStatus) {
            fClosed = this.isClosed();
            while (fClosed ^ true) {
                long ldtStart = System.currentTimeMillis();
                try {
                    this.wait(cMillisRemain);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Comm.ensureRuntimeException(e);
                }
                fClosed = this.isClosed();
                if (fClosed ? true : (cMillisRemain -= Math.max(System.currentTimeMillis() - ldtStart, 0L)) <= (long)0) break;
            }
            response = this.getResponse();
        }
        if (response == null) {
            if (fClosed) {
                throw new ConnectionException("request was canceled");
            }
            if (cMillis <= 0L) {
                Component._assert(false);
            } else {
                Connection connection;
                Channel channel;
                ConnectionException e = new ConnectionException(String.valueOf("did not receive a response within ") + cMillis + " milliseconds");
                requestStatus = this;
                synchronized (requestStatus) {
                    channel = this.getChannel();
                }
                if (channel != null && (connection = (Connection)channel.getConnection()) != null) {
                    connection.close((Throwable)e);
                }
                throw e;
            }
        }
        return response;
    }
}

