/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionCloseTask;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionEventTask;
import com.tangosol.coherence.component.comm.ConnectionManager$DaemonPool;
import com.tangosol.coherence.component.comm.ConnectionManager$EventDispatcher;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageDispatchTask;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageExecuteTask;
import com.tangosol.license.CoherenceCachingEdition;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.ListMap;
import com.tangosol.util.UUID;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Acceptor
extends ConnectionManager
implements ConnectionAcceptor {
    private volatile boolean __m_AcceptingConnections;
    private Set __m_ConnectionPendingSet;
    private Set __m_ConnectionSet;
    private static ListMap __mapChildren;

    static {
        Acceptor._initStatic();
    }

    public Acceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ConnectionCloseTask", (Object)ConnectionManager$ConnectionCloseTask.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ConnectionEventTask", (Object)ConnectionManager$ConnectionEventTask.get_CLASS());
        Object object3 = __mapChildren.put((Object)"DaemonPool", (Object)ConnectionManager$DaemonPool.get_CLASS());
        Object object4 = __mapChildren.put((Object)"EventDispatcher", (Object)ConnectionManager$EventDispatcher.get_CLASS());
        Object object5 = __mapChildren.put((Object)"MessageDispatchTask", (Object)ConnectionManager$MessageDispatchTask.get_CLASS());
        Object object6 = __mapChildren.put((Object)"MessageExecuteTask", (Object)ConnectionManager$MessageExecuteTask.get_CLASS());
    }

    private static void _initStatic$Default() {
        Acceptor.__initStatic();
    }

    protected static void _initStatic() {
        try {
            new CoherenceCachingEdition();
        }
        catch (RuntimeException e) {
            ConnectionManager.setLicenseError(e.getMessage());
        }
        Acceptor._initStatic$Default();
    }

    public boolean acceptConnection(Connection connection, UUID uuid, int nEdition, Map mapProtocols) {
        boolean fAdded;
        Component._assert(connection.getConnectionManager() == this);
        if (this.isRunning() ^ true) {
            return false;
        }
        if (this.isAcceptingConnections() ^ true) {
            return false;
        }
        this.negotiateProtocols(connection, mapProtocols);
        Set setPending = this.getConnectionPendingSet();
        Set setAccepted = this.getConnectionSet();
        Set set = setPending;
        synchronized (set) {
            if (setPending.remove(connection)) {
                Set set2 = setAccepted;
                synchronized (set2) {
                    fAdded = setAccepted.add(connection);
                }
            } else {
                fAdded = false;
            }
        }
        if (fAdded) {
            connection.setId(new UUID());
            connection.setPeerId(uuid);
            connection.setPeerEdition(nEdition);
            this.onConnectionAccepted(connection);
        }
        return fAdded;
    }

    protected void doStart() {
        this.setAcceptingConnections(true);
        super.doStart();
    }

    protected void doStop() {
        this.setAcceptingConnections(false);
        HashSet setPending = this.getConnectionPendingSet();
        HashSet setAccepted = this.getConnectionSet();
        HashSet hashSet = setPending;
        synchronized (hashSet) {
            HashSet hashSet2 = setAccepted;
            synchronized (hashSet2) {
                com.tangosol.net.messaging.Connection connection;
                setPending = new HashSet(setPending);
                setAccepted = new HashSet(setAccepted);
                Iterator iter = setPending.iterator();
                while (iter.hasNext()) {
                    connection = (com.tangosol.net.messaging.Connection)iter.next();
                    connection.close();
                }
                iter = setAccepted.iterator();
                while (iter.hasNext()) {
                    connection = (com.tangosol.net.messaging.Connection)iter.next();
                    connection.close();
                }
            }
        }
        super.doStop();
    }

    public String formatStats() {
        return String.valueOf("Connections=") + this.getConnectionSet().size() + ", " + super.formatStats();
    }

    protected Set getConnectionPendingSet() {
        return this.__m_ConnectionPendingSet;
    }

    protected Set getConnectionSet() {
        return this.__m_ConnectionSet;
    }

    public Collection getConnections() {
        Set set;
        Set set2 = set = this.getConnectionSet();
        synchronized (set2) {
            HashSet hashSet = new HashSet(set);
            Object var4_4 = null;
            return hashSet;
        }
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/Acceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection(Object oCtx) {
        return null;
    }

    public boolean isAccepted(com.tangosol.net.messaging.Connection connection) {
        Set set;
        Set set2 = set = this.getConnectionSet();
        synchronized (set2) {
            boolean bl = set.contains(connection);
            Object var5_5 = null;
            return bl;
        }
    }

    protected boolean isAcceptingConnections() {
        return this.__m_AcceptingConnections;
    }

    protected void negotiateProtocols(Connection connection, Map mapRequired) {
        Integer IVersion;
        String sProtocol;
        Map.Entry entry;
        HashMap<String, Protocol.MessageFactory> mapFactory = connection.getMessageFactoryMap();
        Iterator iter = mapRequired.entrySet().iterator();
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            sProtocol = (String)entry.getKey();
            IVersion = (Integer)entry.getValue();
            Protocol.MessageFactory factory = (Protocol.MessageFactory)mapFactory.get(sProtocol);
            if (!(factory == null ? true : factory.getVersion() != IVersion.intValue())) continue;
            mapFactory = null;
            break;
        }
        if (mapFactory == null) {
            mapFactory = new HashMap<String, Protocol.MessageFactory>();
            iter = mapRequired.entrySet().iterator();
            while (iter.hasNext()) {
                entry = (Map.Entry)iter.next();
                sProtocol = (String)entry.getKey();
                IVersion = (Integer)entry.getValue();
                Protocol protocol = this.getProtocol(sProtocol);
                if (protocol == null) {
                    throw new RuntimeException(String.valueOf("unsupported protocol: ") + sProtocol);
                }
                mapFactory.put(sProtocol, protocol.getMessageFactory(IVersion.intValue()));
            }
            connection.setMessageFactoryMap(mapFactory);
        }
    }

    protected void onConnectionAccepted(com.tangosol.net.messaging.Connection connection) {
        this.dispatchConnectionEvent(new ConnectionEvent(connection, ConnectionEvent.CONNECTION_ACCEPTED));
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Accepted: ") + connection, 6);
        }
    }

    public void onConnectionClosed(com.tangosol.net.messaging.Connection connection) {
        boolean fRemoved;
        Set setPending = this.getConnectionPendingSet();
        Set setAccepted = this.getConnectionSet();
        Set set = setPending;
        synchronized (set) {
            fRemoved = setPending.remove(connection);
            if (fRemoved ^ true) {
                Set set2 = setAccepted;
                synchronized (set2) {
                    fRemoved = setAccepted.remove(connection);
                }
            }
        }
        if (fRemoved) {
            super.onConnectionClosed(connection);
        }
    }

    public void onConnectionError(com.tangosol.net.messaging.Connection connection, Throwable cause) {
        boolean fRemoved;
        Set setPending = this.getConnectionPendingSet();
        Set setAccepted = this.getConnectionSet();
        Set set = setPending;
        synchronized (set) {
            fRemoved = setPending.remove(connection);
            if (fRemoved ^ true) {
                Set set2 = setAccepted;
                synchronized (set2) {
                    fRemoved = setAccepted.remove(connection);
                }
            }
        }
        if (fRemoved) {
            super.onConnectionError(connection, cause);
        }
    }

    public void onInit() {
        this.setConnectionPendingSet(new HashSet());
        this.setConnectionSet(new HashSet());
        super.onInit();
    }

    public Connection openConnection(Object oCtx) {
        Set set;
        if (this.isRunning() ^ true) {
            return null;
        }
        Connection connection = this.instantiateConnection(oCtx);
        connection.setCodec(this.getCodec());
        connection.setConnectionManager(this);
        connection.setMessageFactoryMap(this.getMessageFactoryMap());
        connection.open();
        Set set2 = set = this.getConnectionPendingSet();
        synchronized (set2) {
            set.add(connection);
        }
        return connection;
    }

    public void ping() {
        boolean fPing = false;
        Iterator iter = this.getConnections().iterator();
        while (iter.hasNext()) {
            fPing |= this.ping((com.tangosol.net.messaging.Connection)iter.next());
        }
        if (fPing) {
            super.ping();
        }
    }

    protected void setAcceptingConnections(boolean fAccepting) {
        this.__m_AcceptingConnections = fAccepting;
    }

    protected void setConnectionPendingSet(Set set) {
        this.__m_ConnectionPendingSet = set;
    }

    protected void setConnectionSet(Set set) {
        this.__m_ConnectionSet = set;
    }

    public void setPingLastMillis(long ldt) {
        super.setPingLastMillis(ldt);
    }
}

