/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionCloseTask;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionEventTask;
import com.tangosol.coherence.component.comm.ConnectionManager$Daemon;
import com.tangosol.coherence.component.comm.ConnectionManager$DaemonPool;
import com.tangosol.coherence.component.comm.ConnectionManager$EventDispatcher;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageDispatchTask;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageExecuteTask;
import com.tangosol.coherence.component.comm.connection.JmsConnection;
import com.tangosol.coherence.component.comm.connectionManager.Acceptor;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.JmsAcceptor$ConnectionInfo;
import com.tangosol.coherence.component.comm.util.JmsUtil;
import com.tangosol.coherence.component.comm.util.JndiUtil;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ListMap;
import java.util.Map;
import javax.jms.DeliveryMode;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.naming.NamingException;

public class JmsAcceptor
extends Acceptor
implements ExceptionListener,
MessageListener {
    private int __m_MessageDeliveryMode;
    private long __m_MessageExpiration;
    private int __m_MessagePriority;
    private Queue __m_Queue;
    private QueueConnection __m_QueueConnection;
    private String __m_QueueConnectionFactoryName;
    private String __m_QueueName;
    private QueueReceiver __m_QueueReceiver;
    private QueueSender __m_QueueSender;
    private QueueSession __m_QueueSession;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        JmsAcceptor.__initStatic();
    }

    public JmsAcceptor() {
        this(null, null, true);
    }

    public JmsAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new ConnectionManager$Daemon("Daemon", this, true), "Daemon");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ConnectionCloseTask", (Object)ConnectionManager$ConnectionCloseTask.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ConnectionEventTask", (Object)ConnectionManager$ConnectionEventTask.get_CLASS());
        Object object3 = __mapChildren.put((Object)"ConnectionInfo", (Object)JmsAcceptor$ConnectionInfo.get_CLASS());
        Object object4 = __mapChildren.put((Object)"DaemonPool", (Object)ConnectionManager$DaemonPool.get_CLASS());
        Object object5 = __mapChildren.put((Object)"EventDispatcher", (Object)ConnectionManager$EventDispatcher.get_CLASS());
        Object object6 = __mapChildren.put((Object)"MessageDispatchTask", (Object)ConnectionManager$MessageDispatchTask.get_CLASS());
        Object object7 = __mapChildren.put((Object)"MessageExecuteTask", (Object)ConnectionManager$MessageExecuteTask.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("javax.jms.Queue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("javax.jms.QueueConnectionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void doConfigure(XmlElement xml) {
        super.doConfigure(xml);
        XmlElement xmlCat = xml.getSafeElement("jms-acceptor");
        this.setQueueConnectionFactoryName(this.ensureStringValue(xmlCat, "queue-connection-factory-name", this.getQueueConnectionFactoryName()));
        this.setQueueName(this.ensureStringValue(xmlCat, "queue-name", this.getQueueName()));
        XmlElement xmlVal = xmlCat.getSafeElement("message-delivery-mode");
        if (xmlVal.getString("NON_PERSISTENT").equalsIgnoreCase("PERSISTENT")) {
            this.setMessageDeliveryMode(DeliveryMode.PERSISTENT);
        } else {
            this.setMessageDeliveryMode(DeliveryMode.NON_PERSISTENT);
        }
        this.setMessageExpiration(ConnectionManager.parseTime(xmlCat, "message-expiration", Message.DEFAULT_TIME_TO_LIVE));
        this.setMessagePriority(xmlCat.getSafeElement("message-priority").getInt(Message.DEFAULT_PRIORITY));
    }

    protected void doStart() {
        QueueReceiver receiver;
        QueueSession session;
        QueueConnection connection;
        QueueConnectionFactory factory;
        Queue queue;
        this.setThreadCount(Math.max(this.getThreadCount(), 1));
        super.doStart();
        try {
            queue = (Queue)JndiUtil.lookup(this.getQueueName(), JmsAcceptor.__sm0());
            this.setQueue(queue);
        }
        catch (NamingException e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("error retrieving a Queue from JNDI") + " using the name \"" + this.getQueueName() + "\"");
        }
        try {
            factory = (QueueConnectionFactory)JndiUtil.lookup(this.getQueueConnectionFactoryName(), JmsAcceptor.__sm1());
        }
        catch (NamingException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, String.valueOf("error retrieving a ") + " QueueConnectionFactory from JNDI using the name \"" + this.getQueueConnectionFactoryName() + "\"");
        }
        try {
            connection = factory.createQueueConnection();
            this.setQueueConnection(connection);
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error creating a QueueConnection");
        }
        try {
            session = connection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
            this.setQueueSession(session);
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error creating a QueueSession");
        }
        try {
            this.setQueueSender(session.createSender(null));
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error creating a QueueSender");
        }
        try {
            receiver = session.createReceiver(queue);
            this.setQueueReceiver(receiver);
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error creating a QueueReceiver");
        }
        try {
            receiver.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error registering a MessageListener");
        }
        try {
            connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error registering an ExceptionListener");
        }
        try {
            connection.start();
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error starting a QueueConnection");
        }
        Component._trace(String.valueOf("JmsAcceptor now listening for connections on ") + this.getQueueName(), 3);
    }

    protected void doStop() {
        super.doStop();
        JmsUtil.close((javax.jms.Connection)this.getQueueConnection());
        JmsUtil.close((MessageConsumer)this.getQueueReceiver());
        JmsUtil.close((Session)this.getQueueSession());
        this.setQueue(null);
        this.setQueueConnection(null);
        this.setQueueReceiver(null);
        this.setQueueSession(null);
    }

    protected String getDescription() {
        String sMode;
        switch (this.getMessageDeliveryMode()) {
            case 2: {
                sMode = "PERSISTENT";
                break;
            }
            case 1: {
                sMode = "NON_PERSISTENT";
                break;
            }
            default: {
                sMode = "UNKNOWN";
            }
        }
        return String.valueOf(super.getDescription()) + ", QueueConnectionFactoryName=" + this.getQueueConnectionFactoryName() + ", QueueName=" + this.getQueueName() + ", MessageExpiration=" + this.getMessageExpiration() + ", MessagePriority=" + this.getMessageDeliveryMode() + ", MessageDeliveryMode=" + sMode;
    }

    protected int getMessageDeliveryMode() {
        return this.__m_MessageDeliveryMode;
    }

    protected long getMessageExpiration() {
        return this.__m_MessageExpiration;
    }

    protected int getMessagePriority() {
        return this.__m_MessagePriority;
    }

    protected Queue getQueue() {
        return this.__m_Queue;
    }

    protected QueueConnection getQueueConnection() {
        return this.__m_QueueConnection;
    }

    protected String getQueueConnectionFactoryName() {
        return this.__m_QueueConnectionFactoryName;
    }

    protected String getQueueName() {
        return this.__m_QueueName;
    }

    protected QueueReceiver getQueueReceiver() {
        return this.__m_QueueReceiver;
    }

    protected QueueSender getQueueSender() {
        return this.__m_QueueSender;
    }

    protected QueueSession getQueueSession() {
        return this.__m_QueueSession;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/acceptor/JmsAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new JmsAcceptor();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection(Object oCtx) {
        JmsAcceptor$ConnectionInfo info = (JmsAcceptor$ConnectionInfo)oCtx;
        Component._assert(info != null);
        JmsConnection connection = new JmsConnection();
        connection.setQueueIn(info.getQueueIn());
        connection.setQueueOut(info.getQueueOut());
        connection.setQueueSession(info.getQueueSession());
        connection.setMessageDeliveryMode(this.getMessageDeliveryMode());
        connection.setMessageExpiration(this.getMessageExpiration());
        connection.setMessagePriority(this.getMessagePriority());
        return connection;
    }

    public void onException(JMSException e) {
        Component._trace(e, "A fatal JMS exception occured; the JmsAcceptor will be stopped");
        this.stop();
    }

    public void onMessage(Message message) {
        Message reply;
        JmsConnection jmsConnection;
        QueueSession session;
        TemporaryQueue queueIn;
        Queue queueOut;
        QueueConnection connection = this.getQueueConnection();
        try {
            Destination oQueue = message.getJMSReplyTo();
            if (!(oQueue instanceof Queue)) {
                Component._trace(String.valueOf("Received an unexpected peer JMS destination: ") + oQueue, 1);
                return;
            }
            queueOut = (Queue)oQueue;
        }
        catch (JMSException e) {
            Component._trace(e, "An error occured while processing an incoming JMS message");
            return;
        }
        try {
            queueIn = this.getQueueSession().createTemporaryQueue();
        }
        catch (JMSException e) {
            Component._trace(e, "An error occured while creating a TemporaryQueue");
            return;
        }
        try {
            session = connection.createQueueSession(false, Session.DUPS_OK_ACKNOWLEDGE);
        }
        catch (JMSException e) {
            Component._trace(e, "An error occured while creating a QueueSession");
            JmsUtil.delete((Destination)queueIn);
            return;
        }
        try {
            JmsAcceptor$ConnectionInfo info = new JmsAcceptor$ConnectionInfo();
            info.setQueueIn((Queue)queueIn);
            info.setQueueOut(queueOut);
            info.setQueueSession(session);
            jmsConnection = (JmsConnection)this.openConnection(info);
        }
        catch (RuntimeException e) {
            Component._trace(e, "An error occured while opening a new JMS connection");
            JmsUtil.close((Session)session);
            JmsUtil.delete((Destination)queueIn);
            return;
        }
        try {
            reply = this.getQueueSession().createMessage();
            reply.setJMSCorrelationID(message.getJMSMessageID());
            reply.setJMSDeliveryMode(this.getMessageDeliveryMode());
            reply.setJMSExpiration(this.getMessageExpiration());
            reply.setJMSPriority(this.getMessagePriority());
            reply.setJMSReplyTo((Destination)queueIn);
        }
        catch (JMSException e) {
            jmsConnection.close(e);
            return;
        }
        try {
            this.getQueueSender().send(queueOut, reply);
        }
        catch (JMSException e) {
            jmsConnection.close(e);
        }
    }

    protected void setMessageDeliveryMode(int nMode) {
        this.__m_MessageDeliveryMode = nMode;
    }

    protected void setMessageExpiration(long cMillis) {
        this.__m_MessageExpiration = cMillis;
    }

    protected void setMessagePriority(int nPriority) {
        this.__m_MessagePriority = nPriority;
    }

    protected void setQueue(Queue queue) {
        this.__m_Queue = queue;
    }

    protected void setQueueConnection(QueueConnection connection) {
        this.__m_QueueConnection = connection;
    }

    protected void setQueueConnectionFactoryName(String sName) {
        this.__m_QueueConnectionFactoryName = sName;
    }

    protected void setQueueName(String sName) {
        this.__m_QueueName = sName;
    }

    protected void setQueueReceiver(QueueReceiver receiver) {
        this.__m_QueueReceiver = receiver;
    }

    protected void setQueueSender(QueueSender sender) {
        this.__m_QueueSender = sender;
    }

    protected void setQueueSession(QueueSession session) {
        this.__m_QueueSession = session;
    }
}

