/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.pool.simplePool.GrowablePool;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.io.nio.ByteBufferWriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class TcpAcceptor$ByteBufferPool
extends GrowablePool
implements MultiBufferWriteBuffer.WriteBufferPool {
    public static final int TYPE_DIRECT = 0;
    public static final int TYPE_HEAP = 1;
    private int __m_BufferSize;
    private int __m_BufferType;
    private String __m_Name;
    private int __m_Overflow;

    public TcpAcceptor$ByteBufferPool() {
        this(null, null, true);
    }

    public TcpAcceptor$ByteBufferPool(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferSize(10240);
            this.setBufferType(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public Object acquire() {
        Object oElement = this.getStorage().removeNoWait();
        if (oElement == null) {
            boolean fGrow;
            TcpAcceptor$ByteBufferPool tcpAcceptor$ByteBufferPool = this;
            synchronized (tcpAcceptor$ByteBufferPool) {
                int cSize = this.getSize();
                int cCapacity = this.getCapacity();
                if (cSize < cCapacity ? true : cCapacity <= 0) {
                    this.setSize(cSize + 1);
                    fGrow = true;
                } else {
                    this.setOverflow(this.getOverflow() + 1);
                    fGrow = false;
                }
            }
            oElement = this.instantiateResource();
            if (Component._isTraceEnabled(6)) {
                if (fGrow) {
                    Component._trace(String.valueOf(this.getName()) + "ByteBufferPool increased to " + this.getSize() * this.getBufferSize() + " bytes total", 6);
                } else if (Component._isTraceEnabled(7)) {
                    Component._trace(String.valueOf(this.getName()) + "ByteBufferPool allocated " + this.getBufferSize() + " bytes", 7);
                }
            }
        }
        return oElement;
    }

    public WriteBuffer allocate(int cbPreviousTotal) {
        return new ByteBufferWriteBuffer((ByteBuffer)this.acquire());
    }

    public int getBufferSize() {
        return this.__m_BufferSize;
    }

    public int getBufferType() {
        return this.__m_BufferType;
    }

    public int getMaximumCapacity() {
        return this.getBufferSize() * this.getCapacity();
    }

    public String getName() {
        String sName = this.__m_Name;
        return sName == null ? "" : sName;
    }

    public int getOverflow() {
        return this.__m_Overflow;
    }

    public static int getType(String sType) {
        if (sType.equalsIgnoreCase("HEAP")) {
            return TYPE_HEAP;
        }
        return TYPE_DIRECT;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/acceptor/TcpAcceptor$ByteBufferPool".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new TcpAcceptor$ByteBufferPool();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected Object instantiateResource() {
        ByteBuffer buf;
        switch (this.getBufferType()) {
            case 0: {
                buf = ByteBuffer.allocateDirect(this.getBufferSize());
                break;
            }
            default: {
                buf = ByteBuffer.allocate(this.getBufferSize());
            }
        }
        return buf;
    }

    protected Queue instantiateStorage() {
        return new DualQueue();
    }

    public synchronized void release() {
        Queue queue = this.getStorage();
        while (queue.isEmpty() ^ true) {
            queue.removeNoWait();
        }
        this.setOverflow(0);
        this.setSize(0);
    }

    public void release(ReadBuffer rb) {
        if (rb instanceof ByteBufferReadBuffer) {
            this.release(((ByteBufferReadBuffer)rb).getByteBuffer());
        } else if (!(rb == null)) {
            Component._assert(false, String.valueOf("invalid ReadBuffer type: ") + rb.getClass());
        }
    }

    public void release(WriteBuffer wb) {
        if (wb instanceof ByteBufferWriteBuffer) {
            this.release(((ByteBufferWriteBuffer)wb).getByteBuffer());
        } else if (wb instanceof MultiBufferWriteBuffer) {
            MultiBufferWriteBuffer mbwb = (MultiBufferWriteBuffer)wb;
            int i = 0;
            int c = mbwb.getBufferCount();
            while (i < c) {
                this.release(mbwb.getBuffer(i));
                ++i;
            }
        } else if (!(wb == null)) {
            Component._assert(false, String.valueOf("invalid WriteBuffer type: ") + wb.getClass());
        }
    }

    public void release(Object oElement) {
        boolean fRelease;
        int cOverflow;
        if (oElement == null) {
            return;
        }
        Component._assert(oElement instanceof ByteBuffer);
        ByteBuffer buf = (ByteBuffer)oElement;
        TcpAcceptor$ByteBufferPool tcpAcceptor$ByteBufferPool = this;
        synchronized (tcpAcceptor$ByteBufferPool) {
            cOverflow = this.getOverflow();
            if (cOverflow == 0) {
                fRelease = true;
            } else {
                this.setOverflow(--cOverflow);
                fRelease = false;
            }
        }
        if (fRelease) {
            ((Buffer)buf).clear();
            super.release(buf);
        } else {
            if (!(this.getBufferType() == TYPE_DIRECT) ? false : cOverflow == 0) {
                System.gc();
            }
            if (Component._isTraceEnabled(7)) {
                Component._trace(String.valueOf(this.getName()) + "ByteBufferPool released " + buf.capacity() + " bytes", 7);
            }
        }
    }

    public void release(ByteBuffer[] abuf) {
        int i = 0;
        int c = abuf == null ? 0 : abuf.length;
        while (i < c) {
            this.release(abuf[i]);
            abuf[i] = null;
            ++i;
        }
    }

    public void setBufferSize(int cb) {
        Component._assert(cb > 0);
        this.__m_BufferSize = cb;
    }

    public void setBufferType(int nType) {
        Component._assert(!(nType >= TYPE_DIRECT) ? false : nType <= TYPE_HEAP);
        this.__m_BufferType = nType;
    }

    public void setName(String sName) {
        if (!(!(sName != null) ? false : sName.length() > 0) ? false : sName.endsWith(" ") ^ true) {
            sName = String.valueOf(sName) + ' ';
        }
        this.__m_Name = sName;
    }

    protected void setOverflow(int cResources) {
        this.__m_Overflow = cResources;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + '(' + "BufferSize=" + Base.toMemorySizeString((long)this.getBufferSize()) + ", BufferType=" + (this.getBufferType() == TYPE_DIRECT ? "DIRECT" : "HEAP") + ", Capacity=" + this.getCapacity() + ')';
    }
}

