/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionCloseTask;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionEventTask;
import com.tangosol.coherence.component.comm.ConnectionManager$Daemon;
import com.tangosol.coherence.component.comm.ConnectionManager$DaemonPool;
import com.tangosol.coherence.component.comm.ConnectionManager$EventDispatcher;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageDispatchTask;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageExecuteTask;
import com.tangosol.coherence.component.comm.connectionManager.Acceptor;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$ByteBufferPool;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$ByteBufferReadBuffer;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.coherence.component.comm.connectionManager.acceptor.TcpAcceptor$TcpProcessor;
import com.tangosol.coherence.component.comm.util.TcpUtil;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TcpAcceptor
extends Acceptor {
    private transient TcpAcceptor$ByteBufferPool __m_ByteBufferPoolIn;
    private transient TcpAcceptor$ByteBufferPool __m_ByteBufferPoolOut;
    private Queue __m_ConnectionFlushQueue;
    private Queue __m_ConnectionReleaseQueue;
    private boolean __m_KeepAliveEnabled;
    private transient long __m_LastThrottleWarningTimestamp;
    private long __m_LingerTimeout;
    private int __m_ListenBacklog;
    private InetSocketAddress __m_LocalAddress;
    private boolean __m_LocalAddressReusable;
    private transient TcpAcceptor$TcpProcessor __m_Processor;
    private long __m_ReceiveBufferSize;
    private Selector __m_Selector;
    private long __m_SendBufferSize;
    private ServerSocket __m_ServerSocket;
    private ServerSocketChannel __m_ServerSocketChannel;
    private SelectionKey __m_ServerSocketKey;
    private boolean __m_TcpDelayEnabled;
    private static ListMap __mapChildren;

    static {
        TcpAcceptor.__initStatic();
    }

    public TcpAcceptor() {
        this(null, null, true);
    }

    public TcpAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setKeepAliveEnabled(true);
            this.setLingerTimeout(-1L);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new ConnectionManager$Daemon("Daemon", this, true), "Daemon");
        this._addChild(new TcpAcceptor$TcpProcessor("TcpProcessor", this, true), "TcpProcessor");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ByteBufferPool", (Object)TcpAcceptor$ByteBufferPool.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ByteBufferReadBuffer", (Object)TcpAcceptor$ByteBufferReadBuffer.get_CLASS());
        Object object3 = __mapChildren.put((Object)"ConnectionCloseTask", (Object)ConnectionManager$ConnectionCloseTask.get_CLASS());
        Object object4 = __mapChildren.put((Object)"ConnectionEventTask", (Object)ConnectionManager$ConnectionEventTask.get_CLASS());
        Object object5 = __mapChildren.put((Object)"DaemonPool", (Object)ConnectionManager$DaemonPool.get_CLASS());
        Object object6 = __mapChildren.put((Object)"EventDispatcher", (Object)ConnectionManager$EventDispatcher.get_CLASS());
        Object object7 = __mapChildren.put((Object)"MessageDispatchTask", (Object)ConnectionManager$MessageDispatchTask.get_CLASS());
        Object object8 = __mapChildren.put((Object)"MessageExecuteTask", (Object)ConnectionManager$MessageExecuteTask.get_CLASS());
        Object object9 = __mapChildren.put((Object)"TcpConnection", (Object)TcpAcceptor$TcpConnection.get_CLASS());
    }

    public boolean acceptConnection(Connection connection, UUID uuid, int nEdition, Map mapProtocols) {
        SelectionKey key = this.getServerSocketKey();
        if (key == null ? true : key.isValid() ^ true) {
            return false;
        }
        return super.acceptConnection(connection, uuid, nEdition, mapProtocols);
    }

    protected void configureSocket(ServerSocket socket) {
        try {
            TcpUtil.setReuseAddress(socket, this.isLocalAddressReusable());
            TcpUtil.setReceiveBufferSize(socket, (int)this.getReceiveBufferSize());
        }
        catch (Exception e) {
            throw Comm.ensureRuntimeException(e, "error configuring ServerSocket");
        }
        InetSocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            Component._trace(String.valueOf("Binding ServerSocket to ") + TcpUtil.toString(addr), 6);
            try {
                socket.bind(addr, this.getListenBacklog());
            }
            catch (Exception e) {
                throw Comm.ensureRuntimeException(e, String.valueOf("error binding ServerSocket to ") + TcpUtil.toString(addr));
            }
            if (socket.isBound() ^ true) {
                throw new RuntimeException(String.valueOf("error binding ServerSocket to ") + TcpUtil.toString(addr));
            }
        }
    }

    protected void configureSocket(Socket socket) {
        try {
            TcpUtil.setKeepAlive(socket, this.isKeepAliveEnabled());
            TcpUtil.setTcpNoDelay(socket, this.isTcpDelayEnabled() ^ true);
            TcpUtil.setSendBufferSize(socket, (int)this.getSendBufferSize());
            long cMillis = this.getLingerTimeout();
            int cSecs = cMillis >= (long)0 ? (int)(cMillis / 1000L) : -1;
            TcpUtil.setSoLinger(socket, cSecs);
        }
        catch (Exception e) {
            throw Comm.ensureRuntimeException(e, "error configuring Socket");
        }
    }

    protected void dispatchConnectionEvent(ConnectionEvent evt) {
        switch (evt.getId()) {
            case 2: 
            case 3: {
                this.getConnectionReleaseQueue().add(evt.getConnection());
                this.getSelector().wakeup();
                break;
            }
        }
        super.dispatchConnectionEvent(evt);
    }

    protected void doConfigure(XmlElement xml) {
        super.doConfigure(xml);
        XmlElement xmlCat = xml.getSafeElement("tcp-acceptor");
        XmlElement xmlSub = xmlCat.getSafeElement("local-address");
        this.setLocalAddress(TcpAcceptor.parseLocalSocketAddress(xmlSub));
        if (this.getLocalAddress() == null) {
            throw new IllegalArgumentException(String.valueOf("the \"tcp-acceptor\" ") + "configuration element does not contain a valid " + "\"local-address\" element");
        }
        this.setLocalAddressReusable(xmlSub.getSafeElement("reusable").getBoolean(this.isLocalAddressReusable()));
        this.setKeepAliveEnabled(xmlCat.getSafeElement("keep-alive-enabled").getBoolean(this.isKeepAliveEnabled()));
        this.setTcpDelayEnabled(xmlCat.getSafeElement("tcp-delay-enabled").getBoolean(this.isTcpDelayEnabled()));
        this.setReceiveBufferSize(ConnectionManager.parseMemorySize(xmlCat, "receive-buffer-size", this.getReceiveBufferSize()));
        this.setSendBufferSize(ConnectionManager.parseMemorySize(xmlCat, "send-buffer-size", this.getSendBufferSize()));
        this.setListenBacklog(xmlCat.getSafeElement("listen-backlog").getInt(this.getListenBacklog()));
        this.setLingerTimeout(ConnectionManager.parseTime(xmlCat, "linger-timeout", this.getLingerTimeout()));
        XmlElement xmlVal = xmlCat.getSafeElement("incoming-byte-buffer-pool");
        TcpAcceptor$ByteBufferPool pool = this.getByteBufferPoolIn();
        pool.setBufferSize((int)ConnectionManager.parseMemorySize(xmlVal, "buffer-size", pool.getBufferSize()));
        pool.setBufferType(TcpAcceptor$ByteBufferPool.getType(xmlVal.getSafeElement("buffer-type").getString()));
        pool.setCapacity(xmlVal.getSafeElement("capacity").getInt(pool.getCapacity()));
        xmlVal = xmlCat.getSafeElement("outgoing-byte-buffer-pool");
        pool = this.getByteBufferPoolOut();
        pool.setBufferSize((int)ConnectionManager.parseMemorySize(xmlVal, "buffer-size", pool.getBufferSize()));
        pool.setBufferType(TcpAcceptor$ByteBufferPool.getType(xmlVal.getSafeElement("buffer-type").getString()));
        pool.setCapacity(xmlVal.getSafeElement("capacity").getInt(pool.getCapacity()));
    }

    protected void doStart() {
        Selector selector;
        ServerSocket socket;
        ServerSocketChannel channel;
        super.doStart();
        try {
            channel = ServerSocketChannel.open();
            this.setServerSocketChannel(channel);
            channel.configureBlocking(false);
        }
        catch (IOException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error opening ServerSocketChannel");
        }
        try {
            socket = channel.socket();
            this.setServerSocket(socket);
            this.configureSocket(socket);
        }
        catch (RuntimeException e) {
            this.doShutdown();
            throw e;
        }
        try {
            selector = Selector.open();
            this.setSelector(selector);
        }
        catch (Throwable t) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(t, "error opening Selector");
        }
        try {
            this.setServerSocketKey(channel.register(selector, SelectionKey.OP_ACCEPT));
        }
        catch (IOException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error registering ServerSocketChannel");
        }
        this.getProcessor().start();
        InetSocketAddress addr = (InetSocketAddress)socket.getLocalSocketAddress();
        Component._trace(String.valueOf("TcpAcceptor now listening for connections on ") + TcpUtil.toString(addr), 3);
    }

    protected void doStop() {
        TcpUtil.cancel(this.getServerSocketKey());
        super.doStop();
        this.getProcessor().stop();
        TcpUtil.close(this.getSelector());
        TcpUtil.close(this.getServerSocketChannel());
        this.getByteBufferPoolIn().release();
        this.getByteBufferPoolOut().release();
        this.setSelector(null);
        this.setServerSocket(null);
        this.setServerSocketChannel(null);
        this.setServerSocketKey(null);
    }

    public TcpAcceptor$ByteBufferPool getByteBufferPoolIn() {
        return this.__m_ByteBufferPoolIn;
    }

    public TcpAcceptor$ByteBufferPool getByteBufferPoolOut() {
        return this.__m_ByteBufferPoolOut;
    }

    public Queue getConnectionFlushQueue() {
        return this.__m_ConnectionFlushQueue;
    }

    public Queue getConnectionReleaseQueue() {
        return this.__m_ConnectionReleaseQueue;
    }

    protected String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        InetSocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            sb.append(", LocalAddress=").append(TcpUtil.toString(addr)).append(", LocalAddressReusable=").append(this.isLocalAddressReusable());
        }
        sb.append(", KeepAliveEnabled=").append(this.isKeepAliveEnabled()).append(", TcpDelayEnabled=").append(this.isTcpDelayEnabled()).append(", ReceiveBufferSize=").append(Base.toMemorySizeString((long)this.getReceiveBufferSize())).append(", SendBufferSize=").append(Base.toMemorySizeString((long)this.getSendBufferSize())).append(", ListenBacklog=").append(this.getListenBacklog()).append(", LingerTimeout=").append(this.getLingerTimeout()).append(", ByteBufferPoolIn=").append(this.getByteBufferPoolIn()).append(", ByteBufferPoolOut=").append(this.getByteBufferPoolOut());
        return sb.toString();
    }

    public long getLastThrottleWarningTimestamp() {
        return this.__m_LastThrottleWarningTimestamp;
    }

    protected long getLingerTimeout() {
        return this.__m_LingerTimeout;
    }

    protected int getListenBacklog() {
        return this.__m_ListenBacklog;
    }

    protected InetSocketAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    protected TcpAcceptor$TcpProcessor getProcessor() {
        return this.__m_Processor;
    }

    protected long getReceiveBufferSize() {
        return this.__m_ReceiveBufferSize;
    }

    public Selector getSelector() {
        return this.__m_Selector;
    }

    protected long getSendBufferSize() {
        return this.__m_SendBufferSize;
    }

    protected ServerSocket getServerSocket() {
        return this.__m_ServerSocket;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.__m_ServerSocketChannel;
    }

    protected SelectionKey getServerSocketKey() {
        return this.__m_ServerSocketKey;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/acceptor/TcpAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpAcceptor();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection(Object oCtx) {
        Component._assert(oCtx instanceof SocketChannel);
        SocketChannel channel = (SocketChannel)oCtx;
        Socket socket = channel.socket();
        TcpUtil.setBlockingMode(channel, false);
        this.configureSocket(socket);
        TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)this._newChild("TcpConnection");
        connection.setSocket(socket);
        connection.setSocketChannel(channel);
        return connection;
    }

    protected boolean isKeepAliveEnabled() {
        return this.__m_KeepAliveEnabled;
    }

    protected boolean isLocalAddressReusable() {
        return this.__m_LocalAddressReusable;
    }

    protected boolean isTcpDelayEnabled() {
        return this.__m_TcpDelayEnabled;
    }

    public void onInit() {
        this.setByteBufferPoolIn((TcpAcceptor$ByteBufferPool)this._newChild("ByteBufferPool"));
        this.setByteBufferPoolOut((TcpAcceptor$ByteBufferPool)this._newChild("ByteBufferPool"));
        this.setConnectionFlushQueue(new DualQueue());
        this.setConnectionReleaseQueue(new DualQueue());
        this.setProcessor((TcpAcceptor$TcpProcessor)this._findChild("TcpProcessor"));
        this.getByteBufferPoolIn().setName("Incoming");
        this.getByteBufferPoolOut().setName("Outgoing");
        super.onInit();
    }

    public Connection openConnection(Object oCtx) {
        SelectionKey key = this.getServerSocketKey();
        if (key == null ? true : key.isValid() ^ true) {
            return null;
        }
        return super.openConnection(oCtx);
    }

    protected static InetSocketAddress parseLocalSocketAddress(XmlElement xml) {
        InetAddress addr;
        XmlElement xmlAddr = xml.getElement("address");
        XmlElement xmlPort = xml.getElement("port");
        if (xmlPort == null) {
            return null;
        }
        String sAddr = xmlAddr == null ? "localhost" : xmlAddr.getString();
        int nPort = xmlPort == null ? 0 : xmlPort.getInt();
        try {
            if (sAddr.equals("localhost")) {
                addr = InetAddressHelper.getLocalHost();
            } else {
                addr = InetAddress.getByName(sAddr);
                if (InetAddressHelper.isLoopbackAddress((InetAddress)addr)) {
                    Component._trace(String.valueOf("The specified local address \"") + sAddr + "\" is a loopback address" + "; clients running on remote machines will not be able to connect" + " to this TcpAcceptor", 3);
                } else {
                    byte[] abAddr = addr.getAddress();
                    if (abAddr.length == 16) {
                        boolean fSuspect = true;
                        List listLocal = InetAddressHelper.getAllLocalAddresses();
                        Iterator iter = listLocal.iterator();
                        while (iter.hasNext()) {
                            InetAddress addrLocal = (InetAddress)iter.next();
                            if (!InetAddressHelper.virtuallyEqual((byte[])addrLocal.getAddress(), (byte[])abAddr)) continue;
                            fSuspect = false;
                            break;
                        }
                        if (fSuspect) {
                            Component._trace(String.valueOf("The local IPv6 address \"") + InetAddressHelper.toString((InetAddress)addr) + "\" does not correspond to any of the local interface addresses; " + "this address may not be reachable by IPv4-bound nodes", 2);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("the \"") + xml.getName() + "\" configuration " + "element contains an invalid \"address\" element");
        }
        try {
            return new InetSocketAddress(addr, nPort);
        }
        catch (RuntimeException e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("the \"") + xml.getName() + "\" configuration " + "element contains an invalid \"port\" element");
        }
    }

    protected void setByteBufferPoolIn(TcpAcceptor$ByteBufferPool pool) {
        this.__m_ByteBufferPoolIn = pool;
    }

    protected void setByteBufferPoolOut(TcpAcceptor$ByteBufferPool pool) {
        this.__m_ByteBufferPoolOut = pool;
    }

    protected void setConnectionFlushQueue(Queue queue) {
        this.__m_ConnectionFlushQueue = queue;
    }

    protected void setConnectionReleaseQueue(Queue queue) {
        this.__m_ConnectionReleaseQueue = queue;
    }

    protected void setKeepAliveEnabled(boolean pKeepAliveEnabled) {
        this.__m_KeepAliveEnabled = pKeepAliveEnabled;
    }

    public void setLastThrottleWarningTimestamp(long ldt) {
        this.__m_LastThrottleWarningTimestamp = ldt;
    }

    protected void setLingerTimeout(long cMillis) {
        this.__m_LingerTimeout = cMillis;
    }

    protected void setListenBacklog(int n) {
        this.__m_ListenBacklog = n;
    }

    protected void setLocalAddress(InetSocketAddress addr) {
        this.__m_LocalAddress = addr;
    }

    protected void setLocalAddressReusable(boolean fReusable) {
        this.__m_LocalAddressReusable = fReusable;
    }

    protected void setProcessor(TcpAcceptor$TcpProcessor processor) {
        this.__m_Processor = processor;
    }

    protected void setReceiveBufferSize(long cb) {
        this.__m_ReceiveBufferSize = cb;
    }

    protected void setSelector(Selector selector) {
        this.__m_Selector = selector;
    }

    protected void setSendBufferSize(long cb) {
        this.__m_SendBufferSize = cb;
    }

    protected void setServerSocket(ServerSocket socket) {
        this.__m_ServerSocket = socket;
    }

    protected void setServerSocketChannel(ServerSocketChannel channel) {
        this.__m_ServerSocketChannel = channel;
    }

    protected void setServerSocketKey(SelectionKey key) {
        this.__m_ServerSocketKey = key;
    }

    protected void setTcpDelayEnabled(boolean fEnabled) {
        this.__m_TcpDelayEnabled = fEnabled;
    }
}

