/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.connectionManager.initiator;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Comm;
import com.tangosol.coherence.component.comm.Connection;
import com.tangosol.coherence.component.comm.ConnectionManager;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionCloseTask;
import com.tangosol.coherence.component.comm.ConnectionManager$ConnectionEventTask;
import com.tangosol.coherence.component.comm.ConnectionManager$Daemon;
import com.tangosol.coherence.component.comm.ConnectionManager$DaemonPool;
import com.tangosol.coherence.component.comm.ConnectionManager$EventDispatcher;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageDispatchTask;
import com.tangosol.coherence.component.comm.ConnectionManager$MessageExecuteTask;
import com.tangosol.coherence.component.comm.connection.JmsConnection;
import com.tangosol.coherence.component.comm.connectionManager.Initiator;
import com.tangosol.coherence.component.comm.util.JmsUtil;
import com.tangosol.coherence.component.comm.util.JndiUtil;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.util.Map;
import javax.jms.DeliveryMode;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.naming.NamingException;

public class JmsInitiator
extends Initiator
implements ExceptionListener {
    private int __m_MessageDeliveryMode;
    private long __m_MessageExpiration;
    private int __m_MessagePriority;
    private Queue __m_Queue;
    private QueueConnection __m_QueueConnection;
    private String __m_QueueConnectionFactoryName;
    private String __m_QueueName;
    private QueueSender __m_QueueSender;
    private QueueSession __m_QueueSession;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        JmsInitiator.__initStatic();
    }

    public JmsInitiator() {
        this(null, null, true);
    }

    public JmsInitiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new ConnectionManager$Daemon("Daemon", this, true), "Daemon");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"ConnectionCloseTask", (Object)ConnectionManager$ConnectionCloseTask.get_CLASS());
        Object object2 = __mapChildren.put((Object)"ConnectionEventTask", (Object)ConnectionManager$ConnectionEventTask.get_CLASS());
        Object object3 = __mapChildren.put((Object)"DaemonPool", (Object)ConnectionManager$DaemonPool.get_CLASS());
        Object object4 = __mapChildren.put((Object)"EventDispatcher", (Object)ConnectionManager$EventDispatcher.get_CLASS());
        Object object5 = __mapChildren.put((Object)"MessageDispatchTask", (Object)ConnectionManager$MessageDispatchTask.get_CLASS());
        Object object6 = __mapChildren.put((Object)"MessageExecuteTask", (Object)ConnectionManager$MessageExecuteTask.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("javax.jms.Queue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("javax.jms.QueueConnectionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void doConfigure(XmlElement xml) {
        super.doConfigure(xml);
        XmlElement xmlCat = xml.getSafeElement("jms-initiator");
        this.setQueueConnectionFactoryName(this.ensureStringValue(xmlCat, "queue-connection-factory-name", this.getQueueConnectionFactoryName()));
        this.setQueueName(this.ensureStringValue(xmlCat, "queue-name", this.getQueueName()));
        XmlElement xmlVal = xmlCat.getSafeElement("message-delivery-mode");
        if (xmlVal.getString("NON_PERSISTENT").equalsIgnoreCase("PERSISTENT")) {
            this.setMessageDeliveryMode(DeliveryMode.PERSISTENT);
        } else {
            this.setMessageDeliveryMode(DeliveryMode.NON_PERSISTENT);
        }
        this.setMessageExpiration(ConnectionManager.parseTime(xmlCat, "message-expiration", Message.DEFAULT_TIME_TO_LIVE));
        this.setMessagePriority(xmlCat.getSafeElement("message-priority").getInt(Message.DEFAULT_PRIORITY));
        this.setConnectTimeout(ConnectionManager.parseTime(xmlCat, "connect-timeout", this.getRequestTimeout()));
    }

    protected void doStart() {
        QueueSession session;
        QueueConnection connection;
        QueueConnectionFactory factory;
        Queue queue;
        this.setThreadCount(Math.max(this.getThreadCount(), 1));
        super.doStart();
        try {
            queue = (Queue)JndiUtil.lookup(this.getQueueName(), JmsInitiator.__sm0());
            this.setQueue(queue);
        }
        catch (NamingException e) {
            throw Comm.ensureRuntimeException(e, String.valueOf("error retrieving a Queue from JNDI") + " using the name \"" + this.getQueueName() + "\"");
        }
        try {
            factory = (QueueConnectionFactory)JndiUtil.lookup(this.getQueueConnectionFactoryName(), JmsInitiator.__sm1());
        }
        catch (NamingException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, String.valueOf("error retrieving a ") + " QueueConnectionFactory from JNDI using the name \"" + this.getQueueConnectionFactoryName() + "\"");
        }
        try {
            connection = factory.createQueueConnection();
            this.setQueueConnection(connection);
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error creating a QueueConnection");
        }
        try {
            session = connection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
            this.setQueueSession(session);
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error creating a QueueSession");
        }
        try {
            this.setQueueSender(session.createSender(queue));
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error creating a QueueSender");
        }
        try {
            connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error registering an ExceptionListener");
        }
        try {
            connection.start();
        }
        catch (JMSException e) {
            this.doShutdown();
            throw Comm.ensureRuntimeException(e, "error starting a QueueConnection");
        }
    }

    protected void doStop() {
        super.doStop();
        JmsUtil.close((javax.jms.Connection)this.getQueueConnection());
        JmsUtil.close((MessageProducer)this.getQueueSender());
        JmsUtil.close((Session)this.getQueueSession());
        this.setQueue(null);
        this.setQueueConnection(null);
        this.setQueueSender(null);
        this.setQueueSession(null);
    }

    protected String getDescription() {
        String sMode;
        switch (this.getMessageDeliveryMode()) {
            case 2: {
                sMode = "PERSISTENT";
                break;
            }
            case 1: {
                sMode = "NON_PERSISTENT";
                break;
            }
            default: {
                sMode = "UNKNOWN";
            }
        }
        return String.valueOf(super.getDescription()) + ", QueueConnectionFactoryName=" + this.getQueueConnectionFactoryName() + ", QueueName=" + this.getQueueName() + ", MessageExpiration=" + this.getMessageExpiration() + ", MessagePriority=" + this.getMessageDeliveryMode() + ", MessageDeliveryMode=" + sMode;
    }

    public int getMessageDeliveryMode() {
        return this.__m_MessageDeliveryMode;
    }

    public long getMessageExpiration() {
        return this.__m_MessageExpiration;
    }

    public int getMessagePriority() {
        return this.__m_MessagePriority;
    }

    protected Queue getQueue() {
        return this.__m_Queue;
    }

    protected QueueConnection getQueueConnection() {
        return this.__m_QueueConnection;
    }

    protected String getQueueConnectionFactoryName() {
        return this.__m_QueueConnectionFactoryName;
    }

    protected String getQueueName() {
        return this.__m_QueueName;
    }

    protected QueueSender getQueueSender() {
        return this.__m_QueueSender;
    }

    protected QueueSession getQueueSession() {
        return this.__m_QueueSession;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/connectionManager/initiator/JmsInitiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new JmsInitiator();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        QueueSession session;
        Queue queueOut;
        String sId;
        Message message;
        QueueReceiver receiver;
        TemporaryQueue queueIn;
        QueueConnection connection = this.getQueueConnection();
        try {
            queueIn = this.getQueueSession().createTemporaryQueue();
        }
        catch (JMSException e) {
            throw new ConnectionException("error creating a TemporaryQueue", (Throwable)e);
        }
        try {
            receiver = this.getQueueSession().createReceiver((Queue)queueIn);
        }
        catch (JMSException e) {
            JmsUtil.delete((Destination)queueIn);
            throw new ConnectionException("error creating a QueueReceiver", (Throwable)e);
        }
        try {
            message = this.getQueueSession().createMessage();
            message.setJMSDeliveryMode(this.getMessageDeliveryMode());
            message.setJMSExpiration(this.getMessageExpiration());
            message.setJMSPriority(this.getMessagePriority());
            message.setJMSReplyTo((Destination)queueIn);
        }
        catch (JMSException e) {
            JmsUtil.close((MessageConsumer)receiver);
            JmsUtil.delete((Destination)queueIn);
            throw new ConnectionException("error creating a JMS Message", (Throwable)e);
        }
        try {
            this.getQueueSender().send(message);
            sId = message.getJMSMessageID();
        }
        catch (JMSException e) {
            JmsUtil.close((MessageConsumer)receiver);
            JmsUtil.delete((Destination)queueIn);
            throw new ConnectionException("error sending a JMS Message", (Throwable)e);
        }
        try {
            Destination oQueue;
            try {
                Message reply;
                do {
                    if ((reply = receiver.receive(this.getConnectTimeout())) == null) {
                        throw new JMSException(String.valueOf("did not receive a reply within ") + this.getConnectTimeout() + " milliseconds");
                    }
                    oQueue = reply.getJMSReplyTo();
                    if (!(oQueue instanceof Queue)) {
                        throw new JMSException(String.valueOf("received an unexpected reply-to JMS") + " Destination: " + oQueue);
                    }
                    queueOut = (Queue)oQueue;
                } while (Base.equals((Object)sId, (Object)reply.getJMSCorrelationID()) ^ true);
            }
            catch (JMSException e) {
                JmsUtil.delete((Destination)queueIn);
                throw new ConnectionException("error while waiting for a response", (Throwable)e);
            }
            oQueue = null;
        }
        catch (Throwable e) {
            Object oQueue = null;
            JmsUtil.close((MessageConsumer)receiver);
            throw e;
        }
        JmsUtil.close((MessageConsumer)receiver);
        try {
            session = connection.createQueueSession(false, Session.DUPS_OK_ACKNOWLEDGE);
        }
        catch (JMSException e) {
            throw new ConnectionException("error creating a QueueSession", (Throwable)e);
        }
        JmsConnection jmsConnection = new JmsConnection();
        jmsConnection.setQueueIn((Queue)queueIn);
        jmsConnection.setQueueOut(queueOut);
        jmsConnection.setQueueSession(session);
        jmsConnection.setMessageDeliveryMode(this.getMessageDeliveryMode());
        jmsConnection.setMessageExpiration(this.getMessageExpiration());
        jmsConnection.setMessagePriority(this.getMessagePriority());
        Component._trace(String.valueOf("Connected to ") + queueOut, 3);
        return jmsConnection;
    }

    public synchronized void onException(JMSException e) {
        this.onConnectionError(this.getConnection(), e);
    }

    protected void setMessageDeliveryMode(int nMode) {
        this.__m_MessageDeliveryMode = nMode;
    }

    protected void setMessageExpiration(long cMillis) {
        this.__m_MessageExpiration = cMillis;
    }

    protected void setMessagePriority(int nPriority) {
        this.__m_MessagePriority = nPriority;
    }

    protected void setQueue(Queue queue) {
        this.__m_Queue = queue;
    }

    protected void setQueueConnection(QueueConnection connection) {
        this.__m_QueueConnection = connection;
    }

    protected void setQueueConnectionFactoryName(String sName) {
        this.__m_QueueConnectionFactoryName = sName;
    }

    protected void setQueueName(String sName) {
        this.__m_QueueName = sName;
    }

    protected void setQueueSender(QueueSender sender) {
        this.__m_QueueSender = sender;
    }

    protected void setQueueSession(QueueSession session) {
        this.__m_QueueSession = session;
    }
}

