/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.comm.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.comm.Util;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueRequestor;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicRequestor;
import javax.jms.TopicSession;

public abstract class JmsUtil
extends Util {
    public JmsUtil(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static boolean close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                return true;
            }
            catch (JMSException jMSException) {
            }
        }
        return false;
    }

    public static boolean close(MessageConsumer consumer) {
        if (consumer != null) {
            try {
                consumer.close();
                return true;
            }
            catch (JMSException jMSException) {
            }
        }
        return false;
    }

    public static boolean close(MessageProducer producer) {
        if (producer != null) {
            try {
                producer.close();
                return true;
            }
            catch (JMSException jMSException) {
            }
        }
        return false;
    }

    public static boolean close(QueueRequestor requestor) {
        if (requestor != null) {
            try {
                requestor.close();
                return true;
            }
            catch (JMSException jMSException) {
            }
        }
        return false;
    }

    public static boolean close(Session session) {
        if (session != null) {
            try {
                session.close();
                return true;
            }
            catch (JMSException jMSException) {
            }
        }
        return false;
    }

    public static boolean close(TopicRequestor requestor) {
        if (requestor != null) {
            try {
                requestor.close();
                return true;
            }
            catch (JMSException jMSException) {
            }
        }
        return false;
    }

    public static Destination createDestination(Connection connection) throws JMSException {
        Session session;
        TemporaryQueue destination;
        block3: {
            destination = null;
            session = JmsUtil.createSession(connection);
            try {
                if (connection instanceof QueueConnection) {
                    destination = ((QueueSession)session).createTemporaryQueue();
                    break block3;
                }
                if (!(connection instanceof TopicConnection)) break block3;
                destination = ((TopicSession)session).createTemporaryTopic();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                JmsUtil.close(session);
                throw throwable;
            }
        }
        Object var4_3 = null;
        JmsUtil.close(session);
        return destination;
    }

    public static MessageConsumer createMessageConsumer(Connection connection, Session session, Destination destination, String sSelector) throws JMSException {
        QueueReceiver consumer = null;
        if (connection instanceof QueueConnection) {
            Component._assert(destination == null ? true : destination instanceof Queue);
            consumer = ((QueueSession)session).createReceiver((Queue)destination, sSelector);
        } else if (connection instanceof TopicConnection) {
            Component._assert(destination == null ? true : destination instanceof Topic);
            consumer = ((TopicSession)session).createSubscriber((Topic)destination, sSelector, true);
        }
        return consumer;
    }

    public static MessageProducer createMessageProducer(Session session) throws JMSException {
        QueueSender producer = null;
        if (session instanceof QueueSession) {
            producer = ((QueueSession)session).createSender(null);
        } else if (session instanceof TopicSession) {
            producer = ((TopicSession)session).createPublisher(null);
        }
        return producer;
    }

    public static Session createSession(Connection connection) throws JMSException {
        QueueSession session = null;
        if (connection instanceof QueueConnection) {
            session = ((QueueConnection)connection).createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
        } else if (connection instanceof TopicConnection) {
            session = ((TopicConnection)connection).createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
        }
        return session;
    }

    public static boolean delete(Destination destination) {
        if (destination instanceof TemporaryQueue) {
            try {
                ((TemporaryQueue)destination).delete();
                return true;
            }
            catch (JMSException e) {}
        } else if (destination instanceof TemporaryTopic) {
            try {
                ((TemporaryTopic)destination).delete();
                return true;
            }
            catch (JMSException jMSException) {
            }
        }
        return false;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/comm/util/JmsUtil".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public static int readPackedInt(BytesMessage message) throws JMSException {
        int b = message.readUnsignedByte();
        int n = b & 0x3F;
        int cBits = 6;
        boolean fNeg = (b & 0x40) != 0;
        while ((b & 0x80) != 0) {
            b = message.readUnsignedByte();
            n |= (b & 0x7F) << cBits;
            cBits += 7;
        }
        if (fNeg) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    public static void send(MessageProducer producer, Destination destination, Message message, int nDeliveryMode, int nPriority, long cExpiry) throws JMSException {
        if (destination == null) {
            if (producer instanceof QueueSender) {
                ((QueueSender)producer).send(message, nDeliveryMode, nPriority, cExpiry);
            } else if (producer instanceof TopicPublisher) {
                ((TopicPublisher)producer).publish(message, nDeliveryMode, nPriority, cExpiry);
            }
        } else if (producer instanceof QueueSender) {
            Component._assert(destination instanceof Queue);
            ((QueueSender)producer).send((Queue)destination, message, nDeliveryMode, nPriority, cExpiry);
        } else if (producer instanceof TopicPublisher) {
            Component._assert(destination instanceof Topic);
            ((TopicPublisher)producer).publish((Topic)destination, message, nDeliveryMode, nPriority, cExpiry);
        }
    }

    public static void send(MessageProducer producer, Message message, int nDeliveryMode, int nPriority, long cExpiry) throws JMSException {
        JmsUtil.send(producer, null, message, nDeliveryMode, nPriority, cExpiry);
    }

    public static void writePackedInt(BytesMessage message, int n) throws JMSException {
        int b = 0;
        if (n < 0) {
            b = 64;
            n ^= 0xFFFFFFFF;
        }
        b |= (byte)(n & 0x3F);
        n >>>= 6;
        while (n != 0) {
            message.writeByte((byte)(b |= 0x80));
            b = n & 0x7F;
            n >>>= 7;
        }
        message.writeByte((byte)b);
    }
}

