/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$ClusterService;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher$AckQueue;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher$ConfirmationQueue;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher$InQueue;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher$MemberSet;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher$ResendQueue;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher$UdpPacketPool;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$OutgoingMessageArray;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Cluster$PacketPublisher
extends PacketPublisher {
    public Cluster$PacketPublisher() {
        this(null, null, true);
    }

    public Cluster$PacketPublisher(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAckdPacketListTemp((List)new RecyclingLinkedList());
            this.setCloggedCount(1024);
            this.setCloggedDelay(32);
            this.setDaemonState(0);
            this.setLostPacketListTemp((List)new RecyclingLinkedList());
            this.setMulticastEnabled(true);
            this.setMulticastThreshold(0.25);
            this.setSingleMemberSetTemp(new SingleMemberSet());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new Cluster$PacketPublisher$AckQueue("AckQueue", this, true), "AckQueue");
        this._addChild(new Cluster$PacketPublisher$ConfirmationQueue("ConfirmationQueue", this, true), "ConfirmationQueue");
        this._addChild(new Cluster$PacketPublisher$InQueue("InQueue", this, true), "InQueue");
        this._addChild(new Cluster$PacketPublisher$MemberSet("MemberSet", this, true), "MemberSet");
        this._addChild(new PacketPublisher$OutgoingMessageArray("OutgoingMessageArray", this, true), "OutgoingMessageArray");
        this._addChild(new Cluster$PacketPublisher$ResendQueue("ResendQueue", this, true), "ResendQueue");
        this._addChild(new Cluster$PacketPublisher$UdpPacketPool("UdpPacketPool", this, true), "UdpPacketPool");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster$PacketPublisher".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Cluster$PacketPublisher();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void onException(Throwable e) {
        ((Cluster)this.get_Module()).onException(e);
    }

    public void onSlowPacket(MessagePacket packet) {
        Cluster cluster = (Cluster)this.get_Module();
        Cluster$ClusterService service = cluster.getClusterService();
        int nToId = packet.getToId();
        if (nToId != 0) {
            service.verifyMemberSlow(this.getMember(nToId), packet);
        } else {
            DependentMemberSet setToMember = packet.getToMemberSet();
            if (setToMember != null) {
                Iterator iter = setToMember.iterator();
                while (iter.hasNext()) {
                    Member member = (Member)iter.next();
                    service.verifyMemberSlow(member, packet);
                }
            }
        }
    }

    public void onUndeliverablePacket(MessagePacket packet) {
        Cluster cluster = (Cluster)this.get_Module();
        Cluster$ClusterService service = cluster.getClusterService();
        LinkedList<Member> listDead = new LinkedList<Member>();
        int nToId = packet.getToId();
        if (nToId != 0) {
            Member member = this.getMember(nToId);
            if (service.verifyMemberLeft(member, packet)) {
                listDead.add(member);
                packet.setToId(0);
            }
        } else {
            DependentMemberSet setToMember = packet.getToMemberSet();
            if (setToMember != null) {
                Iterator iter = setToMember.iterator();
                while (iter.hasNext()) {
                    Member member = (Member)iter.next();
                    if (!service.verifyMemberLeft(member, packet)) continue;
                    listDead.add(member);
                    try {
                        iter.remove();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        Iterator iter = listDead.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(member != null)) continue;
            service.doMemberLeft(member);
        }
    }

    public void setStatsCpu(long cMillis) {
        super.setStatsCpu(cMillis);
    }

    public void setStatsSent(long cPackets) {
        super.setStatsSent(cPackets);
    }
}

