/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$SocketManager$MulticastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$TcpSocketAccepter;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class Cluster$SocketManager
extends Util {
    private transient int __m_AttemptCount;
    private Collection __m_RegisteredSockets;

    public Cluster$SocketManager() {
        this(null, null, true);
    }

    public Cluster$SocketManager(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setRegisteredSockets((Collection)new SafeLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new Cluster$SocketManager$MulticastUdpSocket("MulticastUdpSocket", this, true), "MulticastUdpSocket");
        this._addChild(new Cluster$SocketManager$TcpSocketAccepter("TcpSocketAccepter", this, true), "TcpSocketAccepter");
        this._addChild(new Cluster$SocketManager$UnicastUdpSocket("UnicastUdpSocket", this, true), "UnicastUdpSocket");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private void forceGC() {
        Runtime.getRuntime().gc();
        Thread.yield();
        try {
            Thread.sleep(50);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getAttemptCount() {
        return this.__m_AttemptCount;
    }

    public Cluster$SocketManager$MulticastUdpSocket getMulticastUdpSocket() {
        return (Cluster$SocketManager$MulticastUdpSocket)this._findChild("MulticastUdpSocket");
    }

    public Collection getRegisteredSockets() {
        return this.__m_RegisteredSockets;
    }

    public Cluster$SocketManager$TcpSocketAccepter getTcpSocketAccepter() {
        return (Cluster$SocketManager$TcpSocketAccepter)this._findChild("TcpSocketAccepter");
    }

    public Cluster$SocketManager$UnicastUdpSocket getUnicastUdpSocket() {
        return (Cluster$SocketManager$UnicastUdpSocket)this._findChild("UnicastUdpSocket");
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster$SocketManager".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Cluster$SocketManager();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshSockets(IOException eCause, Socket socketCause) {
        Collection collection;
        Cluster cluster = (Cluster)this.get_Module();
        Socket socket = socketCause;
        Exception eLast = eCause;
        long lTimeout = 0L;
        Collection collection2 = collection = this.getRegisteredSockets();
        synchronized (collection2) {
            int cMaxTries = 8;
            if (socketCause instanceof UdpSocket) {
                UdpSocket socketUdp = (UdpSocket)socketCause;
                if (socketUdp.getCountReceived() == 0 ? true : socketUdp.getCountSent() == 0) {
                    int cAttempts = this.getAttemptCount() + 1;
                    this.setAttemptCount(cAttempts);
                    cMaxTries -= cAttempts;
                } else {
                    this.setAttemptCount(0);
                }
            }
            String sMsgLast = null;
            int iTry = 0;
            while (iTry < cMaxTries) {
                try {
                    if (collection.isEmpty()) {
                        return;
                    }
                    String sMsg = String.valueOf("Attempt to refresh sockets: ") + collection + " caused by " + socket + "; exception " + Component.getStackTrace(eLast);
                    Iterator iter = collection.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            if (cluster.getState() < Cluster.STATE_STOPPING) break;
                            return;
                        }
                        socket = (Socket)iter.next();
                        if (lTimeout == 0L) {
                            lTimeout = Base.getSafeTimeMillis() + (long)socket.getReopenTimeout();
                        }
                        socket.close();
                    }
                    boolean bl = true;
                    if (!bl) return;
                    if (sMsg.equals(sMsgLast) ^ true) {
                        Component._trace(sMsg, 5);
                        sMsgLast = sMsg;
                    }
                    this.forceGC();
                    iter = collection.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            return;
                        }
                        socket = (Socket)iter.next();
                        socket.open();
                    }
                }
                catch (Exception e) {
                    eLast = e;
                    this.forceGC();
                    Component._assert(lTimeout != 0L);
                    if (Base.getSafeTimeMillis() > lTimeout) throw new ConnectionException(String.valueOf("Unable to refresh sockets: ") + collection + "; last failed socket: " + socket, (Throwable)eLast);
                    ++iTry;
                }
            }
            throw new ConnectionException(String.valueOf("Unable to refresh sockets: ") + collection + "; last failed socket: " + socket, (Throwable)eLast);
        }
    }

    public void registerSocket(Socket socket) {
        Collection collection;
        Component._assert(socket != null);
        Collection collection2 = collection = this.getRegisteredSockets();
        synchronized (collection2) {
            socket.setLock(collection);
            if (collection.contains(socket) ^ true) {
                collection.add(socket);
            }
        }
    }

    public void releaseSockets() {
        Collection collection;
        Collection collection2 = collection = this.getRegisteredSockets();
        synchronized (collection2) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                Socket socket = (Socket)iter.next();
                socket.close();
            }
            collection.clear();
        }
    }

    protected void setAttemptCount(int c) {
        this.__m_AttemptCount = c;
    }

    protected void setRegisteredSockets(Collection collection) {
        this.__m_RegisteredSockets = collection;
    }

    public void unregisterSocket(Socket socket) {
        Collection collection;
        Collection collection2 = collection = this.getRegisteredSockets();
        synchronized (collection2) {
            collection.remove(socket);
        }
    }
}

