/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Cluster$ClusterConfig;
import com.tangosol.coherence.component.net.Cluster$ClusterService;
import com.tangosol.coherence.component.net.Cluster$DaemonPool;
import com.tangosol.coherence.component.net.Cluster$PacketListener1;
import com.tangosol.coherence.component.net.Cluster$PacketListenerN;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher;
import com.tangosol.coherence.component.net.Cluster$PacketReceiver;
import com.tangosol.coherence.component.net.Cluster$PacketSpeaker;
import com.tangosol.coherence.component.net.Cluster$ShutdownHook;
import com.tangosol.coherence.component.net.Cluster$SocketManager;
import com.tangosol.coherence.component.net.Cluster$SocketManager$MulticastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$TcpSocketAccepter;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$TcpRingListener;
import com.tangosol.coherence.component.net.ClusterConfig;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.socket.TcpSocketAccepter;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.TcpRingListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.net.ClusterException;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.Service;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Cluster
extends Net
implements com.tangosol.net.Cluster {
    public static final int STATE_EXITED = 6;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_JOINING = 2;
    public static final int STATE_LEAVING = 4;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_STARTING = 1;
    public static final int STATE_STOPPING = 5;
    private String __m_ClusterName;
    private Cluster$ClusterService __m_ClusterService;
    private ClusterConfig __m_Config;
    private DaemonPool __m_DaemonPool;
    private transient Registry __m_Management;
    private Cluster$PacketListenerN __m_MultiListener;
    private Cluster$PacketListener1 __m_PointListener;
    private Cluster$PacketPublisher __m_Publisher;
    private Cluster$PacketReceiver __m_Receiver;
    private Cluster$PacketSpeaker __m_Speaker;
    private Throwable __m_StartException;
    private volatile int __m_State;
    private Cluster$TcpRingListener __m_TcpRingListener;
    private ThreadGroup __m_ThreadGroup;

    public Cluster() {
        this(null, null, true);
    }

    public Cluster(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new Cluster$ClusterConfig("ClusterConfig", this, true), "ClusterConfig");
        this._addChild(new Cluster$ClusterService("ClusterService", this, true), "ClusterService");
        this._addChild(new Cluster$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Cluster$PacketListener1("PacketListener1", this, true), "PacketListener1");
        this._addChild(new Cluster$PacketListenerN("PacketListenerN", this, true), "PacketListenerN");
        this._addChild(new Cluster$PacketPublisher("PacketPublisher", this, true), "PacketPublisher");
        this._addChild(new Cluster$PacketReceiver("PacketReceiver", this, true), "PacketReceiver");
        this._addChild(new Cluster$PacketSpeaker("PacketSpeaker", this, true), "PacketSpeaker");
        this._addChild(new Cluster$ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
        this._addChild(new Cluster$SocketManager("SocketManager", this, true), "SocketManager");
        this._addChild(new Cluster$TcpRingListener("TcpRingListener", this, true), "TcpRingListener");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public synchronized void configure(XmlElement xml) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot configure a running cluster");
        }
        if (xml != null) {
            this.getConfig().fromXml(xml);
        }
    }

    public Service ensureService(String sName, String sType) {
        com.tangosol.coherence.component.util.daemon.queueProcessor.Service service;
        block17: {
            if (sName == null ? true : sName.length() == 0) {
                throw new IllegalArgumentException(String.valueOf("Invalid service name: ") + sName);
            }
            service = (com.tangosol.coherence.component.util.daemon.queueProcessor.Service)this.getService(sName);
            if (!(service == null ? true : service.isRunning() ^ true)) break block17;
            Cluster cluster = this;
            synchronized (cluster) {
                block19: {
                    block18: {
                        if (!(service == null)) break block18;
                        service = (com.tangosol.coherence.component.util.daemon.queueProcessor.Service)this.getService(sName);
                        break block19;
                    }
                    int cTries = 10;
                    while (true) {
                        com.tangosol.coherence.component.util.daemon.queueProcessor.Service service2 = service;
                        synchronized (service2) {
                            service = (com.tangosol.coherence.component.util.daemon.queueProcessor.Service)this.getService(sName);
                            if (service == null ? true : service.isRunning()) {
                                Object var7_9 = null;
                                break;
                            }
                        }
                        if (--cTries == 0) {
                            throw new IllegalStateException(String.valueOf("Failed to unregister: ") + service);
                        }
                        Thread.yield();
                    }
                }
                if (service == null) {
                    List listFilter;
                    String sComponent = (String)this.getConfig().getServiceMap().get(sType);
                    if (sComponent != null) {
                        try {
                            service = (com.tangosol.coherence.component.util.daemon.queueProcessor.Service)Component._newInstance(String.valueOf("Component.Util.Daemon.QueueProcessor.Service.") + sComponent);
                        }
                        catch (SecurityException e) {
                            throw Base.ensureRuntimeException(null, (String)(String.valueOf(sType) + " service: " + e.getMessage()));
                        }
                    }
                    if (service == null) {
                        throw new IllegalArgumentException(String.valueOf("Unknown service type: ") + sType);
                    }
                    service.setServiceName(sName);
                    service.setCluster(this);
                    service.setThreadGroup(this.getThreadGroup());
                    ClusterConfig config = this.getConfig();
                    List listNames = (List)config.getServiceFilterMap().get(sType);
                    if ((!(listNames != null) ? false : listNames.isEmpty() ^ true) && (listFilter = this.instantiateWrapperStreamFactoryList(listNames)).isEmpty() ^ true) {
                        service.setWrapperStreamFactoryList((List)new ImmutableArrayList((Collection)listFilter));
                    }
                }
            }
        }
        if (service.getServiceType().equals(sType) ^ true) {
            throw new IllegalArgumentException(String.valueOf("Requested service type \"") + sType + "\", but the existing service has type \"" + service.getServiceType() + '\"');
        }
        return service;
    }

    public void ensureStopped() {
        if (this.getState() != STATE_EXITED) {
            long ldtTimeout = Base.getSafeTimeMillis() + (long)(4 * this.getConfig().getClusterHeartbeatDelay());
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException((Throwable)e);
                }
                if (!(this.getState() == STATE_EXITED)) continue;
                return;
            } while (!(Base.getSafeTimeMillis() >= ldtTimeout));
            throw new ClusterException("Timeout while waiting for cluster to stop.");
        }
    }

    public String formatPointToPointStats() {
        MasterMemberSet members = this.getPublisher().getMemberSet();
        Member memberThis = members.getThisMember();
        StringBuffer sb = new StringBuffer();
        try {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(!(member != null) ? false : member != memberThis)) continue;
                sb.append('\n').append(member.formatStats());
            }
        }
        catch (ConcurrentModificationException e) {}
        return sb.toString();
    }

    public String formatStats() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nPacketPublisher: ").append(this.getPublisher().formatStats()).append("\nPacketSpeaker  : ").append(this.getSpeaker().formatStats()).append("\nPacketReceiver : ").append(this.getReceiver().formatStats());
        Cluster$TcpRingListener tcplistener = this.getTcpRingListener();
        if (tcplistener.isStarted()) {
            sb.append("\nTcpRing        : ").append(tcplistener.formatStats());
        }
        return sb.toString();
    }

    public String getClusterName() {
        return this.__m_ClusterName;
    }

    public Cluster$ClusterService getClusterService() {
        return this.__m_ClusterService;
    }

    public ClusterConfig getConfig() {
        return this.__m_Config;
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public DaemonPool getDaemonPool() {
        DaemonPool pool = this.__m_DaemonPool;
        if (pool == null) {
            pool = (DaemonPool)this._findChild("DaemonPool");
            this.setDaemonPool(pool);
        }
        return pool;
    }

    public com.tangosol.net.Member getLocalMember() {
        return this.getClusterService().getClusterMemberSet().getThisMember();
    }

    public Registry getManagement() {
        return this.__m_Management;
    }

    public Set getMemberSet() {
        return this.getClusterService().getClusterMemberSet();
    }

    public Cluster$PacketListenerN getMultiListener() {
        return this.__m_MultiListener;
    }

    public com.tangosol.net.Member getOldestMember() {
        return this.getClusterService().getClusterOldestMember();
    }

    public Cluster$PacketListener1 getPointListener() {
        return this.__m_PointListener;
    }

    public Cluster$PacketPublisher getPublisher() {
        return this.__m_Publisher;
    }

    public Cluster$PacketReceiver getReceiver() {
        return this.__m_Receiver;
    }

    public Service getService(String sName) {
        return this.getClusterService().getService(sName);
    }

    public com.tangosol.net.ServiceInfo getServiceInfo(String sName) {
        return this.getClusterService().getServiceInfo(sName);
    }

    public Enumeration getServiceNames() {
        ArrayList<String> list = new ArrayList<String>();
        Cluster$ClusterService daemonClusterService = this.getClusterService();
        int cServices = daemonClusterService.getServiceInfoCount();
        int i = 0;
        while (i < cServices) {
            ServiceInfo info = daemonClusterService.getServiceInfo(i);
            if (info != null) {
                list.add(info.getServiceName());
            }
            ++i;
        }
        return new SimpleEnumerator((Object[])list.toArray(new String[list.size()]));
    }

    public Cluster$SocketManager getSocketManager() {
        return (Cluster$SocketManager)this._findChild("SocketManager");
    }

    public Cluster$PacketSpeaker getSpeaker() {
        return this.__m_Speaker;
    }

    public Throwable getStartException() {
        return this.__m_StartException;
    }

    public int getState() {
        return this.__m_State;
    }

    public Cluster$TcpRingListener getTcpRingListener() {
        return this.__m_TcpRingListener;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public long getTimeMillis() {
        return this.getClusterService().getTimestamp();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Cluster();
    }

    private final Component get_Module() {
        return this;
    }

    protected List instantiateWrapperStreamFactoryList(List listNames) {
        ArrayList<WrapperStreamFactory> listFilter = new ArrayList<WrapperStreamFactory>();
        ClusterConfig config = this.getConfig();
        Map mapClasses = config.getFilterMap();
        Map mapConfig = config.getFilterConfigMap();
        Iterator iter = listNames.iterator();
        while (iter.hasNext()) {
            XmlElement xmlConfig;
            WrapperStreamFactory factory;
            Class<?> clz;
            String sName = (String)iter.next();
            String sClass = (String)mapClasses.get(sName);
            if (sClass == null) {
                Component._trace(String.valueOf("Cannot find WrapperStreamFactory class name for filter-name: ") + sName, 1);
                continue;
            }
            try {
                clz = Class.forName(sClass);
            }
            catch (Throwable e) {
                Component._trace(String.valueOf("Cannot load filter class: \"") + sClass + '\"', 1);
                Component._trace(e);
                continue;
            }
            try {
                factory = (WrapperStreamFactory)clz.newInstance();
            }
            catch (Throwable e) {
                Component._trace(String.valueOf("Cannot instantiate WrapperStreamFactory class: ") + clz.getName(), 1);
                continue;
            }
            if (factory instanceof XmlConfigurable && (xmlConfig = (XmlElement)mapConfig.get(sName)) != null) {
                ((XmlConfigurable)factory).setConfig(xmlConfig);
            }
            listFilter.add(factory);
        }
        return listFilter;
    }

    public boolean isRunning() {
        while (true) {
            switch (this.getState()) {
                case 3: {
                    return true;
                }
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    return false;
                }
            }
            Cluster cluster = this;
            synchronized (cluster) {
                try {
                    this.wait(1000);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    boolean bl = this.getState() == STATE_RUNNING;
                    Object var4_4 = null;
                    return bl;
                }
            }
        }
    }

    public synchronized void onException(Throwable e) {
        int nState = this.getState();
        if (nState < STATE_RUNNING) {
            this.setStartException(e);
        }
        if (nState < STATE_STOPPING) {
            Component._trace(e, "Stopping cluster due to unhandled exception");
            this.stop();
        }
    }

    public void onInit() {
        super.onInit();
        this.setPointListener((Cluster$PacketListener1)this._findName("PacketListener1"));
        this.setMultiListener((Cluster$PacketListenerN)this._findName("PacketListenerN"));
        this.setReceiver((Cluster$PacketReceiver)this._findName("PacketReceiver"));
        this.setPublisher((Cluster$PacketPublisher)this._findName("PacketPublisher"));
        this.setSpeaker((Cluster$PacketSpeaker)this._findName("PacketSpeaker"));
        this.setConfig((Cluster$ClusterConfig)this._findName("ClusterConfig"));
        this.setClusterService((Cluster$ClusterService)this._findName("ClusterService"));
        this.setTcpRingListener((Cluster$TcpRingListener)this._findName("TcpRingListener"));
    }

    protected void onStart() {
        List listFilter;
        List listFilterNames;
        ClusterConfig config = this.getConfig();
        Component._assert(config != null, "super.onInit() has not been called");
        config.setReadOnly(true);
        if (config.isConfigured() ^ true) {
            throw new IllegalArgumentException("Incomplete Config!");
        }
        if (config.isTcmpEnabled() ^ true) {
            throw new UnsupportedOperationException(String.valueOf("TCMP clustering has been disabled;") + " this configuration may only access clustered services via Extend" + " proxies.");
        }
        Security.getInstance();
        this.setClusterName(config.getClusterName());
        int cbPacket = config.getPacketMaxLength();
        int cbPacketPref = config.getPacketPreferredLength();
        int cBufferSentPackets = config.getPublisherBufferFactor();
        InetAddress addrLocal = config.getLocalAddress();
        if (InetAddressHelper.isLoopbackAddress((InetAddress)addrLocal)) {
            Component._trace(String.valueOf("Local address \"") + InetAddressHelper.toString((InetAddress)addrLocal) + "\" is a loopback address; this cluster node will not connect" + " to nodes located on different machines", 2);
        }
        int nPortLocal = config.getLocalPort();
        Cluster$SocketManager$UnicastUdpSocket udpsocketUnicast = this.getSocketManager().getUnicastUdpSocket();
        udpsocketUnicast.setInetAddress(addrLocal);
        udpsocketUnicast.setPort(nPortLocal);
        udpsocketUnicast.setPortAutoSelect(config.isLocalPortAuto());
        udpsocketUnicast.setPacketLength(cbPacket);
        udpsocketUnicast.setBufferSent(cBufferSentPackets);
        udpsocketUnicast.setBufferReceived(config.getLocalBufferFactor());
        try {
            ((UdpSocket)udpsocketUnicast).open();
        }
        catch (IOException e) {
            throw new WrapperException((Throwable)e, udpsocketUnicast.toString());
        }
        nPortLocal = udpsocketUnicast.getPort();
        InetAddress addrInterface = config.getGroupInterface();
        if (addrInterface == null) {
            addrInterface = addrLocal;
        }
        Cluster$SocketManager$MulticastUdpSocket udpsocketMulticast = null;
        if (config.getWellKnownAddressList().isEmpty()) {
            udpsocketMulticast = this.getSocketManager().getMulticastUdpSocket();
            udpsocketMulticast.setInterfaceInetAddress(addrInterface);
            udpsocketMulticast.setInetAddress(config.getGroupAddress());
            udpsocketMulticast.setPort(config.getGroupPort());
            udpsocketMulticast.setTimeToLive(config.getGroupTimeToLive());
            udpsocketMulticast.setPacketLength(cbPacket);
            udpsocketMulticast.setBufferSent(cBufferSentPackets);
            udpsocketMulticast.setBufferReceived(config.getGroupBufferFactor());
            try {
                ((UdpSocket)udpsocketMulticast).open();
            }
            catch (IOException e) {
                throw new WrapperException((Throwable)e, udpsocketMulticast.toString());
            }
        }
        Cluster$SocketManager$TcpSocketAccepter tcpsocketAccepter = null;
        boolean fTcpRingEnabled = config.isTcpRingEnabled();
        if (fTcpRingEnabled) {
            tcpsocketAccepter = this.getSocketManager().getTcpSocketAccepter();
            tcpsocketAccepter.setInetAddress(udpsocketUnicast.getInetAddress());
            tcpsocketAccepter.setPort(udpsocketUnicast.getPort());
            tcpsocketAccepter.setPortAutoSelect(false);
            try {
                ((TcpSocketAccepter)tcpsocketAccepter).open();
            }
            catch (IOException e) {
                throw new WrapperException((Throwable)e, tcpsocketAccepter.toString());
            }
        }
        Cluster$PacketListener1 daemonPointListener = this.getPointListener();
        Cluster$PacketListenerN daemonMultiListener = this.getMultiListener();
        Cluster$PacketReceiver daemonReceiver = this.getReceiver();
        Cluster$PacketPublisher daemonPublisher = this.getPublisher();
        Cluster$PacketSpeaker daemonSpeaker = this.getSpeaker();
        Cluster$ClusterService daemonClusterService = this.getClusterService();
        Cluster$TcpRingListener daemonTcpRingListener = this.getTcpRingListener();
        ThreadGroup group = this.getThreadGroup();
        if (group == null) {
            group = new ThreadGroup(this.get_Name());
            group.setDaemon(true);
            this.setThreadGroup(group);
        }
        daemonPointListener.setThreadGroup(group);
        daemonMultiListener.setThreadGroup(group);
        daemonReceiver.setThreadGroup(group);
        daemonPublisher.setThreadGroup(group);
        daemonClusterService.setThreadGroup(group);
        daemonTcpRingListener.setThreadGroup(group);
        daemonSpeaker.setThreadGroup(group);
        daemonPointListener.setPriority(config.getLocalListenerPriority());
        daemonMultiListener.setPriority(config.getGroupListenerPriority());
        daemonReceiver.setPriority(config.getReceiverPriority());
        daemonSpeaker.setPriority(config.getSpeakerPriority());
        daemonPublisher.setPriority(config.getPublisherPriority());
        MasterMemberSet setMember = daemonClusterService.getClusterMemberSet();
        Member member = daemonClusterService.instantiateMember();
        member.configure(config, addrLocal, nPortLocal);
        daemonClusterService.setAnnounceMember(member);
        daemonPointListener.setMemberSet(setMember);
        daemonMultiListener.setMemberSet(setMember);
        daemonReceiver.setMemberSet(setMember);
        daemonPublisher.setMemberSet(setMember);
        daemonSpeaker.setMemberSet(setMember);
        daemonPointListener.setUdpPacketPool(daemonReceiver.getUdpPacketPool());
        daemonPointListener.setUdpSocket(udpsocketUnicast);
        daemonPointListener.setReceiveQueue(daemonReceiver.getQueue());
        daemonMultiListener.setUdpPacketPool(daemonReceiver.getUdpPacketPool());
        daemonMultiListener.setUdpSocket(udpsocketMulticast);
        daemonMultiListener.setReceiveQueue(daemonReceiver.getQueue());
        daemonReceiver.setAckSendQueue(daemonPublisher.getAckQueue());
        daemonReceiver.setConfirmationQueue(daemonPublisher.getConfirmationQueue());
        daemonReceiver.setService(0, daemonClusterService);
        daemonReceiver.setMaximumPacketLength(cbPacket);
        daemonReceiver.setPreferredPacketLength(cbPacketPref);
        daemonReceiver.getUdpPacketPool().setCapacity(config.getReceiverPacketPoolCapacity());
        daemonReceiver.getUdpPacketPool().grow(config.getReceiverPacketPoolInitialSize());
        daemonReceiver.setNackEnabled(config.isReceiverNackEnabled());
        daemonReceiver.setPublisher(daemonPublisher);
        PacketSpeaker$BundlingQueue queueSpeaker = (PacketSpeaker$BundlingQueue)daemonSpeaker.getQueue();
        int nVolume = config.getSpeakerVolumeMinimum();
        daemonSpeaker.setUdpPacketPool(daemonPublisher.getUdpPacketPool());
        daemonSpeaker.setMaximumPacketLength(cbPacket);
        daemonSpeaker.setPreferredPacketLength(config.getPacketPreferredLength());
        daemonSpeaker.setBurstCount(config.getPublisherBurstCount());
        daemonSpeaker.setBurstDelay(config.getPublisherBurstDelay());
        queueSpeaker.setVolumeTunable(nVolume < 0);
        queueSpeaker.setVolumeThreshold(nVolume < 0 ? udpsocketUnicast.getActualBufferSent() : nVolume);
        if (queueSpeaker.isBundlingEnabled()) {
            queueSpeaker.setDeferralThresholdNanos(config.getPacketBundlingThresholdNanos());
            queueSpeaker.setBundlingAggression(config.getPacketBundlingAggression());
        }
        daemonPublisher.setUdpSocketUnicast(udpsocketUnicast);
        daemonPublisher.setUdpSocketMulticast(udpsocketMulticast);
        daemonPublisher.setSendQueue(daemonSpeaker.getQueue());
        daemonPublisher.setMaximumPacketLength(cbPacket);
        daemonPublisher.setPreferredPacketLength(cbPacketPref);
        daemonPublisher.setNackEnabled(config.isReceiverNackEnabled());
        daemonPublisher.setNackDelayMillis(config.getPublisherNackDelay());
        daemonPublisher.getUdpPacketPool().setCapacity(config.getPublisherPacketPoolCapacity());
        daemonPublisher.getUdpPacketPool().grow(config.getPublisherPacketPoolInitialSize());
        if (config.isFlowControlEnabled()) {
            daemonPublisher.setDeferredReadyQueue(new Queue());
            Member$FlowControl.setEnabled(true);
            int iMax = config.getOutstandingPacketMaximum();
            int iMin = config.getOutstandingPacketMinimum();
            Member$FlowControl.setOutstandingPacketMaximum(iMax);
            Member$FlowControl.setOutstandingPacketMinimum(iMin);
            Member$FlowControl.setLostPacketThreshold(config.getLostPacketThreshold());
        }
        if ((!((listFilterNames = config.getFilterList()) != null) ? false : listFilterNames.isEmpty() ^ true) && (listFilter = this.instantiateWrapperStreamFactoryList(listFilterNames)).isEmpty() ^ true) {
            daemonPublisher.setWrapperStreamFactoryList((List)new ImmutableArrayList((Collection)listFilter));
        }
        int cMillisDelay = config.getPublisherResendDelay();
        daemonPublisher.setResendDelay(cMillisDelay);
        int cMillisTimeout = config.getPublisherResendTimeout();
        daemonPublisher.setResendTimeout(cMillisTimeout);
        daemonPublisher.setAckDelay(config.getPublisherAckDelay());
        daemonPublisher.setCloggedCount(config.getPublisherCloggedCount());
        daemonPublisher.setCloggedDelay(config.getPublisherCloggedDelay());
        daemonPublisher.setMulticastThreshold((double)config.getPublisherGroupThreshold() / 100.0);
        if (config.getWellKnownAddressList().isEmpty() ^ true) {
            daemonPublisher.setWellKnownAddressList(config.getWellKnownAddressList());
        }
        daemonClusterService.setCluster(this);
        daemonClusterService.setBroadcastRepeatMillis(cMillisDelay);
        setMember.setRecycleMillis(cMillisTimeout * 4);
        daemonClusterService.setTimestampMaxVariance(config.getClusterTimestampMaxVariance());
        if (udpsocketMulticast != null) {
            daemonMultiListener.start();
        }
        daemonPointListener.start();
        daemonReceiver.start();
        daemonPublisher.start();
        daemonSpeaker.start();
        this.setState(STATE_JOINING);
        daemonClusterService.setBroadcastTimeoutMillis(config.getClusterAnnounceTimeout());
        daemonClusterService.setHeartbeatDelay(config.getClusterHeartbeatDelay());
        daemonClusterService.start();
        if (fTcpRingEnabled) {
            ObservableMap mapConfig = daemonClusterService.getThisMemberConfigMap();
            InetAddress address = tcpsocketAccepter.getInetAddress();
            int nPort = tcpsocketAccepter.getPort();
            mapConfig.put(TcpRingListener.KEY_ADDRESS, address.getAddress());
            mapConfig.put(TcpRingListener.KEY_PORT, Base.makeInteger((int)nPort));
            mapConfig.put(TcpRingListener.KEY_POINTS, Base.makeInteger((int)0));
            daemonTcpRingListener.setSocketAccepter(tcpsocketAccepter);
            int nTcpRingPriority = config.getTcpRingPriority();
            int nTcpRingMaxExceptions = config.getTcpRingExceptionMaximum();
            daemonTcpRingListener.setPriority(nTcpRingPriority);
            daemonTcpRingListener.setMaxExceptions(nTcpRingMaxExceptions);
            daemonTcpRingListener.setService(daemonClusterService);
            daemonTcpRingListener.start();
        }
        this.setState(STATE_RUNNING);
        int nShutdownOption = config.getShutdownHookOption();
        if (nShutdownOption != ClusterConfig.SHUTDOWN_NONE) {
            try {
                Cluster$ShutdownHook hook = (Cluster$ShutdownHook)this._findName("ShutdownHook");
                hook.setGraceful(nShutdownOption == ClusterConfig.SHUTDOWN_GRACEFUL);
                hook.register();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        Enumeration enumeration = this._enumChildrenInOrder();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(!(o instanceof com.tangosol.coherence.component.util.daemon.queueProcessor.Service) ? false : o != daemonClusterService)) continue;
            com.tangosol.coherence.component.util.daemon.queueProcessor.Service service = (com.tangosol.coherence.component.util.daemon.queueProcessor.Service)o;
            this.startService(service);
        }
    }

    public void resetPointToPointStats() {
        try {
            Iterator iter = this.getPublisher().getMemberSet().iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(member != null)) continue;
                member.resetStats();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    public void resetStats() {
        this.getPointListener().resetStats();
        this.getMultiListener().resetStats();
        this.getSpeaker().resetStats();
        this.getPublisher().resetStats();
        this.getReceiver().resetStats();
        this.getTcpRingListener().resetStats();
    }

    protected void setClusterName(String sClusterName) {
        Component._assert(sClusterName != null);
        if (this.getClusterService().isStarted()) {
            throw new IllegalStateException("Cluster name cannot be changed.");
        }
        this.__m_ClusterName = sClusterName;
    }

    private void setClusterService(Cluster$ClusterService daemon) {
        this.__m_ClusterService = daemon;
    }

    public void setConfig(ClusterConfig config) {
        this.__m_Config = config;
    }

    public void setContextClassLoader(ClassLoader loader) {
    }

    protected void setDaemonPool(DaemonPool pool) {
        this.__m_DaemonPool = pool;
    }

    public void setManagement(Registry registry) {
        this.__m_Management = registry;
    }

    private void setMultiListener(Cluster$PacketListenerN daemon) {
        this.__m_MultiListener = daemon;
    }

    private void setPointListener(Cluster$PacketListener1 daemon) {
        this.__m_PointListener = daemon;
    }

    private void setPublisher(Cluster$PacketPublisher daemon) {
        this.__m_Publisher = daemon;
    }

    private void setReceiver(Cluster$PacketReceiver daemon) {
        this.__m_Receiver = daemon;
    }

    public void setSpeaker(Cluster$PacketSpeaker pSpeaker) {
        this.__m_Speaker = pSpeaker;
    }

    public void setStartException(Throwable e) {
        if (this.getStartException() == null) {
            this.__m_StartException = e;
        }
    }

    protected synchronized void setState(int nState) {
        this.__m_State = nState;
        this.notifyAll();
    }

    private void setTcpRingListener(Cluster$TcpRingListener daemon) {
        this.__m_TcpRingListener = daemon;
    }

    public void setThreadGroup(ThreadGroup threadgroup) {
        Component._assert(this.getState() < STATE_RUNNING);
        this.__m_ThreadGroup = threadgroup;
    }

    public synchronized void shutdown() {
        switch (this.getState()) {
            case 0: {
                this.setState(STATE_EXITED);
                break;
            }
            case 1: 
            case 2: {
                this.start();
            }
            case 3: {
                try {
                    this.setState(STATE_LEAVING);
                    Cluster$ClusterService daemonClusterService = this.getClusterService();
                    int i = 1;
                    int c = daemonClusterService.getServiceCount();
                    while (i < c) {
                        com.tangosol.coherence.component.util.daemon.queueProcessor.Service service = daemonClusterService.getService(i);
                        if (service != null) {
                            service.shutdown();
                        }
                        ++i;
                    }
                    daemonClusterService.shutdown();
                }
                finally {
                    Object var2_5 = null;
                    this.stop();
                }
            }
            case 4: 
            case 5: {
                while (this.getState() != STATE_EXITED) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Base.ensureRuntimeException((Throwable)e);
                    }
                }
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf("Unknown State=") + this.getState());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void start() {
        try {
            switch (this.getState()) {
                case 0: {
                    this.setState(STATE_STARTING);
                    try {
                        this.onStart();
                    }
                    catch (RuntimeException e) {
                        this.setStartException(e);
                        throw e;
                    }
                }
                case 1: 
                case 2: {
                    Throwable e;
                    do {
                        if (!(this.getState() < STATE_RUNNING)) return;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            if (!(this.getStartException() == null)) continue;
                            throw Base.ensureRuntimeException((Throwable)e2, (String)"Interrupted while waiting for Cluster start");
                        }
                    } while (!((e = this.getStartException()) != null));
                    throw Base.ensureRuntimeException((Throwable)e);
                }
                case 3: {
                    return;
                }
                case 4: 
                case 5: {
                    throw new IllegalStateException("Cluster is shutting down!");
                }
                case 6: {
                    throw new IllegalStateException("Cluster is dead!");
                }
            }
            throw new IllegalStateException(String.valueOf("Unknown State=") + this.getState());
        }
        catch (RuntimeException e) {
            try {
                this.stop();
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public void startService(com.tangosol.coherence.component.util.daemon.queueProcessor.Service service) {
        String sName = service.getServiceName();
        Component._assert(this.getService(sName) == null, String.valueOf("Service \"") + sName + "\" is already started!");
        Component._assert(service.getCluster() == null, String.valueOf("Service \"") + sName + "\" is already tied to a cluster object!");
        service.setCluster(this);
        service.start();
    }

    public synchronized void stop() {
        if (this.getState() != STATE_EXITED) {
            this.setState(STATE_STOPPING);
            try {
                Cluster$ShutdownHook hook = (Cluster$ShutdownHook)this._findName("ShutdownHook");
                hook.unregister();
                Cluster$PacketListener1 daemonPointListener = this.getPointListener();
                Cluster$PacketListenerN daemonMultiListener = this.getMultiListener();
                Cluster$PacketReceiver daemonReceiver = this.getReceiver();
                Cluster$PacketPublisher daemonPublisher = this.getPublisher();
                Cluster$PacketSpeaker daemonSpeaker = this.getSpeaker();
                Cluster$TcpRingListener daemonTcpRingListener = this.getTcpRingListener();
                Cluster$ClusterService daemonClusterService = this.getClusterService();
                daemonClusterService.stop();
                daemonTcpRingListener.stop();
                daemonPointListener.stop();
                daemonMultiListener.stop();
                daemonReceiver.stop();
                daemonPublisher.stop();
                daemonSpeaker.stop();
                int cServices = daemonClusterService.getServiceCount();
                LinkedList<Thread> listThreads = new LinkedList<Thread>();
                int i = cServices - 1;
                while (i > 0) {
                    com.tangosol.coherence.component.util.daemon.queueProcessor.Service service = daemonClusterService.getService(i);
                    if (service != null) {
                        service.stop();
                        Thread thread = service.getThread();
                        if (thread != null) {
                            listThreads.add(thread);
                        }
                    }
                    --i;
                }
                long cMillisMax = 2 * this.getConfig().getClusterHeartbeatDelay();
                boolean fInterrupted = false;
                Iterator iter = listThreads.iterator();
                while (!(cMillisMax > (long)0) ? false : iter.hasNext()) {
                    Thread thread = (Thread)iter.next();
                    long lStart = Base.getSafeTimeMillis();
                    try {
                        thread.join(cMillisMax);
                    }
                    catch (InterruptedException e) {
                        fInterrupted = true;
                    }
                    cMillisMax -= Base.getSafeTimeMillis() - lStart;
                }
                if (fInterrupted) {
                    Thread.currentThread().interrupt();
                }
                this.getSocketManager().releaseSockets();
            }
            finally {
                Object var2_3 = null;
                this.setState(STATE_EXITED);
            }
        }
    }

    public String toString() {
        if (this.getState() == STATE_RUNNING) {
            StringBuffer sb = new StringBuffer();
            String sClusterName = this.getClusterName();
            sb.append("Name=").append(sClusterName.length() == 0 ? "n/a" : sClusterName).append("\n\n");
            List listWka = this.getPublisher().getWellKnownAddressList();
            if (listWka == null ? true : listWka.size() == 0) {
                sb.append("Group{Address=").append(InetAddressHelper.toString((InetAddress)this.getPublisher().getUdpSocketMulticast().getInetAddress())).append(", Port=").append(this.getPublisher().getUdpSocketMulticast().getPort()).append(", TTL=").append(this.getPublisher().getUdpSocketMulticast().getTimeToLive()).append('}');
            } else {
                sb.append("WellKnownAddressList(Size=").append(listWka.size()).append(',');
                Iterator iterWka = listWka.iterator();
                while (iterWka.hasNext()) {
                    InetSocketAddress addr = (InetSocketAddress)iterWka.next();
                    sb.append("\n  WKA{Address=").append(InetAddressHelper.toString((InetAddress)addr.getAddress())).append(", Port=").append(addr.getPort()).append('}');
                }
                sb.append("\n  )");
            }
            sb.append("\n\n").append(this.getClusterService().getClusterMemberSet()).append("\n\n").append("Services\n  (\n  ").append(this.getTcpRingListener());
            Enumeration enumeration = this.getServiceNames();
            while (enumeration.hasMoreElements()) {
                com.tangosol.coherence.component.util.daemon.queueProcessor.Service service = (com.tangosol.coherence.component.util.daemon.queueProcessor.Service)this.getService((String)enumeration.nextElement());
                if (!(service != null)) continue;
                sb.append("\n  ").append(service);
            }
            sb.append("\n  )");
            return sb.toString();
        }
        return String.valueOf("Cluster is not running: State=") + this.getState();
    }
}

