/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class Message
extends Net {
    private Member __m_FromMember;
    private long __m_FromMessageId;
    private transient boolean __m_Incoming;
    private int __m_MessagePartCount;
    private int __m_MessageType;
    private int __m_NullPacketCount;
    private MessagePacket[] __m_Packet;
    private Service __m_Service;
    private MemberSet __m_ToMemberSet;
    private long __m_ToPollId;

    public Message() {
        this(null, null, true);
    }

    public Message(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addToMember(Member member) {
        this.ensureToMemberSet().add(member);
    }

    public Message cloneMessage() {
        Service service = this.getService();
        if (service == null) {
            throw new IllegalStateException(String.valueOf("Unable to clone message: ") + this);
        }
        return service.instantiateMessage(this.getMessageType());
    }

    public MemberSet ensureToMemberSet() {
        MemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            setMember = new MemberSet();
            this.setToMemberSet(setMember);
        }
        return setMember;
    }

    public String getDescription() {
        return null;
    }

    public Member getFromMember() {
        return this.__m_FromMember;
    }

    public long getFromMessageId() {
        return this.__m_FromMessageId;
    }

    public int getMessagePartCount() {
        MessagePacket[] aPacket = this.getPacket();
        return aPacket == null ? 0 : aPacket.length;
    }

    public int getMessageType() {
        return this.__m_MessageType;
    }

    public int getNullPacketCount() {
        return this.__m_NullPacketCount;
    }

    protected MessagePacket[] getPacket() {
        return this.__m_Packet;
    }

    public MessagePacket getPacket(int i) {
        return this.getPacket()[i];
    }

    public Poll getPoll() {
        Service service = this.getService();
        return service == null ? null : (Poll)service.getPollArray().get(this.getToPollId());
    }

    public Service getService() {
        return this.__m_Service;
    }

    public MemberSet getToMemberSet() {
        return this.__m_ToMemberSet;
    }

    public long getToPollId() {
        return this.__m_ToPollId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Message".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Message();
    }

    private final Component get_Module() {
        return this;
    }

    public Component get_Parent() {
        Component parent = super.get_Parent();
        return parent == null ? this.getService() : parent;
    }

    public boolean isIncoming() {
        return this.__m_Incoming;
    }

    public boolean isInternal() {
        return this.getMessageType() < 0;
    }

    public boolean isNotifySent() {
        return false;
    }

    public void onInit() {
        super.onInit();
        Component._assert(this.get_Parent() == null, "Message must be instantiated using instantiateMessage() method.");
    }

    public void onReceived() {
    }

    public void onSent() {
    }

    public void read(DataInputStream stream) throws IOException {
    }

    public void readInternal(DataInputStream stream) throws IOException {
        if (stream.readBoolean()) {
            int nId = Packet.readUnsignedTrint(stream);
            this.setToPollId(Packet.translateTrint(nId, this.getService().getPollArray().getFirstIndex()));
        }
    }

    public static Object readObject(DataInputStream stream, ClassLoader loader) throws IOException {
        return ExternalizableHelper.readObject((DataInput)stream, (ClassLoader)loader);
    }

    public void respondTo(RequestMessage msg) {
        this.setToMemberSet(SingleMemberSet.instantiate(msg.getFromMember()));
        this.setToPollId(msg.getFromPollId());
    }

    public void setFromMember(Member member) {
        this.__m_FromMember = member;
    }

    public void setFromMessageId(long lMsgId) {
        this.__m_FromMessageId = lMsgId;
    }

    public void setIncoming(boolean fIncoming) {
        this.__m_Incoming = fIncoming;
    }

    public void setMessagePartCount(int cPackets) {
        Component._assert(cPackets > 0);
        Component._assert(this.getPacket() == null);
        this.setPacket(new MessagePacket[cPackets]);
        this.setNullPacketCount(cPackets);
    }

    public void setMessageType(int nType) {
        this.__m_MessageType = nType;
    }

    protected void setNullPacketCount(int cPackets) {
        this.__m_NullPacketCount = cPackets;
    }

    public void setPacket(int i, MessagePacket packet) {
        MessagePacket[] aPacket = this.getPacket();
        if (packet == null) {
            if (aPacket[i] != null) {
                this.setNullPacketCount(this.getNullPacketCount() + 1);
            }
        } else if (aPacket[i] == null) {
            this.setNullPacketCount(this.getNullPacketCount() - 1);
        }
        aPacket[i] = packet;
    }

    protected void setPacket(MessagePacket[] aPacket) {
        this.__m_Packet = aPacket;
    }

    public void setService(Service service) {
        this.__m_Service = service;
    }

    public void setToMemberSet(MemberSet setMember) {
        this.__m_ToMemberSet = setMember;
    }

    public void setToPollId(long lPollId) {
        this.__m_ToPollId = lPollId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean fVerbose) {
        int cParts = this.getMessagePartCount();
        int cPending = this.isIncoming() ? this.getNullPacketCount() : cParts - this.getNullPacketCount();
        StringBuffer sb = new StringBuffer();
        sb.append("Message \"").append(this.get_Name()).append("\"\n  {").append("\n  FromMember=").append(this.getFromMember()).append("\n  FromMessageId=").append(this.getFromMessageId()).append("\n  Internal=").append(this.isInternal()).append("\n  MessagePartCount=").append(cParts).append("\n  PendingCount=").append(cPending).append("\n  MessageType=").append(this.getMessageType()).append("\n  ToPollId=").append(this.getToPollId()).append("\n  Poll=").append(this.getPoll());
        if (fVerbose) {
            sb.append("\n  Packets").append("\n    {");
            int cDigts = cParts > 1000 ? 4 : 3;
            int i = 0;
            while (i < cParts) {
                MessagePacket packet = this.getPacket(i);
                if (packet != null) {
                    sb.append("\n    [").append(Base.toDecString((int)i, (int)cDigts)).append("]=").append(Base.indentString((String)packet.toString(), (String)"          ", (boolean)false));
                }
                ++i;
            }
            sb.append("\n    }");
        }
        sb.append("\n  Service=");
        Service service = this.getService();
        if (service == null) {
            sb.append("null");
        } else {
            sb.append(Base.indentString((String)service.toString(), (String)"    ", (boolean)false));
        }
        sb.append("\n  ToMemberSet=");
        MemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append(Base.indentString((String)setMember.toString(), (String)"    ", (boolean)false));
        }
        sb.append("\n  NotifySent=").append(this.isNotifySent());
        String sDesc = this.getDescription();
        if (!(sDesc != null) ? false : sDesc.length() > 0) {
            sb.append('\n').append(Base.indentString((String)sDesc, (String)"  "));
        }
        sb.append("\n  }");
        return sb.toString();
    }

    public void write(DataOutputStream stream) throws IOException {
    }

    public void writeInternal(DataOutputStream stream) throws IOException {
        long lPollId = this.getToPollId();
        boolean fResponse = lPollId != 0L;
        stream.writeBoolean(fResponse);
        if (fResponse) {
            Packet.writeTrint(stream, lPollId);
        }
    }

    public static void writeObject(DataOutputStream stream, Object o) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)stream, (Object)o);
    }
}

