/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Management;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.gateway.Mock;
import com.tangosol.coherence.component.net.management.gateway.Remote;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.localModel.CacheModel;
import com.tangosol.coherence.component.net.management.model.localModel.ClusterModel;
import com.tangosol.coherence.component.net.management.model.localModel.ClusterNodeModel;
import com.tangosol.coherence.component.net.management.model.localModel.PointToPointModel;
import com.tangosol.coherence.component.net.management.model.localModel.ServiceModel;
import com.tangosol.coherence.component.net.management.model.localModel.StorageManagerModel;
import com.tangosol.coherence.component.net.management.model.localModel.WrapperModel;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.Service;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class Gateway
extends Management
implements Registry {
    private Cluster __m_Cluster;
    private String __m_DomainName;
    private boolean __m_ReadOnly;
    private String __m_ServiceName;

    public Gateway() {
        this(null, null, true);
    }

    public Gateway(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDomainName("");
            this.setReadOnly(false);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void configure(XmlElement xmlConfig) {
        boolean fReadOnly = xmlConfig.getSafeElement("read-only").getBoolean(false);
        this.setReadOnly(fReadOnly);
        String sServiceName = xmlConfig.getSafeElement("service-name").getString("Management");
        this.setServiceName(sServiceName);
    }

    protected String convertSpecialCharacters(String s) {
        return s.replace(':', '_');
    }

    public static Gateway createGateway(XmlElement xmlConfig, Cluster cluster) {
        String sManage = xmlConfig.getSafeElement("managed-nodes").getString("none");
        boolean fRemoteMgmt = xmlConfig.getSafeElement("allow-remote-management").getBoolean();
        if (!sManage.equals("none") ? false : fRemoteMgmt ^ true) {
            return null;
        }
        Local gatewayLocal = null;
        Remote gatewayRemote = null;
        Mock gatewayMock = null;
        Connector connector = new Connector();
        if (fRemoteMgmt) {
            gatewayRemote = new Remote();
            gatewayRemote.configure(xmlConfig);
            gatewayRemote.setCluster(cluster);
            gatewayRemote.setConnector(connector);
            if (sManage.equals("none")) {
                return gatewayRemote;
            }
        }
        try {
            gatewayLocal = new Local();
            gatewayLocal.configure(xmlConfig);
            gatewayLocal.setCluster(cluster);
        }
        catch (Throwable e) {
            String sMsg = String.valueOf("This node is not configured for local management; ") + (fRemoteMgmt ? "it can only be managed remotely." : "it will not be managed");
            Component._trace(sMsg, 2);
            if (e instanceof NoClassDefFoundError ^ true) {
                Component._trace(e);
            }
            return gatewayRemote;
        }
        if (fRemoteMgmt) {
            gatewayLocal.setRemoteGateway(gatewayRemote);
        }
        if (sManage.equals("local-only")) {
            return gatewayLocal;
        }
        boolean fRemoteOnly = sManage.equals("remote-only");
        if (fRemoteOnly ^ true) {
            Component._assert(sManage.equals("all"), String.valueOf("Unsupported \"managed-nodes\" value: ") + sManage);
        }
        connector.setLocalGateway(gatewayLocal);
        if (fRemoteMgmt) {
            if (fRemoteOnly) {
                Component._trace(String.valueOf("The 'managed-nodes' value of 'remote-only' is incompatible ") + "with 'allow-remote-management' value of 'true'; " + "using the 'managed-nodes' value of 'all' instead", 2);
            }
            return gatewayLocal;
        }
        gatewayMock = new Mock();
        gatewayMock.configure(xmlConfig);
        gatewayMock.setCluster(cluster);
        gatewayMock.setConnector(connector);
        if (fRemoteOnly) {
            return gatewayMock;
        }
        gatewayLocal.setRemoteGateway(gatewayMock);
        return gatewayLocal;
    }

    public String ensureGlobalName(String sName) {
        Member member = this.getCluster().getLocalMember();
        if (member == null) {
            return sName;
        }
        StringBuffer sb = new StringBuffer(sName == null ? "" : sName);
        int cch = sb.length();
        if (!(cch > 0) ? false : sb.charAt(cch - 1) != ',') {
            sb.append(',');
        }
        return sb.append("nodeId=").append(member.getId()).toString();
    }

    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    public String getDomainName() {
        return this.__m_DomainName;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/Gateway".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Gateway();
    }

    private final Component get_Module() {
        return this;
    }

    protected CacheModel instantiateCacheModel(Map map) {
        CacheModel model = new CacheModel();
        model.set_Map(map);
        return model;
    }

    protected ClusterModel instantiateClusterModel() {
        ClusterModel model = new ClusterModel();
        model.set_Cluster(this.getCluster());
        return model;
    }

    protected ClusterNodeModel instantiateClusterNodeModel(Member member) {
        ClusterNodeModel model = new ClusterNodeModel();
        model.set_Cluster(this.getCluster());
        model.set_Member(member);
        return model;
    }

    protected LocalModel instantiateLocalModel(Object oBean) {
        LocalModel model;
        Component._assert(oBean != null);
        if (oBean instanceof Cluster) {
            Component._assert(oBean == this.getCluster());
            model = this.instantiateClusterModel();
        } else {
            model = oBean instanceof Member ? this.instantiateClusterNodeModel((Member)oBean) : (oBean instanceof Service ? this.instantiateServiceModel((Service)oBean) : (oBean instanceof Map ? this.instantiateCacheModel((Map)oBean) : (oBean instanceof DistributedCache$Storage ? this.instantiateStorageManagerModel((DistributedCache$Storage)oBean) : (oBean instanceof MasterMemberSet ? this.instantiatePointToPointModel((MasterMemberSet)oBean) : this.instantiateWrapperModel(oBean)))));
        }
        if (this.isReadOnly()) {
            model.set_ReadOnly(true);
        }
        return model;
    }

    protected PointToPointModel instantiatePointToPointModel(MasterMemberSet memberset) {
        PointToPointModel model = new PointToPointModel();
        model.set_MemberSet(memberset);
        return model;
    }

    protected ServiceModel instantiateServiceModel(Service service) {
        ServiceModel model = new ServiceModel();
        model.set_Service(service);
        if (this.getServiceName().equals(service.getInfo().getServiceName())) {
            model.set_ReadOnly(true);
        }
        return model;
    }

    protected StorageManagerModel instantiateStorageManagerModel(DistributedCache$Storage storage) {
        StorageManagerModel model = new StorageManagerModel();
        model.set_Storage(storage);
        return model;
    }

    protected WrapperModel instantiateWrapperModel(Object oBean) {
        WrapperModel model = new WrapperModel();
        model.set_MBean(oBean);
        return model;
    }

    protected boolean isGlobal(String sCanonicalName) {
        return sCanonicalName.indexOf("nodeId=") >= 0;
    }

    public boolean isReadOnly() {
        return this.__m_ReadOnly;
    }

    public boolean isRegistered(String sCanonicalName) {
        throw new UnsupportedOperationException();
    }

    public void register(String sCanonicalName, Object oBean) {
        this.registerLocalModel(sCanonicalName, this.instantiateLocalModel(oBean));
    }

    public void registerLocalModel(String sCanonicalName, LocalModel model) {
        throw new UnsupportedOperationException();
    }

    public void setCluster(Cluster cluster) {
        Component._assert(cluster == null ? true : this.getCluster() == null, "Cluster is not resetable");
        this.__m_Cluster = cluster;
        if (cluster != null) {
            this.register(Registry.CLUSTER_TYPE, cluster);
        }
    }

    protected void setDomainName(String sDomain) {
        this.__m_DomainName = sDomain;
    }

    protected void setReadOnly(boolean fReadOnly) {
        this.__m_ReadOnly = fReadOnly;
    }

    protected void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void unregister(String sCanonicalName) {
        this.unregisterModel(sCanonicalName);
    }

    public void unregisterModel(String sCanonicalName) {
        throw new UnsupportedOperationException();
    }
}

