/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class LocalModel
extends Model
implements ExternalizableLite {
    private transient int __m__ExpiryDelay;
    private transient long __m__ExpiryMillis;
    private Object __m__InvocationResult;
    private transient boolean __m__ReadOnly;
    private transient boolean __m__Snapshot;
    private transient Map __m__SnapshotMap;

    public LocalModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void checkRange(String sOperation, double dValue, double dMin, double dMax) {
        this.checkReadOnly(sOperation);
        if (dValue < dMin ? true : dValue > dMax) {
            throw new IllegalArgumentException(String.valueOf("Operation \"") + sOperation + "\" -- value out of range [" + dMin + ", " + dMax + "]: " + dValue);
        }
    }

    protected void checkRange(String sOperation, int nValue, int nMin, int nMax) {
        this.checkReadOnly(sOperation);
        if (nValue < nMin ? true : nValue > nMax) {
            throw new IllegalArgumentException(String.valueOf("Operation \"") + sOperation + "\" -- value out of range [" + nMin + ", " + nMax + "]: " + nValue);
        }
    }

    protected void checkReadOnly(String sOperation) {
        if (this.is_ReadOnly()) {
            throw new SecurityException(String.valueOf("Operation is not allowed: ") + sOperation);
        }
    }

    public String getDescription() {
        return this.get_Name();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/LocalModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public int get_ExpiryDelay() {
        return this.__m__ExpiryDelay;
    }

    public long get_ExpiryMillis() {
        return this.__m__ExpiryMillis;
    }

    public Object get_InvocationResult() {
        return this.__m__InvocationResult;
    }

    private final Component get_Module() {
        return this;
    }

    public Map get_SnapshotMap() {
        return this.__m__SnapshotMap;
    }

    public Object invoke(String sMethod, Object[] aoParam) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return ClassHelper.invoke((Object)this, (String)sMethod, (Object[])aoParam);
    }

    public boolean is_Expired() {
        return !this.is_Snapshot() ? false : Base.getSafeTimeMillis() > this.get_ExpiryMillis();
    }

    public boolean is_ReadOnly() {
        return this.__m__ReadOnly;
    }

    public boolean is_Snapshot() {
        return this.__m__Snapshot;
    }

    public void onInit() {
        String sDelay = System.getProperty("tangosol.coherence.management.refreshrate");
        if (sDelay != null) {
            this.set_ExpiryDelay(Integer.parseInt(sDelay));
        }
        super.onInit();
    }

    public void readExternal(DataInput in) throws IOException {
        this.set_Snapshot(true);
        this.set_InvocationResult(ExternalizableHelper.readObject((DataInput)in));
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("Description", ExternalizableHelper.readSafeUTF((DataInput)in));
    }

    protected void scheduleExpiry() {
        long dtExpiry = 0L;
        int cDelay = this.get_ExpiryDelay();
        if (cDelay > 0) {
            dtExpiry = Base.getSafeTimeMillis() + (long)cDelay;
        }
        this.set_ExpiryMillis(dtExpiry);
    }

    public void set_ExpiryDelay(int cMillis) {
        this.__m__ExpiryDelay = cMillis;
    }

    protected void set_ExpiryMillis(long cMillis) {
        this.__m__ExpiryMillis = cMillis;
    }

    public void set_InvocationResult(Object oResult) {
        this.__m__InvocationResult = oResult;
    }

    public void set_ReadOnly(boolean flag) {
        this.__m__ReadOnly = flag;
    }

    protected void set_Snapshot(boolean flag) {
        Component._assert(flag, "One way property");
        this.__m__Snapshot = flag;
        this.set_SnapshotMap(new HashMap());
        this.scheduleExpiry();
    }

    protected void set_SnapshotMap(Map map) {
        this.__m__SnapshotMap = map;
    }

    public void writeExternal(DataOutput out) throws IOException {
        Component._assert(this.is_Snapshot() ^ true);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.get_InvocationResult());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getDescription());
    }
}

