/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.NearCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.net.cache.SimpleOverflowMap;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CacheModel
extends LocalModel {
    private double __m_BatchFactor;
    private int __m_ExpiryDelay;
    private int __m_FlushDelay;
    private int __m_HighUnits;
    private int __m_LowUnits;
    private int __m_QueueDelay;
    private double __m_RefreshFactor;
    private int __m_RequeueThreshold;
    private transient ReadWriteBackingMap __m__BackingMap;
    private transient LocalCache __m__LocalCache;
    private transient Map __m__Map;
    private transient CacheStatistics __m__Stats;

    public CacheModel() {
        this(null, null, true);
    }

    public CacheModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_ExpiryDelay(1000);
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public double getAverageGetMillis() {
        return this.get_Stats().getAverageGetMillis();
    }

    public double getAverageHitMillis() {
        return this.get_Stats().getAverageHitMillis();
    }

    public double getAverageMissMillis() {
        return this.get_Stats().getAverageMissMillis();
    }

    public double getAveragePutMillis() {
        return this.get_Stats().getAveragePutMillis();
    }

    public double getBatchFactor() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isWriteBehind()) {
            return map.getWriteBatchFactor();
        }
        return 0.0;
    }

    public long getCacheHits() {
        return this.get_Stats().getCacheHits();
    }

    public long getCacheHitsMillis() {
        return this.get_Stats().getCacheHitsMillis();
    }

    public long getCacheMisses() {
        return this.get_Stats().getCacheMisses();
    }

    public long getCacheMissesMillis() {
        return this.get_Stats().getCacheMissesMillis();
    }

    public String getDescription() {
        return String.valueOf("Implementation: ") + this.get_Map().getClass().getName();
    }

    public int getExpiryDelay() {
        LocalCache cache = this.get_LocalCache();
        return cache == null ? -1 : cache.getExpiryDelay();
    }

    public int getFlushDelay() {
        LocalCache cache = this.get_LocalCache();
        return cache == null ? -1 : cache.getFlushDelay();
    }

    public int getHighUnits() {
        LocalCache cache = this.get_LocalCache();
        return cache == null ? -1 : cache.getHighUnits();
    }

    public double getHitProbability() {
        return this.get_Stats().getHitProbability();
    }

    public int getLowUnits() {
        LocalCache cache = this.get_LocalCache();
        return cache == null ? -1 : cache.getLowUnits();
    }

    public String getPersistenceType() {
        ReadWriteBackingMap map = this.get_BackingMap();
        String sType = "NONE";
        if (!(map != null) ? false : map.getCacheStore() != null) {
            if (map.isReadOnly()) {
                sType = "READ-ONLY";
            } else if (map.isWriteThrough()) {
                sType = "WRITE-THROUGH";
            } else if (map.isWriteBehind()) {
                sType = "WRITE-BEHIND";
            }
        }
        return sType;
    }

    public int getQueueDelay() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isWriteBehind()) {
            return map.getWriteBehindSeconds();
        }
        return -1;
    }

    public int getQueueSize() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isWriteBehind()) {
            return map.getWriteQueue().size();
        }
        return -1;
    }

    public double getRefreshFactor() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isRefreshAhead()) {
            return map.getRefreshAheadFactor();
        }
        return 0.0;
    }

    public int getRequeueThreshold() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isWriteBehind()) {
            return map.getWriteRequeueThreshold();
        }
        return 0;
    }

    public int getSize() {
        LocalCache cache = this.get_LocalCache();
        Map map = this.get_Map();
        return ((cache == null ? true : map instanceof OverflowMap) ? true : map instanceof SimpleOverflowMap) ? map.size() : cache.size();
    }

    public long getStoreAverageBatchSize() {
        ReadWriteBackingMap.CacheStoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getAverageBatchSize();
        }
        return -1;
    }

    public long getStoreAverageReadMillis() {
        ReadWriteBackingMap.CacheStoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getAverageLoadMillis();
        }
        return -1;
    }

    public long getStoreAverageWriteMillis() {
        ReadWriteBackingMap.CacheStoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            long cOps = store.getStoreOps() + store.getEraseOps();
            long cMillis = store.getStoreMillis() + store.getEraseMillis();
            return cOps > 0L ? cMillis / cOps : 0L;
        }
        return -1;
    }

    public long getStoreFailures() {
        ReadWriteBackingMap.CacheStoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getLoadFailures() + store.getStoreFailures() + store.getEraseFailures();
        }
        return -1;
    }

    public long getStoreReadMillis() {
        ReadWriteBackingMap.CacheStoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getLoadMillis();
        }
        return -1;
    }

    public long getStoreReads() {
        ReadWriteBackingMap.CacheStoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getLoadOps();
        }
        return -1;
    }

    public long getStoreWriteMillis() {
        ReadWriteBackingMap.CacheStoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if ((!(map != null) ? false : map.isReadOnly() ^ true) && (store = map.getCacheStore()) != null) {
            return store.getStoreMillis() + store.getEraseMillis();
        }
        return -1;
    }

    public long getStoreWrites() {
        ReadWriteBackingMap.CacheStoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if ((!(map != null) ? false : map.isReadOnly() ^ true) && (store = map.getCacheStore()) != null) {
            return store.getStoreOps() + store.getEraseOps();
        }
        return -1;
    }

    public long getTotalGets() {
        return this.get_Stats().getTotalGets();
    }

    public long getTotalGetsMillis() {
        return this.get_Stats().getTotalGetsMillis();
    }

    public long getTotalPuts() {
        return this.get_Stats().getTotalPuts();
    }

    public long getTotalPutsMillis() {
        return this.get_Stats().getTotalPutsMillis();
    }

    public int getUnits() {
        LocalCache cache = this.get_LocalCache();
        return cache == null ? -1 : cache.getUnits();
    }

    protected ReadWriteBackingMap get_BackingMap() {
        return this.__m__BackingMap;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/CacheModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new CacheModel();
    }

    protected LocalCache get_LocalCache() {
        Map map = this.get_Map();
        if (map instanceof NearCache) {
            NearCache cache = (NearCache)map;
            try {
                return (LocalCache)cache.getFrontMap();
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return this.__m__LocalCache;
    }

    public Map get_Map() {
        return this.__m__Map;
    }

    private final Component get_Module() {
        return this;
    }

    public CacheStatistics get_Stats() {
        return this.__m__Stats;
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("AverageGetMillis", new Double(in.readDouble()));
        mapSnapshot.put("AverageHitMillis", new Double(in.readDouble()));
        mapSnapshot.put("AverageMissMillis", new Double(in.readDouble()));
        mapSnapshot.put("AveragePutMillis", new Double(in.readDouble()));
        mapSnapshot.put("BatchFactor", new Double(in.readDouble()));
        mapSnapshot.put("CacheHits", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("CacheHitsMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("CacheMisses", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("CacheMissesMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("ExpiryDelay", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("FlushDelay", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("HighUnits", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("HitProbability", new Double(in.readDouble()));
        mapSnapshot.put("LowUnits", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("PersistenceType", ExternalizableHelper.readUTF((DataInput)in));
        mapSnapshot.put("QueueDelay", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("QueueSize", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("RefreshFactor", new Double(in.readDouble()));
        mapSnapshot.put("RequeueThreshold", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("Size", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("StoreAverageBatchSize", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("StoreAverageReadMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("StoreAverageWriteMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("StoreFailures", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("StoreReadMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("StoreReads", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("StoreWriteMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("StoreWrites", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TotalGets", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TotalGetsMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TotalPuts", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TotalPutsMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("Units", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
    }

    private void resetStatistics$Router() {
        this.get_Stats().resetHitStatistics();
    }

    public void resetStatistics() {
        this.resetStatistics$Router();
        try {
            this.get_BackingMap().getCacheStore().resetStatistics();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void setBatchFactor(double dFactor) {
        this.checkRange("setBatchFactor", dFactor, 0.0, 1.0);
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isWriteBehind()) {
            map.setWriteBatchFactor(dFactor);
        }
    }

    public void setExpiryDelay(int cMillis) {
        LocalCache cache = this.get_LocalCache();
        if (cache != null) {
            this.checkRange("setExpiryDelay", cMillis, 0, Integer.MAX_VALUE);
            cache.setExpiryDelay(cMillis);
        }
    }

    public void setFlushDelay(int cMillis) {
        LocalCache cache = this.get_LocalCache();
        if (cache != null) {
            this.checkRange("setFlushDelay", cMillis, 0, Integer.MAX_VALUE);
            cache.setFlushDelay(cMillis);
        }
    }

    public void setHighUnits(int cUnits) {
        LocalCache cache = this.get_LocalCache();
        if (cache != null) {
            this.checkRange("setHighUnits", cUnits, 0, Integer.MAX_VALUE);
            cache.setHighUnits(cUnits);
        }
    }

    public void setLowUnits(int cUnits) {
        LocalCache cache = this.get_LocalCache();
        if (cache != null) {
            this.checkRange("setLowUnits", cUnits, 0, Integer.MAX_VALUE);
            cache.setLowUnits(cUnits);
        }
    }

    public void setQueueDelay(int cDelay) {
        this.checkReadOnly("setQueueDelay");
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isWriteBehind()) {
            map.setWriteBehindSeconds(cDelay);
        }
    }

    public void setRefreshFactor(double dFactor) {
        this.checkRange("setRefreshFactor", dFactor, 0.0, 1.0);
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isRefreshAhead()) {
            map.setRefreshAheadFactor(dFactor);
        }
    }

    public void setRequeueThreshold(int cThreshold) {
        this.checkRange("setRequeueThreshold", cThreshold, 0, Integer.MAX_VALUE);
        ReadWriteBackingMap map = this.get_BackingMap();
        if (!(map != null) ? false : map.isWriteBehind()) {
            map.setWriteRequeueThreshold(cThreshold);
        }
    }

    protected void set_BackingMap(ReadWriteBackingMap map) {
        this.__m__BackingMap = map;
    }

    protected void set_LocalCache(LocalCache cache) {
        this.__m__LocalCache = cache;
    }

    public void set_Map(Map map) {
        this.__m__Map = map;
        if (map instanceof ReadWriteBackingMap) {
            this.set_BackingMap((ReadWriteBackingMap)map);
            map = ((ReadWriteBackingMap)map).getInternalCache();
        }
        CacheStatistics stats = null;
        try {
            stats = (CacheStatistics)ClassHelper.invoke((Object)map, (String)"getCacheStatistics", (Object[])ClassHelper.VOID);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (stats == null) {
            stats = new SimpleCacheStatistics();
        }
        this.set_Stats(stats);
        if (map instanceof OverflowMap) {
            map = ((OverflowMap)map).getFrontMap();
        }
        if (map instanceof LocalCache) {
            this.set_LocalCache((LocalCache)map);
        }
    }

    protected void set_Stats(CacheStatistics stats) {
        this.__m__Stats = stats;
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeDouble(this.getAverageGetMillis());
        out.writeDouble(this.getAverageHitMillis());
        out.writeDouble(this.getAverageMissMillis());
        out.writeDouble(this.getAveragePutMillis());
        out.writeDouble(this.getBatchFactor());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getCacheHits());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getCacheHitsMillis());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getCacheMisses());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getCacheMissesMillis());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getExpiryDelay());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getFlushDelay());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getHighUnits());
        out.writeDouble(this.getHitProbability());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getLowUnits());
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.getPersistenceType());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getQueueDelay());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getQueueSize());
        out.writeDouble(this.getRefreshFactor());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getRequeueThreshold());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getSize());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getStoreAverageBatchSize());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getStoreAverageReadMillis());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getStoreAverageWriteMillis());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getStoreFailures());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getStoreReadMillis());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getStoreReads());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getStoreWriteMillis());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getStoreWrites());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTotalGets());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTotalGetsMillis());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTotalPuts());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTotalPutsMillis());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getUnits());
    }
}

