/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.net.Cluster;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ClusterModel
extends LocalModel {
    private transient Cluster __m__Cluster;

    public ClusterModel() {
        this(null, null, true);
    }

    public ClusterModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_ExpiryDelay(1000);
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void ensureRunning() {
        Cluster cluster = this.get_Cluster();
        if (cluster.isRunning() ^ true) {
            cluster.start();
        }
    }

    public String getClusterName() {
        return Model.canonicalString(this.get_Cluster().getClusterName());
    }

    public int getClusterSize() {
        Cluster cluster = this.get_Cluster();
        return cluster.isRunning() ? cluster.getMemberSet().size() : 0;
    }

    public String getDescription() {
        Cluster cluster = this.get_Cluster();
        return cluster.isRunning() ? String.valueOf("MemberId=") + cluster.getLocalMember().getId() : "Not running";
    }

    public String getLicenseMode() {
        Cluster cluster = this.get_Cluster();
        if (cluster.isRunning()) {
            Member member = (Member)cluster.getLocalMember();
            return Member.MODE_NAME[member.getMode()];
        }
        return Model.canonicalString(null);
    }

    public int getLocalMemberId() {
        Cluster cluster = this.get_Cluster();
        if (cluster.isRunning()) {
            return cluster.getLocalMember().getId();
        }
        return -1;
    }

    public int[] getMemberIds() {
        Cluster cluster = this.get_Cluster();
        if (cluster.isRunning()) {
            Set setMember = cluster.getMemberSet();
            int[] anMember = new int[setMember.size()];
            Iterator iter = setMember.iterator();
            int i = 0;
            while (iter.hasNext()) {
                anMember[i] = ((com.tangosol.net.Member)iter.next()).getId();
                ++i;
            }
            return anMember;
        }
        return new int[0];
    }

    public String[] getMembers() {
        Cluster cluster = this.get_Cluster();
        if (cluster.isRunning()) {
            Set setMember = cluster.getMemberSet();
            String[] asMember = new String[setMember.size()];
            Iterator iter = setMember.iterator();
            int i = 0;
            while (iter.hasNext()) {
                asMember[i] = iter.next().toString();
                ++i;
            }
            return asMember;
        }
        return new String[0];
    }

    public int getOldestMemberId() {
        Cluster cluster = this.get_Cluster();
        if (cluster.isRunning()) {
            return cluster.getOldestMember().getId();
        }
        return -1;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/ClusterModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public Cluster get_Cluster() {
        return this.__m__Cluster;
    }

    public static Component get_Instance() {
        return new ClusterModel();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isRunning() {
        return this.get_Cluster().isRunning();
    }

    public void readExternal(DataInput in) throws IOException {
        throw new IllegalStateException("ClusterModel is not global");
    }

    public void set_Cluster(Cluster cluster) {
        this.__m__Cluster = cluster;
    }

    public void shutdown() {
        this.get_Cluster().shutdown();
    }

    public void writeExternal(DataOutput out) throws IOException {
        throw new IllegalStateException("ClusterModel is not global");
    }
}

