/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.application.console.Coherence$Logger;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$SocketManager;
import com.tangosol.coherence.component.net.Cluster$SocketManager$MulticastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.socket.udpSocket.MulticastUdpSocket;
import com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.TcpRingListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$InQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker;
import com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue.BundlingQueue;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterNodeModel
extends LocalModel {
    private int __m_BufferPublishSize;
    private int __m_BufferReceiveSize;
    private int __m_BurstCount;
    private int __m_BurstDelay;
    private String __m_LoggingFormat;
    private int __m_LoggingLevel;
    private int __m_LoggingLimit;
    private int __m_MulticastThreshold;
    private int __m_ResendDelay;
    private int __m_SendAckDelay;
    private int __m_TrafficJamCount;
    private int __m_TrafficJamDelay;
    private transient com.tangosol.net.Cluster __m__Cluster;
    private transient com.tangosol.net.Member __m__Member;

    public ClusterNodeModel() {
        this(null, null, true);
    }

    public ClusterNodeModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_ExpiryDelay(1000);
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String ensureCacheService(String sCacheName) {
        this.checkReadOnly("ensureCacheService");
        try {
            DefaultConfigurableCacheFactory factory = (DefaultConfigurableCacheFactory)CacheFactory.getConfigurableCacheFactory();
            DefaultConfigurableCacheFactory.CacheInfo info = factory.findSchemeMapping(sCacheName);
            CacheService service = (CacheService)factory.ensureService(factory.resolveScheme(info));
            return service.getInfo().getServiceName();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public void ensureInvocationService(String sServiceName) {
        this.checkReadOnly("ensureInvocationService");
        CacheFactory.getInvocationService((String)sServiceName);
    }

    public int getBufferPublishSize() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getUdpSocketUnicast().getBufferSent();
    }

    public int getBufferReceiveSize() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getUdpSocketUnicast().getBufferReceived();
    }

    public int getBurstCount() {
        PacketSpeaker speaker = this.get_Speaker();
        return speaker == null ? -1 : speaker.getBurstCount();
    }

    public int getBurstDelay() {
        PacketSpeaker speaker = this.get_Speaker();
        return speaker == null ? -1 : speaker.getBurstDelay();
    }

    public int getCpuCount() {
        return ((Member)this.get_Member()).getCpuCount();
    }

    public String getDescription() {
        return String.valueOf("Uid=") + this.get_Member().getUid();
    }

    public int getId() {
        return this.get_Member().getId();
    }

    public String getLoggingDestination() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        return logger == null ? null : logger.getDestination();
    }

    public String getLoggingFormat() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        return logger == null ? null : logger.getFormat();
    }

    public int getLoggingLevel() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        return logger == null ? -1 : logger.getLevel();
    }

    public int getLoggingLimit() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        return logger == null ? -1 : logger.getLimit();
    }

    public int getMachineId() {
        return this.get_Member().getMachineId();
    }

    public String getMachineName() {
        return Model.canonicalString(this.get_Member().getMachineName());
    }

    public String getMemberName() {
        return Model.canonicalString(this.get_Member().getMemberName());
    }

    public int getMemoryAvailableMB() {
        Runtime runtime = Runtime.getRuntime();
        return (int)((runtime.freeMemory() + runtime.maxMemory() - runtime.totalMemory()) / (long)(1024 * 1024));
    }

    public int getMemoryMaxMB() {
        return (int)(Runtime.getRuntime().maxMemory() / (long)(1024 * 1024));
    }

    public String getMulticastAddress() {
        PacketPublisher publisher = this.get_Publisher();
        MulticastUdpSocket socket = publisher == null ? null : publisher.getUdpSocketMulticast();
        return socket == null ? "" : String.valueOf(socket.getInetAddress());
    }

    public int getMulticastPort() {
        PacketPublisher publisher = this.get_Publisher();
        MulticastUdpSocket socket = publisher == null ? null : publisher.getUdpSocketMulticast();
        return socket == null ? -1 : socket.getPort();
    }

    public int getMulticastTTL() {
        PacketPublisher publisher = this.get_Publisher();
        MulticastUdpSocket socket = publisher == null ? null : publisher.getUdpSocketMulticast();
        return socket == null ? -1 : socket.getTimeToLive();
    }

    public int getMulticastThreshold() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : (int)((double)100 * publisher.getMulticastThreshold());
    }

    public long getNackSent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsNacksSent();
    }

    public float getPacketDeliveryEfficiency() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return 0.0f;
        }
        long lSent = publisher.getStatsSent();
        long lWasted = publisher.getStatsResentExcess();
        return lSent == 0L ? 1.0f : (float)(1.0 - (double)lWasted / (double)lSent);
    }

    public long getPacketsBundled() {
        PacketSpeaker speaker = this.get_Speaker();
        return speaker == null ? -1L : ((BundlingQueue)speaker.getQueue()).getStatsBundled();
    }

    public long getPacketsReceived() {
        PacketReceiver receiver = this.get_Receiver();
        return receiver == null ? -1L : receiver.getStatsReceived();
    }

    public long getPacketsRepeated() {
        PacketReceiver receiver = this.get_Receiver();
        return receiver == null ? -1L : receiver.getStatsRepeated();
    }

    public long getPacketsResent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResent();
    }

    public long getPacketsResentEarly() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResentEarly();
    }

    public long getPacketsResentExcess() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResentExcess();
    }

    public long getPacketsSent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsSent();
    }

    public int getPriority() {
        return ((Member)this.get_Member()).getPriority();
    }

    public String getProcessName() {
        return Model.canonicalString(this.get_Member().getProcessName());
    }

    public String getProductEdition() {
        return Member.EDITION_NAME[((Member)this.get_Member()).getEdition()];
    }

    public float getPublisherPacketUtilization() {
        SafeCluster cluster = (SafeCluster)this.get_Cluster();
        if (cluster.isRunning()) {
            Cluster$SocketManager manager = ((Cluster)cluster.getCluster()).getSocketManager();
            Cluster$SocketManager$UnicastUdpSocket socket1 = manager.getUnicastUdpSocket();
            Cluster$SocketManager$MulticastUdpSocket socketN = manager.getMulticastUdpSocket();
            long cPackets = socket1.getCountSent();
            long cBytes = socket1.getBytesSent();
            if (socketN != null) {
                cPackets += (long)socketN.getCountSent();
                cBytes += socketN.getBytesSent();
            }
            if (cPackets == 0L) {
                return 1.0f;
            }
            return (float)((double)cBytes / (double)cPackets / (double)socket1.getPacketLength());
        }
        return 0.0f;
    }

    public float getPublisherSuccessRate() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return 0.0f;
        }
        long lSent = publisher.getStatsSent();
        long lResent = publisher.getStatsResent();
        return lSent == 0L ? 1.0f : (float)(1.0 - (double)lResent / (double)lSent);
    }

    public String getRackName() {
        return Model.canonicalString(this.get_Member().getRackName());
    }

    public float getReceiverPacketUtilization() {
        SafeCluster cluster = (SafeCluster)this.get_Cluster();
        if (cluster.isRunning()) {
            Cluster$SocketManager manager = ((Cluster)cluster.getCluster()).getSocketManager();
            Cluster$SocketManager$UnicastUdpSocket socket1 = manager.getUnicastUdpSocket();
            Cluster$SocketManager$MulticastUdpSocket socketN = manager.getMulticastUdpSocket();
            long cPackets = socket1.getCountReceived();
            long cBytes = socket1.getBytesReceived();
            if (socketN != null) {
                cPackets += (long)socketN.getCountReceived();
                cBytes += socketN.getBytesReceived();
            }
            if (cPackets == 0L) {
                return 1.0f;
            }
            return (float)((double)cBytes / (double)cPackets / (double)socket1.getPacketLength());
        }
        return 0.0f;
    }

    public float getReceiverSuccessRate() {
        PacketReceiver receiver = this.get_Receiver();
        if (receiver == null) {
            return 0.0f;
        }
        long lReceived = receiver.getStatsReceived();
        long lRepeated = receiver.getStatsRepeated();
        return lReceived == 0L ? 1.0f : (float)(1.0 - (double)lRepeated / (double)lReceived);
    }

    public int getResendDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getResendDelay();
    }

    public String getRoleName() {
        return Model.canonicalString(this.get_Member().getRoleName());
    }

    public int getSendAckDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getAckDelay();
    }

    public int getSendQueueSize() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return -1;
        }
        int iSize = ((PacketPublisher$InQueue)publisher.getQueue()).getPacketAdapter().size() + publisher.getResendQueue().size();
        Queue queueDeferred = publisher.getDeferredReadyQueue();
        if (queueDeferred != null) {
            iSize += queueDeferred.size();
        }
        return iSize;
    }

    public String getSiteName() {
        return Model.canonicalString(this.get_Member().getSiteName());
    }

    public int getSocketCount() {
        return ((Member)this.get_Member()).getSocketCount();
    }

    public String getStatistics() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        if (clusterSafe.isRunning()) {
            return ((Cluster)clusterSafe.getCluster()).formatStats();
        }
        return "n/a";
    }

    public long getTcpRingFailures() {
        TcpRingListener listener = this.get_TcpRingListener();
        return (!(listener != null) ? false : listener.isStarted()) ? listener.getStatsRestores() : -1L;
    }

    public long getTcpRingTimeouts() {
        TcpRingListener listener = this.get_TcpRingListener();
        return (!(listener != null) ? false : listener.isStarted()) ? listener.getStatsTimeouts() : -1L;
    }

    public Date getTimestamp() {
        return new Date(this.get_Member().getTimestamp());
    }

    public int getTrafficJamCount() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getCloggedCount();
    }

    public int getTrafficJamDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getCloggedDelay();
    }

    public String getUnicastAddress() {
        return String.valueOf(this.get_Member().getAddress());
    }

    public int getUnicastPort() {
        return this.get_Member().getPort();
    }

    public int getWeakestChannel() {
        Member memberWorst = Member.findWeakestMember(this.get_Publisher().getMemberSet());
        if (memberWorst == null) {
            return -1;
        }
        return memberWorst.getId();
    }

    public String[] getWellKnownAddresses() {
        PacketPublisher publisher = this.get_Publisher();
        List listWka = publisher == null ? null : publisher.getWellKnownAddressList();
        if (listWka == null) {
            return new String[0];
        }
        InetSocketAddress[] asock = new InetSocketAddress[listWka.size()];
        asock = listWka.toArray(asock);
        int cAddress = asock.length;
        String[] asAddress = new String[cAddress];
        int i = 0;
        while (i < cAddress) {
            asAddress[i] = String.valueOf(asock[i]);
            ++i;
        }
        return asAddress;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/ClusterNodeModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public com.tangosol.net.Cluster get_Cluster() {
        return this.__m__Cluster;
    }

    public static Component get_Instance() {
        return new ClusterNodeModel();
    }

    public com.tangosol.net.Member get_Member() {
        return this.__m__Member;
    }

    private final Component get_Module() {
        return this;
    }

    public PacketPublisher get_Publisher() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getPublisher() : null;
    }

    public PacketReceiver get_Receiver() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getReceiver() : null;
    }

    public PacketSpeaker get_Speaker() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getSpeaker() : null;
    }

    public TcpRingListener get_TcpRingListener() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getTcpRingListener() : null;
    }

    public boolean isFlowControlEnabled() {
        return Member$FlowControl.isEnabled();
    }

    public boolean isMulticastEnabled() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? false : publisher.isMulticastEnabled();
    }

    public boolean isNackEnabled() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? false : publisher.isNackEnabled();
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("BufferPublishSize", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("BufferReceiveSize", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("BurstCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("BurstDelay", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("CpuCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("FlowControlEnabled", in.readBoolean());
        mapSnapshot.put("Id", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("LoggingDestination", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("LoggingFormat", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("LoggingLevel", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("LoggingLimit", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("MachineId", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("MachineName", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("MemberName", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("MemoryAvailableMB", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("MemoryMaxMB", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("MulticastAddress", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("MulticastEnabled", in.readBoolean());
        mapSnapshot.put("MulticastPort", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("MulticastThreshold", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("MulticastTTL", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("NackEnabled", in.readBoolean());
        mapSnapshot.put("NackSent", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("PacketDeliveryEfficiency", new Float(in.readFloat()));
        mapSnapshot.put("PacketsBundled", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("PacketsReceived", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("PacketsRepeated", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("PacketsResent", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("PacketsResentEarly", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("PacketsResentExcess", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("PacketsSent", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("Priority", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("ProcessName", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("ProductEdition", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("PublisherPacketUtilization", new Float(in.readFloat()));
        mapSnapshot.put("PublisherSuccessRate", new Float(in.readFloat()));
        mapSnapshot.put("RackName", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("ReceiverPacketUtilization", new Float(in.readFloat()));
        mapSnapshot.put("ReceiverSuccessRate", new Float(in.readFloat()));
        mapSnapshot.put("ResendDelay", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("RoleName", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("SendAckDelay", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("SendQueueSize", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("SiteName", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("SocketCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("Statistics", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("TcpRingFailures", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TcpRingTimeouts", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("Timestamp", new Date(ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TrafficJamCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("TrafficJamDelay", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("UnicastAddress", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("UnicastPort", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("WellKnownAddresses", ExternalizableHelper.readStringArray((DataInput)in));
        mapSnapshot.put("WeakestChannel", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
    }

    public void resetStatistics() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        if (clusterSafe.isRunning()) {
            Cluster cluster = (Cluster)clusterSafe.getCluster();
            cluster.resetStats();
        }
    }

    public void setBufferPublishSize(int cPackets) {
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cPackets != this.getBufferPublishSize()) {
            this.checkRange("BufferPublishSize", cPackets, 1, Integer.MAX_VALUE);
            try {
                UnicastUdpSocket socket = publisher.getUdpSocketUnicast();
                Object object = socket.getLock();
                synchronized (object) {
                    socket.close();
                    socket.setBufferSent(cPackets);
                    socket.open();
                }
            }
            catch (Exception e) {
                Component._trace("Buffer resizing failed; stopping cluster service", 1);
                this.get_Cluster().stop();
                throw Base.ensureRuntimeException((Throwable)e);
            }
        }
    }

    public void setBufferReceiveSize(int cPackets) {
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cPackets != this.getBufferReceiveSize()) {
            this.checkRange("BufferReceiveSize", cPackets, 1, Integer.MAX_VALUE);
            try {
                UnicastUdpSocket socket = publisher.getUdpSocketUnicast();
                Object object = socket.getLock();
                synchronized (object) {
                    socket.close();
                    socket.setBufferReceived(cPackets);
                    socket.open();
                }
            }
            catch (Exception e) {
                Component._trace("Buffer resizing failed; stopping cluster service", 1);
                this.get_Cluster().stop();
                throw Base.ensureRuntimeException((Throwable)e);
            }
        }
    }

    public void setBurstCount(int cPackets) {
        PacketSpeaker speaker = this.get_Speaker();
        if (!(speaker != null) ? false : cPackets != this.getBurstCount()) {
            this.checkReadOnly("setBurstCount");
            speaker.setBurstCount(cPackets);
        }
    }

    public void setBurstDelay(int cMillis) {
        PacketSpeaker speaker = this.get_Speaker();
        if (!(speaker != null) ? false : cMillis != this.getBurstDelay()) {
            this.checkRange("setBurstDelay", cMillis, 1, 100);
            speaker.setBurstDelay(cMillis);
        }
    }

    public void setLoggingFormat(String sFormat) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        if (!(logger != null) ? false : Base.equals((Object)sFormat, (Object)this.getLoggingFormat()) ^ true) {
            this.checkReadOnly("setLoggerFormat");
            logger.setFormat(sFormat);
        }
    }

    public void setLoggingLevel(int nLevel) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        if (!(logger != null) ? false : nLevel != this.getLoggingLevel()) {
            this.checkRange("setLoggerLevel", nLevel, -1, Integer.MAX_VALUE);
            logger.setLevel(nLevel);
        }
    }

    public void setLoggingLimit(int cChars) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        if (!(logger != null) ? false : cChars != this.getLoggingLimit()) {
            this.checkRange("setLoggerLimit", cChars, 0, Integer.MAX_VALUE);
            logger.setLimit(cChars);
        }
    }

    public void setMulticastThreshold(int nThreshold) {
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : nThreshold != this.getMulticastThreshold()) {
            this.checkRange("setMulticastThreshold", nThreshold, 0, 100);
            publisher.setMulticastThreshold(0.01 * (double)nThreshold);
        }
    }

    public void setResendDelay(int cMillis) {
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cMillis != this.getResendDelay()) {
            this.checkRange("setResendDelay", cMillis, 10, 1000);
            publisher.setResendDelay(cMillis);
        }
    }

    public void setSendAckDelay(int cMillis) {
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cMillis != this.getSendAckDelay()) {
            this.checkRange("setSendAckDelay", cMillis, 1, 100);
            publisher.setAckDelay(cMillis);
        }
    }

    public void setTrafficJamCount(int cPackets) {
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cPackets != this.getTrafficJamCount()) {
            this.checkReadOnly("setTrafficJamCount");
            publisher.setCloggedCount(cPackets);
        }
    }

    public void setTrafficJamDelay(int cMillis) {
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cMillis != this.getTrafficJamDelay()) {
            this.checkReadOnly("setTrafficJamDelay");
            publisher.setCloggedDelay(cMillis);
        }
    }

    public void set_Cluster(com.tangosol.net.Cluster member) {
        this.__m__Cluster = member;
    }

    public void set_Member(com.tangosol.net.Member member) {
        this.__m__Member = member;
    }

    public void shutdown() {
        this.checkReadOnly("shutdown");
        this.get_Cluster().shutdown();
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getBufferPublishSize());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getBufferReceiveSize());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getBurstCount());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getBurstDelay());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getCpuCount());
        out.writeBoolean(this.isFlowControlEnabled());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getId());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getLoggingDestination());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getLoggingFormat());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getLoggingLevel());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getLoggingLimit());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getMachineId());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getMachineName());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getMemberName());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getMemoryAvailableMB());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getMemoryMaxMB());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getMulticastAddress());
        out.writeBoolean(this.isMulticastEnabled());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getMulticastPort());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getMulticastThreshold());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getMulticastTTL());
        out.writeBoolean(this.isNackEnabled());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getNackSent());
        out.writeFloat(this.getPacketDeliveryEfficiency());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getPacketsBundled());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getPacketsReceived());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getPacketsRepeated());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getPacketsResent());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getPacketsResentEarly());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getPacketsResentExcess());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getPacketsSent());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getPriority());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getProcessName());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getProductEdition());
        out.writeFloat(this.getPublisherPacketUtilization());
        out.writeFloat(this.getPublisherSuccessRate());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getRackName());
        out.writeFloat(this.getReceiverPacketUtilization());
        out.writeFloat(this.getReceiverSuccessRate());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getResendDelay());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getRoleName());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getSendAckDelay());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getSendQueueSize());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getSiteName());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getSocketCount());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getStatistics());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTcpRingFailures());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTcpRingTimeouts());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTimestamp().getTime());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getTrafficJamCount());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getTrafficJamDelay());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getUnicastAddress());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getUnicastPort());
        ExternalizableHelper.writeStringArray((DataOutput)out, (String[])this.getWellKnownAddresses());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getWeakestChannel());
    }
}

