/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ServiceModel
extends LocalModel {
    private transient long __m_RequestTimeoutMillis;
    private transient long __m_TaskHungThresholdMillis;
    private transient long __m_TaskTimeoutMillis;
    private int __m_ThreadCount;
    private transient com.tangosol.net.Service __m__Service;
    private transient Map __m__ServiceData;

    public ServiceModel() {
        this(null, null, true);
    }

    public ServiceModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_ExpiryDelay(1000);
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected int calculateBackupOwnership(DistributedCache serviceDist) {
        int[] acBuckets = (int[])this.get_ServiceData().get("BackupBuckets");
        if (acBuckets == null) {
            acBuckets = serviceDist.calculateOwnership(null, false);
            this.get_ServiceData().put("BackupBuckets", acBuckets);
        }
        return acBuckets[serviceDist.getThisMember().getId()];
    }

    protected int calculateEndangered(DistributedCache serviceDist) {
        int[] acBuckets = (int[])this.get_ServiceData().get("BackupBuckets");
        if (acBuckets == null) {
            if (serviceDist.getBackupCount() == 0) {
                return -1;
            }
            if (serviceDist.getStorageMemberSet().size() <= 1) {
                return serviceDist.getPartitionCount();
            }
            acBuckets = serviceDist.calculateOwnership(null, false);
            this.get_ServiceData().put("BackupBuckets", acBuckets);
        }
        return acBuckets[0];
    }

    protected int calculatePrimaryOwnership(DistributedCache serviceDist) {
        int[] acBuckets = (int[])this.get_ServiceData().get("PrimeBuckets");
        if (acBuckets == null) {
            acBuckets = serviceDist.calculateOwnership(null, true);
            this.get_ServiceData().put("PrimeBuckets", acBuckets);
        }
        return acBuckets[serviceDist.getThisMember().getId()];
    }

    public int getBackupCount() {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof DistributedCache) {
            return ((DistributedCache)serviceImpl).getBackupCount();
        }
        if (serviceImpl instanceof CacheService) {
            return serviceImpl.getServiceMemberSet().size() - 1;
        }
        return -1;
    }

    public String getDescription() {
        SafeService serviceSafe = (SafeService)this.get_Service();
        return serviceSafe.getServiceName();
    }

    public int getOwnedPartitionsBackup() {
        Service serviceImpl = this.get_ServiceImpl();
        if (!(serviceImpl instanceof CacheService) ? false : serviceImpl.isRunning()) {
            if (serviceImpl instanceof DistributedCache) {
                DistributedCache serviceDist = (DistributedCache)serviceImpl;
                if (serviceDist.isLocalStorageEnabled()) {
                    return this.calculateBackupOwnership(serviceDist);
                }
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public int getOwnedPartitionsPrimary() {
        Service serviceImpl = this.get_ServiceImpl();
        if (!(serviceImpl instanceof CacheService) ? false : serviceImpl.isRunning()) {
            if (serviceImpl instanceof DistributedCache) {
                DistributedCache serviceDist = (DistributedCache)serviceImpl;
                if (serviceDist.isLocalStorageEnabled()) {
                    return this.calculatePrimaryOwnership(serviceDist);
                }
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public int getPartitionsAll() {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl instanceof DistributedCache) {
            return ((DistributedCache)serviceImpl).getPartitionCount();
        }
        return serviceImpl instanceof CacheService ? 1 : -1;
    }

    public int getPartitionsEndangered() {
        Service serviceImpl = this.get_ServiceImpl();
        if (!(serviceImpl instanceof CacheService) ? false : serviceImpl.isRunning()) {
            if (serviceImpl instanceof DistributedCache) {
                return this.calculateEndangered((DistributedCache)serviceImpl);
            }
            return serviceImpl.getServiceMemberSet().size() > 1 ? 0 : 1;
        }
        return -1;
    }

    public int getPartitionsUnbalanced() {
        Service serviceImpl = this.get_ServiceImpl();
        if (!(serviceImpl instanceof CacheService) ? false : serviceImpl.isRunning()) {
            if (serviceImpl instanceof DistributedCache) {
                DistributedCache serviceDist = (DistributedCache)serviceImpl;
                int cMembers = serviceDist.getStorageEnabledMembers().size();
                if (cMembers == 0) {
                    return serviceDist.getPartitionCount() * (serviceDist.getBackupCount() + 1);
                }
                int cBuckets = serviceDist.getPartitionCount();
                int cFairShare = Math.min(cBuckets / cMembers + 1, cBuckets);
                int[] acBucket = (int[])this.get_ServiceData().get("PrimeBuckets");
                if (acBucket == null) {
                    acBucket = serviceDist.calculateOwnership(null, true);
                    this.get_ServiceData().put("PrimeBuckets", acBucket);
                }
                int cUnbalanced = acBucket[0];
                int i = 1;
                int c = acBucket.length;
                while (i < c) {
                    cUnbalanced += Math.max(0, acBucket[i] - cFairShare);
                    ++i;
                }
                if ((cBuckets *= serviceDist.getBackupCount()) > 0) {
                    cFairShare = Math.min(cBuckets / cMembers + 1, cBuckets);
                    acBucket = (int[])this.get_ServiceData().get("BackupBuckets");
                    if (acBucket == null) {
                        acBucket = serviceDist.calculateOwnership(null, false);
                        this.get_ServiceData().put("BackupBuckets", acBucket);
                    }
                    cUnbalanced += acBucket[0];
                    i = 1;
                    c = acBucket.length;
                    while (i < c) {
                        cUnbalanced += Math.max(0, acBucket[i] - cFairShare);
                        ++i;
                    }
                }
                return cUnbalanced;
            }
            return 0;
        }
        return -1;
    }

    public int getPartitionsVulnerable() {
        Service serviceImpl = this.get_ServiceImpl();
        if (!(serviceImpl instanceof CacheService) ? false : serviceImpl.isRunning()) {
            if (serviceImpl instanceof DistributedCache) {
                DistributedCache serviceDist = (DistributedCache)serviceImpl;
                return serviceDist.getBackupCount() == 0 ? -1 : serviceDist.calculateVulnerable();
            }
            return serviceImpl.getServiceMemberSet().getDistantMembers(serviceImpl.getThisMember()).size() > 0 ? 0 : 1;
        }
        return -1;
    }

    public float getRequestAverageDuration() {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            long cMillisTotal = serviceImpl.getStatsPollDuration();
            long cRequests = serviceImpl.getStatsPollCount();
            return cRequests == 0L ? 0.0f : (float)((double)cMillisTotal / (double)cRequests);
        }
        return -1.0f;
    }

    public long getRequestMaxDuration() {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            return serviceImpl.getStatsPollMaxDuration();
        }
        return -1L;
    }

    public long getRequestPendingCount() {
        WindowedArray waPoll;
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null && (waPoll = serviceImpl.getPollArray()) != null) {
            long cPolls = 0;
            try {
                long i = waPoll.getFirstIndex();
                long j = waPoll.getLastIndex();
                while (i <= j) {
                    if (waPoll.get(i) != null) {
                        ++cPolls;
                    }
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            return cPolls;
        }
        return -1L;
    }

    public long getRequestPendingDuration() {
        WindowedArray waPoll;
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null && (waPoll = serviceImpl.getPollArray()) != null) {
            long cTimeMillis = Base.getSafeTimeMillis();
            long cMaxMillis = 0L;
            try {
                long i = waPoll.getFirstIndex();
                long j = waPoll.getLastIndex();
                while (i <= j) {
                    long cMillis;
                    Poll poll = (Poll)waPoll.get(i);
                    if (poll != null && (cMillis = cTimeMillis - poll.getInitTimeMillis()) > cMaxMillis) {
                        cMaxMillis = cMillis;
                    }
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            return cMaxMillis;
        }
        return -1L;
    }

    public long getRequestTimeoutCount() {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            return serviceImpl.getStatsTimeoutCount();
        }
        return -1L;
    }

    public long getRequestTimeoutMillis() {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            return serviceImpl.getRequestTimeout();
        }
        return -1L;
    }

    public long getRequestTotalCount() {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            return serviceImpl.getStatsPollCount();
        }
        return -1L;
    }

    public String getStatistics() {
        Service serviceImpl = this.get_ServiceImpl();
        return serviceImpl == null ? Model.canonicalString(null) : serviceImpl.formatStats();
    }

    public String getStatusHA() {
        int nEndangered = this.getPartitionsEndangered();
        if (nEndangered == -1) {
            return Model.canonicalString(null);
        }
        if (nEndangered > 0) {
            return "ENDANGERED";
        }
        return this.getPartitionsVulnerable() == 0 ? "MACHINE-SAFE" : "NODE-SAFE";
    }

    public int getStorageEnabledCount() {
        com.tangosol.net.Service service = this.get_Service();
        if (service.isRunning()) {
            if (service instanceof DistributedCacheService) {
                return ((DistributedCacheService)service).getStorageEnabledMembers().size();
            }
            if (service instanceof CacheService) {
                return service.getInfo().getServiceMembers().size();
            }
        }
        return -1;
    }

    public float getTaskAverageDuration() {
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            long cPoolTotal = pool.getStatsActiveMillis();
            long cTasks = pool.getStatsTaskCount();
            return cTasks == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTasks);
        }
        return -1.0f;
    }

    public int getTaskBacklog() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getQueue().size() : -1;
    }

    public long getTaskCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsTaskCount() : (long)-1;
    }

    public int getTaskHungCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsHungCount() : -1;
    }

    public long getTaskHungDuration() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsHungDuration() : -1L;
    }

    public String getTaskHungTaskId() {
        DaemonPool pool = this.get_DaemonPool();
        return Model.canonicalString((!(pool != null) ? false : pool.isStarted()) ? pool.getStatsHungTaskId() : null);
    }

    public long getTaskHungThresholdMillis() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getHungThreshold() : -1L;
    }

    public int getTaskMaxBacklog() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsMaxBacklog() : -1;
    }

    public int getTaskTimeoutCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsTimeoutCount() : 0;
    }

    public long getTaskTimeoutMillis() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getTaskTimeout() : 0L;
    }

    public int getThreadAbandonedCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getStatsAbandonedCount() : 0;
    }

    public float getThreadAverageActiveCount() {
        DaemonPool pool;
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null && (pool = serviceImpl.getDaemonPool()).isStarted()) {
            long cTotal = Base.getSafeTimeMillis() - serviceImpl.getStatsReset();
            long cPoolTotal = pool.getStatsActiveMillis();
            int cBacklog = pool.getStatsMaxBacklog();
            return cTotal == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTotal);
        }
        return -1.0f;
    }

    public int getThreadCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getDaemonCount() : 0;
    }

    public int getThreadIdleCount() {
        DaemonPool pool = this.get_DaemonPool();
        return (!(pool != null) ? false : pool.isStarted()) ? pool.getDaemonCount() - pool.getActiveDaemonCount() : -1;
    }

    public String getType() {
        String sType = null;
        try {
            sType = this.get_Service().getInfo().getServiceType();
        }
        catch (Exception exception) {}
        return Model.canonicalString(sType);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/ServiceModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected DaemonPool get_DaemonPool() {
        Service serviceImpl = this.get_ServiceImpl();
        return serviceImpl == null ? null : serviceImpl.getDaemonPool();
    }

    public static Component get_Instance() {
        return new ServiceModel();
    }

    private final Component get_Module() {
        return this;
    }

    public com.tangosol.net.Service get_Service() {
        return this.__m__Service;
    }

    protected Map get_ServiceData() {
        Map map = this.__m__ServiceData;
        if (map == null) {
            map = new LocalCache(Integer.MAX_VALUE, 1000);
            this.set_ServiceData(map);
        }
        return map;
    }

    protected Service get_ServiceImpl() {
        try {
            return (Service)((SafeService)this.get_Service()).getService();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public boolean isRunning() {
        return this.get_Service().isRunning();
    }

    public boolean isStorageEnabled() {
        com.tangosol.net.Service service = this.get_Service();
        return !service.isRunning() ? false : (service instanceof DistributedCacheService ? ((DistributedCacheService)service).isLocalStorageEnabled() : service instanceof CacheService);
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("BackupCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("OwnedPartitionsBackup", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("OwnedPartitionsPrimary", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("PartitionsAll", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("PartitionsEndangered", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("PartitionsUnbalanced", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("PartitionsVulnerable", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("RequestAverageDuration", new Float(in.readFloat()));
        mapSnapshot.put("RequestMaxDuration", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("RequestPendingCount", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("RequestPendingDuration", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("RequestTimeoutCount", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("RequestTimeoutMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("RequestTotalCount", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("Running", in.readBoolean() ? Boolean.TRUE : Boolean.FALSE);
        mapSnapshot.put("Statistics", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("StatusHA", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("StorageEnabled", in.readBoolean() ? Boolean.TRUE : Boolean.FALSE);
        mapSnapshot.put("StorageEnabledCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("TaskAverageDuration", new Float(in.readFloat()));
        mapSnapshot.put("TaskBacklog", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("TaskCount", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TaskHungCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("TaskHungDuration", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TaskHungTaskId", ExternalizableHelper.readSafeUTF((DataInput)in));
        mapSnapshot.put("TaskHungThresholdMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("TaskMaxBacklog", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("TaskTimeoutCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("TaskTimeoutMillis", Base.makeLong((long)ExternalizableHelper.readLong((DataInput)in)));
        mapSnapshot.put("ThreadAbandonedCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("ThreadAverageActiveCount", new Float(in.readFloat()));
        mapSnapshot.put("ThreadCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("ThreadIdleCount", Base.makeInteger((int)ExternalizableHelper.readInt((DataInput)in)));
        mapSnapshot.put("Type", ExternalizableHelper.readSafeUTF((DataInput)in));
    }

    public String reportOwnership() {
        Service serviceImpl = this.get_ServiceImpl();
        if (!(serviceImpl instanceof DistributedCache) ? false : serviceImpl.isRunning()) {
            String s = ((DistributedCache)serviceImpl).reportOwnership(false);
            return Base.replace((String)s, (String)"\n", (String)"<br/>");
        }
        return Model.canonicalString(null);
    }

    public void resetStatistics() {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            serviceImpl.resetStats();
        }
    }

    public void setRequestTimeoutMillis(long cMillis) {
        Service serviceImpl = this.get_ServiceImpl();
        if (serviceImpl != null) {
            serviceImpl.setRequestTimeout(Math.max(0L, cMillis));
        }
    }

    public void setTaskHungThresholdMillis(long cMillis) {
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            this.checkReadOnly("setTaskHungThresholdMillis");
            pool.setHungThreshold(cMillis);
        } else if (cMillis > (long)0) {
            throw new IllegalArgumentException("ThreadPool is not configured");
        }
    }

    public void setTaskTimeoutMillis(long cMillis) {
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            this.checkReadOnly("setTaskTimeoutMillis");
            pool.setTaskTimeout(cMillis);
        } else if (cMillis > (long)0) {
            throw new IllegalArgumentException("ThreadPool is not configured");
        }
    }

    public void setThreadCount(int cThreads) {
        DaemonPool pool = this.get_DaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            this.checkRange("setThreadCount", cThreads, 1, 512);
            pool.setDaemonCount(cThreads);
        } else if (cThreads > 0) {
            throw new IllegalArgumentException("ThreadPool cannot be started dynamically");
        }
    }

    public void set_Service(com.tangosol.net.Service service) {
        this.__m__Service = service;
    }

    protected void set_ServiceData(Map map) {
        this.__m__ServiceData = map;
    }

    public void shutdown() {
        this.checkReadOnly("shutdown");
        this.get_Service().shutdown();
    }

    public void start() {
        this.checkReadOnly("start");
        this.get_Service().start();
    }

    public void stop() {
        this.checkReadOnly("stop");
        this.get_Service().stop();
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getBackupCount());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getOwnedPartitionsBackup());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getOwnedPartitionsPrimary());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getPartitionsAll());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getPartitionsEndangered());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getPartitionsUnbalanced());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getPartitionsVulnerable());
        out.writeFloat(this.getRequestAverageDuration());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getRequestMaxDuration());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getRequestPendingCount());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getRequestPendingDuration());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getRequestTimeoutCount());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getRequestTimeoutMillis());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getRequestTotalCount());
        out.writeBoolean(this.isRunning());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getStatistics());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getStatusHA());
        out.writeBoolean(this.isStorageEnabled());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getStorageEnabledCount());
        out.writeFloat(this.getTaskAverageDuration());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getTaskBacklog());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTaskCount());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getTaskHungCount());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTaskHungDuration());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getTaskHungTaskId());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTaskHungThresholdMillis());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getTaskMaxBacklog());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getTaskTimeoutCount());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.getTaskTimeoutMillis());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getThreadAbandonedCount());
        out.writeFloat(this.getThreadAverageActiveCount());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getThreadCount());
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.getThreadIdleCount());
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.getType());
    }
}

