/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.memberSet.actualMemberSet;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.MemberSet$Iterator;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.license.LicensedObject;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;

public class MasterMemberSet
extends ActualMemberSet {
    public static final int MAX_MEMBERS = 8160;
    private Map __m_MemberMap;
    private Member __m_OldestMember;
    private int __m_RecycleMillis;
    private ActualMemberSet __m_RecycleSet;
    private Member __m_ThisMember;
    private static ListMap __mapChildren;

    static {
        MasterMemberSet.__initStatic();
    }

    public MasterMemberSet() {
        this(null, null, true);
    }

    public MasterMemberSet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMemberMap((Map)new SafeHashMap());
            this.setRecycleMillis(60000);
            this.setRecycleSet(new ActualMemberSet());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Iterator", (Object)MemberSet$Iterator.get_CLASS());
    }

    public synchronized boolean add(Object o) {
        if (super.add(o)) {
            Member memberNew = (Member)o;
            this.getMemberMap().put(memberNew.getUid32(), memberNew);
            Member memberOld = this.getOldestMember();
            if (memberOld == null ? true : memberNew.getUid32().compareTo((Object)memberOld.getUid32()) < 0) {
                this.setOldestMember(memberNew);
            }
            this.getRecycleSet().remove(memberNew.getId());
            return true;
        }
        return false;
    }

    public synchronized void clear() {
        throw new UnsupportedOperationException();
    }

    public Member findDeadMember(Member member) {
        Member memberDead = this.getRecycleSet().getMember(member.getId());
        return (!(memberDead != null) ? false : memberDead.getUid32().equals((Object)member.getUid32())) ? memberDead : null;
    }

    public Member getMember(UUID uid) {
        return (Member)this.getMemberMap().get(uid);
    }

    protected Map getMemberMap() {
        return this.__m_MemberMap;
    }

    public Member getOldestMember() {
        return this.__m_OldestMember;
    }

    public int getRecycleMillis() {
        return this.__m_RecycleMillis;
    }

    public ActualMemberSet getRecycleSet() {
        return this.__m_RecycleSet;
    }

    public Member getThisMember() {
        return this.__m_ThisMember;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/memberSet/actualMemberSet/MasterMemberSet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new MasterMemberSet();
    }

    private final Component get_Module() {
        return this;
    }

    public final synchronized int induct(Member memberNew, ClusterService service) {
        Component._assert(!(memberNew != null) ? false : memberNew.getId() <= 1);
        Component._assert(this.getThisMember() == this.getOldestMember());
        if (((Cluster)service.getCluster()).getConfig().isAuthorizedHost(memberNew.getAddress()) ^ true) {
            return MAX_MEMBERS + 1;
        }
        if (LicensedObject.isExpired()) {
            return MAX_MEMBERS + 4;
        }
        int nDiff = service.ensureWkaMember(memberNew);
        if (!(memberNew != this.getOldestMember()) ? false : nDiff <= 0) {
            long lCutoffMillis = Base.getSafeTimeMillis() - (long)this.getRecycleMillis();
            ActualMemberSet setRecycle = this.getRecycleSet();
            int i = 1;
            while (i <= MAX_MEMBERS) {
                Member memberDead;
                if (this.contains(i) ^ true && ((memberDead = ((MemberSet)setRecycle).getMember(i)) == null ? true : memberDead.getTimestamp() < lCutoffMillis)) {
                    memberNew.setId(i);
                    this.add(memberNew);
                    return nDiff;
                }
                ++i;
            }
            nDiff = MAX_MEMBERS;
        }
        return nDiff;
    }

    public synchronized boolean remove(Object o) {
        Component._assert(o != this.getThisMember());
        if (super.remove(o)) {
            Member member = (Member)o;
            this.getMemberMap().remove(member.getUid32());
            member.setDead(true);
            this.getRecycleSet().add(member);
            if (member == this.getOldestMember()) {
                Member memberOldest = null;
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    Member memberCur = (Member)iter.next();
                    if (!(memberOldest == null ? true : memberCur.getUid32().compareTo((Object)memberOldest.getUid32()) < 0)) continue;
                    memberOldest = memberCur;
                }
                this.setOldestMember(memberOldest);
            }
            return true;
        }
        return false;
    }

    protected void setMemberMap(Map map) {
        this.__m_MemberMap = map;
    }

    protected void setOldestMember(Member member) {
        this.__m_OldestMember = member;
    }

    public void setRecycleMillis(int cMillis) {
        this.__m_RecycleMillis = cMillis;
    }

    protected void setRecycleSet(ActualMemberSet set) {
        this.__m_RecycleSet = set;
    }

    public void setThisMember(Member member) {
        Component._assert(!(member != null) ? false : member.getId() != 0);
        Component._assert(this.getThisMember() == null ? true : member == this.getThisMember());
        this.__m_ThisMember = member;
    }

    public String toString() {
        return String.valueOf("MasterMemberSet") + "\n  (" + "\n  ThisMember=" + this.getThisMember() + "\n  OldestMember=" + this.getOldestMember() + "\n  ActualMemberSet=" + Base.indentString((String)super.toString(), (String)"  ", (boolean)false) + "\n  RecycleMillis=" + this.getRecycleMillis() + "\n  RecycleSet=" + Base.indentString((String)this.getRecycleSet().toString(), (String)"  ", (boolean)false) + "\n  )";
    }
}

