/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class NotifyPacket
extends Packet {
    private int[] __m_MessageId;
    private int[] __m_MessagePartIndex;
    private int __m_NotifyCount;
    private volatile long __m_ScheduledMillis;

    public NotifyPacket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addPacket(int nMsgId, int nMsgPart) {
        Component._assert(this.isOutgoing());
        int c = this.getNotifyCount();
        this.setMessageId(c, nMsgId);
        this.setMessagePartIndex(c, nMsgPart);
        this.setNotifyCount(c + 1);
    }

    public void addPacket(MessagePacket packet) {
        this.addPacket(Packet.makeTrint(packet.getFromMessageId()), packet.getMessagePartIndex());
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        int c = this.getNotifyCount();
        sb.append("NotifyCount=").append(c);
        if (c > 0) {
            sb.append(", MessageId:MessagePartIndex=[");
            int i = 0;
            while (i < c) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getMessageId(i)).append(':').append(this.getMessagePartIndex(i));
                ++i;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected int[] getMessageId() {
        return this.__m_MessageId;
    }

    public int getMessageId(int i) {
        return this.getMessageId()[i];
    }

    protected int[] getMessagePartIndex() {
        return this.__m_MessagePartIndex;
    }

    public int getMessagePartIndex(int i) {
        return this.getMessagePartIndex()[i];
    }

    public int getNotifyCount() {
        return this.__m_NotifyCount;
    }

    public long getScheduledMillis() {
        return this.__m_ScheduledMillis;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/NotifyPacket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public void read(DataInputStream stream, int nMemberId) throws IOException {
        this.setToId(stream.readUnsignedShort());
        this.setFromId(stream.readUnsignedShort());
        this.readBody(stream);
    }

    public void readBody(DataInputStream stream) throws IOException {
        int c = stream.readUnsignedShort();
        this.setNotifyCount(c);
        this.setMessageId(new int[c]);
        this.setMessagePartIndex(new int[c]);
        int i = 0;
        while (i < c) {
            this.setMessageId(i, Packet.readUnsignedTrint(stream));
            this.setMessagePartIndex(i, Packet.readUnsignedTrint(stream));
            ++i;
        }
    }

    protected void setMessageId(int i, int nMsgId) {
        int[] an = this.getMessageId();
        if (an == null ? true : i >= an.length) {
            int cNew = Math.max(i + (i >>> 1), 16);
            int[] anNew = new int[cNew];
            if (an != null) {
                System.arraycopy(an, 0, anNew, 0, an.length);
            }
            an = anNew;
            this.setMessageId(anNew);
        }
        an[i] = nMsgId;
    }

    protected void setMessageId(int[] anMsgId) {
        this.__m_MessageId = anMsgId;
    }

    protected void setMessagePartIndex(int i, int nMsgPart) {
        int[] an = this.getMessagePartIndex();
        if (an == null ? true : i >= an.length) {
            int cNew = Math.max(i + (i >>> 1), 16);
            int[] anNew = new int[cNew];
            if (an != null) {
                System.arraycopy(an, 0, anNew, 0, an.length);
            }
            an = anNew;
            this.setMessagePartIndex(anNew);
        }
        an[i] = nMsgPart;
    }

    protected void setMessagePartIndex(int[] anMsgPart) {
        this.__m_MessagePartIndex = anMsgPart;
    }

    protected void setNotifyCount(int c) {
        this.__m_NotifyCount = c;
    }

    public void setScheduledMillis(long cMillis) {
        this.__m_ScheduledMillis = cMillis;
    }

    public static void skip(DataInputStream stream, int nType) throws IOException {
        stream.readUnsignedShort();
        stream.readUnsignedShort();
        NotifyPacket.skipBody(stream);
    }

    public static void skipBody(DataInputStream stream) throws IOException {
        int cbSkip = stream.readUnsignedShort() * 6;
        long cbSkipped = stream.skip(cbSkip);
        Component._assert(cbSkipped == (long)cbSkip);
    }

    public void write(DataOutputStream stream, MemberSet setTo) throws IOException {
        stream.writeInt(this.getPacketType());
        stream.writeShort(this.getToId());
        stream.writeShort(this.getFromId());
        this.writeBody(stream);
    }

    public void writeBody(DataOutputStream stream) throws IOException {
        int c = this.getNotifyCount();
        int[] anMsgId = this.getMessageId();
        int[] anMsgPart = this.getMessagePartIndex();
        stream.writeShort(c);
        int i = 0;
        while (i < c) {
            Packet.writeTrint(stream, anMsgId[i]);
            Packet.writeTrint(stream, anMsgPart[i]);
            ++i;
        }
    }
}

