/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.messagePacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Time;
import java.util.Iterator;

public class Directed
extends MessagePacket {
    private int __m_ToMessageId;

    public Directed() {
        this(null, null, true);
    }

    public Directed(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDeliveryState(0);
            this.setPacketType(232718548);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("ToMemberSet=");
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append('[');
            boolean fFirst = true;
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                Member member = (Member)iter.next();
                int nMember = member.getId();
                sb.append(nMember);
                int nToMsgId = setMember.getDestinationMessageId(nMember);
                if (!(nToMsgId != 0)) continue;
                sb.append('(').append(nToMsgId).append(')');
            }
            sb.append(']');
        }
        long ldtResend = this.getResendScheduled();
        long ldtTimeout = this.getResendTimeout();
        String sResend = ldtResend <= (long)0 ? "none" : String.valueOf(new Time(ldtResend).toString()) + "." + ldtResend % (long)1000;
        String sTimeout = ldtTimeout <= (long)0 ? "none" : String.valueOf(new Time(ldtTimeout).toString()) + "." + ldtTimeout % (long)1000;
        sb.append(", ServiceId=").append(this.getServiceId()).append(", MessageType=").append(this.getMessageType()).append(", FromMessageId=").append(this.getFromMessageId()).append(", ToMessageId=").append(this.getToMessageId()).append(", MessagePartCount=").append(this.getMessagePartCount()).append(", MessagePartIndex=").append(this.getMessagePartIndex()).append(", NackInProgress=").append(this.isNackInProgress()).append(", ResendScheduled=").append(sResend).append(", Timeout=").append(sTimeout).append(", PendingResendSkips=").append(this.getPendingResendSkips()).append(", DeliveryState=").append(this.formatDeliveryState(this.getDeliveryState())).append(", Body=");
        byte[] ab = this.getBody();
        if (ab == null) {
            sb.append("null");
        } else {
            if (ab.length > 128) {
                sb.append(Base.toHexEscape((byte[])ab, (int)0, (int)128)).append("...");
            } else {
                sb.append(Base.toHexEscape((byte[])ab));
            }
            sb.append(", Body.length=").append(ab.length);
        }
        return sb.toString();
    }

    public int getDestinationMessageId(int nMemberId) {
        if (nMemberId == this.getToId()) {
            return this.getToMessageId();
        }
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember != null) {
            return setMember.getDestinationMessageId(nMemberId);
        }
        return 0;
    }

    public int getToMessageId() {
        return this.__m_ToMessageId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/messagePacket/Directed".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Directed();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isConfirmationRequired() {
        return true;
    }

    public void read(DataInputStream stream, int nMemberId) throws IOException {
        int cMembers = 0;
        int iMember = -1;
        switch (this.getPacketType()) {
            case 232718549: {
                int nIdTmp = stream.readUnsignedShort();
                Component._assert(nIdTmp == nMemberId);
                cMembers = 1;
                iMember = 0;
                break;
            }
            case 232718547: {
                cMembers = stream.readUnsignedByte();
                int i = 0;
                while (i < cMembers) {
                    if (stream.readUnsignedShort() == nMemberId) {
                        iMember = i;
                    }
                    ++i;
                }
                break;
            }
            case 232718548: {
                int cBitSets = stream.readUnsignedByte();
                int nTheSet = Member.calcByteOffset(nMemberId);
                int nTheMask = Member.calcByteMask(nMemberId);
                int nPartial = nTheMask >>> 1;
                int i = 1;
                int iShift = 1;
                while (i <= 5) {
                    nPartial |= nPartial >>> iShift;
                    ++i;
                    iShift <<= 1;
                }
                i = 0;
                while (i < cBitSets) {
                    int nBits = stream.readInt();
                    if (i == nTheSet) {
                        Component._assert((nBits & nTheMask) != 0);
                        iMember = cMembers + MemberSet.countBits(nBits & nPartial);
                    }
                    cMembers += MemberSet.countBits(nBits);
                    ++i;
                }
                int cMembersTmp = stream.readUnsignedShort();
                Component._assert(cMembersTmp == cMembers);
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + this.getPacketType());
            }
        }
        Component._assert(!(!(cMembers > 0) ? false : iMember >= 0) ? false : iMember < cMembers);
        int cbSkip = iMember * 3;
        if (cbSkip > 0) {
            long cbSkipped = stream.skip(cbSkip);
            Component._assert(cbSkipped == (long)cbSkip);
        }
        this.setToMessageId(Packet.readUnsignedTrint(stream));
        cbSkip = (cMembers - iMember - 1) * 3;
        if (cbSkip > 0) {
            long cbSkipped = stream.skip(cbSkip);
            Component._assert(cbSkipped == (long)cbSkip);
        }
        this.setFromId(stream.readUnsignedShort());
        this.setFromMessageId(Packet.readUnsignedTrint(stream));
        this.setMessagePartCount(Packet.readUnsignedTrint(stream));
        this.setServiceId(stream.readUnsignedShort());
        this.setMessageType(stream.readShort());
        this.readBody(stream);
    }

    public int selectType(MemberSet memberSet) {
        int cMembers = memberSet.size();
        switch (cMembers) {
            case 0: {
                throw new IllegalArgumentException("no members in set!");
            }
            case 1: {
                return Packet.TYPE_DIRECTED_ONE;
            }
            case 2: 
            case 3: {
                return Packet.TYPE_DIRECTED_FEW;
            }
        }
        if (cMembers > 255) {
            return Packet.TYPE_DIRECTED_MANY;
        }
        int cbFew = 19 + 5 * cMembers;
        int cbMany = 21 + 3 * cMembers + 4 * (memberSet.getLastId() / 32 + 1);
        return cbFew <= cbMany ? Packet.TYPE_DIRECTED_FEW : Packet.TYPE_DIRECTED_MANY;
    }

    public void setToMessageId(int nId) {
        this.__m_ToMessageId = nId;
    }

    public static void skip(DataInputStream stream, int nType) throws IOException {
        int cMembers = 0;
        long cbSkip = 0L;
        switch (nType) {
            case 232718549: {
                cMembers = 1;
                cbSkip += 2L;
                break;
            }
            case 232718547: {
                cMembers = stream.readUnsignedByte();
                cbSkip += (long)(cMembers << 1);
                break;
            }
            case 232718548: {
                int cBitSets = stream.readUnsignedByte();
                long cbSkipped = stream.skip(cbSkip += (long)(cBitSets << 2));
                Component._assert(cbSkipped == cbSkip);
                cbSkip = 0L;
                cMembers = stream.readUnsignedShort();
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        cbSkip += (long)cMembers * 3L;
        long cbSkipped = stream.skip(cbSkip += 12L);
        Component._assert(cbSkipped == cbSkip);
        MessagePacket.skipBody(stream);
    }

    public void write(DataOutputStream stream, MemberSet setTo) throws IOException {
        int nType = this.selectType(setTo);
        this.setPacketType(nType);
        stream.writeInt(nType);
        DependentMemberSet setMember = this.getToMemberSet();
        switch (nType) {
            case 232718549: {
                setTo.writeOne(stream);
                if (setMember == null) {
                    Packet.writeTrint(stream, this.getToMessageId());
                    break;
                }
                setMember.writeOneToMessageId(stream, setTo);
                break;
            }
            case 232718547: {
                setTo.writeFew(stream);
                setMember.writeFewToMessageId(stream, setTo);
                break;
            }
            case 232718548: {
                setTo.writeMany(stream);
                setMember.writeManyToMessageId(stream, setTo);
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        stream.writeShort(this.getFromId());
        Packet.writeTrint(stream, this.getFromMessageId());
        Packet.writeTrint(stream, this.getMessagePartCount());
        stream.writeShort(this.getServiceId());
        stream.writeShort(this.getMessageType());
        this.writeBody(stream);
    }
}

