/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.security;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$ClusterService;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.Security$RefAction;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.security.Standard$PermissionInfo;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.net.ClusterPermission;
import com.tangosol.net.Service;
import com.tangosol.net.security.AccessController;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;

public class Standard
extends Security {
    private transient AccessController __m_AccessController;
    private transient CallbackHandler __m_CallbackHandler;
    private transient String __m_ModuleName;
    private transient Map __m_ServiceContext;
    private transient Map __m_ServiceMemberContext;
    private transient ThreadLocal __m_ThreadContext;
    private static ListMap __mapChildren;

    static {
        Standard.__initStatic();
    }

    public Standard() {
        this(null, null, true);
    }

    public Standard(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_ServiceContext = new SafeHashMap();
            this.__m_ServiceMemberContext = new SafeHashMap();
            this.__m_ThreadContext = new ThreadLocal();
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"PermissionInfo", (Object)Standard$PermissionInfo.get_CLASS());
        Object object2 = __mapChildren.put((Object)"RefAction", (Object)Security$RefAction.get_CLASS());
    }

    public void checkPermission(com.tangosol.net.Cluster cluster, ClusterPermission permission) {
        Member memberSenior;
        Object oResponse;
        String sService;
        AccessController controller = this.getAccessController();
        Subject subject = (Subject)this.getThreadContext().get();
        if (subject == null) {
            subject = this.getTempSubject();
        }
        Component._assert((sService = permission.getServiceName()) != null);
        this.validateSubject(sService, subject);
        controller.checkPermission(permission, subject);
        if (cluster == null ? true : cluster.isRunning() ^ true) {
            return;
        }
        Cluster$ClusterService clusterservice = ((Cluster)cluster).getClusterService();
        com.tangosol.coherence.component.util.daemon.queueProcessor.Service service = clusterservice.getService(sService);
        if (!(service != null) ? false : service.isRunning()) {
            return;
        }
        ServiceInfo info = clusterservice.getServiceInfo(sService);
        if (info == null) {
            return;
        }
        do {
            if (!((memberSenior = (Member)info.getOldestMember()) == null)) continue;
            return;
        } while ((oResponse = clusterservice.pollSecure(memberSenior, this.encryptPermissionInfo(permission, subject))) == null);
        if (oResponse instanceof Throwable) {
            throw Base.ensureRuntimeException((Throwable)((Throwable)oResponse));
        }
        Standard$PermissionInfo responseInfo = (Standard$PermissionInfo)oResponse;
        ClusterPermission permissionResponse = responseInfo.getPermission();
        if (permissionResponse == null) {
            try {
                permissionResponse = (ClusterPermission)controller.decrypt(responseInfo.getSignedPermission(), responseInfo.getSubject(), subject);
            }
            catch (GeneralSecurityException e) {
                throw new AccessControlException("Security configuration mismatch or break-in attempt", (Permission)permission);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)"Security configuration mismatch");
            }
        }
        if (Base.equals((Object)permission, (Object)permissionResponse) ^ true) {
            throw new AccessControlException("Permission mismatch or break-in attempt", (Permission)permission);
        }
    }

    protected void configure(XmlElement xmlConfig) {
        boolean fEnabled;
        super.configure(xmlConfig);
        if (xmlConfig != null && (fEnabled = xmlConfig.getSafeElement("enabled").getBoolean())) {
            String sModule = xmlConfig.getSafeElement("login-module-name").getString("Coherence");
            XmlElement xmlAC = xmlConfig.getSafeElement("access-controller");
            XmlElement xmlCH = xmlConfig.getSafeElement("callback-handler");
            CallbackHandler handler = (CallbackHandler)Standard.newInstance(xmlCH);
            AccessController controller = (AccessController)Standard.newInstance(xmlAC);
            if (controller == null) {
                throw new RuntimeException("The 'access-controller' configuration element must be specified");
            }
            this.setAccessController(controller);
            this.setCallbackHandler(handler);
            this.setModuleName(sModule);
        }
    }

    protected Standard$PermissionInfo encryptPermissionInfo(ClusterPermission permission, Subject subject) {
        Standard$PermissionInfo info = new Standard$PermissionInfo();
        try {
            info.setPermission(permission);
            info.setServiceName(permission.getServiceName());
            info.setSignedPermission(this.getAccessController().encrypt((Object)permission, subject));
            info.setSubject(subject);
            return info;
        }
        catch (Exception e) {
            throw new SecurityException(String.valueOf("Invalid subject credentials: ") + e);
        }
    }

    public AccessController getAccessController() {
        return this.__m_AccessController;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.__m_CallbackHandler;
    }

    public String getModuleName() {
        return this.__m_ModuleName;
    }

    private Map getServiceContext() {
        return this.__m_ServiceContext;
    }

    private Map getServiceMemberContext() {
        return this.__m_ServiceMemberContext;
    }

    protected Object getSubjectSecure() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new AuthPermission("coherence.getSubject"));
        }
        return (Subject)this.getThreadContext().get();
    }

    protected Subject getTempSubject() {
        DomainCombiner dc;
        Object oContext;
        CallbackHandler handler = this.getCallbackHandler();
        if (handler != null) {
            return (Subject)this.loginSecure(handler);
        }
        SecurityManager manager = System.getSecurityManager();
        Object object = oContext = manager == null ? java.security.AccessController.getContext() : manager.getSecurityContext();
        if (oContext instanceof AccessControlContext && (dc = ((AccessControlContext)oContext).getDomainCombiner()) instanceof SubjectDomainCombiner) {
            return ((SubjectDomainCombiner)dc).getSubject();
        }
        throw new SecurityException(String.valueOf("Attempt to access a protected resource was made without credentials and ") + "the default 'callback-handler' was not configured.");
    }

    private ThreadLocal getThreadContext() {
        return this.__m_ThreadContext;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/security/Standard".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Standard();
    }

    private final Component get_Module() {
        return this;
    }

    public Object impersonate(Object oSubject, String sNameOld, String sNameNew) {
        Subject subject = (Subject)oSubject;
        Subject subjectNew = new Subject();
        Iterator iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            Principal p = (Principal)iter.next();
            String sName = p.getName();
            if (sName.indexOf(sNameOld) >= 0) {
                try {
                    sName = Base.replace((String)sName, (String)sNameOld, (String)sNameNew);
                    p = (Principal)ClassHelper.newInstance(p.getClass(), (Object[])new Object[]{sName});
                    Component._trace(String.valueOf("Successfully impersonated ") + p + "@" + p.getClass());
                }
                catch (Exception e) {
                    Component._trace(String.valueOf("Cannot impersonate ") + p + "@" + p.getClass());
                }
            }
            subjectNew.getPrincipals().add(p);
        }
        subjectNew.getPublicCredentials().addAll(subject.getPublicCredentials());
        subjectNew.getPrivateCredentials().addAll(subject.getPrivateCredentials());
        return subjectNew;
    }

    public Object loginSecure(Object oHandler) {
        LoginContext lc;
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new AuthPermission("coherence.login"));
        }
        CallbackHandler handler = (CallbackHandler)oHandler;
        try {
            lc = new LoginContext(this.getModuleName(), handler);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException((Throwable)e, (String)"Failed to create LoginContext");
        }
        try {
            lc.login();
            Subject subject = lc.getSubject();
            subject.setReadOnly();
            return subject;
        }
        catch (Exception e) {
            throw new SecurityException(String.valueOf("Authentication failed: ") + e.getMessage());
        }
    }

    protected static Object newInstance(XmlElement xmlConfig) {
        String sClass = xmlConfig.getSafeElement("class-name").getString();
        if (sClass.length() > 0) {
            XmlElement xmlParams = xmlConfig.getSafeElement("init-params");
            Object[] aoParam = XmlHelper.parseInitParams((XmlElement)xmlParams);
            try {
                return ClassHelper.newInstance(Class.forName(sClass), (Object[])aoParam);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    public Object processSecureRequest(Service service, Member memberFrom, Object oRequestInfo) {
        ClusterPermission permission;
        Subject subjCurrent;
        ClusterService clusterservice = (ClusterService)service;
        Component._assert(Thread.currentThread() == clusterservice.getThread());
        AccessController controller = this.getAccessController();
        Standard$PermissionInfo infoRequest = (Standard$PermissionInfo)oRequestInfo;
        String sService = infoRequest.getServiceName();
        ServiceInfo infoService = clusterservice.getServiceInfo(sService);
        Member memberThis = clusterservice.getThisMember();
        if (infoService == null ? true : infoService.getOldestMember() != memberThis) {
            return null;
        }
        Subject subjRequestor = infoRequest.getSubject();
        try {
            subjCurrent = (Subject)this.getServiceContext().get(sService);
            if (subjCurrent == null) {
                return new RuntimeException("No service context");
            }
            permission = memberFrom.equals(memberThis) ? infoRequest.getPermission() : (ClusterPermission)controller.decrypt(infoRequest.getSignedPermission(), subjRequestor, subjCurrent);
            Component._trace(String.valueOf("Remote permission request: ") + permission + " by " + memberFrom, 5);
            controller.checkPermission(permission, subjRequestor);
        }
        catch (Exception e) {
            return Base.ensureRuntimeException((Throwable)e, (String)"Remote permission check failed");
        }
        DependentMemberSet setMembers = (DependentMemberSet)this.getServiceMemberContext().get(sService);
        if (setMembers == null) {
            setMembers = new DependentMemberSet();
            setMembers.setBaseSet(infoService.getMemberSet());
            this.getServiceMemberContext().put(sService, setMembers);
        } else {
            setMembers.sync();
        }
        setMembers.add(memberFrom);
        try {
            return this.encryptPermissionInfo(permission, subjCurrent);
        }
        catch (Exception e) {
            return Base.ensureRuntimeException((Throwable)e, (String)"Remote encryption failed");
        }
    }

    public void releaseSecureContext(String sServiceName) {
        this.getServiceContext().remove(sServiceName);
    }

    public static Object runAnonymously(Object oAction) throws PrivilegedActionException {
        return Security.runAnonymously(oAction);
    }

    protected Object runSecure(Object oSubject, Object oAction) throws PrivilegedActionException {
        Subject subject;
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new AuthPermission("coherence.runAs"));
        }
        if ((subject = (Subject)oSubject) == null) {
            return Standard.runAnonymously(oAction);
        }
        this.getThreadContext().set(subject);
        try {
            Object t = oAction instanceof PrivilegedAction ? Subject.doAs(subject, (PrivilegedAction)oAction) : Subject.doAs(subject, (PrivilegedExceptionAction)oAction);
            Object var6_7 = null;
            this.getThreadContext().set(null);
            return t;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.getThreadContext().set(null);
            throw throwable;
        }
    }

    protected void setAccessController(AccessController controller) {
        this.__m_AccessController = controller;
    }

    protected void setCallbackHandler(CallbackHandler handler) {
        this.__m_CallbackHandler = handler;
    }

    protected void setModuleName(String sName) {
        this.__m_ModuleName = sName;
    }

    private void setServiceContext(Map mapCtx) {
        this.__m_ServiceContext = mapCtx;
    }

    private void setServiceMemberContext(Map map) {
        this.__m_ServiceMemberContext = map;
    }

    protected void setSubjectSecure(Object subject) {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new AuthPermission("coherence.setSubject"));
        }
        this.getThreadContext().set(subject);
    }

    private void setThreadContext(ThreadLocal ctx) {
        this.__m_ThreadContext = ctx;
    }

    protected void validateSubject(String sService, Subject subject) {
        Map mapContext = this.getServiceContext();
        Subject subjCurrent = (Subject)mapContext.get(sService);
        if (subject != subjCurrent) {
            AccessController controller = this.getAccessController();
            Double oTest = new Double(Math.random());
            try {
                Object o = controller.decrypt(controller.encrypt((Object)oTest, subject), subject, null);
                Component._assert(o.equals(oTest));
            }
            catch (Exception e) {
                throw new SecurityException(String.valueOf("Failed to verify the subject; reason=") + e);
            }
        }
        if (subjCurrent == null) {
            mapContext.put(sService, subject);
        }
    }

    public void verifySecureContext(Service service, String sServiceName, Member memberFrom) {
        ClusterService clusterservice = (ClusterService)service;
        Component._assert(Thread.currentThread() == clusterservice.getThread());
        boolean fSuccess = false;
        MemberSet setMembers = (MemberSet)this.getServiceMemberContext().get(sServiceName);
        if (setMembers != null) {
            fSuccess = setMembers.remove(memberFrom);
            if (setMembers.isEmpty()) {
                this.getServiceMemberContext().remove(sServiceName);
            }
        }
        if (fSuccess ^ true) {
            String sMsg = "Security configuration mismatch or break-in attempt";
            Component._trace(sMsg, 1);
            throw new SecurityException(sMsg);
        }
    }
}

