/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.component.net.socket.TcpSocket;
import com.tangosol.coherence.component.net.socket.TcpSocketAccepter$TcpSocket;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Map;

public class TcpSocketAccepter
extends Socket {
    private int __m_Backlog;
    private ServerSocket __m_ServerSocket;
    private static ListMap __mapChildren;

    static {
        TcpSocketAccepter.__initStatic();
    }

    public TcpSocketAccepter() {
        this(null, null, true);
    }

    public TcpSocketAccepter(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBacklog(32);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"TcpSocket", (Object)TcpSocketAccepter$TcpSocket.get_CLASS());
    }

    public TcpSocket accept() {
        while (true) {
            long lCurrent = Base.getSafeTimeMillis();
            IOException eIO = null;
            ServerSocket socketSrv = this.getServerSocket();
            try {
                if (socketSrv != null) {
                    java.net.Socket socket = socketSrv.accept();
                    TcpSocketAccepter$TcpSocket socketTcp = (TcpSocketAccepter$TcpSocket)this._newChild("TcpSocket");
                    socketTcp.setSocket(socket);
                    return socketTcp;
                }
            }
            catch (InterruptedIOException e) {
                this.onInterruptedIOException(e, lCurrent);
                return null;
            }
            catch (IOException e) {
                eIO = e;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (socketSrv == this.getServerSocket()) {
                    switch (this.getState()) {
                        case 1: {
                            this.onAcceptException(eIO, lCurrent);
                            break;
                        }
                        default: {
                            throw new ConnectionException(String.valueOf("TcpSocketAccepter.accept: ") + "unable to reopen socket; State=" + Socket.formatStateName(this.getState()), (Throwable)eIO);
                        }
                    }
                }
            }
        }
    }

    public void close() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != Socket.STATE_CLOSED) {
                ServerSocket socket = this.getServerSocket();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setServerSocket(null);
                }
                this.setState(Socket.STATE_CLOSED);
            }
        }
    }

    public int getBacklog() {
        return this.__m_Backlog;
    }

    public String getDescription() {
        if (this.getState() == Socket.STATE_OPEN) {
            ServerSocket socket = this.getServerSocket();
            return String.valueOf("ServerSocket=") + Socket.toString(socket.getInetAddress()) + ':' + socket.getLocalPort();
        }
        return super.getDescription();
    }

    public ServerSocket getServerSocket() {
        return this.__m_ServerSocket;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/socket/TcpSocketAccepter".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpSocketAccepter();
    }

    private final Component get_Module() {
        return this;
    }

    protected ServerSocket instantiateServerSocket() throws IOException {
        InetAddress addr = this.getInetAddress();
        int nPort = this.getPort();
        int cItems = this.getBacklog();
        Component._assert(addr != null, String.valueOf("TcpSocketAccepter.open: ") + "InetAddress is required");
        Component._assert(!(nPort > 0) ? false : nPort <= 65535, String.valueOf("TcpSocketAccepter.open: ") + "Port out of range (" + nPort + ")");
        Component._assert(!(cItems > 0) ? false : cItems <= 65535, String.valueOf("TcpSocketAccepter.open: ") + "Backlog out of range (" + cItems + ")");
        int cAttempts = (!this.isPortAutoSelect() ? false : this.getState() == Socket.STATE_INITIAL) ? 256 : 1;
        int nPortOrig = nPort;
        while (true) {
            try {
                ServerSocket socket = new ServerSocket(nPort, cItems, addr);
                if (nPort != nPortOrig) {
                    this.setPort(nPort);
                }
                return socket;
            }
            catch (BindException e) {
                if (--cAttempts == 0) {
                    throw e;
                }
                ++nPort;
                continue;
            }
            break;
        }
    }

    protected void onAcceptException(IOException eException, long lSocketActionMillis) {
        this.onException(eException, lSocketActionMillis);
    }

    public void open() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != Socket.STATE_OPEN) {
                ServerSocket socket = this.instantiateServerSocket();
                try {
                    try {
                        int cMillis = this.getSoTimeout();
                        Component._assert(cMillis >= 0, String.valueOf("TcpSocketAccepter.open: ") + "ReceiveTimeout property must be greater than or equal to zero");
                        socket.setSoTimeout(cMillis);
                        this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                    }
                    catch (SocketException e) {
                        throw new WrapperException((Throwable)e);
                    }
                    this.setServerSocket(socket);
                    this.setLastOpenMillis(Base.getSafeTimeMillis());
                }
                catch (RuntimeException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception eIgnore) {
                        // empty catch block
                    }
                    this.setServerSocket(null);
                    throw e;
                }
                this.setState(Socket.STATE_OPEN);
            }
        }
    }

    public void setBacklog(int cItems) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() == Socket.STATE_INITIAL, "Backlog cannot be modified once the socket has been opened");
            this.__m_Backlog = cItems;
        }
    }

    protected void setServerSocket(ServerSocket socket) {
        this.__m_ServerSocket = socket;
    }

    public void setSoTimeout(int cMillis) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(cMillis >= 0);
            if (this.getState() == Socket.STATE_OPEN) {
                ServerSocket socket = this.getServerSocket();
                try {
                    socket.setSoTimeout(cMillis);
                    this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                }
                catch (IOException e) {
                    throw new WrapperException((Throwable)e);
                }
            }
            super.setSoTimeout(cMillis);
        }
    }
}

