/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.component.net.UdpPacket;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.HashHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public abstract class UdpSocket
extends Socket {
    private transient int __m_ActualBufferSent;
    private int __m_BufferReceived;
    private int __m_BufferSent;
    private long __m_BytesReceived;
    private long __m_BytesSent;
    private int __m_CountReceived;
    private int __m_CountSent;
    private DatagramSocket __m_DatagramSocket;
    private int __m_PacketLength;
    private transient int __m_RxDebugDropRate;
    private transient int __m_TxDebugDropRate;

    public UdpSocket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void close() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != Socket.STATE_CLOSED) {
                DatagramSocket socket = this.getDatagramSocket();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setDatagramSocket(null);
                }
                this.setState(Socket.STATE_CLOSED);
            }
        }
    }

    public int getActualBufferSent() {
        return this.__m_ActualBufferSent;
    }

    public int getBufferReceived() {
        return this.__m_BufferReceived;
    }

    public int getBufferSent() {
        return this.__m_BufferSent;
    }

    public long getBytesReceived() {
        return this.__m_BytesReceived;
    }

    public long getBytesSent() {
        return this.__m_BytesSent;
    }

    public int getCountReceived() {
        return this.__m_CountReceived;
    }

    public int getCountSent() {
        return this.__m_CountSent;
    }

    public DatagramSocket getDatagramSocket() {
        return this.__m_DatagramSocket;
    }

    public int getPacketLength() {
        return this.__m_PacketLength;
    }

    public int getRxDebugDropRate() {
        return this.__m_RxDebugDropRate;
    }

    public int getTxDebugDropRate() {
        return this.__m_TxDebugDropRate;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/socket/UdpSocket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public int hashCode() {
        return HashHelper.hash((Object)this.getInetAddress(), (int)this.getPort());
    }

    protected void initializeDatagramSocket(DatagramSocket socket) {
        try {
            int cbPacket = this.getPacketLength();
            Component._assert(cbPacket > 0, String.valueOf("UdpSocket.open: ") + "PacketLength property is required and must be greater than zero");
            socket.setSendBufferSize(cbPacket * this.getBufferSent());
            int cBufferBytes = socket.getSendBufferSize();
            this.setActualBufferSent(cBufferBytes / cbPacket);
            this.validateBufferSize("send", cBufferBytes, cbPacket * this.getBufferSent(), cbPacket);
            socket.setReceiveBufferSize(cbPacket * this.getBufferReceived());
            this.validateBufferSize("receive", socket.getReceiveBufferSize(), cbPacket * this.getBufferReceived(), cbPacket);
            int cMillis = this.getSoTimeout();
            Component._assert(cMillis >= 0, String.valueOf("UdpSocket.open: ") + "SoTimeout property must be greater than or equal to zero");
            socket.setSoTimeout(cMillis);
            this.validateSoTimeout(socket.getSoTimeout(), cMillis);
        }
        catch (SocketException e) {
            throw new WrapperException((Throwable)e);
        }
    }

    protected DatagramSocket instantiateDatagramSocket() throws IOException {
        InetAddress addr = this.getInetAddress();
        int nPort = this.getPort();
        Component._assert(addr != null, String.valueOf("UdpSocket.open: ") + "InetAddress is required");
        Component._assert(!(nPort > 0) ? false : nPort <= 65535, String.valueOf("UdpSocket.open: ") + "Port out of range (" + nPort + ")");
        int cAttempts = (!this.isPortAutoSelect() ? false : this.getState() == Socket.STATE_INITIAL) ? 256 : 1;
        int nPortOrig = nPort;
        while (true) {
            try {
                DatagramSocket socket = new DatagramSocket(nPort, addr);
                if (nPort != nPortOrig) {
                    this.setPort(nPort);
                }
                return socket;
            }
            catch (BindException e) {
                if (--cAttempts == 0) {
                    throw e;
                }
                ++nPort;
                continue;
            }
            break;
        }
    }

    protected void onReceiveException(IOException eException, long lSocketActionMillis) {
        this.onException(eException, lSocketActionMillis);
    }

    protected void onSendException(IOException eException, long lSocketActionMillis) {
        this.onException(eException, lSocketActionMillis);
    }

    public void open() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != Socket.STATE_OPEN) {
                DatagramSocket socket = this.instantiateDatagramSocket();
                try {
                    this.initializeDatagramSocket(socket);
                    this.setDatagramSocket(socket);
                    this.setLastOpenMillis(Base.getSafeTimeMillis());
                }
                catch (RuntimeException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception eIgnore) {
                        // empty catch block
                    }
                    this.setDatagramSocket(null);
                    throw e;
                }
                this.setCountSent(0);
                this.setCountReceived(0);
                this.setBytesSent(0L);
                this.setBytesReceived(0L);
                this.setState(Socket.STATE_OPEN);
            }
        }
    }

    public void receive(UdpPacket packet) {
        while (true) {
            IOException eIO = null;
            DatagramSocket socket = this.getDatagramSocket();
            try {
                if (socket != null) {
                    int cbAvail = packet.getBufferLength() - packet.getOffset();
                    int cbMax = this.getPacketLength();
                    packet.setLength(Math.min(cbAvail, cbMax));
                    socket.receive(packet.getDatagramPacket());
                    int iRxDropRate = this.getRxDebugDropRate();
                    if (!(iRxDropRate == 0 ? true : iRxDropRate <= Base.getRandom().nextInt(100000))) continue;
                    this.setCountReceived(this.getCountReceived() + 1);
                    this.setBytesReceived(this.getBytesReceived() + (long)packet.getLength());
                    return;
                }
            }
            catch (InterruptedIOException e) {
                this.onInterruptedIOException(e, Base.getSafeTimeMillis());
                return;
            }
            catch (IOException e) {
                eIO = e;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (socket == this.getDatagramSocket()) {
                    if (this.getState() == Socket.STATE_OPEN) {
                        this.onReceiveException(eIO, Base.getSafeTimeMillis());
                    } else {
                        throw new ConnectionException(String.valueOf("UdpSocket.receive: ") + "unable to reopen socket; State=" + Socket.formatStateName(this.getState()), (Throwable)eIO);
                    }
                }
            }
        }
    }

    public void send(UdpPacket packet) {
        int iTxDropRate = this.getTxDebugDropRate();
        while (true) {
            IOException eIO = null;
            DatagramSocket socket = this.getDatagramSocket();
            try {
                if (socket != null) {
                    if (iTxDropRate == 0 ? true : iTxDropRate < Base.getRandom().nextInt(100000)) {
                        socket.send(packet.getDatagramPacket());
                    }
                    this.setCountSent(this.getCountSent() + 1);
                    this.setBytesSent(this.getBytesSent() + (long)packet.getLength());
                    return;
                }
            }
            catch (IOException e) {
                eIO = e;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (socket == this.getDatagramSocket()) {
                    if (this.getState() == Socket.STATE_OPEN) {
                        this.onSendException(eIO, Base.getSafeTimeMillis());
                    } else {
                        throw new ConnectionException(String.valueOf("UdpSocket.send: ") + "unable to reopen socket; State=" + Socket.formatStateName(this.getState()), (Throwable)eIO);
                    }
                }
            }
        }
    }

    protected void setActualBufferSent(int cPackets) {
        this.__m_ActualBufferSent = cPackets;
    }

    public void setBufferReceived(int cPackets) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() != Socket.STATE_OPEN, "BufferReceived cannot be modified once the socket is open");
            this.__m_BufferReceived = cPackets;
        }
    }

    public void setBufferSent(int cPackets) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() != Socket.STATE_OPEN, "BufferSent cannot be modified once the socket is open");
            this.__m_BufferSent = cPackets;
        }
    }

    public void setBytesReceived(long cBytes) {
        this.__m_BytesReceived = cBytes;
    }

    public void setBytesSent(long cBytes) {
        this.__m_BytesSent = cBytes;
    }

    protected void setCountReceived(int cReceived) {
        this.__m_CountReceived = cReceived;
    }

    protected void setCountSent(int cSent) {
        this.__m_CountSent = cSent;
    }

    protected void setDatagramSocket(DatagramSocket socket) {
        this.__m_DatagramSocket = socket;
    }

    public void setPacketLength(int cb) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() != Socket.STATE_OPEN, "PacketLength cannot be modified once the socket is open");
            this.__m_PacketLength = cb;
        }
    }

    public void setRxDebugDropRate(int iRate) {
        if (iRate != this.getRxDebugDropRate()) {
            this.__m_RxDebugDropRate = iRate;
            Component._trace(String.valueOf("Configuring ") + this + " to drop " + (float)iRate / 1000.0f + "% of incomming packets.", 2);
        }
    }

    public void setSoTimeout(int cMillis) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(cMillis >= 0);
            if (this.getState() == Socket.STATE_OPEN) {
                DatagramSocket socket = this.getDatagramSocket();
                try {
                    socket.setSoTimeout(cMillis);
                    this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                }
                catch (SocketException e) {
                    throw new WrapperException((Throwable)e);
                }
            }
            super.setSoTimeout(cMillis);
        }
    }

    public void setTxDebugDropRate(int iRate) {
        if (iRate != this.getTxDebugDropRate()) {
            this.__m_TxDebugDropRate = iRate;
            Component._trace(String.valueOf("Configuring ") + this + " to drop " + (float)iRate / 1000.0f + "% of outgoing packets.", 2);
        }
    }

    protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
        if (cbActualSize < cbRequestedSize) {
            int iPacketLength = this.getPacketLength();
            String sMsg = String.valueOf(this.get_Name()) + " failed to set " + sBufferName + " buffer size to " + cbRequestedSize / iPacketLength + " packets (" + cbRequestedSize + " bytes); " + "actual size is " + cbActualSize / iPacketLength + " packets (" + cbActualSize + " bytes). " + "Consult your OS documentation regarding increasing the maximum socket buffer size.";
            if (cbActualSize < cbMinimumSize) {
                Component._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            sMsg = String.valueOf(sMsg) + " Proceeding with the actual value may cause sub-optimal performance.";
            Component._trace(sMsg, 2);
        }
    }
}

