/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.DaemonPool$Queue;
import com.tangosol.coherence.component.util.DaemonPool$StopTask;
import com.tangosol.coherence.component.util.DaemonPool$WrapperTask;
import com.tangosol.net.PriorityTask;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.WrapperException;
import java.util.List;

public class DaemonPool$Daemon
extends Daemon {
    private volatile transient int __m_InterruptCount;
    private DaemonPool$Queue __m_Queue;
    private volatile transient DaemonPool$WrapperTask __m_WrapperTask;

    public DaemonPool$Daemon() {
        this(null, null, true);
    }

    public DaemonPool$Daemon(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setThreadName("Worker");
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void abandon() {
        boolean fAbandon = false;
        Thread thread = null;
        DaemonPool$Daemon daemonPool$Daemon = this;
        synchronized (daemonPool$Daemon) {
            thread = this.getThread();
            if (thread == null) {
                Object var4_4 = null;
                return;
            }
            if (!this.isStarted() ? false : this.isExiting() ^ true) {
                fAbandon = true;
                this.setExiting(true);
            }
        }
        if (fAbandon) {
            DaemonPool pool = (DaemonPool)this.get_Module();
            DaemonPool$WrapperTask wrapper = this.getWrapperTask();
            String sThread = this.getThreadName();
            String sTaskId = wrapper.getTaskId();
            pool.runCanceled((PriorityTask)wrapper.getTask(), true);
            StringBuffer sbMsg = new StringBuffer();
            sbMsg.append("A worker thread \"").append(sThread).append("\" timed-out while executing task \"").append(sTaskId).append("\", did not respond to ").append(this.getInterruptCount()).append(" interrupt requests. The execution was canceled.").append(" The thread ");
            int cAttempts = pool.getAbandonThreshold();
            if (cAttempts < 0) {
                int i = cAttempts;
                while (!(i < 0) ? false : thread.isAlive()) {
                    try {
                        ClassHelper.invoke((Object)thread, (String)"stop", (Object[])ClassHelper.VOID);
                        Thread.sleep(1);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread();
                        Thread.interrupted();
                        break;
                    }
                    catch (Exception e) {
                        break;
                    }
                    ++i;
                }
                if (thread.isAlive()) {
                    sbMsg.append("could not be stopped and ");
                }
            }
            if (thread.isAlive()) {
                sThread = String.valueOf(sThread) + "!abandoned";
                try {
                    thread.setName(sThread);
                    thread.setPriority(Thread.MIN_PRIORITY);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                sbMsg.append("is abandoned...");
                try {
                    StackTraceElement[] atrace = (StackTraceElement[])ClassHelper.invoke((Object)thread, (String)"getStackTrace", (Object[])ClassHelper.VOID);
                    int i = 0;
                    int c = atrace.length;
                    while (i < c) {
                        sbMsg.append("\n  at ").append(atrace[i]);
                        ++i;
                    }
                    sbMsg.append('\n');
                }
                catch (Throwable e) {}
            } else {
                sbMsg.append("is stopped.");
            }
            Component._trace(sbMsg.toString(), 1);
        }
    }

    public int getInterruptCount() {
        return this.__m_InterruptCount;
    }

    public Object getLock() {
        return this.getQueue();
    }

    public DaemonPool$Queue getQueue() {
        return this.__m_Queue;
    }

    public DaemonPool$WrapperTask getWrapperTask() {
        return this.__m_WrapperTask;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DaemonPool$Daemon".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DaemonPool$Daemon();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public synchronized void interrupt() {
        DaemonPool$WrapperTask wrapper;
        if ((!this.isStarted() ? false : this.isExiting() ^ true) && (wrapper = this.getWrapperTask()) != null) {
            String sTaskId = wrapper.getTaskId();
            try {
                this.getThread().interrupt();
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            int cInterrupts = this.getInterruptCount();
            if (cInterrupts == 0) {
                Component._trace(String.valueOf("A worker thread timed-out while executing task: ") + sTaskId + "; attepted to interrupt: " + this.getThreadName(), 2);
            }
            this.setInterruptCount(cInterrupts + 1);
        }
    }

    public boolean isNotification() {
        return this.getQueue().isAvailable() ? true : super.isNotification();
    }

    protected void onException(Throwable e) {
        if (this.isExiting()) {
            super.onException(e);
        } else {
            Component._trace(String.valueOf("An unhandled exception occurred on worker thread \"") + this.get_Name() + "\":", 1);
            Component._trace(e);
        }
    }

    protected void onExit() {
        List listDaemons = ((DaemonPool)this.get_Module()).getDaemons();
        if (listDaemons != null) {
            listDaemons.remove(this);
        }
        super.onExit();
    }

    public void onInit() {
        this.setQueue(((DaemonPool)this.get_Module()).getQueue());
        super.onInit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onNotify() {
        DaemonPool$WrapperTask wrapper;
        DaemonPool$Queue queue;
        block13: {
            boolean bl;
            block12: {
                DaemonPool pool = (DaemonPool)this.get_Parent();
                queue = this.getQueue();
                long ldtStart = 0L;
                int cTasks = 0;
                wrapper = this.getWrapperTask();
                boolean fOnce = wrapper != null;
                try {
                    while (this.isExiting() ^ true) {
                        Object var11_11;
                        long cHungMillis;
                        if (fOnce ^ true) {
                            if ((wrapper = (DaemonPool$WrapperTask)queue.removeNoWait(wrapper)) == null) {
                                if (cTasks > 0) {
                                    pool.updateStats(cTasks, ldtStart);
                                }
                                Object var9_12 = null;
                                bl = wrapper != null;
                                break block12;
                            }
                            if (cTasks % 1024 == 0) {
                                ldtStart = pool.updateStats(cTasks, ldtStart);
                                cTasks = 0;
                            }
                        }
                        if ((cHungMillis = pool.getHungThreshold()) > (long)0) {
                            pool.ensureNextCheck(0L, ldtStart + cHungMillis);
                        }
                        ++cTasks;
                        this.setWrapperTask(wrapper);
                        try {
                            try {
                                wrapper.run();
                            }
                            catch (EventDeathException e) {
                                if (!(wrapper.getTask() instanceof DaemonPool$StopTask)) throw e;
                                fOnce = true;
                            }
                            var11_11 = null;
                            this.setWrapperTask(null);
                            if (!fOnce) continue;
                            this.setExiting(true);
                        }
                        catch (Throwable throwable) {
                            var11_11 = null;
                            this.setWrapperTask(null);
                            if (!fOnce) throw throwable;
                            this.setExiting(true);
                            throw throwable;
                        }
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    if (!(wrapper != null)) throw throwable;
                    queue.release(wrapper);
                    throw throwable;
                }
            }
            if (!bl) return;
            queue.release(wrapper);
            return;
        }
        Object var9_13 = null;
        if (!(wrapper != null)) return;
        queue.release(wrapper);
    }

    protected void onWait() throws InterruptedException {
        if (this.getWrapperTask() == null) {
            super.onWait();
        }
    }

    protected void setInterruptCount(int cInterrupts) {
        this.__m_InterruptCount = cInterrupts;
    }

    public void setLock(Object oLock) {
        throw new UnsupportedOperationException();
    }

    private void setQueue(DaemonPool$Queue queue) {
        this.__m_Queue = queue;
    }

    public void setWrapperTask(DaemonPool$WrapperTask task) {
        Thread thread = this.getThread();
        Component._assert(thread == null ? true : thread == Thread.currentThread());
        this.__m_WrapperTask = task;
        if (this.getInterruptCount() > 0) {
            Thread.interrupted();
            this.setInterruptCount(0);
        }
    }
}

