/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SafeNamedCache
extends Util
implements NamedCache,
CacheStore,
MapListener {
    private transient String __m_CacheName;
    private transient ClassLoader __m_ClassLoader;
    private transient MapListenerSupport __m_ListenerSupport;
    private NamedCache __m_NamedCache;
    private boolean __m_Released;
    private SafeCacheService __m_SafeCacheService;

    public SafeNamedCache() {
        this(null, null, true);
    }

    public SafeNamedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setListenerSupport(new MapListenerSupport());
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getRunningNamedCache().addIndex(extractor, fOrdered, comparator);
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        boolean bl;
        boolean fWasLite;
        boolean fWasEmpty;
        MapListenerSupport support;
        if (listener == this) {
            NamedCache cache = this.getNamedCache();
            try {
                cache.addMapListener(listener, filter, fLite);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null) {
                    return;
                }
                boolean bl2 = true;
                if (!bl2) {
                    return;
                }
                boolean bl3 = cache.isActive();
                if (!bl3) {
                    return;
                }
                boolean bl4 = cache.getCacheService().isRunning();
                if (!bl4) return;
                throw e;
            }
        }
        if (listener instanceof MapListenerSupport.SynchronousListener) {
            this.getRunningNamedCache().addMapListener(listener, filter, fLite);
            return;
        }
        if (listener == null) {
            return;
        }
        boolean bl5 = true;
        if (!bl5) return;
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            fWasEmpty = support.isEmpty(filter);
            fWasLite = fWasEmpty ? true : support.containsStandardListeners(filter) ^ true;
            support.addListener(listener, filter, fLite);
        }
        if (fWasEmpty) {
            bl = true;
        } else {
            if (!fWasLite) {
                return;
            }
            bl = fLite ^ true;
        }
        if (!bl) return;
        try {
            this.addMapListener((MapListener)this, filter, fLite);
            return;
        }
        catch (RuntimeException e) {
            support.removeListener(listener, filter);
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        boolean bl;
        boolean fWasLite;
        boolean fWasEmpty;
        MapListenerSupport support;
        if (listener == this) {
            NamedCache cache = this.getNamedCache();
            try {
                cache.addMapListener(listener, oKey, fLite);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null) {
                    return;
                }
                boolean bl2 = true;
                if (!bl2) {
                    return;
                }
                boolean bl3 = cache.isActive();
                if (!bl3) {
                    return;
                }
                boolean bl4 = cache.getCacheService().isRunning();
                if (!bl4) return;
                throw e;
            }
        }
        if (listener instanceof MapListenerSupport.SynchronousListener) {
            this.getRunningNamedCache().addMapListener(listener, oKey, fLite);
            return;
        }
        if (listener == null) {
            return;
        }
        boolean bl5 = true;
        if (!bl5) return;
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            fWasEmpty = support.isEmpty(oKey);
            fWasLite = fWasEmpty ? true : support.containsStandardListeners(oKey) ^ true;
            support.addListener(listener, oKey, fLite);
        }
        if (fWasEmpty) {
            bl = true;
        } else {
            if (!fWasLite) {
                return;
            }
            bl = fLite ^ true;
        }
        if (!bl) return;
        try {
            this.addMapListener((MapListener)this, oKey, fLite);
            return;
        }
        catch (RuntimeException e) {
            support.removeListener(listener, oKey);
            throw e;
        }
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getRunningNamedCache().aggregate(filter, agent);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return this.getRunningNamedCache().aggregate(collKeys, agent);
    }

    public void clear() {
        this.getRunningNamedCache().clear();
    }

    public boolean containsKey(Object oKey) {
        return this.getRunningNamedCache().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.getRunningNamedCache().containsValue(oValue);
    }

    public void destroy() {
        SafeCluster safecluster;
        SafeCacheService safeservice = this.getSafeCacheService();
        SafeCluster safeCluster = safecluster = safeservice.getSafeCluster();
        synchronized (safeCluster) {
            SafeCacheService safeCacheService = safeservice;
            synchronized (safeCacheService) {
                SafeNamedCache safeNamedCache = this;
                synchronized (safeNamedCache) {
                    this.setReleased(true);
                    this.releaseListeners();
                    this.getSafeCacheService().destroyCache(this);
                    this.setNamedCache(null);
                }
            }
        }
    }

    public NamedCache ensureRunningNamedCache() {
        NamedCache cache = this.getNamedCache();
        CacheService service = cache == null ? null : cache.getCacheService();
        if ((service == null ? true : service.isRunning() ^ true) ? true : cache.isActive() ^ true) {
            SafeCluster safecluster;
            SafeCacheService safeservice = this.getSafeCacheService();
            SafeCluster safeCluster = safecluster = safeservice.getSafeCluster();
            synchronized (safeCluster) {
                SafeCacheService safeCacheService = safeservice;
                synchronized (safeCacheService) {
                    SafeNamedCache safeNamedCache = this;
                    synchronized (safeNamedCache) {
                        cache = this.getNamedCache();
                        service = cache == null ? null : cache.getCacheService();
                        if ((service == null ? true : service.isRunning() ^ true) ? true : cache.isActive() ^ true) {
                            if (this.isReleased()) {
                                throw new IllegalStateException("SafeNamedCache was explicitly released");
                            }
                            if (cache != null) {
                                this.setNamedCache(null);
                                Component._trace(String.valueOf("Restarting NamedCache: ") + this.getCacheName(), 3);
                            }
                            cache = this.restartNamedCache();
                            this.setNamedCache(cache);
                        }
                    }
                }
            }
            safeservice.drainEvents();
        }
        return cache;
    }

    public void entryDeleted(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    public void entryInserted(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    public Set entrySet() {
        return this.getRunningNamedCache().entrySet();
    }

    public Set entrySet(Filter filter) {
        return this.getRunningNamedCache().entrySet(filter);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return this.getRunningNamedCache().entrySet(filter, comparator);
    }

    public void entryUpdated(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    public void erase(Object oKey) {
        this.getRunningCacheStore().erase(oKey);
    }

    public void eraseAll(Collection colKeys) {
        this.getRunningCacheStore().eraseAll(colKeys);
    }

    public Object get(Object oKey) {
        return this.getRunningNamedCache().get(oKey);
    }

    public Map getAll(Collection col) {
        return this.getRunningNamedCache().getAll(col);
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return this.getSafeCacheService();
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public NamedCache getNamedCache() {
        return this.__m_NamedCache;
    }

    protected CacheLoader getRunningCacheLoader() {
        NamedCache cache = this.getRunningNamedCache();
        try {
            return (CacheLoader)cache;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    protected CacheStore getRunningCacheStore() {
        NamedCache cache = this.getRunningNamedCache();
        try {
            return (CacheStore)cache;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    protected NamedCache getRunningNamedCache() {
        return this.ensureRunningNamedCache();
    }

    public SafeCacheService getSafeCacheService() {
        return this.__m_SafeCacheService;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/SafeNamedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new SafeNamedCache();
    }

    private final Component get_Module() {
        return this;
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invoke(oKey, agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invokeAll(filter, agent);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invokeAll(collKeys, agent);
    }

    public boolean isActive() {
        try {
            return this.getNamedCache().isActive();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isEmpty() {
        return this.getRunningNamedCache().isEmpty();
    }

    public boolean isReleased() {
        return this.__m_Released;
    }

    public Set keySet() {
        return this.getRunningNamedCache().keySet();
    }

    public Set keySet(Filter filter) {
        return this.getRunningNamedCache().keySet(filter);
    }

    public Object load(Object oKey) {
        return this.getRunningCacheLoader().load(oKey);
    }

    public Map loadAll(Collection colKeys) {
        return this.getRunningCacheLoader().loadAll(colKeys);
    }

    public boolean lock(Object oKey) {
        return this.getRunningNamedCache().lock(oKey);
    }

    public boolean lock(Object oKey, long cMillis) {
        return this.getRunningNamedCache().lock(oKey, cMillis);
    }

    public Object put(Object oKey, Object oValue) {
        return this.getRunningNamedCache().put(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.getRunningNamedCache().put(oKey, oValue, cMillis);
    }

    public void putAll(Map map) {
        this.getRunningNamedCache().putAll(map);
    }

    public void release() {
        SafeCluster safecluster;
        SafeCacheService safeservice = this.getSafeCacheService();
        SafeCluster safeCluster = safecluster = safeservice.getSafeCluster();
        synchronized (safeCluster) {
            SafeCacheService safeCacheService = safeservice;
            synchronized (safeCacheService) {
                SafeNamedCache safeNamedCache = this;
                synchronized (safeNamedCache) {
                    this.setReleased(true);
                    this.releaseListeners();
                    this.getSafeCacheService().releaseCache(this);
                    this.setNamedCache(null);
                }
            }
        }
    }

    protected void releaseListeners() {
        MapListenerSupport support;
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            if (support.isEmpty() ^ true) {
                Iterator iter = support.getFilterSet().iterator();
                while (iter.hasNext()) {
                    this.removeMapListener((MapListener)this, (Filter)iter.next());
                }
                iter = support.getKeySet().iterator();
                while (iter.hasNext()) {
                    this.removeMapListener((MapListener)this, iter.next());
                }
            }
            support.clear();
        }
    }

    public Object remove(Object oKey) {
        return this.getRunningNamedCache().remove(oKey);
    }

    public void removeIndex(ValueExtractor extractor) {
        this.getRunningNamedCache().removeIndex(extractor);
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeMapListener(MapListener listener, Filter filter) {
        boolean fEmpty;
        MapListenerSupport support;
        if (listener == this ? true : listener instanceof MapListenerSupport.SynchronousListener) {
            NamedCache cache = this.getNamedCache();
            try {
                cache.removeMapListener(listener, filter);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null) {
                    return;
                }
                boolean bl = true;
                if (!bl) {
                    return;
                }
                boolean bl2 = cache.isActive();
                if (!bl2) {
                    return;
                }
                boolean bl3 = cache.getCacheService().isRunning();
                if (!bl3) return;
                throw e;
            }
        }
        if (listener == null) {
            return;
        }
        boolean bl = true;
        if (!bl) return;
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            support.removeListener(listener, filter);
            fEmpty = support.isEmpty(filter);
        }
        if (!fEmpty) return;
        this.removeMapListener((MapListener)this, filter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeMapListener(MapListener listener, Object oKey) {
        boolean fEmpty;
        MapListenerSupport support;
        if (listener == this ? true : listener instanceof MapListenerSupport.SynchronousListener) {
            NamedCache cache = this.getNamedCache();
            try {
                cache.removeMapListener(listener, oKey);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null) {
                    return;
                }
                boolean bl = true;
                if (!bl) {
                    return;
                }
                boolean bl2 = cache.isActive();
                if (!bl2) {
                    return;
                }
                boolean bl3 = cache.getCacheService().isRunning();
                if (!bl3) return;
                throw e;
            }
        }
        if (listener == null) {
            return;
        }
        boolean bl = true;
        if (!bl) return;
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            support.removeListener(listener, oKey);
            fEmpty = support.isEmpty(oKey);
        }
        if (!fEmpty) return;
        this.removeMapListener((MapListener)this, oKey);
    }

    protected NamedCache restartNamedCache() {
        MapListenerSupport support;
        NamedCache cache = this.getSafeCacheService().ensureRunningCacheService(false).ensureCache(this.getCacheName(), this.getClassLoader());
        Filter[] aFilter = new Filter[]{};
        Object[] aoKey = new Object[]{};
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            if (support.isEmpty() ^ true) {
                aFilter = support.getFilterSet().toArray(aFilter);
                aoKey = support.getKeySet().toArray();
            }
        }
        int i = 0;
        int c = aFilter.length;
        while (i < c) {
            Filter filter = aFilter[i];
            cache.addMapListener((MapListener)this, filter, support.containsStandardListeners(filter) ^ true);
            ++i;
        }
        i = 0;
        c = aoKey.length;
        while (i < c) {
            Object oKey = aoKey[i];
            cache.addMapListener((MapListener)this, oKey, support.containsStandardListeners(oKey) ^ true);
            ++i;
        }
        return cache;
    }

    public void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setClassLoader(ClassLoader loader) {
        this.__m_ClassLoader = loader;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    public void setNamedCache(NamedCache cache) {
        this.__m_NamedCache = cache;
    }

    public synchronized void setReleased(boolean fRelease) {
        this.__m_Released = fRelease;
    }

    public void setSafeCacheService(SafeCacheService service) {
        this.__m_SafeCacheService = service;
    }

    public int size() {
        return this.getRunningNamedCache().size();
    }

    public void store(Object oKey, Object oValue) {
        this.getRunningCacheStore().store(oKey, oValue);
    }

    public void storeAll(Map mapEntries) {
        this.getRunningCacheStore().storeAll(mapEntries);
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ": " + this.getNamedCache();
    }

    protected void translateMapEvent(MapEvent evt) {
        if (evt.getSource() == this.getNamedCache()) {
            evt = MapListenerSupport.convertEvent((MapEvent)evt, (ObservableMap)this, null, null);
            this.getListenerSupport().fireEvent(evt, true);
        }
    }

    public boolean unlock(Object oKey) {
        return this.getRunningNamedCache().unlock(oKey);
    }

    public Collection values() {
        return this.getRunningNamedCache().values();
    }
}

