/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Listeners;
import com.tangosol.util.WrapperException;
import java.util.EventListener;

public class SafeService
extends Util
implements MemberListener,
com.tangosol.net.Service {
    public static final int SERVICE_INITIAL = 0;
    public static final int SERVICE_STARTED = 1;
    public static final int SERVICE_STOPPED = 2;
    private transient XmlElement __m_Config;
    private ClassLoader __m_ContextClassLoader;
    private Listeners __m_MemberListeners;
    private transient SafeCluster __m_SafeCluster;
    private int __m_SafeServiceState;
    private transient com.tangosol.net.Service __m_Service;
    private String __m_ServiceName;
    private String __m_ServiceType;
    private Object __m_UserContext;

    public SafeService() {
        this(null, null, true);
    }

    public SafeService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setSafeServiceState(0);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_MemberListeners = new Listeners();
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
    }

    public synchronized void addMemberListener(MemberListener l) {
        com.tangosol.net.Service service;
        Listeners listeners = this.getMemberListeners();
        boolean fWasEmpty = listeners.isEmpty();
        listeners.add((EventListener)l);
        if ((!fWasEmpty ? false : listeners.isEmpty() ^ true) && (!((service = this.getService()) != null) ? false : service.isRunning())) {
            service.addMemberListener((MemberListener)this);
        }
    }

    protected void checkClientThread(String sMethod) {
        Service service;
        com.tangosol.net.Service _service = this.getService();
        if (_service instanceof Service && (service = (Service)_service).isServiceThread(false)) {
            Component._trace(String.valueOf("Application code running on \"") + service.getServiceName() + "\" service thread(s) should not call " + sMethod + " as this may result in deadlock. The most common case is" + " a CacheFactory call from a custom CacheStore implementation.", 2);
        }
    }

    protected void cleanup() {
        this.setService(null);
        this.setContextClassLoader(null);
        this.getMemberListeners().removeAll();
    }

    public void configure(XmlElement xmlConfig) {
        this.setConfig(xmlConfig);
    }

    public void drainEvents() {
        com.tangosol.net.Service service = this.getService();
        if (service instanceof Service) {
            ((Service)service).drainEvents();
        } else if (service instanceof RemoteService) {
            ((RemoteService)service).drainEvents();
        }
    }

    public com.tangosol.net.Service ensureRunningService(boolean fDrain) {
        com.tangosol.net.Service service = this.getService();
        if (service == null ? true : service.isRunning() ^ true) {
            SafeCluster cluster;
            boolean fRegister = true;
            SafeCluster safeCluster = cluster = this.getSafeCluster();
            synchronized (safeCluster) {
                SafeService safeService = this;
                synchronized (safeService) {
                    service = this.getService();
                    switch (this.getSafeServiceState()) {
                        case 0: {
                            if (service == null) {
                                service = this.restartService();
                                this.setService(service);
                                break;
                            }
                            this.startService(service);
                            break;
                        }
                        case 1: {
                            if (service == null ? true : service.isRunning() ^ true) {
                                service = null;
                                this.setService(null);
                                Component._trace(String.valueOf("Restarting Service: ") + this.getServiceName(), 3);
                                service = this.restartService();
                                this.setService(service);
                                break;
                            }
                            fRegister = false;
                            break;
                        }
                        case 2: {
                            throw new IllegalStateException("SafeService was explicitly stopped");
                        }
                    }
                }
            }
            if (fRegister) {
                this.register();
            }
            if (fDrain) {
                this.drainEvents();
            }
        }
        return service;
    }

    public Cluster getCluster() {
        return this.getSafeCluster();
    }

    public XmlElement getConfig() {
        return this.__m_Config;
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader loader = this.__m_ContextClassLoader;
        if (loader == null) {
            loader = Base.getContextClassLoader((Object)this);
        }
        return loader;
    }

    public ServiceInfo getInfo() {
        return this.getRunningService().getInfo();
    }

    protected Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    protected com.tangosol.net.Service getRunningService() {
        return this.ensureRunningService(true);
    }

    public SafeCluster getSafeCluster() {
        return this.__m_SafeCluster;
    }

    public int getSafeServiceState() {
        return this.__m_SafeServiceState;
    }

    public com.tangosol.net.Service getService() {
        return this.__m_Service;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return this.__m_ServiceType;
    }

    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/SafeService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new SafeService();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isRunning() {
        com.tangosol.net.Service service = this.getService();
        return !(service != null) ? false : this.getService().isRunning();
    }

    public void memberJoined(MemberEvent evt) {
        this.translateEvent(evt);
    }

    public void memberLeaving(MemberEvent evt) {
        this.translateEvent(evt);
    }

    public void memberLeft(MemberEvent evt) {
        this.translateEvent(evt);
    }

    protected void register() {
        Member member;
        Registry registry = this.getSafeCluster().getManagement();
        if ((!(!(registry != null) ? false : this.getServiceType().equals("Cluster") ^ true) ? false : this.getService() instanceof RemoteService ^ true) && (member = this.getSafeCluster().getLocalMember()) != null) {
            String sName = String.valueOf(Registry.SERVICE_TYPE) + ",name=" + this.getServiceName();
            sName = registry.ensureGlobalName(sName);
            registry.register(sName, (Object)this);
        }
    }

    public synchronized void removeMemberListener(MemberListener l) {
        Listeners listeners = this.getMemberListeners();
        if (listeners.isEmpty() ^ true) {
            com.tangosol.net.Service service;
            listeners.remove((EventListener)l);
            if (listeners.isEmpty() && (!((service = this.getService()) != null) ? false : service.isRunning())) {
                service.removeMemberListener((MemberListener)this);
            }
        }
    }

    protected com.tangosol.net.Service restartService() {
        String sServiceName = this.getServiceName();
        String sServiceType = this.getServiceType();
        com.tangosol.net.Service service = SafeCluster.isLocalService(sServiceType) ? this.getSafeCluster().ensureLocalService(sServiceName, sServiceType) : this.getSafeCluster().ensureRunningCluster().ensureService(sServiceName, sServiceType);
        this.startService(service);
        return service;
    }

    public void setConfig(XmlElement xmlConfig) {
        this.__m_Config = xmlConfig;
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
        com.tangosol.net.Service service = this.getService();
        if (service != null) {
            service.setContextClassLoader(loader);
        }
    }

    private void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    public void setSafeCluster(SafeCluster cluster) {
        this.__m_SafeCluster = cluster;
    }

    protected void setSafeServiceState(int nState) {
        this.__m_SafeServiceState = nState;
    }

    public void setService(com.tangosol.net.Service service) {
        this.__m_Service = service;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setServiceType(String sType) {
        this.__m_ServiceType = sType;
    }

    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
        com.tangosol.net.Service service = this.getService();
        if (service != null) {
            service.setUserContext(oCtx);
        }
    }

    public void shutdown() {
        SafeCluster safecluster;
        SafeCluster safeCluster = safecluster = this.getSafeCluster();
        synchronized (safeCluster) {
            SafeService safeService = this;
            synchronized (safeService) {
                if (this.getSafeServiceState() != SERVICE_STOPPED) {
                    com.tangosol.net.Service service = this.getService();
                    if (service != null) {
                        com.tangosol.net.Service service2 = service;
                        synchronized (service2) {
                            if (service.isRunning()) {
                                service.shutdown();
                            }
                        }
                    }
                    this.cleanup();
                    this.setSafeServiceState(SERVICE_STOPPED);
                }
            }
        }
    }

    public void start() {
        SafeCluster safecluster;
        SafeCluster safeCluster = safecluster = this.getSafeCluster();
        synchronized (safeCluster) {
            SafeService safeService = this;
            synchronized (safeService) {
                if (this.getSafeServiceState() == SERVICE_STOPPED) {
                    this.setSafeServiceState(SERVICE_INITIAL);
                }
                try {
                    this.ensureRunningService(false);
                }
                finally {
                    Object var5_4 = null;
                    this.setSafeServiceState(SERVICE_STARTED);
                }
            }
        }
        this.drainEvents();
    }

    protected void startService(com.tangosol.net.Service service) {
        service.setContextClassLoader(this.getContextClassLoader());
        service.setUserContext(this.getUserContext());
        service.configure(this.getConfig());
        Listeners listeners = this.getMemberListeners();
        if (listeners.isEmpty() ^ true) {
            service.addMemberListener((MemberListener)this);
        }
        try {
            service.start();
        }
        catch (Throwable e) {
            Component._trace(String.valueOf("Error while starting service \"") + this.getServiceName() + "\": " + Component.getStackTrace(e), 1);
            try {
                service.stop();
            }
            catch (Throwable e2) {
                Component._trace(String.valueOf("Failed to stop service \"") + this.getServiceName() + "\": " + Component.getStackTrace(e2), 2);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (RuntimeException)e;
        }
    }

    public void stop() {
        SafeCluster safecluster;
        SafeCluster safeCluster = safecluster = this.getSafeCluster();
        synchronized (safeCluster) {
            SafeService safeService = this;
            synchronized (safeService) {
                if (this.getSafeServiceState() != SERVICE_STOPPED) {
                    com.tangosol.net.Service service = this.getService();
                    if (service != null) {
                        com.tangosol.net.Service service2 = service;
                        synchronized (service2) {
                            if (service.isRunning()) {
                                service.stop();
                            }
                        }
                    }
                    this.cleanup();
                    this.setSafeServiceState(SERVICE_STOPPED);
                }
            }
        }
    }

    public String toString() {
        com.tangosol.net.Service service = this.getService();
        return String.valueOf(this.get_Name()) + ": " + (service == null ? "STOPPED" : service.toString());
    }

    protected void translateEvent(MemberEvent evt) {
        Listeners listeners;
        com.tangosol.net.Service service = this.getService();
        if ((service == evt.getSource() ? true : service == null) && (listeners = this.getMemberListeners()).isEmpty() ^ true) {
            MemberEvent evtSafe = new MemberEvent((Object)this, evt.getId(), evt.getMember());
            evtSafe.dispatch(listeners);
        }
    }

    protected void unregister() {
        Member member;
        Registry registry = this.getSafeCluster().getManagement();
        if ((!(!(registry != null) ? false : this.getServiceType().equals("Cluster") ^ true) ? false : this.getService() instanceof RemoteService ^ true) && (member = this.getSafeCluster().getLocalMember()) != null) {
            String sName = String.valueOf(Registry.SERVICE_TYPE) + ",name=" + this.getServiceName();
            sName = registry.ensureGlobalName(sName);
            registry.unregister(sName);
        }
    }
}

