/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.socket.TcpSocket;
import com.tangosol.coherence.component.net.socket.TcpSocketAccepter;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.daemon.TcpRingListener$Connector;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.WrapperException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;

public class TcpRingListener
extends Daemon {
    public static final String KEY_ADDRESS = "TcpRing/address";
    public static final String KEY_BUDDY = "TcpRing/buddy";
    public static final String KEY_POINTS = "TcpRing/points";
    public static final String KEY_PORT = "TcpRing/port";
    public static final int MEMBER_DEAD = 57005;
    public static final int MEMBER_DISCONNECT = 57007;
    private transient TcpRingListener$Connector[] __m_Connector;
    private transient Map __m_DisconnectedSockets;
    private int __m_MaxExceptions;
    private transient boolean __m_RingBroken;
    private transient ClusterService __m_Service;
    private transient TcpSocketAccepter __m_SocketAccepter;
    private transient long __m_StatsPings;
    private transient long __m_StatsRestores;
    private transient long __m_StatsTimeouts;
    private static ListMap __mapChildren;

    static {
        TcpRingListener.__initStatic();
    }

    public TcpRingListener() {
        this(null, null, true);
    }

    public TcpRingListener(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDisconnectedSockets((Map)new ListMap());
            this.setPriority(6);
            this.setWaitMillis(-1L);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"Connector", (Object)TcpRingListener$Connector.get_CLASS());
    }

    public void acceptConnection() {
        TcpSocket socket;
        block16: {
            socket = null;
            try {
                socket = this.getSocketAccepter().accept();
            }
            catch (ConnectionException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (!(this.isExiting() ^ true)) break block16;
                Component._trace(e, "TcpRing: An exception occurred at accept()");
            }
        }
        TcpRingListener e = this;
        synchronized (e) {
            if (socket == null ? true : this.isExiting()) {
                Object var3_5 = null;
                return;
            }
        }
        ClusterService service = this.getService();
        if (service.isAcceptingClients() ^ true) {
            Component._trace(String.valueOf("Rejecting a premature or late connect request: ") + socket, 4);
            socket.close();
            return;
        }
        boolean fAccept = false;
        int nMember = 0;
        try {
            int cMillis = service.getHeartbeatDelay();
            this.configureSocket(socket, cMillis << 2);
            nMember = this.drainInput(socket, 0);
            Member member = service.getClusterMemberSet().getMember(nMember);
            if (member != null) {
                TcpRingListener tcpRingListener = this;
                synchronized (tcpRingListener) {
                    TcpRingListener$Connector connector = this.getConnector(nMember);
                    if (connector == null ? true : connector.isBroken()) {
                        socket.setSoTimeout(1);
                        this.ensureConnector(nMember, socket);
                        fAccept = true;
                        this.reduceConnections(member);
                    }
                }
            }
            if (fAccept ^ true) {
                Component._trace(String.valueOf("Rejecting connection to member ") + nMember + " using " + socket, 4);
                socket.close();
            }
        }
        catch (IOException e2) {
            Component._trace(String.valueOf("Incomplete handshake after accept: ") + socket + " " + e2, 4);
            socket.close();
        }
    }

    public synchronized void checkConnections() {
        this.closeDisconnectedSockets(false);
        this.validateMembers();
        if (this.isRingBroken()) {
            if (this.restoreConnections()) {
                this.setRingBroken(false);
            }
        } else {
            this.ensureTopology();
        }
        TcpRingListener$Connector[] aConnector = this.getConnector();
        if (aConnector != null) {
            int nMember = 1;
            int cMembers = aConnector.length;
            while (nMember < cMembers) {
                TcpRingListener$Connector connector = aConnector[nMember];
                if (!(connector != null) ? false : connector.isBroken() ^ true) {
                    this.ping(connector, nMember);
                }
                ++nMember;
            }
        }
    }

    protected void closeDisconnectedSockets(boolean fForce) {
        Map mapSockets = this.getDisconnectedSockets();
        if (mapSockets.isEmpty() ^ true) {
            long lTime = Base.getSafeTimeMillis();
            Iterator iter = mapSockets.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Long LTimeout = (Long)entry.getValue();
                if (!(fForce ? true : lTime > LTimeout)) continue;
                TcpSocket socket = (TcpSocket)entry.getKey();
                iter.remove();
                socket.close();
            }
        }
    }

    protected void configureSocket(TcpSocket socket, int nTimeout) throws IOException {
        socket.setSoLinger(-1);
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(nTimeout);
    }

    protected boolean connect(int nMember) {
        TcpRingListener$Connector connector = this.getConnector(nMember);
        if (connector == null ? true : connector.isBroken()) {
            ClusterService service = this.getService();
            ServiceMemberSet setMembers = service.getServiceMemberSet();
            ObservableMap mapConfig = setMembers.getMemberConfigMap(nMember);
            byte[] abAddress = (byte[])mapConfig.get(KEY_ADDRESS);
            Integer IPort = (Integer)mapConfig.get(KEY_PORT);
            if (abAddress == null ? true : IPort == null) {
                return false;
            }
            if (service.getTimestamp() <= setMembers.getServiceJoined(nMember) + (long)service.getHeartbeatDelay()) {
                return false;
            }
            TcpSocket socket = new TcpSocket();
            try {
                socket.setRemoteInetAddress(InetAddressHelper.getByAddress((byte[])abAddress));
                socket.setRemotePort(IPort);
                socket.setSoTimeout(service.getHeartbeatDelay() >>> 1);
                socket.open();
                this.configureSocket(socket, 1);
            }
            catch (IOException e) {
                socket.close();
                this.onPeerException(e, nMember);
                return false;
            }
            this.ensureConnector(nMember, socket);
        }
        return true;
    }

    public void disconnect(int nMember, String sReason) {
        TcpRingListener$Connector connector = this.getConnector(nMember);
        if (connector != null) {
            if (connector.isBroken() ^ true) {
                TcpSocket socket = connector.getSocket();
                boolean fAlive = !this.isStarted() ? false : this.isExiting() ^ true;
                try {
                    this.flushOutput(socket, fAlive ? MEMBER_DISCONNECT : MEMBER_DEAD);
                }
                catch (Exception e) {
                    // empty catch block
                }
                int cHearbeatMillis = this.getService().getHeartbeatDelay();
                this.getDisconnectedSockets().put(socket, new Long(Base.getSafeTimeMillis() + (long)(2 * cHearbeatMillis)));
                if (fAlive) {
                    Component._trace(String.valueOf("TcpRing: disconnected from member ") + nMember + " due to " + sReason, 5);
                }
            }
            this.setConnector(nMember, null);
        }
    }

    protected void disconnectAll() {
        TcpRingListener$Connector[] aConnector = this.getConnector();
        if (aConnector != null) {
            int nMember = 1;
            int cMembers = aConnector.length;
            while (nMember < cMembers) {
                this.disconnect(nMember, "the local node shutdown");
                ++nMember;
            }
        }
        this.closeDisconnectedSockets(true);
    }

    protected void disconnectWeak() {
        TcpRingListener$Connector[] aConnector = this.getConnector();
        if (aConnector != null) {
            ServiceMemberSet setMembers = this.getService().getServiceMemberSet();
            int nMachineThis = this.getThisMember().getMachineId();
            int nMember = 1;
            int cMembers = aConnector.length;
            while (nMember < cMembers) {
                Member member = ((MemberSet)setMembers).getMember(nMember);
                if (!(member != null) ? false : member.getMachineId() == nMachineThis) {
                    this.disconnect(nMember, "transition to a strong connection");
                }
                ++nMember;
            }
        }
    }

    protected int drainInput(TcpSocket socket, int nMemberConnect) throws IOException {
        InputStream stream = socket.getInputStream();
        int cRead = Math.max(stream.available(), 2);
        while (cRead >= 2) {
            byte[] ab = new byte[2];
            int of = 0;
            TcpRingListener$Connector connector = nMemberConnect == 0 ? null : this.getConnector(nMemberConnect);
            if (!(connector != null) ? false : connector.isBuffered()) {
                ab[of++] = connector.getBufferedInput();
                connector.setBuffered(false);
            }
            while (of < 2) {
                try {
                    int c = stream.read(ab, of, 1);
                    if (c == -1) {
                        socket.shutdownInput();
                        throw new EOFException();
                    }
                    --cRead;
                    ++of;
                }
                catch (InterruptedIOException iioe) {
                    if (connector == null) {
                        socket.shutdownInput();
                    } else if (of == 1) {
                        connector.setBufferedInput(ab[0]);
                        connector.setBuffered(true);
                    }
                    throw iioe;
                }
            }
            int b1 = ab[0] & 0xFF;
            int b2 = ab[1] & 0xFF;
            int nMember = b1 + (b2 << 8);
            if (nMemberConnect == 0) {
                return nMember;
            }
            if (nMember == MEMBER_DISCONNECT) {
                this.disconnect(nMemberConnect, "a disconnect request");
                return MEMBER_DISCONNECT;
            }
            if (nMember == MEMBER_DEAD) {
                this.kill(nMemberConnect);
                return MEMBER_DEAD;
            }
            if (nMember == nMemberConnect) {
                if (!(connector.isEstablished() ^ true)) continue;
                connector.setEstablished(true);
                this.updateConnectionInfo();
                continue;
            }
            Component._trace(String.valueOf("New member uses existing connection; ") + "killing the old member: " + nMember, 4);
            this.kill(nMemberConnect);
            return MEMBER_DEAD;
        }
        return nMemberConnect;
    }

    protected TcpRingListener$Connector ensureConnector(int nMember, TcpSocket socket) {
        Component._assert(nMember != this.getThisMember().getId());
        TcpRingListener$Connector connector = this.getConnector(nMember);
        if (connector == null) {
            connector = this.instantiateConnector();
            connector.setSocket(socket);
            connector.setTimestamp(Base.getSafeTimeMillis());
            this.setConnector(nMember, connector);
        } else {
            connector.setSocket(socket);
        }
        Component._trace(String.valueOf("TcpRing: connecting to member ") + nMember + " using " + socket, 5);
        return connector;
    }

    protected void ensureTopology() {
        ServiceMemberSet setMembers = this.getService().getServiceMemberSet();
        if (setMembers.size() == 1) {
            return;
        }
        Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        int nMachineThis = memberThis.getMachineId();
        int cPointsThis = 0;
        boolean fWeak = false;
        boolean fStrong = false;
        TcpRingListener$Connector[] aConnector = this.getConnector();
        if (aConnector != null) {
            int nMember = 1;
            int cMembers = aConnector.length;
            while (nMember < cMembers) {
                Member member;
                TcpRingListener$Connector connector = aConnector[nMember];
                if (connector != null && !((member = setMembers.getMember(nMember)) == null ? true : member.isDeaf())) {
                    if (member.getMachineId() == nMachineThis) {
                        fWeak = true;
                    } else {
                        fStrong = true;
                    }
                    ++cPointsThis;
                }
                ++nMember;
            }
        }
        if (fStrong) {
            if (fWeak) {
                this.disconnectWeak();
            }
        } else {
            short WEAK_WEIGHT = Short.MAX_VALUE;
            int nConnectMember = 0;
            int nConnectWeight = Integer.MAX_VALUE;
            Iterator iter = setMembers.iterator();
            while (iter.hasNext()) {
                int nWeight;
                int nMember;
                Member member = (Member)iter.next();
                if ((member == null ? true : member.isDeaf()) || !((nMember = member.getId()) != nMemberThis)) continue;
                boolean fMemberWeak = member.getMachineId() == nMachineThis;
                ObservableMap mapConfig = setMembers.getMemberConfigMap(nMember);
                Integer IPoints = (Integer)mapConfig.get(KEY_POINTS);
                if (!(IPoints != null) || !((nWeight = IPoints + (fMemberWeak ? WEAK_WEIGHT : (short)0)) < nConnectWeight)) continue;
                nConnectWeight = nWeight;
                nConnectMember = nMember;
            }
            if (nConnectMember != 0 && !(!(!(cPointsThis == 0) ? false : (nConnectWeight == 0 ? true : nConnectWeight == WEAK_WEIGHT)) ? false : nConnectMember < nMemberThis)) {
                if (nConnectWeight < WEAK_WEIGHT) {
                    if (this.connect(nConnectMember)) {
                        this.disconnectWeak();
                        this.updateConnectionInfo();
                    }
                } else if (cPointsThis == 0) {
                    this.connect(nConnectMember);
                }
            }
        }
    }

    protected void flushOutput(TcpSocket socket, int nMemberThis) throws IOException {
        OutputStream stream = socket.getOutputStream();
        byte[] ab = new byte[]{(byte)(nMemberThis & 0xFF), (byte)((nMemberThis & 0xFF00) >>> 8)};
        stream.write(ab, 0, 2);
        stream.flush();
    }

    public String formatStats() {
        long cFails;
        long cTotal = this.getStatsPings();
        long cMisses = this.getStatsTimeouts();
        double dSuccess = cMisses + (cFails = this.getStatsRestores()) == 0L ? 1.0 : 1.0 - (double)(cMisses + cFails) / (double)cTotal;
        return String.valueOf("TotalPings=") + cTotal + ", Timeouts=" + cMisses + ", Failures=" + cFails + ", SuccessRate=" + (float)dSuccess;
    }

    public int getBuddyId() {
        TcpRingListener$Connector[] aConnector = this.getConnector();
        if (aConnector == null) {
            return 0;
        }
        int nThisMember = this.getService().getThisMember().getId();
        int nFirst = 0;
        int nMember = 1;
        int cMembers = aConnector.length;
        while (nMember < cMembers) {
            TcpRingListener$Connector connector = aConnector[nMember];
            if (!(connector != null) ? false : connector.isEstablished()) {
                if (nMember > nThisMember) {
                    return nMember;
                }
                if (nFirst == 0) {
                    nFirst = nMember;
                }
            }
            ++nMember;
        }
        return nFirst;
    }

    public int getConnectionCount() {
        TcpRingListener$Connector[] aConnector = this.getConnector();
        if (aConnector == null) {
            return 0;
        }
        int count = 0;
        int nMember = 1;
        int cMembers = aConnector.length;
        while (nMember < cMembers) {
            TcpRingListener$Connector connector = aConnector[nMember];
            if (!(connector != null) ? false : connector.isEstablished()) {
                ++count;
            }
            ++nMember;
        }
        return count;
    }

    protected TcpRingListener$Connector[] getConnector() {
        return this.__m_Connector;
    }

    public TcpRingListener$Connector getConnector(int nMember) {
        TcpRingListener$Connector[] aConnector = this.getConnector();
        return (aConnector == null ? true : nMember >= aConnector.length) ? null : aConnector[nMember];
    }

    public Map getDisconnectedSockets() {
        return this.__m_DisconnectedSockets;
    }

    public int getMaxExceptions() {
        return this.__m_MaxExceptions;
    }

    public ClusterService getService() {
        return this.__m_Service;
    }

    public TcpSocketAccepter getSocketAccepter() {
        return this.__m_SocketAccepter;
    }

    public long getStatsPings() {
        return this.__m_StatsPings;
    }

    public long getStatsRestores() {
        return this.__m_StatsRestores;
    }

    public long getStatsTimeouts() {
        return this.__m_StatsTimeouts;
    }

    protected Member getThisMember() {
        return this.getService().getClusterMemberSet().getThisMember();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/TcpRingListener".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpRingListener();
    }

    private final Component get_Module() {
        return this;
    }

    protected TcpRingListener$Connector instantiateConnector() {
        return (TcpRingListener$Connector)this._newChild("Connector");
    }

    public boolean isRingBroken() {
        return this.__m_RingBroken;
    }

    protected void kill(int nMember) {
        this.disconnect(nMember, "a kill request");
        ClusterService service = this.getService();
        Member member = service.getClusterMemberSet().getMember(nMember);
        if (member != null) {
            service.doMemberLeft(member);
        }
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    protected void onExit() {
        super.onExit();
        this.disconnectAll();
    }

    protected void onNotify() {
        this.acceptConnection();
    }

    protected void onPeerException(IOException eException, int nMember) {
        TcpRingListener$Connector connector = this.getConnector(nMember);
        if (connector != null) {
            connector.setSocket(null);
            if (connector.isEstablished()) {
                if (connector.addFailure() >= this.getMaxExceptions()) {
                    Component._trace(String.valueOf("TcpRing: Number of socket exceptions exceeded maximum") + "; last was \"" + eException + "\"; removing the member: " + nMember, 4);
                    this.kill(nMember);
                } else {
                    this.setRingBroken(true);
                }
            } else {
                this.disconnect(nMember, String.valueOf("an initial connection failure: ") + eException);
            }
        }
    }

    protected void ping(TcpRingListener$Connector connector, int nMember) {
        this.setStatsPings(this.getStatsPings() + 1L);
        TcpSocket socket = connector.getSocket();
        IOException exception = null;
        try {
            int nResponse = this.drainInput(socket, nMember);
            if (nResponse == MEMBER_DISCONNECT ? true : nResponse == MEMBER_DEAD) {
                this.updateConnectionInfo();
                return;
            }
            Member member = this.getService().getServiceMemberSet().getMember(nMember);
        }
        catch (InterruptedIOException e) {
            if (connector.isEstablished()) {
                this.setStatsTimeouts(this.getStatsTimeouts() + 1L);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        if (exception == null) {
            try {
                this.flushOutput(socket, this.getThisMember().getId());
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception != null) {
            socket.close();
            this.onPeerException(exception, nMember);
        }
    }

    protected void reduceConnections(Member memberLast) {
        ClusterService service = this.getService();
        Member memberThis = service.getThisMember();
        if (memberLast.getMachineId() != memberThis.getMachineId()) {
            ServiceMemberSet setMembers = service.getServiceMemberSet();
            boolean fUpdate = false;
            Iterator iter = setMembers.iterator();
            while (iter.hasNext()) {
                int nMember;
                ObservableMap mapConfig;
                Integer IPoints;
                Member member = (Member)iter.next();
                if (!(!(member != memberThis) ? false : member != memberLast) || !(!((IPoints = (Integer)(mapConfig = setMembers.getMemberConfigMap(nMember = member.getId())).get(KEY_POINTS)) != null) ? false : IPoints >= 2)) continue;
                this.disconnect(nMember, "connection reduction");
                fUpdate = true;
            }
            if (fUpdate) {
                this.updateConnectionInfo();
            }
        }
    }

    public void resetStats() {
        this.setStatsPings(0L);
        this.setStatsRestores(0L);
        this.setStatsTimeouts(0L);
    }

    protected boolean restoreConnections() {
        boolean fBroken = false;
        TcpRingListener$Connector[] aConnector = this.getConnector();
        if (aConnector != null) {
            int nMember = 1;
            int cMembers = aConnector.length;
            while (nMember < cMembers) {
                TcpRingListener$Connector connector = this.getConnector(nMember);
                if (!(connector != null) ? false : connector.isBroken()) {
                    if (this.connect(nMember)) {
                        this.setStatsRestores(this.getStatsRestores() + (long)1);
                    } else {
                        fBroken = true;
                    }
                }
                ++nMember;
            }
        }
        return fBroken ^ true;
    }

    protected synchronized void setConnector(int nMember, TcpRingListener$Connector connector) {
        boolean fBeyondBounds;
        TcpRingListener$Connector[] aConnector = this.getConnector();
        Component._assert(nMember > 0);
        boolean bl = fBeyondBounds = aConnector == null ? true : nMember >= aConnector.length;
        if (!(connector != null) ? false : fBeyondBounds) {
            TcpRingListener$Connector[] aConnectorNew = new TcpRingListener$Connector[nMember + 4];
            if (aConnector != null) {
                System.arraycopy(aConnector, 0, aConnectorNew, 0, aConnector.length);
            }
            aConnector = aConnectorNew;
            this.setConnector(aConnector);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aConnector[nMember] = connector;
        }
    }

    protected void setConnector(TcpRingListener$Connector[] aSocket) {
        this.__m_Connector = aSocket;
    }

    protected void setDisconnectedSockets(Map list) {
        this.__m_DisconnectedSockets = list;
    }

    public void setMaxExceptions(int cExceptions) {
        this.__m_MaxExceptions = cExceptions;
    }

    protected void setRingBroken(boolean fBroken) {
        this.__m_RingBroken = fBroken;
    }

    public void setService(ClusterService service) {
        this.__m_Service = service;
    }

    public void setSocketAccepter(TcpSocketAccepter socket) {
        this.__m_SocketAccepter = socket;
    }

    protected void setStatsPings(long c) {
        this.__m_StatsPings = c;
    }

    protected void setStatsRestores(long c) {
        this.__m_StatsRestores = c;
    }

    protected void setStatsTimeouts(long c) {
        this.__m_StatsTimeouts = c;
    }

    public synchronized void stop() {
        block5: {
            if (!this.isStarted()) break block5;
            super.stop();
            try {
                this.getSocketAccepter().close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (Thread.currentThread() != this.getThread()) {
                try {
                    this.wait(100);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String toString() {
        if (this.isStarted()) {
            StringBuffer sb = new StringBuffer();
            sb.append("TcpRing{").append(this.getSocketAccepter()).append(", Connections=[");
            TcpRingListener$Connector[] aConnector = this.getConnector();
            int cMembers = aConnector == null ? 0 : aConnector.length;
            boolean fFirst = true;
            int nMember = 1;
            while (nMember < cMembers) {
                TcpRingListener$Connector connector = aConnector[nMember];
                if (connector != null) {
                    if (fFirst) {
                        fFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    if (connector.isBroken()) {
                        sb.append('!');
                    }
                    sb.append(nMember);
                }
                ++nMember;
            }
            sb.append("]}");
            return sb.toString();
        }
        return "TcpRing is disabled";
    }

    protected void updateConnectionInfo() {
        ClusterService service = this.getService();
        if (!(service != null) ? false : service.isAcceptingClients()) {
            int nBuddyId;
            ObservableMap mapConfig = service.getThisMemberConfigMap();
            Integer IPoints = Base.makeInteger((int)this.getConnectionCount());
            if (IPoints.equals(mapConfig.get(KEY_POINTS)) ^ true) {
                mapConfig.put(KEY_POINTS, IPoints);
            }
            if ((nBuddyId = this.getBuddyId()) == 0) {
                if (mapConfig.containsKey(KEY_BUDDY)) {
                    mapConfig.remove(KEY_BUDDY);
                }
            } else {
                Integer IBuddy = Base.makeInteger((int)nBuddyId);
                if (IBuddy.equals(mapConfig.get(KEY_BUDDY)) ^ true) {
                    mapConfig.put(KEY_BUDDY, IBuddy);
                }
            }
        }
    }

    protected void validateMembers() {
        TcpRingListener$Connector[] aConnector = this.getConnector();
        if (aConnector != null) {
            ServiceMemberSet setMembers = this.getService().getServiceMemberSet();
            boolean fUpdate = false;
            int nMember = 1;
            int cMembers = aConnector.length;
            while (nMember < cMembers) {
                TcpRingListener$Connector connector = aConnector[nMember];
                if (!(connector != null) ? false : setMembers.contains(nMember) ^ true) {
                    this.disconnect(nMember, "the peer departure");
                    fUpdate = true;
                }
                ++nMember;
            }
            if (fUpdate) {
                this.updateConnectionInfo();
            }
        }
    }
}

