/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberAcceptId;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClusterService$NewMemberRequestIdReply
extends DiscoveryMessage {
    private int __m_MulticastTimeToLive;
    private String __m_ServiceVersion;
    private int __m_WkaListHashCode;

    public ClusterService$NewMemberRequestIdReply() {
        this(null, null, true);
    }

    public ClusterService$NewMemberRequestIdReply(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(12);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return String.valueOf("ToMember=") + this.getToMember() + "\nServiceVersion=" + this.getServiceVersion();
    }

    public int getMulticastTimeToLive() {
        return this.__m_MulticastTimeToLive;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public int getWkaListHashCode() {
        return this.__m_WkaListHashCode;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService$NewMemberRequestIdReply".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberRequestIdReply();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        Member memberFrom = this.getFromMember();
        ClusterService service = (ClusterService)this.getService();
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(-2, memberFrom);
                    throw new EventDeathException("Version mismatch");
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                break;
            }
            case 1: {
                int iTtlSenior;
                if (this.isReadError()) {
                    service.onMemberRejected(-2, memberFrom);
                    throw new EventDeathException("Version mismatch");
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                if (!this.getToMember().getUid32().equals((Object)service.getRequestMember().getUid32())) break;
                Member memberOldest = service.ensureMember(this.getFromMember(), this.getServiceVersion());
                Member memberThis = service.getRequestMember();
                memberThis.setId(this.getToMember().getId());
                memberThis = service.ensureMember(memberThis, service.getServiceVersion());
                MasterMemberSet setMember = service.getClusterMemberSet();
                setMember.setThisMember(memberThis);
                Component._assert(setMember.getOldestMember() == memberOldest);
                service.setState(ClusterService.STATE_JOINED);
                Component._trace(String.valueOf("This ") + memberThis.toString(Member.SHOW_ALL) + " joined " + service.formatClusterString() + " with senior " + memberOldest.toString(Member.SHOW_ALL), 3);
                ClusterService$NewMemberAcceptId msg = (ClusterService$NewMemberAcceptId)service.instantiateMessage("NewMemberAcceptId");
                msg.addToMember(memberOldest);
                msg.setFromMemberId(memberThis.getId());
                msg.setFromMemberUid(memberThis.getUid32());
                msg.setToMemberId(memberOldest.getId());
                msg.setToMemberUid(memberOldest.getUid32());
                service.send(msg);
                if (service.isWkaEnabled()) {
                    if (!(service.getWkaListHashCode() != this.getWkaListHashCode())) break;
                    Component._trace(String.valueOf("This member is configured with a compatible but ") + "different WKA list then the senior " + memberOldest + ". It is strongly recommended to use the same WKA list for " + "all cluster members.", 2);
                    break;
                }
                int iTtlThis = service.getMulticastTimeToLive();
                if (!(iTtlThis != (iTtlSenior = this.getMulticastTimeToLive()))) break;
                Component._trace(String.valueOf("This member is configured with a multicast TTL of ") + iTtlThis + "; the senior " + memberOldest + " is " + "configured with a TTL of " + iTtlSenior + ". It is strongly recommended to use the same TTL setting for " + "all cluster members.", 2);
                break;
            }
            case 2: {
                service.validateSeniorBroadcast(this, null);
                break;
            }
        }
    }

    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        this.setServiceVersion(stream.readUTF());
        this.setMulticastTimeToLive(stream.readInt());
        this.setWkaListHashCode(stream.readInt());
        this.ensureEOS(stream);
    }

    public void setMulticastTimeToLive(int pMulticastTimeToLive) {
        this.__m_MulticastTimeToLive = pMulticastTimeToLive;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void setWkaListHashCode(int iHash) {
        this.__m_WkaListHashCode = iHash;
    }

    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        stream.writeUTF(this.getServiceVersion());
        stream.writeInt(this.getMulticastTimeToLive());
        stream.writeInt(this.getWkaListHashCode());
    }
}

