/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceJoined$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceUpdateResponse;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ClusterService$ServiceJoined
extends RequestMessage {
    private transient ClusterService.ServiceJoinRequest __m_JoinRequest;
    private Map __m_MemberConfigMap;
    private int __m_MemberId;
    private int __m_ServiceId;
    private long __m_ServiceJoined;
    private String __m_ServiceName;
    private String __m_ServiceType;
    private String __m_ServiceVersion;

    public ClusterService$ServiceJoined() {
        this(null, null, true);
    }

    public ClusterService$ServiceJoined(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(21);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new ClusterService$ServiceJoined$Poll("Poll", this, true), "Poll");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return String.valueOf("MemberId=") + this.getMemberId() + "\nServiceId=" + this.getServiceId() + "\nServiceName=" + this.getServiceName() + "\nServiceVersion=" + this.getServiceVersion() + "\nServiceJoined=" + this.getServiceJoined() + "\nMemberConfigMap=" + this.getMemberConfigMap();
    }

    public ClusterService.ServiceJoinRequest getJoinRequest() {
        return this.__m_JoinRequest;
    }

    public Map getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public int getMemberId() {
        return this.__m_MemberId;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public long getServiceJoined() {
        return this.__m_ServiceJoined;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return this.__m_ServiceType;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService$ServiceJoined".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$ServiceJoined();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        int nMember = this.getMemberId();
        Member member = service.getClusterMemberSet().getMember(nMember);
        if (member == null) {
            Component._trace(String.valueOf("ClusterService$ServiceJoined: ") + this.getServiceName() + "; " + "Unknown Member " + nMember, 4);
        } else {
            ServiceInfo info = service.ensureServiceInfo(this.getServiceId(), this.getServiceName(), this.getServiceType());
            ServiceMemberSet setMember = info.getMemberSet();
            long lJoined = this.getServiceJoined();
            boolean fNew = true;
            if (setMember.contains(member)) {
                long lJoinedOld = setMember.getServiceJoined(member.getId());
                if (lJoined == lJoinedOld) {
                    fNew = false;
                } else {
                    Component._assert(lJoined > lJoinedOld);
                    setMember.remove(member);
                    service.onServiceLeft(info, member, lJoinedOld);
                }
            }
            if (fNew) {
                setMember.add(member);
                setMember.setServiceVersion(nMember, this.getServiceVersion());
                setMember.setServiceJoined(nMember, lJoined);
            }
            service.onServiceJoined(info, member, this.getMemberConfigMap(), fNew);
        }
        ClusterService$ServiceUpdateResponse msg = (ClusterService$ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
        msg.respondTo(this);
        service.send(msg);
    }

    public void read(DataInputStream stream) throws IOException {
        this.setMemberId(stream.readUnsignedShort());
        this.setServiceId(stream.readUnsignedShort());
        this.setServiceName(stream.readUTF());
        this.setServiceType(stream.readUTF());
        this.setServiceVersion(stream.readUTF());
        this.setServiceJoined(stream.readLong());
        this.setMemberConfigMap((Map)Message.readObject(stream, this.getService().getContextClassLoader()));
    }

    public void setJoinRequest(ClusterService.ServiceJoinRequest pJoinRequest) {
        this.__m_JoinRequest = pJoinRequest;
    }

    public void setMemberConfigMap(Map map) {
        this.__m_MemberConfigMap = map;
    }

    public void setMemberId(int pMemberId) {
        this.__m_MemberId = pMemberId;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setServiceJoined(long lMillis) {
        this.__m_ServiceJoined = lMillis;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setServiceType(String pServiceType) {
        this.__m_ServiceType = pServiceType;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getMemberId());
        stream.writeShort(this.getServiceId());
        stream.writeUTF(this.getServiceName());
        stream.writeUTF(this.getServiceType());
        stream.writeUTF(this.getServiceVersion());
        stream.writeLong(this.getServiceJoined());
        Message.writeObject(stream, this.getMemberConfigMap());
    }
}

