/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher;
import com.tangosol.coherence.component.net.ClusterConfig;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.socket.udpSocket.MulticastUdpSocket;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.TcpRingListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$DispatchMemberEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$ServiceConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$MemberConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$MemberHeartbeat;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$MemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$MemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$MemberLeftResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberAcceptId;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberAcceptIdReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberAnnounce;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberAnnounceReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberAnnounceWait;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberRequestId;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberRequestIdReject;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberRequestIdReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberRequestIdWait;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberTimestampRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberTimestampResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberWelcomeAnnounce;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NewMemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$SeniorMemberHeartbeat;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$SeniorMemberKill;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$SeniorMemberPanic;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceJoinRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceRegister;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceRegisterRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceSecureRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.ClusterService$ServiceUpdateResponse;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterService
extends Service {
    public static final int STATE_ANNOUNCE = 0;
    public static final int STATE_JOINED = 2;
    public static final int STATE_JOINING = 1;
    public static final int STATE_LEAVING = 3;
    public static final int STATE_LEFT = 4;
    private Member __m_AnnounceMember;
    private int __m_BroadcastCounter;
    private int __m_BroadcastLimit;
    private int __m_BroadcastMode;
    private long __m_BroadcastNextMillis;
    private int __m_BroadcastRepeatMillis;
    private int __m_BroadcastTimeoutMillis;
    private Binary __m_BroadcastTimestamp;
    private transient List __m_DeferredAcceptMember;
    private int __m_HeartbeatDelay;
    private transient MemberSet __m_HeartbeatMemberSet;
    private transient long __m_LastInterminableWarningMillis;
    private UUID __m_LastPanicUid;
    private long __m_MembershipReopen;
    private transient LongArray __m_PendingServiceJoined;
    private Member __m_RequestMember;
    private Service[] __m_Service;
    private ServiceInfo[] __m_ServiceInfo;
    private int __m_State;
    private transient long __m_TimestampAdjustment;
    private transient int __m_TimestampMaxVariance;
    private Map __m_WkaMap;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        ClusterService.__initStatic();
    }

    public ClusterService() {
        this(null, null, true);
    }

    public ClusterService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(true);
            this.setBroadcastRepeatMillis(256);
            this.setBroadcastTimeoutMillis(32768);
            this.setClusterMemberSet(new MasterMemberSet());
            this.setDaemonState(0);
            this.setServiceId(0);
            this.setServiceName("Cluster");
            this.setTimestampMaxVariance(10);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new Service$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Service$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Service$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Service$ServiceConfigMap("ServiceConfigMap", this, true), "ServiceConfigMap");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_DeferredAcceptMember = new LinkedList();
            this.__m_PendingServiceJoined = new SparseArray();
            this.__m_WkaMap = new SafeHashMap();
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Object object = __mapChildren.put((Object)"DispatchMemberEvent", (Object)Service$DispatchMemberEvent.get_CLASS());
        Object object2 = __mapChildren.put((Object)"MemberConfigRequest", (Object)ClusterService$MemberConfigRequest.get_CLASS());
        Object object3 = __mapChildren.put((Object)"MemberConfigResponse", (Object)Service$MemberConfigResponse.get_CLASS());
        Object object4 = __mapChildren.put((Object)"MemberConfigUpdate", (Object)Service$MemberConfigUpdate.get_CLASS());
        Object object5 = __mapChildren.put((Object)"MemberHeartbeat", (Object)ClusterService$MemberHeartbeat.get_CLASS());
        Object object6 = __mapChildren.put((Object)"MemberJoined", (Object)ClusterService$MemberJoined.get_CLASS());
        Object object7 = __mapChildren.put((Object)"MemberLeaving", (Object)ClusterService$MemberLeaving.get_CLASS());
        Object object8 = __mapChildren.put((Object)"MemberLeft", (Object)ClusterService$MemberLeft.get_CLASS());
        Object object9 = __mapChildren.put((Object)"MemberLeftResponse", (Object)ClusterService$MemberLeftResponse.get_CLASS());
        Object object10 = __mapChildren.put((Object)"NewMemberAcceptId", (Object)ClusterService$NewMemberAcceptId.get_CLASS());
        Object object11 = __mapChildren.put((Object)"NewMemberAcceptIdReply", (Object)ClusterService$NewMemberAcceptIdReply.get_CLASS());
        Object object12 = __mapChildren.put((Object)"NewMemberAnnounce", (Object)ClusterService$NewMemberAnnounce.get_CLASS());
        Object object13 = __mapChildren.put((Object)"NewMemberAnnounceReply", (Object)ClusterService$NewMemberAnnounceReply.get_CLASS());
        Object object14 = __mapChildren.put((Object)"NewMemberAnnounceWait", (Object)ClusterService$NewMemberAnnounceWait.get_CLASS());
        Object object15 = __mapChildren.put((Object)"NewMemberRequestId", (Object)ClusterService$NewMemberRequestId.get_CLASS());
        Object object16 = __mapChildren.put((Object)"NewMemberRequestIdReject", (Object)ClusterService$NewMemberRequestIdReject.get_CLASS());
        Object object17 = __mapChildren.put((Object)"NewMemberRequestIdReply", (Object)ClusterService$NewMemberRequestIdReply.get_CLASS());
        Object object18 = __mapChildren.put((Object)"NewMemberRequestIdWait", (Object)ClusterService$NewMemberRequestIdWait.get_CLASS());
        Object object19 = __mapChildren.put((Object)"NewMemberTimestampRequest", (Object)ClusterService$NewMemberTimestampRequest.get_CLASS());
        Object object20 = __mapChildren.put((Object)"NewMemberTimestampResponse", (Object)ClusterService$NewMemberTimestampResponse.get_CLASS());
        Object object21 = __mapChildren.put((Object)"NewMemberWelcome", (Object)ClusterService$NewMemberWelcome.get_CLASS());
        Object object22 = __mapChildren.put((Object)"NewMemberWelcomeAnnounce", (Object)ClusterService$NewMemberWelcomeAnnounce.get_CLASS());
        Object object23 = __mapChildren.put((Object)"NewMemberWelcomeRequest", (Object)ClusterService$NewMemberWelcomeRequest.get_CLASS());
        Object object24 = __mapChildren.put((Object)"NotifyMemberJoined", (Object)ClusterService$NotifyMemberJoined.get_CLASS());
        Object object25 = __mapChildren.put((Object)"NotifyMemberLeaving", (Object)Service$NotifyMemberLeaving.get_CLASS());
        Object object26 = __mapChildren.put((Object)"NotifyMemberLeft", (Object)ClusterService$NotifyMemberLeft.get_CLASS());
        Object object27 = __mapChildren.put((Object)"NotifyMessageReceipt", (Object)Service$NotifyMessageReceipt.get_CLASS());
        Object object28 = __mapChildren.put((Object)"NotifyPollClosed", (Object)Service$NotifyPollClosed.get_CLASS());
        Object object29 = __mapChildren.put((Object)"NotifyServiceAnnounced", (Object)Service$NotifyServiceAnnounced.get_CLASS());
        Object object30 = __mapChildren.put((Object)"NotifyServiceJoined", (Object)Service$NotifyServiceJoined.get_CLASS());
        Object object31 = __mapChildren.put((Object)"NotifyServiceLeaving", (Object)Service$NotifyServiceLeaving.get_CLASS());
        Object object32 = __mapChildren.put((Object)"NotifyServiceLeft", (Object)Service$NotifyServiceLeft.get_CLASS());
        Object object33 = __mapChildren.put((Object)"NotifyShutdown", (Object)ClusterService$NotifyShutdown.get_CLASS());
        Object object34 = __mapChildren.put((Object)"NotifyStartup", (Object)Service$NotifyStartup.get_CLASS());
        Object object35 = __mapChildren.put((Object)"ProtocolContext", (Object)Service$ProtocolContext.get_CLASS());
        Object object36 = __mapChildren.put((Object)"Queue", (Object)QueueProcessor$Queue.get_CLASS());
        Object object37 = __mapChildren.put((Object)"SeniorMemberHeartbeat", (Object)ClusterService$SeniorMemberHeartbeat.get_CLASS());
        Object object38 = __mapChildren.put((Object)"SeniorMemberKill", (Object)ClusterService$SeniorMemberKill.get_CLASS());
        Object object39 = __mapChildren.put((Object)"SeniorMemberPanic", (Object)ClusterService$SeniorMemberPanic.get_CLASS());
        Object object40 = __mapChildren.put((Object)"ServiceConfigRequest", (Object)Service$ServiceConfigRequest.get_CLASS());
        Object object41 = __mapChildren.put((Object)"ServiceConfigResponse", (Object)Service$ServiceConfigResponse.get_CLASS());
        Object object42 = __mapChildren.put((Object)"ServiceConfigSync", (Object)Service$ServiceConfigSync.get_CLASS());
        Object object43 = __mapChildren.put((Object)"ServiceConfigUpdate", (Object)Service$ServiceConfigUpdate.get_CLASS());
        Object object44 = __mapChildren.put((Object)"ServiceJoined", (Object)ClusterService$ServiceJoined.get_CLASS());
        Object object45 = __mapChildren.put((Object)"ServiceJoinRequest", (Object)ClusterService$ServiceJoinRequest.get_CLASS());
        Object object46 = __mapChildren.put((Object)"ServiceLeaving", (Object)ClusterService$ServiceLeaving.get_CLASS());
        Object object47 = __mapChildren.put((Object)"ServiceLeft", (Object)ClusterService$ServiceLeft.get_CLASS());
        Object object48 = __mapChildren.put((Object)"ServiceRegister", (Object)ClusterService$ServiceRegister.get_CLASS());
        Object object49 = __mapChildren.put((Object)"ServiceRegisterRequest", (Object)ClusterService$ServiceRegisterRequest.get_CLASS());
        Object object50 = __mapChildren.put((Object)"ServiceSecureRequest", (Object)ClusterService$ServiceSecureRequest.get_CLASS());
        Object object51 = __mapChildren.put((Object)"ServiceUpdateResponse", (Object)ClusterService$ServiceUpdateResponse.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.util.Base");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void addDynamicBroadcast(Member member) {
        List listBroadcast;
        if ((!(member != null) ? false : this.isWellKnown(member) ^ true) && (listBroadcast = this.getPublisherBroadcastList()) != null) {
            List list = listBroadcast;
            synchronized (list) {
                InetSocketAddress address = member.getSocketAddress();
                if (listBroadcast.contains(address) ^ true) {
                    listBroadcast.add(address);
                }
            }
        }
    }

    public static int calcMachines(Set setMembers) {
        HashSet<Integer> setMachines = new HashSet<Integer>();
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            setMachines.add(Base.makeInteger((int)member.getMachineId()));
        }
        return setMachines.size();
    }

    public long calcTimestamp(long lLocalhostMillis) {
        if (lLocalhostMillis != (long)0) {
            lLocalhostMillis += this.getTimestampAdjustment();
        }
        return lLocalhostMillis;
    }

    protected void checkPendingJoinPolls() {
        block13: {
            Component._assert(Thread.currentThread() == this.getThread());
            LongArray laPending = this.getPendingServiceJoined();
            if (!(laPending.isEmpty() ^ true)) break block13;
            long ldtNow = Base.getSafeTimeMillis();
            long cTimeout = this.getPublisherTimeoutMillis();
            long ldtCutoff = ldtNow - (cTimeout - (cTimeout >> 2));
            long ldtOldest = laPending.getFirstIndex();
            if (ldtOldest < ldtCutoff) {
                ClusterService$ServiceJoined msg = (ClusterService$ServiceJoined)laPending.get(ldtOldest);
                String sMsg = "ServiceJoined";
                try {
                    sMsg = String.valueOf(msg);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Poll poll = msg.getRequestPoll();
                if (poll == null) {
                    laPending.remove(ldtOldest);
                    Component._trace(String.valueOf("validatePolls: ") + "This senior encountered a null pending poll for message: " + sMsg, 1);
                    return;
                }
                MemberSet setRemain = poll.getRemainingMemberSet();
                if (setRemain.isEmpty()) {
                    boolean fWasClosed = poll.isClosed();
                    poll.close();
                    laPending.remove(ldtOldest);
                    Component._trace(String.valueOf("validatePolls: ") + "This senior encountered an empty " + (fWasClosed ? "closed " : "") + "pending poll for message: " + sMsg, 1);
                    return;
                }
                String sPoll = "Poll";
                try {
                    sPoll = poll.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Component._trace(String.valueOf("validatePolls: ") + "This senior encountered an overdue poll, indicating a dead " + "member, a significant network issue or an Operating " + "System threading library bug (e.g. Linux NPTL): " + sPoll + "\nfor message: " + sMsg, 2);
                try {
                    ArrayList<Member> listOverdue = new ArrayList<Member>();
                    HashSet<Integer> setMachines = new HashSet<Integer>();
                    MasterMemberSet setAll = this.getClusterMemberSet();
                    Member[] aMember = (Member[])((MemberSet)setAll).toArray(new Member[((MemberSet)setAll).size()]);
                    int i = 0;
                    int c = aMember.length;
                    while (i < c) {
                        Member member = aMember[i];
                        if (!(member != null) ? false : setRemain.contains(member)) {
                            listOverdue.add(member);
                            setMachines.add(new Integer(member.getMachineId()));
                        }
                        ++i;
                    }
                    long ldtGiveUp = ldtOldest + (cTimeout + (cTimeout >> 2));
                    if (!(setMachines.size() <= 1 ? true : ldtNow > ldtGiveUp)) break block13;
                    Iterator iter = listOverdue.iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        Component._trace(String.valueOf("Removing unresponsive member: ") + member, 2);
                        this.doMemberLeft(member);
                    }
                    poll.close();
                    if (listOverdue.isEmpty()) {
                        Component._trace(String.valueOf("validatePolls: ") + "This senior encountered and closed an overdue poll " + "that did not contain any known members, indicating " + "a likely JVM or Operating System threading library " + "(e.g. Linux NPTL) bug: " + sPoll, 1);
                    }
                }
                catch (Throwable e) {
                    Component._trace(String.valueOf("validatePolls: ") + "Non-fatal exception detected during processing:", 1);
                    Component._trace(e);
                    Component._trace(String.valueOf("validatePolls: ") + "Exception has been logged; continuing processing.", 1);
                }
            }
        }
    }

    public int compareImportance(Member memberThat) {
        Member memberThis = this.getThisMember();
        int nThisWeight = memberThis.getPriority();
        if (this.isWellKnown(memberThis)) {
            ++nThisWeight;
        }
        int nThatWeight = memberThat.getPriority();
        if (this.isWellKnown(memberThat)) {
            ++nThatWeight;
        }
        int iResult = nThisWeight - nThatWeight;
        int i = 1;
        int c = this.getServiceCount();
        while (i < c) {
            Service service = this.getService(i);
            if (service != null) {
                iResult += service.compareImportance(memberThat);
            }
            ++i;
        }
        return iResult;
    }

    public void doMemberAccept(Member memberNew) {
        Component._assert(Thread.currentThread() == this.getThread());
        if (this.getPendingServiceJoined().isEmpty()) {
            ClusterService$NewMemberAcceptIdReply msg = (ClusterService$NewMemberAcceptIdReply)this.instantiateMessage("NewMemberAcceptIdReply");
            msg.addToMember(memberNew);
            MasterMemberSet setMember = this.getClusterMemberSet();
            ServiceMemberSet setServiceMember = this.getServiceMemberSet();
            Object[] aoMember = setMember.toArray();
            int cMembers = aoMember.length;
            msg.setMemberCount(cMembers);
            int i = 0;
            while (i < cMembers) {
                Member member = (Member)aoMember[i];
                msg.setMember(i, member);
                msg.setServiceVersion(i, setServiceMember.getServiceVersion(member.getId()));
                ++i;
            }
            int cServices = this.getServiceInfoCount();
            msg.setServiceCount(cServices);
            int i2 = 0;
            while (i2 < cServices) {
                ServiceInfo info = this.getServiceInfo(i2);
                msg.setServiceId(i2, info.getServiceId());
                msg.setServiceName(i2, info.getServiceName());
                msg.setServiceType(i2, info.getServiceType());
                ++i2;
            }
            this.send(msg);
        } else {
            List listDeferred = this.getDeferredAcceptMember();
            Component._assert(listDeferred.contains(memberNew) ^ true);
            listDeferred.add(memberNew);
        }
    }

    public void doMemberLeaving() {
        this.setState(STATE_LEAVING);
        Member memberThis = this.getThisMember();
        if (memberThis != null) {
            ClusterService$MemberLeaving msg = (ClusterService$MemberLeaving)this.instantiateMessage("MemberLeaving");
            msg.setToMemberSet(this.getOthersMemberSet());
            msg.setMemberId(memberThis.getId());
            msg.setMemberUid(memberThis.getUid32());
            this.send(msg);
        }
    }

    public void doMemberLeft() {
        this.setState(STATE_LEFT);
        Member memberThis = this.getThisMember();
        if (memberThis != null) {
            ClusterService$MemberLeft msg = (ClusterService$MemberLeft)this.instantiateMessage("MemberLeft");
            msg.setToMemberSet(this.getOthersMemberSet());
            msg.setMemberId(memberThis.getId());
            msg.setMemberUID(memberThis.getUid32());
            this.send(msg);
        }
    }

    public void doMemberLeft(Member member) {
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member memberThis = setMember.getThisMember();
        if (setMember.contains(member)) {
            Component._assert(member != memberThis);
            MemberSet setTo = new MemberSet();
            setTo.addAll((Collection)this.getClusterMemberSet());
            setTo.remove(member);
            setTo.remove(memberThis);
            if (setTo.isEmpty() ^ true) {
                ClusterService$MemberLeft msg = (ClusterService$MemberLeft)this.instantiateMessage("MemberLeft");
                msg.setToMemberSet(setTo);
                msg.setMemberId(member.getId());
                msg.setMemberUID(member.getUid32());
                this.send(msg);
            }
            this.removeMember(member);
        } else {
            Component._trace(String.valueOf("ClusterService.doMemberLeft: ") + "Unknown " + member, 4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doServiceJoined(Service service) {
        int nServiceId = service.getServiceId();
        if (!(nServiceId > 0) ? false : this.getService(nServiceId) == null) {
            ServiceInfo info = this.getServiceInfo(nServiceId);
            Member memberThis = this.getThisMember();
            int nMemberId = memberThis.getId();
            this.setService(nServiceId, service);
            ObservableMap mapMemberConfig = service.getServiceMemberSet().ensureMemberConfigMap(nMemberId);
            HashMap mapSnapshot = new HashMap();
            mapSnapshot.putAll(mapMemberConfig);
            mapMemberConfig.addMapListener((MapListener)((Service$MemberConfigListener)service._findChild("MemberConfigListener")));
            do {
                ClusterService$ServiceJoinRequest msg = (ClusterService$ServiceJoinRequest)this.instantiateMessage("ServiceJoinRequest");
                msg.addToMember(this.getClusterOldestMember());
                msg.setServiceId(nServiceId);
                msg.setServiceVersion(service.getServiceVersion());
                msg.setMemberConfigMap(mapSnapshot);
                Object oResponse = this.poll(msg);
                if (oResponse instanceof RuntimeException) {
                    throw (RuntimeException)oResponse;
                }
                if (info.getServiceJoined(nMemberId) > 0L) return;
                boolean bl = false;
                if (bl) return;
            } while (!(nServiceId != this.ensureService(service.getServiceName(), service.getServiceType())));
            this.setService(nServiceId, null);
            throw new RuntimeException("Service info mismatch; service has to be restarted");
        }
        if (this.getService(nServiceId) == service) {
            return;
        }
        boolean bl = true;
        if (!bl) return;
        throw new IllegalStateException(String.valueOf("Attempt to replace existing service: ") + this.getService(nServiceId) + "\nwith a different instance: " + service);
    }

    public void doServiceLeaving(Service service) {
        int nId = service.getServiceId();
        if (nId > 0) {
            if (this.getService(nId) == service) {
                ServiceMemberSet setMember = this.getServiceInfo(nId).getMemberSet();
                Member memberThis = this.getThisMember();
                int nMemberId = memberThis.getId();
                long lJoined = setMember.getServiceJoined(nMemberId);
                setMember.setServiceLeaving(nMemberId, true);
                ClusterService$ServiceLeaving msg = (ClusterService$ServiceLeaving)this.instantiateMessage("ServiceLeaving");
                msg.setToMemberSet(this.getOthersMemberSet());
                msg.setServiceId(nId);
                msg.setServiceJoined(lJoined);
                this.send(msg);
            } else {
                Component._trace(String.valueOf("ClusterService.doServiceLeaving: ") + "Unknown Service " + service, 1);
            }
        }
    }

    public void doServiceLeft(Service service) {
        int nId = service.getServiceId();
        if (nId > 0) {
            if (this.getService(nId) == service) {
                ServiceMemberSet setMember = this.getServiceInfo(nId).getMemberSet();
                Member memberThis = this.getThisMember();
                long lJoined = setMember.getServiceJoined(memberThis.getId());
                setMember.remove(memberThis);
                this.setService(nId, null);
                ClusterService$ServiceLeft msg = (ClusterService$ServiceLeft)this.instantiateMessage("ServiceLeft");
                msg.setToMemberSet(this.getOthersMemberSet());
                msg.setServiceId(nId);
                msg.setServiceJoined(lJoined);
                this.send(msg);
            } else {
                Component._trace(String.valueOf("ClusterService.doServiceLeft: ") + "Unknown Service " + service, 1);
            }
        }
    }

    public Member ensureMember(Member memberNew, String sVersion) {
        int nId;
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member member = setMember.getMember(nId = memberNew.getId());
        if (member == null) {
            member = memberNew;
            setMember.add(member);
            ServiceMemberSet setServiceMember = this.getServiceMemberSet();
            setServiceMember.add(member);
            setServiceMember.setServiceVersion(nId, sVersion);
            setServiceMember.setServiceJoined(nId, member.getTimestamp());
            setServiceMember.ensureMemberConfigMap(nId).clear();
            this.onMemberJoined(member);
        }
        return member;
    }

    /*
     * Unable to fully structure code
     */
    public int ensureService(String sName, String sType) {
        do {
            msg = (ClusterService$ServiceRegisterRequest)this.instantiateMessage("ServiceRegisterRequest");
            msg.addToMember(this.getClusterOldestMember());
            msg.setServiceName(sName);
            msg.setServiceType(sType);
        } while ((oResult = this.poll(msg)) == null);
        nId = (Integer)oResult;
        info = this.getServiceInfo(nId);
        sTypeReg = info.getServiceType();
        if (!(sType.equals(sTypeReg) ^ true)) ** GOTO lbl17
        throw new IllegalArgumentException(String.valueOf("Invalid service type: requested=") + sType + ", registered=" + sTypeReg);
        while (!((memberSenior = (Member)info.getOldestMember()) == null != false ? true : memberSenior.equals(this.getThisMember()))) {
            oResponse = this.pollSecure(memberSenior, null);
            if (!(oResponse == null)) {
                if (!(oResponse instanceof Exception)) break;
                throw new WrapperException((Throwable)((Exception)oResponse));
            }
lbl17:
            // 3 sources

            if (Security.getInstance() == null) continue;
        }
        return nId;
    }

    public ServiceInfo ensureServiceInfo(int nService, String sName, String sType) {
        ServiceInfo[] ainfo = this.getServiceInfo();
        int i = 0;
        int c = ainfo == null ? 0 : ainfo.length;
        while (i < c) {
            ServiceInfo info = ainfo[i];
            if (info != null) {
                boolean fObsolete = false;
                fObsolete = i == nService ? (info.getServiceName().equals(sName) ^ true ? true : (!(sType != null) ? false : sType.equals(info.getServiceType()) ^ true)) : info.getServiceName().equals(sName);
                if (fObsolete) {
                    Component._trace(String.valueOf("Removing the obsolete service info: ") + info, 3);
                    ainfo[i] = null;
                }
            }
            ++i;
        }
        ServiceInfo info = this.getServiceInfo(nService);
        if (info == null) {
            info = new ServiceInfo();
            info.setServiceId(nService);
            info.setServiceName(sName);
            info.setServiceType(sType);
            this.setServiceInfo(nService, info);
            this.onServiceAnnounced(info);
        } else {
            Component._assert(sName.equals(info.getServiceName()));
            Component._assert(sType == null ? true : sType.equals(info.getServiceType()));
        }
        return info;
    }

    public int ensureWkaMember(Member memberNew) {
        int[] acMax = new int[4];
        int nType = memberNew.getEdition();
        Iterator iter = this.getWkaMap().values().iterator();
        while (iter.hasNext()) {
            int[] an = (int[])iter.next();
            if (!(!(an[0] == nType) ? false : an[1] < 4)) continue;
            acMax[an[1]] = acMax[an[1]] + Math.max(an[2], 1);
        }
        if (acMax[0] > 0) {
            return 0;
        }
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        map.put(new Integer(memberNew.getMachineId()), memberNew.getStatsCount());
        Iterator iter2 = this.getClusterMemberSet().iterator();
        while (iter2.hasNext()) {
            int[] anNew;
            Integer IKey;
            int[] anOld;
            Member member = (Member)iter2.next();
            if (!(member.getEdition() == nType) || !((anOld = map.put(IKey = new Integer(member.getMachineId()), anNew = member.getStatsCount())) != null)) continue;
            int i = 0;
            int c = anNew.length;
            while (i < c) {
                anNew[i] = Math.max(anOld[i], anNew[i]);
                ++i;
            }
        }
        int[] acCur = new int[4];
        Iterator iter3 = map.values().iterator();
        while (iter3.hasNext()) {
            int[] an = (int[])iter3.next();
            acCur[1] = acCur[1] + 1;
            acCur[2] = acCur[2] + an[1];
            acCur[3] = acCur[3] + an[0];
        }
        int i = 1;
        int c = acMax.length;
        while (i < c) {
            int cMax = acMax[i];
            if (cMax > 0) {
                int nResult = acCur[i] - cMax;
                return nResult <= 0 ? nResult : i << 29 | cMax << 12 | nResult;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    public String formatClusterString() {
        String sClusterName = this.getClusterName();
        StringBuffer sb = new StringBuffer("cluster");
        if (!(sClusterName != null) ? false : sClusterName.length() > 0) {
            sb.append(" \"").append(sClusterName).append('\"');
        }
        return sb.toString();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "STATE_ANNOUNCE";
            }
            case 1: {
                return "STATE_JOINING";
            }
            case 2: {
                return "STATE_JOINED";
            }
            case 3: {
                return "STATE_LEAVING";
            }
            case 4: {
                return "STATE_LEFT";
            }
        }
        return "<unknown>";
    }

    public int fromString(String s) {
        if (!(s != null) ? false : s.length() >= 2) {
            String[] a;
            char ch1 = s.charAt(0);
            int ch2 = s.charAt(1);
            if (s.indexOf(32) > 0 && (!(!(!(!((a = Base.parseDelimitedString((String)s, (char)' ')).length > 3) ? false : a[0].length() > 5) ? false : a[1].length() > 5) ? false : a[2].length() > 3) ? false : a[3].length() > 3)) {
                int n = 0;
                int i = 1;
                while (i < 4) {
                    n = n << 8 | a[i].charAt(i);
                    ++i;
                }
                switch (n) {
                    case 7103333: 
                    case 7304293: {
                        return 0;
                    }
                    case 7299429: 
                    case 7302501: {
                        return 1;
                    }
                    case 7299956: {
                        if (a[2].charAt(0) == 'L') {
                            return 0;
                        }
                    }
                    case 7299444: 
                    case 7304564: {
                        return 3;
                    }
                    case 7303284: 
                    case 7304308: {
                        if (a[2].charAt(0) != 'D') {
                            return 4;
                        }
                    }
                    case 7301492: {
                        return 5;
                    }
                }
            }
            if (!(!(s.length() >= 30) ? false : s.charAt(13) == 'l') ? false : s.charAt(28) == 'c') {
                ch2 = s.length();
                ch1 = s.charAt(ch2 - 1);
                switch (ch1) {
                    case 'e': {
                        return 5 - (ch2 < 33 ? 2 : 1);
                    }
                    case 'l': 
                    case 's': {
                        return 0;
                    }
                }
                ch2 = s.charAt(ch2 - (ch1 == 'n' ? 1 : 0) - 6);
                ch1 = s.charAt(30);
            }
            switch (ch1) {
                case 'G': {
                    return 5;
                }
                case 'E': 
                case 'e': {
                    return ch2 == ch1 ? 4 : 0;
                }
                case 'S': {
                    return 3;
                }
                case 'P': 
                case 'p': {
                    return 2;
                }
                case 'C': 
                case 'R': {
                    return 1;
                }
                case 'D': 
                case 'd': {
                    return ch2 == 101 ? 1 : 0;
                }
            }
        }
        return -1;
    }

    public Member getAnnounceMember() {
        return this.__m_AnnounceMember;
    }

    public int getBroadcastCounter() {
        return this.__m_BroadcastCounter;
    }

    public int getBroadcastLimit() {
        return this.__m_BroadcastLimit;
    }

    private int getBroadcastMode() {
        return this.__m_BroadcastMode;
    }

    public long getBroadcastNextMillis() {
        return this.__m_BroadcastNextMillis;
    }

    public int getBroadcastRepeatMillis() {
        return this.__m_BroadcastRepeatMillis;
    }

    public int getBroadcastTimeoutMillis() {
        return this.__m_BroadcastTimeoutMillis;
    }

    public Binary getBroadcastTimestamp() {
        return this.__m_BroadcastTimestamp;
    }

    public int getBroadcastVariance() {
        return 212343923;
    }

    public int getClusterId() {
        return this.isWkaEnabled() ? this.getWkaListHashCode() : ((Cluster)this.getCluster()).getPublisher().getUdpSocketMulticast().hashCode();
    }

    public String getClusterName() {
        return ((Cluster)this.getCluster()).getClusterName();
    }

    public List getDeferredAcceptMember() {
        return this.__m_DeferredAcceptMember;
    }

    public int getHeartbeatDelay() {
        return this.__m_HeartbeatDelay;
    }

    public MemberSet getHeartbeatMemberSet() {
        MemberSet setTo = this.__m_HeartbeatMemberSet;
        if (setTo == null) {
            setTo = new MemberSet();
            this.setHeartbeatMemberSet(setTo);
        }
        setTo.removeAll((Collection)setTo);
        MasterMemberSet setMembers = this.getClusterMemberSet();
        int cMembers = setMembers.size();
        if (cMembers > 1) {
            Member memberThis = setMembers.getThisMember();
            int cDelay = Math.max(2 * this.getHeartbeatDelay(), 2000);
            long ldtCutoff = Base.getSafeTimeMillis() - (long)cDelay;
            Member[] aMember = (Member[])setMembers.toArray(new Member[cMembers]);
            cMembers = aMember.length;
            long lFromIdCurr = ((Cluster)this.getCluster()).getPublisher().getMessageOutgoing().getLastIndex();
            long lTrintCutoff = lFromIdCurr - (long)(Packet.TRINT_MAX_VARIANCE >>> 3);
            int iFirst = (int)(Math.random() * (double)cMembers);
            int iLast = iFirst + cMembers;
            int i = iFirst;
            while (i < iLast) {
                Member member = aMember[i >= cMembers ? i - cMembers : i];
                if (!(!(member != null) ? false : member != memberThis) ? false : member.isDeaf() ^ true) {
                    boolean fTrintDanger;
                    long ldtLastOut = member.getLastOutgoingMillis();
                    long ldtLastIn = member.getLastIncomingMillis();
                    boolean fQuiet = !(ldtLastOut < ldtCutoff) ? false : ldtLastIn >= ldtLastOut;
                    PacketIdentifier packetidTo = member.getContiguousToPacketId();
                    boolean bl = packetidTo == null ? true : (fTrintDanger = packetidTo.getFromMessageId() < lTrintCutoff);
                    if (!fQuiet ? false : (fTrintDanger ? true : setTo.isEmpty())) {
                        setTo.add(member);
                    }
                }
                ++i;
            }
        }
        return setTo;
    }

    public long getLastInterminableWarningMillis() {
        return this.__m_LastInterminableWarningMillis;
    }

    public UUID getLastPanicUid() {
        return this.__m_LastPanicUid;
    }

    public long getMembershipReopen() {
        return this.__m_MembershipReopen;
    }

    public int getMulticastTimeToLive() {
        MulticastUdpSocket socket = ((Cluster)this.getCluster()).getPublisher().getUdpSocketMulticast();
        return socket == null ? 0 : socket.getTimeToLive();
    }

    public LongArray getPendingServiceJoined() {
        return this.__m_PendingServiceJoined;
    }

    public List getPublisherBroadcastList() {
        return ((Cluster)this.getCluster()).getPublisher().getBroadcastAddressList();
    }

    public int getPublisherTimeoutMillis() {
        return ((Cluster)this.getCluster()).getPublisher().getResendTimeout();
    }

    public int getReceiverMaxPacketSize() {
        return ((Cluster)this.getCluster()).getReceiver().getMaximumPacketLength();
    }

    public Member getRequestMember() {
        return this.__m_RequestMember;
    }

    protected Service[] getService() {
        return this.__m_Service;
    }

    public Service getService(int i) {
        Service[] aService = this.getService();
        return (aService == null ? true : i >= aService.length) ? null : aService[i];
    }

    public Service getService(String sName) {
        int cServices = this.getServiceCount();
        int i = 0;
        while (i < cServices) {
            Service service = this.getService(i);
            if (!(service != null) ? false : sName.equals(service.getServiceName())) {
                return service;
            }
            ++i;
        }
        return null;
    }

    public int getServiceCount() {
        Service[] aService = this.getService();
        return aService == null ? 0 : aService.length;
    }

    protected ServiceInfo[] getServiceInfo() {
        return this.__m_ServiceInfo;
    }

    public ServiceInfo getServiceInfo(int i) {
        ServiceInfo[] ainfo = this.getServiceInfo();
        return (ainfo == null ? true : i >= ainfo.length) ? null : ainfo[i];
    }

    public ServiceInfo getServiceInfo(String sName) {
        int cInfo = this.getServiceInfoCount();
        int i = 0;
        while (i < cInfo) {
            ServiceInfo info = this.getServiceInfo(i);
            if (!(info != null) ? false : sName.equals(info.getServiceName())) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public int getServiceInfoCount() {
        ServiceInfo[] ainfo = this.getServiceInfo();
        return ainfo == null ? 0 : ainfo.length;
    }

    public Member getServiceOldestMember() {
        return this.getClusterOldestMember();
    }

    public String getServiceStateName() {
        return String.valueOf(super.getServiceStateName()) + ", " + ClusterService.formatStateName(this.getState());
    }

    public String getServiceType() {
        return "Cluster";
    }

    public String getServiceVersion() {
        return "3.3";
    }

    public Set getSlowMembers() {
        HashSet<Member> setMembers = null;
        Iterator iter = this.getClusterMemberSet().iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!this.isSlow(member)) continue;
            if (setMembers == null) {
                setMembers = new HashSet<Member>();
            }
            setMembers.add(member);
        }
        return setMembers;
    }

    public int getState() {
        return this.__m_State;
    }

    public long getTimestamp() {
        return this.calcTimestamp(Base.getSafeTimeMillis());
    }

    public long getTimestampAdjustment() {
        return this.__m_TimestampAdjustment;
    }

    public int getTimestampMaxVariance() {
        return this.__m_TimestampMaxVariance;
    }

    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long cWait2 = Math.max(1L, this.getBroadcastNextMillis() - Base.getSafeTimeMillis());
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    protected MemberSet getWitnessMemberSet(Member memberSuspect) {
        Member member;
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        Member memberThis = this.getThisMember();
        Integer IBuddy = (Integer)setMembers.getMemberConfigMap(memberSuspect.getId()).get(TcpRingListener.KEY_BUDDY);
        if (IBuddy != null && (!(!(!((member = setMembers.getMember(IBuddy)) != null) ? false : member != memberSuspect) ? false : member != memberThis) ? false : member.isDeaf() ^ true)) {
            return SingleMemberSet.instantiate(member);
        }
        Member memberWitness = null;
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            Member member2 = (Member)iter.next();
            if (!(!(!(member2 != memberThis) ? false : member2 != memberSuspect) ? false : member2.isDeaf() ^ true)) continue;
            if (member2.getMachineId() != memberThis.getMachineId()) {
                memberWitness = member2;
                break;
            }
            if (!(memberWitness == null)) continue;
            memberWitness = member2;
        }
        return memberWitness == null ? null : SingleMemberSet.instantiate(memberWitness);
    }

    public int getWkaListHashCode() {
        List listWka = ((Cluster)this.getCluster()).getPublisher().getWellKnownAddressList();
        return listWka == null ? 0 : listWka.hashCode();
    }

    public Map getWkaMap() {
        return this.__m_WkaMap;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/ClusterService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ClusterService();
    }

    private final Component get_Module() {
        return this;
    }

    public int indexOfService(String sName) {
        Component._assert(sName != null);
        ServiceInfo[] ainfo = this.getServiceInfo();
        int i = 0;
        int c = ainfo.length;
        while (i < c) {
            ServiceInfo info = ainfo[i];
            if (!(info != null) ? false : info.getServiceName().equals(sName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Member instantiateMember() {
        return new Member();
    }

    public boolean isHeuristicallyDead(Member member) {
        if (member == null ? true : member.isDeaf()) {
            return true;
        }
        int cTimeoutMillis = this.getPublisherTimeoutMillis();
        long lCurrentMillis = Base.getSafeTimeMillis();
        long lCutoffMillis = lCurrentMillis - (long)(cTimeoutMillis >> 1);
        long lLastInMillis = member.getLastIncomingMillis();
        return lLastInMillis < lCutoffMillis;
    }

    public boolean isMembershipSuspended() {
        return Base.getSafeTimeMillis() <= this.getMembershipReopen();
    }

    public boolean isNotification() {
        if (this.getBroadcastNextMillis() <= Base.getSafeTimeMillis()) {
            return true;
        }
        return super.isNotification();
    }

    public boolean isSlow(Member member) {
        int cTimeoutMillis;
        long lCurrentMillis = Base.getSafeTimeMillis();
        long lLastSlowMillis = member.getLastSlowMillis();
        return lLastSlowMillis > lCurrentMillis - (long)(cTimeoutMillis = this.getPublisherTimeoutMillis());
    }

    public boolean isWellKnown(Member member) {
        Cluster$PacketPublisher publisher = ((Cluster)this.getCluster()).getPublisher();
        return publisher.isMulticastEnabled() ? true : publisher.getWellKnownAddressList().contains(member.getSocketAddress());
    }

    public boolean isWkaEnabled() {
        return ((Cluster)this.getCluster()).getPublisher().isMulticastEnabled() ^ true;
    }

    protected void onEnter() {
        int n;
        if (this.isWkaEnabled() && (!((n = ((Cluster)this.getCluster()).getConfig().getEdition()) < 4) ? false : n != 2)) {
            throw Base.ensureRuntimeException(null, (String)this.toString("HT^\u007fw*16<>,+r013&v\u007f<3*,+:-618\u007f6,\u007f10+\u007f>)>63>=3:q"));
        }
        super.onEnter();
        this.setBroadcastLimit(this.getBroadcastTimeoutMillis() / this.getBroadcastRepeatMillis() + 1);
        this.setBroadcastNextMillis(Base.getSafeTimeMillis());
    }

    public void onException(Throwable e) {
        switch (this.getState()) {
            default: {
                super.onException(e);
                break;
            }
            case 1: {
                Component._trace(String.valueOf("StopJoining ") + this.toString() + " due to unhandled exception: ", 1);
                Component._trace(e);
                this.onStopJoining();
                break;
            }
            case 2: {
                Component._trace(String.valueOf("StopRunning ") + this.toString() + " due to unhandled exception: ", 1);
                Component._trace(e);
                this.onStopRunning();
                break;
            }
        }
    }

    public void onInit() {
        super.onInit();
        ServiceInfo info = this.ensureServiceInfo(0, this.getServiceName(), this.getServiceType());
        this.setService(0, this);
        this.setServiceMemberSet(info.getMemberSet());
    }

    public void onMemberJoined(Member member) {
        Member memberThis = this.getThisMember();
        if (!(memberThis != null) ? false : member != memberThis) {
            Component._trace(String.valueOf(member) + " joined Cluster with senior member " + this.getClusterOldestMember().getId(), 5);
            int i = 0;
            int c = this.getServiceCount();
            while (i < c) {
                Service service = this.getService(i);
                if (service != null) {
                    Service$NotifyMemberJoined msg = (Service$NotifyMemberJoined)service.instantiateMessage("NotifyMemberJoined");
                    msg.setNotifyMember(member);
                    service.send(msg);
                }
                ++i;
            }
        }
        if (this.isAcceptingClients()) {
            this.dispatchMemberEvent(member, MemberEvent.MEMBER_JOINED);
        }
    }

    public void onMemberLeaving(Member member) {
        int i = 0;
        int c = this.getServiceCount();
        while (i < c) {
            Service service = this.getService(i);
            if (service != null) {
                Service$NotifyMemberLeaving msg = (Service$NotifyMemberLeaving)service.instantiateMessage("NotifyMemberLeaving");
                msg.setNotifyMember(member);
                service.send(msg);
            }
            ++i;
        }
        this.dispatchMemberEvent(member, MemberEvent.MEMBER_LEAVING);
    }

    public void onMemberLeft(Member member) {
        Member memberSenior = this.getClusterOldestMember();
        Component._trace(String.valueOf("Member ") + member.getId() + " left Cluster with senior member " + memberSenior.getId(), 5);
        this.removeDynamicBroadcast(member);
        ((Cluster)this.getCluster()).getPublisher().onMemberLeft(member);
        int i = 0;
        int c = this.getServiceCount();
        while (i < c) {
            Service service = this.getService(i);
            if (service != null) {
                Service$NotifyMemberLeft msg = (Service$NotifyMemberLeft)service.instantiateMessage("NotifyMemberLeft");
                msg.setNotifyMember(member);
                service.send(msg);
            }
            ++i;
        }
        this.dispatchMemberEvent(member, MemberEvent.MEMBER_LEFT);
    }

    public void onMemberRejected(int nReason, Member rejecter) {
        nReason = nReason < 0 ? -nReason : (nReason -= MasterMemberSet.MAX_MEMBERS);
        String sError = null;
        switch (nReason) {
            case 0: {
                break;
            }
            case 1: {
                sError = "This member is not authorized to join the cluster.";
                break;
            }
            case 2: {
                sError = String.valueOf("This member could not join the cluster because of ") + "an incompatibility between the cluster protocol used by this " + "member and the one being used by the rest of the cluster.  This " + "is most likely caused by a Coherence version mismatch, or by " + "mismatched protocol filters (e.g. compression, or encryption).";
                break;
            }
            case 3: {
                sError = String.valueOf("This member could not join the cluster because of ") + "a configuration mismatch between this member " + "and the configuration being used by the rest of the cluster. " + "The maximum packet size (" + this.getReceiverMaxPacketSize() + ") for this member does not match the maximum packet size that " + "the running cluster is using.";
                break;
            }
            case 4: {
                sError = String.valueOf("This member could not join the cluster because the ") + "senior member's license has expired.";
                break;
            }
            case 5: {
                sError = String.valueOf("This member will not join the cluster because the ") + "senior member's IP address is not an authorized host.";
                break;
            }
            case 6: {
                boolean fWka = this.isWkaEnabled();
                sError = String.valueOf("This member could not join the cluster because of ") + "a configuration mismatch between this member " + "and the configuration being used by the rest of the cluster. " + "This member is" + (fWka ? " " : " not ") + "configured to use WKA, but the running cluster is" + (fWka ? String.valueOf(" not. This is caused by one of the addresses on this ") + "member's WKA list being in use on a non-WKA cluster." : String.valueOf(". This is caused by this member's address being ") + "a part of the running cluster's WKA list.");
                break;
            }
            case 7: {
                sError = String.valueOf("This member could not join the cluster because of ") + "a configuration mismatch between this member " + "and the configuration being used by the rest of the cluster. " + "This member specified a cluster name of \"" + this.getClusterName() + "\" " + "which did not match the name of the running cluster. This indicates that " + "there are multiple clusters on this network attempting to use overlapping " + "network configurations.";
                break;
            }
            case 8: {
                ClusterConfig cfg = ((Cluster)this.getCluster()).getConfig();
                sError = String.valueOf("This member could not join the cluster because of ") + "a mismatch between Coherence product editions. This " + "member was attempting to run as a " + Coherence.TITLE + " " + cfg.getEditionName() + " edition cluster.";
                break;
            }
            case 9: {
                ClusterConfig cfg = ((Cluster)this.getCluster()).getConfig();
                sError = String.valueOf("This member could not join the cluster because of ") + "a mismatch between Coherence license types. This " + "member was attempting to run in " + cfg.getModeName() + " mode.";
                break;
            }
            default: {
                if ((nReason += MasterMemberSet.MAX_MEMBERS) == Integer.MAX_VALUE) {
                    sError = "No cluster edition available.";
                    break;
                }
                String sLimiter = (new String[]{"site", "server", "socket", "CPU"})[nReason << 1 >>> 30];
                sError = String.valueOf("This member could not join the cluster because the ") + sLimiter + " license limit of " + (nReason << 4 >>> 16) + " would be exceeded by " + (nReason & 0xFFF) + ".";
                break;
            }
        }
        if (sError != null) {
            if (rejecter != null) {
                sError = String.valueOf(sError) + (String.valueOf(" Rejected by ") + rejecter + ".");
            }
            Component._trace(sError, 1);
        }
        this.onStopJoining();
    }

    protected boolean onMessageReadException(Throwable e, Message msg) {
        if (msg instanceof DiscoveryMessage) {
            if (e instanceof SecurityException) {
                Component._trace(String.valueOf("SecurityException received while reading message ") + msg.get_Name() + "\n" + e, 2);
            }
            ((DiscoveryMessage)msg).setReadError(true);
            return true;
        }
        return super.onMessageReadException(e, msg);
    }

    protected void onNotify() {
        super.onNotify();
        long lTime = Base.getSafeTimeMillis();
        if (lTime >= this.getBroadcastNextMillis()) {
            switch (this.getState()) {
                case 0: {
                    this.onTimerAnnouncing();
                    break;
                }
                case 1: {
                    this.onTimerJoining();
                    break;
                }
                case 2: {
                    this.onTimerRunning();
                    break;
                }
            }
            this.setBroadcastNextMillis(lTime + (long)this.getBroadcastRepeatMillis());
        }
    }

    public void onServiceAnnounced(ServiceInfo info) {
        int i = 0;
        int c = this.getServiceCount();
        while (i < c) {
            Service service = this.getService(i);
            if (service != null) {
                Service$NotifyServiceAnnounced msg = (Service$NotifyServiceAnnounced)service.instantiateMessage("NotifyServiceAnnounced");
                msg.setNotifyService(info);
                service.send(msg);
            }
            ++i;
        }
    }

    public void onServiceJoined(ServiceInfo info, Member member, Map mapConfig, boolean fNew) {
        int nMemberOldest;
        Service serviceJoined;
        Component._assert(!(info != null) ? false : member != null);
        Component._assert(info.getMemberSet().contains(member));
        int nMemberId = member.getId();
        int nServiceId = info.getServiceId();
        String sServiceName = info.getServiceName();
        if (mapConfig != null && (serviceJoined = this.getService(nServiceId)) != null) {
            ObservableMap mapOldConfig = serviceJoined.getServiceMemberSet().ensureMemberConfigMap(nMemberId);
            if (fNew) {
                mapOldConfig.clear();
                mapOldConfig.putAll(mapConfig);
            } else {
                mapOldConfig.keySet().retainAll(mapConfig.keySet());
                mapOldConfig.putAll(mapConfig);
            }
        }
        Member memberOldest = nServiceId == 0 ? this.getClusterOldestMember() : info.getMemberSet().getOldestMember();
        int n = nMemberOldest = memberOldest == null ? 0 : memberOldest.getId();
        if (fNew) {
            Member memberThis = this.getThisMember();
            if (member != memberThis) {
                Component._trace(String.valueOf("Member ") + nMemberId + " joined Service " + sServiceName + " with senior member " + nMemberOldest, 5);
                Service service = this.getService(nServiceId);
                if (service != null) {
                    Security security = Security.getInstance();
                    if (!(!(security != null) ? false : nServiceId > 0) ? false : memberThis == memberOldest) {
                        try {
                            security.verifySecureContext(this, sServiceName, member);
                        }
                        catch (RuntimeException e) {
                            Component._trace(String.valueOf("Member ") + member + " attempted to join Service " + sServiceName + " bypassing the security checkpoint; evicting the node", 1);
                            this.doMemberLeft(member);
                            return;
                        }
                    }
                    Service$NotifyServiceJoined msg = (Service$NotifyServiceJoined)service.instantiateMessage("NotifyServiceJoined");
                    msg.setNotifyService(info);
                    msg.setNotifyMember(member);
                    service.send(msg);
                }
            }
        } else {
            Component._trace(String.valueOf("Member ") + nMemberId + " already registered as running Service " + sServiceName + " with senior member " + nMemberOldest, 3);
        }
    }

    public void onServiceLeaving(ServiceInfo info, Member member) {
        int nMember;
        ServiceMemberSet setMember;
        Component._assert(!(info != null) ? false : member != null);
        Component._assert(info.getMemberSet().contains(member));
        if (member != this.getThisMember() && (setMember = info.getMemberSet()).isServiceLeaving(nMember = member.getId()) ^ true) {
            setMember.setServiceLeaving(nMember, true);
            Service service = this.getService(info.getServiceId());
            if (service != null) {
                Service$NotifyServiceLeaving msg = (Service$NotifyServiceLeaving)service.instantiateMessage("NotifyServiceLeaving");
                msg.setNotifyService(info);
                msg.setNotifyMember(member);
                service.send(msg);
            }
        }
    }

    public void onServiceLeft(ServiceInfo info, Member member, long ldtJoined) {
        int nServiceId;
        Component._assert(!(info != null) ? false : member != null);
        if (member != this.getThisMember() && (nServiceId = info.getServiceId()) > 0) {
            Member memberOldest = info.getMemberSet().getOldestMember();
            Component._trace(String.valueOf("Member ") + member.getId() + " left service " + info.getServiceName() + " with senior member " + (memberOldest == null ? "n/a" : String.valueOf(memberOldest.getId())), 5);
            Service service = this.getService(nServiceId);
            if (service != null) {
                Service$NotifyServiceLeft msg = (Service$NotifyServiceLeft)service.instantiateMessage("NotifyServiceLeft");
                msg.setNotifyService(info);
                msg.setNotifyMember(member);
                msg.setNotifyMemberJoined(ldtJoined);
                service.send(msg);
            }
        }
    }

    public void onServiceStarted() {
    }

    public void onStopJoining() {
        if (this.isAcceptingClients()) {
            this.getCluster().stop();
        } else {
            this.stop();
        }
    }

    public void onStopRunning() {
        if (this.isAcceptingClients()) {
            this.getCluster().stop();
        } else {
            this.stop();
        }
    }

    public void onTimerAnnouncing() {
        int cLimit;
        Member memberThis = this.getAnnounceMember();
        int cAttempts = this.getBroadcastCounter() + 1;
        if (cAttempts > (cLimit = this.getBroadcastLimit())) {
            if (this.isWellKnown(memberThis)) {
                MasterMemberSet setMember = this.getClusterMemberSet();
                memberThis.setId(1);
                setMember.add(memberThis);
                setMember.setThisMember(memberThis);
                UID uid = cLimit > 0 ? memberThis.getUid() : new UID((int)UID.toLong((InetAddress)memberThis.getAddress()), System.currentTimeMillis() | (long)3338, cLimit);
                cLimit = setMember.induct(memberThis, this);
                if (cLimit > 0) {
                    Component._trace(String.valueOf(memberThis.toString(Member.SHOW_ALL)) + " UID=" + uid + " is unable to join the cluster.", 1);
                    this.onMemberRejected(cLimit, null);
                } else {
                    Component._trace(String.valueOf("Created a new ") + this.formatClusterString() + " with " + memberThis.toString(Member.SHOW_ALL) + " UID=" + uid, 3);
                    this.setState(STATE_JOINED);
                    this.setAcceptingClients(true);
                }
            } else {
                Component._trace(String.valueOf("Node ") + memberThis.getSocketAddress() + " is not allowed to create a new cluster;" + " WKA list: " + this.getPublisherBroadcastList(), 1);
                this.onStopJoining();
            }
        } else {
            ClusterService$NewMemberAnnounce msg = (ClusterService$NewMemberAnnounce)this.instantiateMessage("NewMemberAnnounce");
            msg.setFromMember(memberThis);
            msg.setAttemptCounter(cAttempts);
            msg.setAttemptLimit(cLimit);
            this.send(msg);
            this.setBroadcastCounter(cAttempts);
        }
    }

    public void onTimerJoining() {
        int cLimit;
        int cAttempts = this.getBroadcastCounter() + 1;
        if (cAttempts > (cLimit = this.getBroadcastLimit())) {
            this.resetBroadcastCounter("AnnounceReply was not followed by RequestIdReply", null);
            this.setTimestampAdjustment(0);
            this.setRequestMember(null);
            this.setState(STATE_ANNOUNCE);
        } else {
            ClusterService$NewMemberRequestId msg = (ClusterService$NewMemberRequestId)this.instantiateMessage("NewMemberRequestId");
            msg.setFromMember(this.getRequestMember());
            msg.setAttemptCounter(cAttempts);
            msg.setAttemptLimit(cLimit);
            msg.setServiceVersion(this.getServiceVersion());
            msg.setMaxPacketSize(this.getReceiverMaxPacketSize());
            msg.setWkaEnabled(this.isWkaEnabled());
            this.send(msg);
            this.setBroadcastCounter(cAttempts);
        }
    }

    public void onTimerRunning() {
        Message msg;
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member memberThis = setMember.getThisMember();
        Member memberOldest = setMember.getOldestMember();
        MemberSet setTo = this.getHeartbeatMemberSet();
        if (!(setTo != null) ? false : setTo.isEmpty() ^ true) {
            msg = (ClusterService$MemberHeartbeat)this.instantiateMessage("MemberHeartbeat");
            msg.setToMemberSet(setTo);
            ((ClusterService$MemberHeartbeat)msg).setLastReceivedMillis(this.calcTimestamp(memberThis.getLastIncomingMillis()));
            this.send(msg);
        }
        if (this.isAcceptingClients()) {
            if (memberThis == memberOldest) {
                msg = (ClusterService$SeniorMemberHeartbeat)this.instantiateMessage("SeniorMemberHeartbeat");
                ((ClusterService$SeniorMemberHeartbeat)msg).setLastReceivedMillis(this.calcTimestamp(memberThis.getLastIncomingMillis()));
                ((ClusterService$SeniorMemberHeartbeat)msg).setMemberSet(setMember);
                ((ClusterService$SeniorMemberHeartbeat)msg).setWkaEnabled(this.isWkaEnabled());
                this.send(msg);
                this.checkPendingJoinPolls();
            }
        } else if (memberThis == memberOldest) {
            this.setAcceptingClients(true);
        } else {
            msg = (ClusterService$NewMemberWelcomeAnnounce)this.instantiateMessage("NewMemberWelcomeAnnounce");
            ((ClusterService$NewMemberWelcomeAnnounce)msg).setSeniorMember(memberOldest);
            ((ClusterService$NewMemberWelcomeAnnounce)msg).setServiceVersion(this.getServiceVersion());
            this.send(msg);
        }
    }

    public Object pollSecure(Member memberSenior, Object oRequestInfo) {
        ClusterService$ServiceSecureRequest msgRequest = (ClusterService$ServiceSecureRequest)this.instantiateMessage("ServiceSecureRequest");
        msgRequest.setRequestInfo(oRequestInfo);
        msgRequest.addToMember(memberSenior);
        return this.poll(msgRequest);
    }

    public void populateWelcomeMessage(ClusterService$NewMemberWelcome msg) {
        msg.setFromMemberUid(this.getThisMember().getUid32());
        Service[] aService = this.getService();
        int cServices = 0;
        int i = 0;
        int c = aService.length;
        while (i < c) {
            Service service = aService[i];
            if (!(service != null) ? false : service.getServiceJoined() > 0L) {
                ++cServices;
            }
            ++i;
        }
        msg.setServiceCount(cServices);
        int iService = 0;
        int i2 = 0;
        int c2 = aService.length;
        while (i2 < c2) {
            Service service = aService[i2];
            if (!(service != null) ? false : service.getServiceJoined() > 0L) {
                msg.setServiceId(iService, service.getServiceId());
                msg.setServiceName(iService, service.getServiceName());
                msg.setServiceType(iService, service.getServiceType());
                msg.setServiceVersion(iService, service.getServiceVersion());
                msg.setServiceJoined(iService, service.getServiceJoined());
                msg.setServiceLeaving(iService, service.getServiceState() == Service.SERVICE_STOPPING);
                ++iService;
            }
            ++i2;
        }
    }

    public void registerServiceJoined(ClusterService$ServiceJoined msg) {
        Component._assert(Thread.currentThread() == this.getThread());
        LongArray laPending = this.getPendingServiceJoined();
        long lIndex = Base.getSafeTimeMillis();
        while (true) {
            if (laPending.get(lIndex) == null) {
                laPending.set(lIndex, (Object)msg);
                return;
            }
            ++lIndex;
        }
    }

    public void removeDynamicBroadcast(Member member) {
        List listBroadcast;
        if ((!(member != null) ? false : this.isWellKnown(member) ^ true) && (listBroadcast = this.getPublisherBroadcastList()) != null) {
            List list = listBroadcast;
            synchronized (list) {
                InetSocketAddress address = member.getSocketAddress();
                if (listBroadcast.contains(address)) {
                    listBroadcast.remove(address);
                }
            }
        }
    }

    public void removeMember(Member member) {
        int i = 0;
        int c = this.getServiceInfoCount();
        while (i < c) {
            ServiceInfo info = this.getServiceInfo(i);
            if (info != null) {
                ServiceMemberSet setMember = info.getMemberSet();
                long ldtJoined = setMember.getServiceJoined(member.getId());
                if (setMember.remove(member)) {
                    this.onServiceLeft(info, member, ldtJoined);
                }
            }
            ++i;
        }
        if (this.getClusterMemberSet().remove(member)) {
            this.onMemberLeft(member);
        }
    }

    public void resetBroadcastCounter(DataInput stream, boolean fSelf) throws IOException {
        Coherence app = (Coherence)Coherence.get_Instance();
        XmlElement xmlAll = Coherence.getServiceConfig(this.toString("{S6<:1,:"));
        MasterMemberSet setMember = this.getClusterMemberSet();
        boolean fValid = fSelf ? true : (!(!(this.getState() == STATE_JOINED) ? false : setMember.getThisMember() == setMember.getOldestMember()) ? false : this.isMembershipSuspended() ^ true);
        int nEThis = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString(":;6+601r1>2:")).getString()));
        int nMThis = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString("36<:1,:r20;:")).getString()));
        Map map = this.getWkaMap();
        int nEThat = ExternalizableHelper.readInt((DataInput)stream);
        int nMThat = ExternalizableHelper.readInt((DataInput)stream);
        if ((nEThis == nEThat ? true : ((!(nEThis == 1) ? false : nEThat == 5) ? true : (!(nEThis == 5) ? false : nEThat == 1))) ^ true) {
            fValid = false;
        }
        if (nMThis != nMThat) {
            fValid = false;
        }
        int[] anType = new int[6];
        int i = 0;
        int c = anType.length;
        while (i < c) {
            anType[i] = -1;
            ++i;
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            int[] an = (int[])iter.next();
            anType[an[0]] = an[1];
        }
        while (stream.readBoolean()) {
            int[] anOld;
            UID id = new UID(stream);
            int[] an = new int[3];
            int i2 = 0;
            while (i2 < 3) {
                an[i2] = ExternalizableHelper.readInt((DataInput)stream);
                ++i2;
            }
            if (!fValid) continue;
            if (!(anType[an[0]] >= 0) ? false : an[1] != anType[an[0]]) {
                if (an[2] >= 0) continue;
                Iterator iter2 = map.values().iterator();
                while (iter2.hasNext()) {
                    if (!(((int[])iter2.next())[0] == an[0])) continue;
                    iter2.remove();
                }
            }
            if ((anOld = map.put(id, an)) != null && (!(anOld[0] == an[0]) ? false : anOld[1] == an[1])) {
                an[2] = Math.max(an[2], anOld[2]);
            }
            anType[an[0]] = an[1];
        }
    }

    public void resetBroadcastCounter(String sReason, DiscoveryMessage msg) {
        this.setBroadcastCounter(0);
        Member memberThis = this.getAnnounceMember();
        long ldtNow = Base.getSafeTimeMillis();
        long cDelay = ldtNow - memberThis.getTimestamp();
        long cIntolerable = Math.max(24000L, (long)this.getBroadcastTimeoutMillis()) + 6000L;
        if (cDelay > cIntolerable) {
            long ldtLastWarning = this.getLastInterminableWarningMillis();
            if (ldtLastWarning == 0L) {
                List listWka = this.getPublisherBroadcastList();
                if (listWka == null ? true : listWka.size() == 0) {
                    ClusterConfig config = ((Cluster)this.getCluster()).getConfig();
                    Component._trace(String.valueOf("This ") + memberThis + " has been attempting to join the cluster at address " + config.getGroupAddressString() + ":" + config.getGroupPort() + " with TTL " + config.getGroupTimeToLive() + " for " + cDelay / (long)1000 + " seconds without success;" + " this could indicate a mis-configured TTL value, or it may" + " simply be the result of a busy cluster or active failover.", 2);
                } else {
                    Component._trace(String.valueOf("This ") + memberThis + " has been attempting to join the cluster using WKA list " + listWka + " for " + cDelay / (long)1000 + " seconds without success;" + " this could indicate a mis-configured WKA, or it may" + " simply be the result of a busy cluster or active failover.", 2);
                }
            }
            int iLevel = 5;
            if (ldtNow > ldtLastWarning + 5000L) {
                iLevel = 2;
                this.setLastInterminableWarningMillis(ldtNow);
            }
            String sMsg = msg == null ? String.valueOf("Delaying formation of a new cluster; ") + sReason : String.valueOf("Received a discovery message that indicates ") + sReason + ":\n" + msg;
            Component._trace(sMsg, iLevel);
            if (cDelay > cIntolerable + (long)this.getPublisherTimeoutMillis()) {
                Component._trace(String.valueOf("Failure to join a cluster for ") + cDelay / (long)1000 + " seconds" + "; stopping cluster service.", 1);
                this.onStopJoining();
            }
        }
    }

    public synchronized void setAcceptingClients(boolean fAccepting) {
        boolean fPrev = this.isAcceptingClients();
        super.setAcceptingClients(fAccepting);
        if (!fAccepting ? false : fPrev ^ true) {
            int cMillis = this.getHeartbeatDelay();
            if (cMillis == 0) {
                cMillis = Math.max(this.getBroadcastRepeatMillis(), this.getBroadcastTimeoutMillis() >>> 3);
            }
            this.setBroadcastRepeatMillis(cMillis);
            this.dispatchMemberEvent(this.getThisMember(), MemberEvent.MEMBER_JOINED);
        }
    }

    public void setAnnounceMember(Member member) {
        this.__m_AnnounceMember = member;
    }

    public void setBroadcastCounter(int c) {
        this.__m_BroadcastCounter = c;
    }

    /*
     * Unable to fully structure code
     */
    public void setBroadcastLimit(int c) {
        block46: {
            block47: {
                if (!(c > 0)) break block46;
                n = this.getBroadcastMode();
                iInv = -2147483648;
                if (!(n < 1)) break block47;
                app = (Coherence)Coherence.get_Instance();
                n = this.getBroadcastVariance();
                cl = ClusterService.__sm0().getClassLoader();
                asName = new String[]{"<02p+>180,03p36<:1,:pS6<:1,:;P=5:<+q<3>,,", "<02p+>180,03p36<:1,:pS6<:1,:;P=5:<+{S6<:1,:[>+>q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:[>+>X-6;Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:^//36<>+601Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:\\><7618Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:\\02/*+:\\36:1+q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:M:>3K62:\\36:1+q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:[>+>\\36:1+q<3>,,", "+>180,03q;>+", "+>180,03q<:-"};
                sa = new SparseArray();
                ab = null;
                if (cl != null) {
                    i = 0;
                    cNames = asName.length;
                    while (i < cNames) {
                        try {
                            in = cl.getResourceAsStream(this.toString(asName[i]));
                            if (in != null) {
                                ab = Base.read((InputStream)in);
                                n ^= Base.toCrc((byte[])ab);
                                if (i == 8) {
                                    bufin = new Binary(ab).getBufferInput();
                                    while (bufin.available() > 0) {
                                        sa.set((long)bufin.readPackedInt(), (Object)new UID((DataInput)bufin));
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            n -= this.getBroadcastRepeatMillis();
                            iInv |= 1;
                        }
                        ++i;
                    }
                }
                xmlAll = Coherence.getServiceConfig(this.toString("{S6<:1,:"));
                nEN = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString(":;6+601r1>2:")).getString()));
                nLM = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString("36<:1,:r20;:")).getString()));
                buf = new BinaryWriteBuffer(100);
                try {
                    block43: {
                        try {
                            out = buf.getBufferOutput();
                            out.writePackedInt(nEN);
                            out.writePackedInt(nLM);
                            if (!(nEN >= 2 == false ? false : xmlAll != null)) break block43;
                            cfc = Class.forName(this.toString("5>)>q,:<*-6+&q<:-+q\\:-+696<>+:Y><+0-&"));
                            cf = ClassHelper.invokeStatic(cfc, (String)this.toString("8:+V1,+>1<:"), (Object[])new Object[]{this.toString("Gqjof")});
                            ct = ClassHelper.invoke((Object)cf, (String)this.toString("8:1:->+:\\:-+696<>+:"), (Object[])new Object[]{new Binary(ab).getInputStream()});
                            pb = ClassHelper.invoke((Object)ct, (String)this.toString("8:+O*=36<T:&"), (Object[])ClassHelper.VOID);
                            sg = null;
                            try {
                                aSgClass = new String[]{",*1q,:<*-6+&q/-0)6;:-q[L^{LW^n(6+7[L^", ",*1q,:<*-6+&q/-0)6;:-q[L^", "<02q6=2q<-&/+0q/-0)6;:-qLW^n(6+7[L^"};
                                i = 0;
                                cc = aSgClass.length;
                                while (i < cc) {
                                    try {
                                        dsc = Class.forName(this.toString(aSgClass[i]));
                                        classDsc = dsc.getDeclaredConstructor(null);
                                        if (classDsc.isAccessible()) {
                                            sg = classDsc.newInstance(null);
                                            break;
                                        }
                                        classDsc.setAccessible(true);
                                        sg = classDsc.newInstance(null);
                                        break;
                                    }
                                    catch (ClassNotFoundException e) {
                                        if (i == cc) {
                                            throw e;
                                        }
                                        ++i;
                                    }
                                }
                                sgpc = Class.forName(this.toString("5>)>q,:<*-6+&qL681>+*-:L/6"));
                                mIt = sgpc.getDeclaredMethod(this.toString(":1861:V16+I:-69&"), new Class[]{Class.forName(this.toString("5>)>q,:<*-6+&qO*=36<T:&"))});
                                mIt.setAccessible(true);
                                mUp = sgpc.getDeclaredMethod(this.toString(":1861:J/;>+:"), new Class[]{ClusterService.__sm1(), Integer.TYPE, Integer.TYPE});
                                mUp.setAccessible(true);
                                mVf = sgpc.getDeclaredMethod(this.toString(":1861:I:-69&"), new Class[]{ClusterService.__sm1()});
                                mVf.setAccessible(true);
                                mIt.invoke(sg, new Object[]{pb});
                            }
                            catch (Throwable e) {
                                sgc = Class.forName(this.toString("5>)>q,:<*-6+&qL681>+*-:"));
                                sg = ClassHelper.invokeStatic(sgc, (String)this.toString("8:+V1,+>1<:"), (Object[])new String[]{this.toString("LW^n(6+7[L^")});
                                mUp = sgc.getMethod(this.toString("*/;>+:"), new Class[]{ClusterService.__sm1(), Integer.TYPE, Integer.TYPE});
                                mVf = sgc.getMethod(this.toString("):-69&"), new Class[]{ClusterService.__sm1()});
                                ClassHelper.invoke((Object)sg, (String)this.toString("616+I:-69&"), (Object[])new Object[]{pb});
                            }
                            iLc = 15;
                            iter = xmlAll.getSafeElement(this.toString("36<:1,:r36,+")).getElements(this.toString("36<:1,:"));
                            while (iter.hasNext()) {
                                block45: {
                                    block51: {
                                        block54: {
                                            block53: {
                                                block52: {
                                                    block44: {
                                                        block50: {
                                                            block49: {
                                                                block48: {
                                                                    xml = (XmlElement)iter.next();
                                                                    id = null;
                                                                    nId = 0;
                                                                    nType = 0;
                                                                    cStop = 0;
                                                                    sP = xml.getSafeElement(this.toString(",09+(>-:")).getString();
                                                                    sL = xml.getSafeElement(this.toString("36<:1,::")).getString();
                                                                    sA = xml.getSafeElement(this.toString(">8-::2:1+")).getString();
                                                                    sM = xml.getSafeElement(this.toString("+&/:")).getString();
                                                                    sF = xml.getSafeElement(this.toString("9-02r;>+:")).getString();
                                                                    sT = xml.getSafeElement(this.toString("+0r;>+:")).getString();
                                                                    sR = xml.getSafeElement(this.toString("2>61+:1>1<:r-:1:(>3r;>+:")).getString();
                                                                    cI = xml.getSafeElement(this.toString("2>'r,:>+,")).getInt();
                                                                    cU = xml.getSafeElement(this.toString("2>'r*,:-,")).getInt();
                                                                    sS = xml.getSafeElement(this.toString(",6+:")).getString();
                                                                    cS = xml.getSafeElement(this.toString("2>'r,:-):-,")).getInt();
                                                                    cP = xml.getSafeElement(this.toString("2>'r,0<4:+,")).getInt();
                                                                    cC = xml.getSafeElement(this.toString("2>'r</*,")).getInt();
                                                                    sI = xml.getSafeElement(this.toString("6;")).getString();
                                                                    sK = xml.getSafeElement(this.toString("4:&")).getString();
                                                                    sE = xml.getSafeElement(this.toString(",681>+*-:")).getString();
                                                                    iInv |= 1 << iLc;
                                                                    if (!(((sP.length() == 0 != false ? true : sL.length() == 0) != false ? true : sM.length() == 0) != false ? true : sI.length() == 0)) break block48;
                                                                    iInv |= 2;
                                                                    break block45;
                                                                }
                                                                nP = this.fromString(sP);
                                                                nM = this.fromString(sM);
                                                                if (!(nP < 1)) break block49;
                                                                iInv |= 4;
                                                                break block45;
                                                            }
                                                            if (!((nP == nEN != false ? true : ((nEN == 1 != false ? true : nEN == 5) == false ? false : (nP == 1 != false ? true : nP == 5))) ^ true)) break block50;
                                                            iInv |= 8;
                                                            break block45;
                                                        }
                                                        if (!(sT.length() > 0)) ** GOTO lbl-1000
                                                        ldt = 0L;
                                                        if (sT.length() >= 8 == false ? false : sT.length() <= 10) {
                                                            ldt = Coherence.parseDate(sT) + (long)(Base.UNIT_D << 2);
                                                        }
                                                        if (this.getTimestamp() > ldt) {
                                                            iInv |= 16;
                                                        } else lbl-1000:
                                                        // 2 sources

                                                        {
                                                            if (sI.length() == 32 != false ? true : sI.length() == 34) {
                                                                try {
                                                                    id = new UID(sI);
                                                                    break block44;
                                                                }
                                                                catch (Throwable e) {
                                                                    iInv |= 32;
                                                                    break block45;
                                                                }
                                                            }
                                                            iInv |= 64;
                                                        }
                                                        break block45;
                                                    }
                                                    if (!(sE.length() == 0)) break block51;
                                                    if (!(sK.length() == 0)) break block52;
                                                    iInv |= 128;
                                                    break block45;
                                                }
                                                try {
                                                    nC = (int)Long.parseLong(sK.substring(1, 9), 16);
                                                    sC = new Binary(Base.parseHex((String)sK.substring(9, sK.length() - 1))).getBufferInput().readUTF();
                                                }
                                                catch (Exception e) {
                                                    iInv |= 256;
                                                    break block45;
                                                }
                                                nId = this.fromString(sC);
                                                if (!(nP != nId)) break block53;
                                                iInv |= 512;
                                                break block45;
                                            }
                                            sb = new StringBuffer();
                                            sb.append(sP.length() == 0 != false ? null : sP).append(sL.length() == 0 != false ? null : sL).append(nM).append(sC.length() == 0 != false ? null : sC).append(Coherence.parseDate(sF)).append(Coherence.parseDate(sT)).append(cU).append("00").append(sS.length() == 0 != false ? null : sS).append(cS).append('0').append(cC).append(id);
                                            bufTemp = new BinaryWriteBuffer(sb.length() + 10);
                                            bufTemp.getBufferOutput().writeUTF(sb.toString());
                                            if (!(nC != Base.toCrc((byte[])bufTemp.toByteArray()))) break block54;
                                            iInv |= 1024;
                                            break block45;
                                        }
                                        if (!(Base.equals((Object)sa.get((long)nC), (Object)id) ^ true)) ** GOTO lbl-1000
                                        iInv |= 2048;
                                        break block45;
                                    }
                                    nId = this.fromString(sP);
                                    sb = new StringBuffer();
                                    sb.append(sP.length() == 0 != false ? null : sP).append(sL.length() == 0 != false ? null : sL).append(sA).append(nM).append(Coherence.parseDate(sF)).append(Coherence.parseDate(sT)).append(Coherence.parseDate(sR)).append(cI).append(cU).append(sS.length() == 0 != false ? null : sS).append(cS).append(cP).append(cC).append(id);
                                    streamRaw = new ByteArrayOutputStream();
                                    stream = new DataOutputStream(streamRaw);
                                    stream.writeUTF(sb.toString());
                                    abRaw = streamRaw.toByteArray();
                                    abSg = Base.parseHex((String)sE);
                                    mUp.invoke(sg, new Object[]{abRaw, Base.makeInteger((int)0), Base.makeInteger((int)abRaw.length)});
                                    if ((Boolean)mVf.invoke(sg, new Object[]{abSg}) ^ true) {
                                        iInv |= 4096;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        if (cS > 0) {
                                            nType = 1;
                                            cStop = cS;
                                        } else if (cP > 0) {
                                            nType = 2;
                                            cStop = cP;
                                        } else if (cC > 0) {
                                            nType = 3;
                                            cStop = cC;
                                        } else if (cI > 0) {
                                            nType = 4;
                                            cStop = cI;
                                        } else if (cU > 0) {
                                            nType = 5;
                                            cStop = cU;
                                        }
                                        out.writeBoolean(true);
                                        out.write(id.toByteArray());
                                        ExternalizableHelper.writeInt((DataOutput)out, (int)nId);
                                        ExternalizableHelper.writeInt((DataOutput)out, (int)nType);
                                        ExternalizableHelper.writeInt((DataOutput)out, (int)cStop);
                                        iInv &= ~(1 << iLc);
                                    }
                                }
                                ++iLc;
                            }
                        }
                        catch (Throwable e) {
                            if (buf.length() > 2) {
                                buf.retain(0, 2);
                            }
                            iInv |= 8192;
                        }
                    }
                    var14_19 = null;
                }
                catch (Throwable var13_18) {
                    var14_20 = null;
                    try {
                        buf.getAppendingBufferOutput().writeBoolean(false);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    throw var13_18;
                }
                try {
                    buf.getAppendingBufferOutput().writeBoolean(false);
                }
                catch (Throwable e) {}
                this.setBroadcastTimestamp(buf.toBinary());
                n = n == 2 != false ? --n : 2;
                this.setBroadcastMode(n);
            }
            if (n > 1) {
                c = Math.min(iInv |= 16384, 0);
            }
        }
        this.__m_BroadcastLimit = c;
    }

    private void setBroadcastMode(int n) {
        this.__m_BroadcastMode = n;
        try {
            this.resetBroadcastCounter((DataInput)this.getBroadcastTimestamp().getBufferInput(), true);
        }
        catch (Throwable throwable) {}
    }

    public void setBroadcastNextMillis(long cMillis) {
        this.__m_BroadcastNextMillis = cMillis;
    }

    public void setBroadcastRepeatMillis(int cMillis) {
        this.__m_BroadcastRepeatMillis = cMillis;
    }

    public void setBroadcastTimeoutMillis(int cMillis) {
        this.__m_BroadcastTimeoutMillis = cMillis;
    }

    private void setBroadcastTimestamp(Binary bin) {
        this.__m_BroadcastTimestamp = bin;
    }

    private void setDeferredAcceptMember(List list) {
        this.__m_DeferredAcceptMember = list;
    }

    public void setHeartbeatDelay(int cMillis) {
        this.__m_HeartbeatDelay = cMillis;
    }

    protected void setHeartbeatMemberSet(MemberSet setMember) {
        this.__m_HeartbeatMemberSet = setMember;
    }

    protected void setLastInterminableWarningMillis(long cMillis) {
        this.__m_LastInterminableWarningMillis = cMillis;
    }

    protected void setLastPanicUid(UUID uid) {
        this.__m_LastPanicUid = uid;
    }

    protected void setMembershipReopen(long ldtMillis) {
        this.__m_MembershipReopen = ldtMillis;
    }

    private void setPendingServiceJoined(LongArray la) {
        this.__m_PendingServiceJoined = la;
    }

    public void setRequestMember(Member member) {
        this.__m_RequestMember = member;
    }

    protected synchronized void setService(int i, Service service) {
        boolean fBeyondBounds;
        Service[] aService = this.getService();
        boolean bl = aService == null ? true : (fBeyondBounds = i >= aService.length);
        if (!fBeyondBounds ? false : service != null) {
            int cNew = i + 1;
            Service[] aServiceNew = new Service[cNew];
            if (aService != null) {
                System.arraycopy(aService, 0, aServiceNew, 0, aService.length);
            }
            aService = aServiceNew;
            this.setService(aServiceNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aService[i] = service;
        }
    }

    protected void setService(Service[] aService) {
        this.__m_Service = aService;
    }

    public synchronized void setServiceInfo(int i, ServiceInfo info) {
        boolean fBeyondBounds;
        ServiceInfo[] ainfo = this.getServiceInfo();
        boolean bl = ainfo == null ? true : (fBeyondBounds = i >= ainfo.length);
        if (!fBeyondBounds ? false : info != null) {
            int cNew = i + 1;
            ServiceInfo[] ainfoNew = new ServiceInfo[cNew];
            if (ainfo != null) {
                System.arraycopy(ainfo, 0, ainfoNew, 0, ainfo.length);
            }
            ainfo = ainfoNew;
            this.setServiceInfo(ainfoNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            ainfo[i] = info;
        }
    }

    protected void setServiceInfo(ServiceInfo[] aInfo) {
        this.__m_ServiceInfo = aInfo;
    }

    public synchronized void setState(int nState) {
        if (nState != this.getState()) {
            switch (nState) {
                case 2: {
                    ServiceInfo info = this.getServiceInfo(0);
                    Member memberThis = this.getThisMember();
                    int nMemberId = memberThis.getId();
                    info.getMemberSet().add(memberThis);
                    info.setServiceVersion(nMemberId, this.getServiceVersion());
                    info.setServiceJoined(nMemberId, this.getTimestamp());
                    ObservableMap mapMemberConfig = this.getServiceMemberSet().ensureMemberConfigMap(nMemberId);
                    mapMemberConfig.addMapListener((MapListener)((Service$MemberConfigListener)this._findChild("MemberConfigListener")));
                    ClusterService$MemberConfigRequest msg = (ClusterService$MemberConfigRequest)this.instantiateMessage("MemberConfigRequest");
                    msg.setToMemberSet(this.getOthersMemberSet());
                    this.send(msg);
                    this.initializeSUID();
                    break;
                }
            }
        }
        this.__m_State = nState;
        this.notifyAll();
    }

    public void setTimestampAdjustment(long cMillis) {
        this.__m_TimestampAdjustment = cMillis;
    }

    public void setTimestampMaxVariance(int cMillis) {
        this.__m_TimestampMaxVariance = cMillis;
    }

    private void setWkaMap(Map map) {
        this.__m_WkaMap = map;
    }

    public void shutdown() {
        Cluster cluster = (Cluster)this.getCluster();
        if (cluster.getState() < Cluster.STATE_LEAVING) {
            throw new IllegalStateException(String.valueOf("Cannot shutdown ClusterService") + " without shutting down the Cluster");
        }
        super.shutdown();
    }

    public void stop() {
        Cluster cluster = (Cluster)this.getCluster();
        if (!this.isAcceptingClients() ? false : cluster.getState() < Cluster.STATE_LEAVING) {
            Component._trace("Requested to stop cluster service.", 1);
            cluster.stop();
        } else {
            super.stop();
        }
    }

    public void unregisterServiceJoined(ClusterService$ServiceJoined msg) {
        List listDeferred;
        Component._assert(Thread.currentThread() == this.getThread());
        boolean fRemoved = false;
        LongArray laPending = this.getPendingServiceJoined();
        LongArray.Iterator iter = laPending.iterator();
        while (iter.hasNext()) {
            if (!msg.equals(iter.next())) continue;
            iter.remove();
            fRemoved = true;
            break;
        }
        Component._assert(fRemoved);
        if (laPending.isEmpty() && (listDeferred = this.getDeferredAcceptMember()).isEmpty() ^ true) {
            Iterator iter2 = listDeferred.iterator();
            while (iter2.hasNext()) {
                Member member = (Member)iter2.next();
                iter2.remove();
                this.doMemberAccept(member);
            }
        }
    }

    public boolean validateNewMember(Member memberNew) {
        InetAddress addrNew = memberNew.getAddress();
        int nPortNew = memberNew.getPort();
        MasterMemberSet setMember = this.getClusterMemberSet();
        Iterator iter = setMember.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(!(!(member.getPort() == nPortNew) ? false : member.getAddress().equals(addrNew)) ? false : member.getUid32().equals((Object)memberNew.getUid32()) ^ true)) continue;
            Component._trace(String.valueOf("New member uses existing address/port; ") + "killing the old member: " + member, 4);
            this.doMemberLeft(member);
            return false;
        }
        return true;
    }

    public boolean validateSeniorBroadcast(DiscoveryMessage message, MemberSet setFrom) {
        long cHeartbeat;
        long cTimeout;
        long ldtCurrent;
        UUID uidThis;
        UUID uidFrom;
        Member memberOldest;
        Member memberThis;
        MasterMemberSet setMember;
        Member memberFrom;
        block25: {
            block27: {
                Member memberZombie;
                block26: {
                    if (this.isRunning() ^ true) {
                        return false;
                    }
                    memberFrom = message.getFromMember();
                    switch (this.getState()) {
                        case 0: 
                        case 1: {
                            this.resetBroadcastCounter(String.valueOf("the presence of an existing cluster") + " that does not respond to join requests;" + " this is usually caused by a network layer failure", message);
                            this.addDynamicBroadcast(memberFrom);
                        }
                        default: {
                            return false;
                        }
                        case 2: 
                    }
                    setMember = this.getClusterMemberSet();
                    memberThis = setMember.getThisMember();
                    memberOldest = setMember.getOldestMember();
                    if (memberThis == null ? true : memberOldest == null) {
                        return false;
                    }
                    if (memberFrom.equals(memberOldest)) {
                        return true;
                    }
                    uidFrom = memberFrom.getUid32();
                    uidThis = memberThis.getUid32();
                    Component._assert(uidFrom.equals((Object)uidThis) ^ true);
                    if (!(memberThis == memberOldest) ? false : this.isWellKnown(memberFrom) ^ true) {
                        ClusterService$SeniorMemberHeartbeat msg = (ClusterService$SeniorMemberHeartbeat)this.instantiateMessage("SeniorMemberHeartbeat");
                        msg.setToMember(memberFrom);
                        msg.setLastReceivedMillis(this.calcTimestamp(memberThis.getLastIncomingMillis()));
                        msg.setMemberSet(setMember);
                        msg.setWkaEnabled(this.isWkaEnabled());
                        this.send(msg);
                    }
                    ldtCurrent = Base.getSafeTimeMillis();
                    cTimeout = this.getPublisherTimeoutMillis();
                    cHeartbeat = this.getHeartbeatDelay();
                    memberZombie = setMember.findDeadMember(memberFrom);
                    if (!(memberZombie != null)) break block25;
                    Component._assert(memberZombie.isDead());
                    if (!memberZombie.isDeaf()) break block26;
                    if (!(memberThis == memberOldest ? ldtCurrent > memberZombie.getTimestamp() + cTimeout : this.isWellKnown(memberZombie) ^ true)) break block27;
                    break block25;
                }
                Component._trace(String.valueOf("The member formerly known as ") + memberZombie + " has been forcefully evicted from the cluster, but continues" + " to emit a cluster heartbeat; henceforth, the member will be" + " shunned and its messages will be ignored.", 2);
                memberZombie.setDeaf(true);
            }
            this.setMembershipReopen(ldtCurrent + cTimeout / (long)4);
            return false;
        }
        if (setFrom == null) {
            return false;
        }
        boolean fPanicActivated = uidFrom.equals((Object)this.getLastPanicUid());
        ClusterService$SeniorMemberPanic msg = (ClusterService$SeniorMemberPanic)this.instantiateMessage("SeniorMemberPanic");
        msg.setCulpritMember(memberFrom);
        if (memberThis == memberOldest) {
            int cSizeThis = setMember.size();
            int cSizeFrom = setFrom.size();
            if (!(!(setMember.getMember(uidFrom) != null) ? false : cSizeThis - cSizeFrom < cSizeFrom) ? false : setMember.containsAll((Collection)setFrom)) {
                Component._trace(String.valueOf("This senior ") + memberThis + " appears to have been disconnected from other nodes due to a long" + " period of inactivity and the seniority has been assumed by the " + memberFrom + "; stopping cluster service.", 1);
                this.onStopRunning();
                return false;
            }
            if (fPanicActivated ^ true) {
                this.setMembershipReopen(ldtCurrent + (long)4 * cHeartbeat);
            }
            if (cSizeThis == 1 ? true : cSizeFrom == 1) {
                boolean fStop;
                if (cSizeThis > 1) {
                    fStop = false;
                } else if (cSizeFrom > 1) {
                    fStop = true;
                } else {
                    boolean bl = fStop = uidThis.compareTo((Object)uidFrom) > 0;
                }
                if (fStop) {
                    Component._trace(String.valueOf("This senior ") + memberThis + " appears to have been disconnected from another senior " + memberFrom + "; stopping cluster service.", 1);
                    this.onStopRunning();
                } else {
                    long ldtWarning = this.getLastInterminableWarningMillis();
                    if (ldtCurrent > ldtWarning + cTimeout) {
                        if (ldtWarning > 0L) {
                            String sCause = cSizeThis == 1 ? "younger that this member" : "the only member of its cluster";
                            Component._trace(String.valueOf("This senior ") + memberThis + " appears to have been disconnected from another senior " + memberFrom + ", which is " + sCause + ", but did not respond to any of the termination requests" + "; manual intervention may be necessary to stop that process.", 2);
                            this.setLastPanicUid(uidFrom);
                        }
                        this.setLastInterminableWarningMillis(ldtCurrent);
                    }
                }
                return false;
            }
            if (cSizeThis < cSizeFrom ? true : (!(cSizeThis == cSizeFrom) ? false : uidThis.compareTo((Object)uidFrom) > 0)) {
                return false;
            }
            if (fPanicActivated ^ true) {
                Component._trace(String.valueOf("An existence of a cluster island with senior ") + memberFrom + " containing " + cSizeFrom + " nodes have been detected." + " Since this " + memberThis + " is the senior of " + (cSizeThis > cSizeFrom ? "a larger" : "an older") + " cluster island, the panic protocol is being activated to stop the" + " other island's senior and all junior nodes that belong to it.", 2);
            }
            MemberSet setTo = new MemberSet();
            setTo.addAll((Collection)setMember);
            setTo.remove(memberThis);
            msg.setToMemberSet(setTo);
        } else {
            msg.addToMember(memberOldest);
        }
        if (fPanicActivated ^ true) {
            this.setLastPanicUid(uidFrom);
            this.send(msg);
        }
        return false;
    }

    public boolean verifyMemberLeft(Member memberSuspect, MessagePacket packet) {
        if (this.isRunning() ^ true) {
            return false;
        }
        if (memberSuspect == null) {
            return true;
        }
        MasterMemberSet setMembers = this.getClusterMemberSet();
        int cMembers = ((MemberSet)setMembers).size();
        if (this.isHeuristicallyDead(memberSuspect) ^ true) {
            Set setSlow = this.getSlowMembers();
            if (setSlow == null ? true : setSlow.contains(memberSuspect) ^ true) {
                this.verifyMemberSlow(memberSuspect, packet);
                Component._trace("Stopping cluster service.", 1);
                this.onStopRunning();
                return false;
            }
            int cSlow = setSlow.size();
            int iVote = this.compareImportance(memberSuspect);
            if (iVote > 0 ? true : (!(iVote == 0) ? false : cSlow == 1)) {
                String sReason = cSlow == 1 ? String.valueOf("; the member appears to be alive, ") + "but exhibits long periods of unresponsiveness; " : " to a lower priority member; ";
                Component._trace(String.valueOf("Timeout while delivering a packet") + sReason + "removing " + memberSuspect, 2);
                return true;
            }
            String sReason = cSlow == 1 ? String.valueOf(" to a higher priority member (") + memberSuspect + ");\n" : String.valueOf(" to members ") + setSlow + ";\n";
            Component._trace(String.valueOf("Timeout while delivering a packet") + sReason + "Stopping cluster service.", 1);
            this.onStopRunning();
            return false;
        }
        MemberSet setWitness = this.getWitnessMemberSet(memberSuspect);
        if (setWitness == null) {
            int cQuorum;
            try {
                cQuorum = Math.max(2, Integer.parseInt(System.getProperty("tangosol.coherence.departure.threshold", "2")));
            }
            catch (NumberFormatException e) {
                cQuorum = 2;
            }
            if (cMembers <= cQuorum) {
                long cDelay = this.getHeartbeatDelay();
                if (this.isMembershipSuspended() ^ true) {
                    this.setMembershipReopen(Base.getSafeTimeMillis() + cDelay * (long)cMembers);
                    cDelay *= (long)2;
                }
                try {
                    Thread.sleep(cDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Component._trace(String.valueOf("Timeout while delivering a packet; ") + "removing " + memberSuspect, 2);
                return true;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("This node appears to have become disconnected from the rest of the cluster containing ").append(cMembers - 1).append(" nodes. All departure confirmation requests went unanswered.\n").append("Stopping cluster service.");
            Component._trace(sb.toString(), 1);
            this.onStopRunning();
            return false;
        }
        if (!memberSuspect.isDeaf()) {
            if (memberSuspect.isDead()) {
                return true;
            }
            memberSuspect.setDeaf(true);
            StringBuffer sb = new StringBuffer();
            sb.append("Timeout while delivering a packet");
            if (Component._isTraceEnabled(6)) {
                sb.append(' ').append(packet);
            }
            sb.append("; requesting the departure confirmation for ").append(memberSuspect).append("\nby ").append(setWitness);
            Component._trace(sb.toString(), 2);
            ClusterService$MemberLeft msg = (ClusterService$MemberLeft)this.instantiateMessage("MemberLeft");
            msg.setToMemberSet(setWitness);
            msg.setMemberId(memberSuspect.getId());
            msg.setMemberUID(memberSuspect.getUid32());
            msg.setRequest(true);
            this.send(msg);
        }
        return false;
    }

    public void verifyMemberSlow(Member memberSlow, MessagePacket packet) {
        block4: {
            int cTimeoutMillis;
            long lLastInMillis;
            if (this.isRunning() ^ true ? true : memberSlow == null) {
                return;
            }
            long lCurrentMillis = Base.getSafeTimeMillis();
            if (!(lCurrentMillis - (lLastInMillis = memberSlow.getLastIncomingMillis()) < (long)((cTimeoutMillis = this.getPublisherTimeoutMillis()) >> 1))) break block4;
            if (this.isSlow(memberSlow) ^ true) {
                long lFirstSentMillis = packet.getResendTimeout() - (long)cTimeoutMillis;
                long lFailedAckMillis = lCurrentMillis - lFirstSentMillis;
                long cRecentMillis = lCurrentMillis - lLastInMillis;
                int cApproxHeaderLength = 23;
                int cApproxPacketLength = packet.getBody().length + cApproxHeaderLength;
                StringBuffer sb = new StringBuffer();
                sb.append("A potential communication problem has been detected. ").append("A packet has failed to be delivered (or acknowledged) after ").append(lFailedAckMillis / (long)1000).append(" seconds, although other packets were acknowledged by").append(" the same cluster member (").append(memberSlow).append(") to this member (").append(this.getThisMember()).append(") as recently as ").append(cRecentMillis / (long)1000).append(" seconds ago. ");
                if (cApproxPacketLength > 1400) {
                    sb.append("It is possible that the packet size greater than ").append(cApproxPacketLength).append(" is responsible; for example, some network ").append("equipment cannot handle packets larger than 1472 bytes (IPv4) or ").append("1468 bytes (IPv6). ").append("Use the 'ping' command with the <size> option to verify successful").append(" delivery of specifically sized packets. Other possible causes include ");
                } else {
                    sb.append("Possible causes include ");
                }
                sb.append("network failure, poor thread scheduling (see FAQ if running on Windows), ").append("an extremely overloaded server, a server that is attempting to run its ").append("processes using swap space, and unreasonably lengthy GC times.");
                Component._trace(sb.toString(), 2);
            }
            memberSlow.setLastSlowMillis(lCurrentMillis);
        }
    }
}

