/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheKeyRequest;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheKeyRequest$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class DistributedCache$LockRequest
extends DistributedCacheKeyRequest {
    private transient long __m_LeaseExpiration;
    private int __m_LeaseHolderId;
    private long __m_LeaseMillis;
    private long __m_LeaseThreadId;
    private long __m_LeaseWaitMillis;
    private transient long __m_LeaseWaitTimeout;

    public DistributedCache$LockRequest() {
        this(null, null, true);
    }

    public DistributedCache$LockRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(12);
        }
        catch (Exception e) {
            throw new WrapperException((Throwable)e);
        }
        this._addChild(new DistributedCacheKeyRequest$Poll("Poll", this, true), "Poll");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public Message cloneMessage() {
        DistributedCache$LockRequest msg = (DistributedCache$LockRequest)super.cloneMessage();
        msg.fromLease(this.toLease());
        return msg;
    }

    public void fromLease(Lease lease) {
        this.setKey((Binary)lease.getResourceKey());
        this.setLeaseHolderId(lease.getHolderId());
        this.setLeaseThreadId(lease.getHolderThreadId());
        long ldtExpiry = lease.getExpirationTime();
        if (ldtExpiry > 0L) {
            this.setLeaseMillis(Math.max(0L, ldtExpiry - ((DistributedCache)this.get_Module()).getClusterTime()));
        }
    }

    public String getDescription() {
        return String.valueOf(super.getDescription()) + "\nWaitTimeout=" + this.getLeaseWaitTimeout() + ", LeaseExpiration=" + this.getLeaseExpiration();
    }

    public long getLeaseExpiration() {
        long ldtExpiry = this.__m_LeaseExpiration;
        if (ldtExpiry == 0L) {
            DistributedCache service = (DistributedCache)this.getService();
            ldtExpiry = service.adjustWaitTime(this.getLeaseMillis() - 1L, Service.TIME_CLUSTER);
            this.setLeaseExpiration(ldtExpiry);
        }
        return ldtExpiry;
    }

    public int getLeaseHolderId() {
        return this.__m_LeaseHolderId;
    }

    public long getLeaseMillis() {
        return this.__m_LeaseMillis;
    }

    public long getLeaseThreadId() {
        return this.__m_LeaseThreadId;
    }

    public long getLeaseWaitMillis() {
        return this.__m_LeaseWaitMillis;
    }

    public long getLeaseWaitTimeout() {
        long ldtTimeout = this.__m_LeaseWaitTimeout;
        if (ldtTimeout == 0L) {
            DistributedCache service = (DistributedCache)this.getService();
            ldtTimeout = service.adjustWaitTime(this.getLeaseWaitMillis(), Service.TIME_CLUSTER);
            this.setLeaseWaitTimeout(ldtTimeout);
        }
        return ldtTimeout;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/DistributedCache$LockRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DistributedCache$LockRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void read(DataInputStream stream) throws IOException {
        super.read(stream);
        this.setLeaseHolderId(stream.readUnsignedShort());
        this.setLeaseThreadId(ExternalizableHelper.readLong((DataInput)stream));
        this.setLeaseMillis(ExternalizableHelper.readLong((DataInput)stream));
        this.setLeaseWaitMillis(ExternalizableHelper.readLong((DataInput)stream));
    }

    public void run() {
        ((DistributedCache)this.getService()).onLockRequest(this);
    }

    protected void setLeaseExpiration(long ltExpiration) {
        this.__m_LeaseExpiration = ltExpiration;
    }

    public void setLeaseHolderId(int nHolderId) {
        this.__m_LeaseHolderId = nHolderId;
    }

    public void setLeaseMillis(long cMillis) {
        this.__m_LeaseMillis = cMillis;
        this.setLeaseExpiration(0L);
    }

    public void setLeaseThreadId(long lThreadId) {
        this.__m_LeaseThreadId = lThreadId;
    }

    public void setLeaseWaitMillis(long cMillis) {
        this.__m_LeaseWaitMillis = cMillis;
        this.setLeaseWaitTimeout(0L);
    }

    protected void setLeaseWaitTimeout(long ldtTimeout) {
        this.__m_LeaseWaitTimeout = ldtTimeout;
    }

    public Lease toLease() {
        Lease lease = Lease.instantiate(0, this.getKey(), this.getService());
        lease.setHolderId(this.getLeaseHolderId());
        lease.setHolderThreadId(this.getLeaseThreadId());
        lease.setExpirationTime(this.getLeaseExpiration());
        return lease;
    }

    public void write(DataOutputStream stream) throws IOException {
        super.write(stream);
        stream.writeShort(this.getLeaseHolderId());
        ExternalizableHelper.writeLong((DataOutput)stream, (long)this.getLeaseThreadId());
        ExternalizableHelper.writeLong((DataOutput)stream, (long)this.getLeaseMillis());
        ExternalizableHelper.writeLong((DataOutput)stream, (long)this.getLeaseWaitMillis());
    }
}

