/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.DistributedCache$Storage$MapIndex;
import com.tangosol.util.Binary;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.util.Map;

public class DistributedCache$Storage$BinaryEntry
extends Util
implements InvocableMap.Entry,
Map.Entry {
    protected static final int KEY_BINARY = 1;
    protected static final int KEY_CONVERTED = 2;
    protected static final int VALUE_BINARY = 4;
    protected static final int VALUE_CONVERTED = 8;
    protected static final int VALUE_DEFERRED = 16;
    protected static final int VALUE_READONLY = 32;
    protected static final int VALUE_REMOVED = 64;
    protected static final int VALUE_SYNTHETIC = 128;
    protected static final int VALUE_UPDATED = 256;
    private Binary __m_BinaryKey;
    private Binary __m_BinaryValue;
    private transient Object __m_ConvertedKey;
    private transient Object __m_ConvertedValue;
    private transient int __m_State;

    public DistributedCache$Storage$BinaryEntry() {
        this(null, null, true);
    }

    public DistributedCache$Storage$BinaryEntry(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void checkMutable() {
        if ((this.getState() & VALUE_READONLY) != 0) {
            throw new UnsupportedOperationException("Read-only entry does not allow Map modifications");
        }
    }

    public void disableConversion() {
        this.setState(this.getState() | (KEY_BINARY | VALUE_BINARY));
    }

    public void disableKeyConversion() {
        this.setState(this.getState() | KEY_BINARY);
    }

    public void enableKeyConversion() {
        this.setState(this.getState() & ~KEY_BINARY);
    }

    public void ensureDeferredRead() {
        Binary binValue = this.getBinaryValue();
        if (binValue == null) {
            this.setState(this.getState() | VALUE_DEFERRED);
        } else {
            Binary binValueReal = (Binary)this.getMap().get(this.getBinaryKey());
            if (binValueReal != binValue) {
                this.setBinaryValue(binValueReal);
            }
        }
    }

    public void ensureReadOnly() {
        this.setState(this.getState() | VALUE_READONLY);
    }

    public Object extract(ValueExtractor extractor) {
        boolean fBinKey;
        DistributedCache$Storage$MapIndex index;
        Map mapIndex;
        int nState = this.getState();
        if ((nState & (VALUE_UPDATED | VALUE_REMOVED)) == 0 && (mapIndex = this.getStorage().getIndexMap()) != null && (index = (DistributedCache$Storage$MapIndex)mapIndex.get(extractor)) != null) {
            return index.get(this.getBinaryKey());
        }
        boolean bl = fBinKey = (nState & KEY_BINARY) != 0;
        if (fBinKey) {
            this.setState(nState & ~KEY_BINARY);
        }
        try {
            Object object = InvocableMapHelper.extractFromEntry((ValueExtractor)extractor, (Map.Entry)this);
            Object var5_7 = null;
            if (fBinKey) {
                this.setState(this.getState() | KEY_BINARY);
            }
            return object;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_8 = null;
                if (!fBinKey) break block5;
                this.setState(this.getState() | KEY_BINARY);
            }
            throw throwable;
        }
    }

    public static String formatState(int nState) {
        StringBuffer sb = new StringBuffer();
        if ((nState & KEY_BINARY) != 0) {
            sb.append(" | KEY_BINARY");
        }
        if ((nState & KEY_CONVERTED) != 0) {
            sb.append(" | KEY_CONVERTED");
        }
        if ((nState & VALUE_BINARY) != 0) {
            sb.append(" | VALUE_BINARY");
        }
        if ((nState & VALUE_CONVERTED) != 0) {
            sb.append(" | VALUE_CONVERTED");
        }
        if ((nState & VALUE_DEFERRED) != 0) {
            sb.append(" | VALUE_DEFERRED");
        }
        if ((nState & VALUE_READONLY) != 0) {
            sb.append(" | VALUE_READONLY");
        }
        if ((nState & VALUE_UPDATED) != 0) {
            sb.append(" | VALUE_UPDATED");
        }
        if ((nState & VALUE_REMOVED) != 0) {
            sb.append(" | VALUE_REMOVED");
        }
        if ((nState & VALUE_SYNTHETIC) != 0) {
            sb.append(" | VALUE_SYNTHETIC");
        }
        return sb.length() > 0 ? sb.substring(3) : "";
    }

    public Binary getBinaryKey() {
        return this.__m_BinaryKey;
    }

    public Binary getBinaryValue() {
        int nState;
        Binary binValue = this.__m_BinaryValue;
        if (binValue == null && ((nState = this.getState()) & VALUE_DEFERRED) != 0) {
            binValue = (Binary)this.getMap().get(this.getBinaryKey());
            this.setBinaryValue(binValue);
            this.setState(nState & ~VALUE_DEFERRED);
        }
        return binValue;
    }

    protected Object getConvertedKey() {
        return this.__m_ConvertedKey;
    }

    protected Object getConvertedValue() {
        return this.__m_ConvertedValue;
    }

    public Object getKey() {
        int nState = this.getState();
        if ((nState & KEY_BINARY) != 0) {
            return this.getBinaryKey();
        }
        if ((nState & KEY_CONVERTED) != 0) {
            return this.getConvertedKey();
        }
        Object oKey = this.getStorage().getConverterUp().convert((Object)this.getBinaryKey());
        this.setConvertedKey(oKey);
        this.setState(nState | KEY_CONVERTED);
        return oKey;
    }

    public Map getMap() {
        return this.getStorage().getResourceMap();
    }

    protected int getState() {
        return this.__m_State;
    }

    public DistributedCache$Storage getStorage() {
        return (DistributedCache$Storage)this.get_Feed();
    }

    public Object getValue() {
        int nState = this.getState();
        if ((nState & VALUE_BINARY) != 0) {
            return this.getBinaryValue();
        }
        if ((nState & VALUE_CONVERTED) != 0) {
            return this.getConvertedValue();
        }
        Object oValue = this.getStorage().getConverterUp().convert((Object)this.getBinaryValue());
        this.setConvertedValue(oValue);
        this.setState(nState | VALUE_CONVERTED);
        return oValue;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/DistributedCache$Storage$BinaryEntry".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DistributedCache$Storage$BinaryEntry();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    public int hashCode() {
        Binary binKey = this.getBinaryKey();
        return binKey == null ? 0 : binKey.hashCode();
    }

    public boolean isPresent() {
        int nState = this.getState();
        if ((nState & VALUE_CONVERTED) != 0) {
            if ((nState & VALUE_UPDATED) != 0) {
                return true;
            }
            if ((nState & VALUE_REMOVED) != 0) {
                return false;
            }
        }
        if ((nState & VALUE_DEFERRED) != 0) {
            return this.getMap().containsKey(this.getBinaryKey());
        }
        return this.getBinaryValue() != null;
    }

    public boolean isSynthetic() {
        return (this.getState() & VALUE_SYNTHETIC) != 0;
    }

    public boolean isValueChanged() {
        return (this.getState() & (VALUE_UPDATED | VALUE_REMOVED)) != 0;
    }

    public boolean isValueRemoved() {
        return (this.getState() & VALUE_REMOVED) != 0;
    }

    public void remove(boolean fSynthetic) {
        this.checkMutable();
        this.setConvertedValue(null);
        int nState = (this.getState() | VALUE_CONVERTED | VALUE_REMOVED) & ~VALUE_UPDATED;
        nState = fSynthetic ? (nState |= VALUE_SYNTHETIC) : (nState &= ~VALUE_SYNTHETIC);
        this.setState(nState);
    }

    public void setBinaryKey(Binary binKey) {
        this.setState(this.getState() & ~KEY_CONVERTED);
        this.__m_BinaryKey = binKey;
    }

    public void setBinaryValue(Binary binValue) {
        this.setState(this.getState() & ~VALUE_CONVERTED);
        this.__m_BinaryValue = binValue;
    }

    protected void setConvertedKey(Object oKey) {
        this.__m_ConvertedKey = oKey;
    }

    protected void setConvertedValue(Object oValue) {
        this.__m_ConvertedValue = oValue;
    }

    protected void setState(int nState) {
        this.__m_State = nState;
    }

    public Object setValue(Object oValue) {
        this.checkMutable();
        Object oValueOld = this.getValue();
        this.setValue(oValue, false);
        return oValueOld;
    }

    public void setValue(Object oValue, boolean fSynthetic) {
        this.checkMutable();
        this.setConvertedValue(oValue);
        int nState = (this.getState() | VALUE_CONVERTED | VALUE_UPDATED) & ~VALUE_REMOVED;
        nState = fSynthetic ? (nState |= VALUE_SYNTHETIC) : (nState &= ~VALUE_SYNTHETIC);
        this.setState(nState);
    }

    public String toString() {
        int nState = this.getState();
        return String.valueOf(this.get_Name()) + "{Key=" + ((nState & KEY_CONVERTED) != 0 ? this.getKey() : this.getBinaryKey()) + ", Value=" + ((nState & VALUE_CONVERTED) != 0 ? this.getValue() : this.getBinaryValue()) + ", State=" + DistributedCache$Storage$BinaryEntry.formatState(nState) + '}';
    }

    public void update(ValueUpdater updater, Object oValue) {
        Object oTarget = this.getValue();
        updater.update(oTarget, oValue);
        this.setValue(oTarget, false);
    }
}

